/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import com.ibm.security.validator.ValidatorException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import sun.security.util.Debug;
import sun.security.validator.SymantecTLSPolicy;

enum CADistrustPolicy {
    SYMANTEC_TLS{

        @Override
        void checkDistrust(String string, X509Certificate[] x509CertificateArray) throws ValidatorException {
            if (!string.equals("tls server")) {
                return;
            }
            SymantecTLSPolicy.checkDistrust(x509CertificateArray);
        }
    };

    static final EnumSet<CADistrustPolicy> POLICIES;

    abstract void checkDistrust(String var1, X509Certificate[] var2) throws ValidatorException;

    private static EnumSet<CADistrustPolicy> parseProperty() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty("jdk.security.caDistrustPolicies");
            }
        });
        EnumSet<CADistrustPolicy> enumSet = EnumSet.noneOf(CADistrustPolicy.class);
        if (string == null || string.isEmpty()) {
            return enumSet;
        }
        for (String string2 : stringArray = string.split(",")) {
            string2 = string2.trim();
            try {
                CADistrustPolicy cADistrustPolicy = Enum.valueOf(CADistrustPolicy.class, string2);
                enumSet.add(cADistrustPolicy);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Debug debug = Debug.getInstance("certpath");
                if (debug == null) continue;
                debug.println("Unknown value for the jdk.security.caDistrustPolicies property: " + string2);
            }
        }
        return enumSet;
    }

    static {
        POLICIES = CADistrustPolicy.parseProperty();
    }
}

