/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.resolver.readers;

import com.ibm.xml.jaxp.util.HashtableFactory;
import com.ibm.xml.resolver.Catalog;
import com.ibm.xml.resolver.CatalogException;
import com.ibm.xml.resolver.helpers.Namespaces;
import com.ibm.xml.resolver.readers.CatalogReader;
import com.ibm.xml.resolver.readers.DOMCatalogParser;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class DOMCatalogReader
implements CatalogReader {
    protected Hashtable namespaceMap = HashtableFactory.newHashtable();

    public void setCatalogParser(String string, String string2, String string3) {
        if (string == null) {
            this.namespaceMap.put(string2, string3);
        } else {
            this.namespaceMap.put("{" + string + "}" + string2, string3);
        }
    }

    public String getCatalogParser(String string, String string2) {
        if (string == null) {
            return (String)this.namespaceMap.get(string2);
        }
        return (String)this.namespaceMap.get("{" + string + "}" + string2);
    }

    public void readCatalog(Catalog catalog, InputStream inputStream) throws IOException, CatalogException {
        Object object;
        DocumentBuilderFactory documentBuilderFactory = null;
        DocumentBuilder documentBuilder = null;
        documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(false);
        documentBuilderFactory.setValidating(false);
        try {
            documentBuilder = documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CatalogException(6);
        }
        Document document = null;
        try {
            document = documentBuilder.parse(inputStream);
        }
        catch (SAXException sAXException) {
            throw new CatalogException(5);
        }
        Element element = document.getDocumentElement();
        String string = Namespaces.getNamespaceURI(element);
        String string2 = Namespaces.getLocalName(element);
        String string3 = this.getCatalogParser(string, string2);
        if (string3 == null) {
            if (string == null) {
                catalog.getCatalogManager().debug.message(1, "No Catalog parser for " + string2);
            } else {
                catalog.getCatalogManager().debug.message(1, "No Catalog parser for {" + string + "}" + string2);
            }
            return;
        }
        DOMCatalogParser dOMCatalogParser = null;
        try {
            int n;
            object = System.getSecurityManager();
            if (object != null && (n = string3.lastIndexOf(46)) != -1) {
                String string4 = string3.substring(0, n);
                ((SecurityManager)object).checkPackageAccess(string4);
            }
            dOMCatalogParser = (DOMCatalogParser)Class.forName(string3).newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            catalog.getCatalogManager().debug.message(1, "Cannot load XML Catalog Parser class", string3);
            throw new CatalogException(6);
        }
        catch (InstantiationException instantiationException) {
            catalog.getCatalogManager().debug.message(1, "Cannot instantiate XML Catalog Parser class", string3);
            throw new CatalogException(6);
        }
        catch (IllegalAccessException illegalAccessException) {
            catalog.getCatalogManager().debug.message(1, "Cannot access XML Catalog Parser class", string3);
            throw new CatalogException(6);
        }
        catch (ClassCastException classCastException) {
            catalog.getCatalogManager().debug.message(1, "Cannot cast XML Catalog Parser class", string3);
            throw new CatalogException(6);
        }
        object = element.getFirstChild();
        while (object != null) {
            dOMCatalogParser.parseCatalogEntry(catalog, (Node)object);
            object = object.getNextSibling();
        }
    }

    public void readCatalog(Catalog catalog, String string) throws MalformedURLException, IOException, CatalogException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        this.readCatalog(catalog, uRLConnection.getInputStream());
    }
}

