/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xml.xlxp.api.stax;

import com.ibm.xml.xlxp.api.stax.msg.StAXMessageProvider;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.namespace.NamespaceContext;

public class JavaXNamespaceContext
implements NamespaceContext {
    private static final String XML_PREFIX = "xml".intern();
    private static final String XML_NS = "http://www.w3.org/XML/1998/namespace".intern();
    private static final String XMLNS_PREFIX = "xmlns".intern();
    private static final String XMLNS_NS = "http://www.w3.org/2000/xmlns/".intern();
    protected String[] fMapping = new String[32];
    protected int fMappingSize = 0;
    protected int[] fScopes = new int[8];
    protected int fScope = 0;

    public JavaXNamespaceContext() {
        this.fMapping[this.fMappingSize++] = XML_PREFIX;
        this.fMapping[this.fMappingSize++] = XML_NS;
        this.fMapping[this.fMappingSize++] = XMLNS_PREFIX;
        this.fMapping[this.fMappingSize++] = XMLNS_NS;
    }

    public JavaXNamespaceContext(JavaXNamespaceContext javaXNamespaceContext, boolean bl) {
        this.fMappingSize = javaXNamespaceContext.fMappingSize;
        if (bl) {
            int n = javaXNamespaceContext.fMapping.length;
            this.fMapping = new String[n];
            System.arraycopy(javaXNamespaceContext.fMapping, 0, this.fMapping, 0, n);
            this.fScope = javaXNamespaceContext.fScope;
            n = javaXNamespaceContext.fScopes.length;
            this.fScopes = new int[n];
            System.arraycopy(javaXNamespaceContext.fScopes, 0, this.fScopes, 0, n);
        } else {
            this.fMapping = new String[this.fMappingSize];
            System.arraycopy(javaXNamespaceContext.fMapping, 0, this.fMapping, 0, this.fMappingSize);
        }
    }

    public void reset() {
        this.fMappingSize = 4;
        this.fScope = 0;
    }

    public int getNamespaceCount() {
        return (this.fMappingSize - this.fScopes[this.fScope]) / 2;
    }

    public String getNamespacePrefix(int n) throws IndexOutOfBoundsException {
        if ((n = this.fMappingSize - n * 2 - 2) < this.fScopes[this.fScope] || n >= this.fMappingSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.fMapping[n];
    }

    public String getNamespaceURI(int n) {
        if ((n = this.fMappingSize - n * 2 - 1) < this.fScopes[this.fScope] || n >= this.fMappingSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.fMapping[n];
    }

    public void startScope() {
        ++this.fScope;
        if (this.fScope == this.fScopes.length) {
            int[] nArray = new int[this.fScope * 2];
            System.arraycopy(this.fScopes, 0, nArray, 0, this.fScope);
            this.fScopes = nArray;
        }
        this.fScopes[this.fScope] = this.fMappingSize;
    }

    public void endScope() {
        if (this.fScope > 0) {
            this.fMappingSize = this.fScopes[this.fScope--];
        }
    }

    public void declareNamespace(String string, String string2) {
        if (this.fMappingSize == this.fMapping.length) {
            String[] stringArray = new String[this.fMappingSize * 2];
            System.arraycopy(this.fMapping, 0, stringArray, 0, this.fMappingSize);
            this.fMapping = stringArray;
        }
        if (string == null) {
            string = "";
        }
        string = string.intern();
        if (string2 != null) {
            string2 = string2.intern();
        }
        this.fMapping[this.fMappingSize++] = string;
        this.fMapping[this.fMappingSize++] = string2;
    }

    public String getNamespaceURI(String string) {
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 47));
        }
        string = string.intern();
        int n = this.fMappingSize - 2;
        while (n >= 0) {
            if (this.fMapping[n] == string) {
                return this.fMapping[n + 1];
            }
            n -= 2;
        }
        return null;
    }

    public String getPrefix(String string) {
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
        } else {
            string = string.intern();
        }
        int n = this.fMappingSize - 2;
        while (n >= 0) {
            if (this.fMapping[n + 1] == string && this.getNamespaceURI(this.fMapping[n]) == string) {
                return this.fMapping[n];
            }
            n -= 2;
        }
        return null;
    }

    public Iterator getPrefixes(String string) {
        if (string == null) {
            StAXMessageProvider.throwIllegalArgumentException(StAXMessageProvider.createMessage(null, 46));
        } else {
            string = string.intern();
        }
        HashSet<String> hashSet = new HashSet<String>();
        int n = this.fMappingSize - 2;
        while (n >= 0) {
            if (this.fMapping[n + 1] == string && this.getNamespaceURI(this.fMapping[n]) == string) {
                hashSet.add(this.fMapping[n]);
            }
            n -= 2;
        }
        return hashSet.iterator();
    }
}

