/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.xtq.xml.datamodel;

import com.ibm.xtq.xml.datamodel.CastLibrary;
import com.ibm.xtq.xml.datamodel.DateTimeBase;
import com.ibm.xtq.xml.datamodel.DynamicError;
import com.ibm.xtq.xml.datamodel.XItem;
import com.ibm.xtq.xml.datamodel.XItemBase;
import com.ibm.xtq.xml.datamodel.XUntypedAtomic;
import com.ibm.xtq.xml.types.ItemType;
import com.ibm.xtq.xml.types.Type;
import com.ibm.xtq.xml.types.TypeError;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.xs.DayDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;

public class XGDay
extends XItemBase {
    private static TypeValidator m_validator = new DayDV();
    private int m_day;

    public XGDay(int n) {
        this(n, Type.GDAY);
    }

    public XGDay(int n, ItemType itemType) {
        this.m_day = n;
        this.m_type = itemType;
    }

    @Override
    public int getPrimitiveId() {
        return 15;
    }

    public int getDay() {
        return this.m_day;
    }

    public static XGDay parse(String string) {
        try {
            DateTimeBase dateTimeBase = (DateTimeBase)m_validator.getActualValue(string, null);
            return new XGDay(dateTimeBase.getDay());
        }
        catch (InvalidDatatypeValueException invalidDatatypeValueException) {
            throw new DynamicError(invalidDatatypeValueException.toString());
        }
    }

    @Override
    public XGDay toGDay() {
        return this;
    }

    @Override
    public String toString() {
        return "---" + CastLibrary.convertTo2CharString(this.m_day);
    }

    @Override
    public XUntypedAtomic toUntypedAtomic() {
        return new XUntypedAtomic(this.toString());
    }

    @Override
    public boolean equals(XItem xItem) throws TypeError {
        switch (xItem.getPrimitiveId()) {
            case 15: {
                return this.equals(xItem.toGDay());
            }
        }
        throw new TypeError();
    }

    public boolean equals(XGDay xGDay) {
        return this.m_day == xGDay.getDay();
    }

    public final boolean notEquals(XGDay xGDay) throws TypeError {
        return !this.equals(xGDay);
    }
}

