/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.datatype;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.Properties;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.xml.datatype.SecuritySupport;

final class FactoryFinder {
    private static boolean debug;
    private static Properties jaxpProperties;
    private static long lastModified;

    private FactoryFinder() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object find(Class<?> clazz, String string, String string2) throws ConfigurationError {
        Object object;
        ClassLoader classLoader = SecuritySupport.getContextClassLoader();
        if (classLoader == null) {
            classLoader = FactoryFinder.class.getClassLoader();
        }
        if (debug) {
            FactoryFinder.dPrint("find factoryId=" + string);
        }
        try {
            String string3 = SecuritySupport.getSystemProperty(string);
            if (string3 != null) {
                if (debug) {
                    FactoryFinder.dPrint("found system property, value=" + string3);
                }
                return FactoryFinder.newInstance(string3, classLoader, true);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        boolean bl = false;
        File file = null;
        try {
            object = SecuritySupport.getSystemProperty("java.home");
            String string4 = (String)object + File.separator + "lib" + File.separator + "jaxp.properties";
            file = new File(string4);
            bl = SecuritySupport.getFileExists(file);
        }
        catch (SecurityException securityException) {
            lastModified = -1L;
            jaxpProperties = null;
        }
        object = FactoryFinder.class;
        synchronized (FactoryFinder.class) {
            boolean bl2 = false;
            FileInputStream fileInputStream = null;
            try {
                if (lastModified >= 0L) {
                    if (bl && lastModified < (lastModified = SecuritySupport.getLastModified(file))) {
                        bl2 = true;
                    } else if (!bl) {
                        lastModified = -1L;
                        jaxpProperties = null;
                    }
                } else if (bl) {
                    bl2 = true;
                    lastModified = SecuritySupport.getLastModified(file);
                }
                if (bl2) {
                    jaxpProperties = new Properties();
                    fileInputStream = SecuritySupport.getFileInputStream(file);
                    jaxpProperties.load(fileInputStream);
                }
            }
            catch (Exception exception) {
                lastModified = -1L;
                jaxpProperties = null;
            }
            finally {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
            // ** MonitorExit[var6_8] (shouldn't be in output)
            if (jaxpProperties != null && (object = jaxpProperties.getProperty(string)) != null) {
                if (debug) {
                    FactoryFinder.dPrint("found in jaxp.properties, value=" + (String)object);
                }
                return FactoryFinder.newInstance((String)object, classLoader, true);
            }
            object = FactoryFinder.findServiceProvider(clazz);
            if (object != null) {
                if (debug) {
                    FactoryFinder.dPrint("found service provider by ServiceLoader, value=" + object.getClass().getName());
                }
                return object;
            }
            if (string2 == null) {
                throw new ConfigurationError("Provider for " + string + " cannot be found", null);
            }
            if (debug) {
                FactoryFinder.dPrint("using fallback, value=" + string2);
            }
            return FactoryFinder.newInstance(string2, classLoader, true);
        }
    }

    private static void dPrint(String string) {
        if (debug) {
            System.err.println("JAXP: " + string);
        }
    }

    static Object newInstance(String string, ClassLoader classLoader, boolean bl) throws ConfigurationError {
        try {
            Class<?> clazz;
            Object object;
            int n;
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null && (n = string.lastIndexOf(46)) != -1) {
                object = string.substring(0, n);
                securityManager.checkPackageAccess((String)object);
            }
            if (classLoader == null) {
                clazz = Class.forName(string);
            } else {
                try {
                    clazz = classLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (bl) {
                        classLoader = FactoryFinder.class.getClassLoader();
                        clazz = classLoader != null ? classLoader.loadClass(string) : Class.forName(string);
                    }
                    throw classNotFoundException;
                }
            }
            object = clazz.newInstance();
            if (debug) {
                FactoryFinder.dPrint("created new instance of " + clazz + " using ClassLoader: " + classLoader);
            }
            return object;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new ConfigurationError("Provider " + string + " not found", classNotFoundException);
        }
        catch (Exception exception) {
            throw new ConfigurationError("Provider " + string + " could not be instantiated: " + exception, exception);
        }
    }

    private static Object findServiceProvider(Class<?> clazz) throws ConfigurationError {
        ServiceLoader<?> serviceLoader = ServiceLoader.load(clazz, SecuritySupport.getContextClassLoader());
        Iterator<?> iterator = serviceLoader.iterator();
        try {
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (RuntimeException runtimeException) {
            throw new ConfigurationError("Provider " + clazz.getName() + " could not be instantiated: " + runtimeException, runtimeException);
        }
        catch (ServiceConfigurationError serviceConfigurationError) {
            throw new ConfigurationError("Provider " + clazz.getName() + " could not be instantiated: " + serviceConfigurationError, null);
        }
        return null;
    }

    static {
        jaxpProperties = null;
        lastModified = -1L;
        try {
            String string = SecuritySupport.getSystemProperty("jaxp.debug");
            debug = string != null && !"false".equals(string);
        }
        catch (SecurityException securityException) {
            debug = false;
        }
    }

    static class ConfigurationError
    extends Error {
        private static final long serialVersionUID = -3644413026244211347L;
        private Exception exception;

        ConfigurationError(String string, Exception exception) {
            super(string);
            this.exception = exception;
        }

        Exception getException() {
            return this.exception;
        }
    }
}

