/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ec;

import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidParameterException;
import java.security.KeyPair;
import java.security.KeyPairGeneratorSpi;
import java.security.ProviderException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import sun.security.ec.ECParameters;
import sun.security.ec.ECPrivateKeyImpl;
import sun.security.ec.ECPublicKeyImpl;
import sun.security.ec.NamedCurve;
import sun.security.jca.JCAUtil;
import sun.security.util.SecurityProviderConstants;

public final class ECKeyPairGenerator
extends KeyPairGeneratorSpi {
    private static final int KEY_SIZE_MIN = 112;
    private static final int KEY_SIZE_MAX = 571;
    private SecureRandom random;
    private int keySize;
    private AlgorithmParameterSpec params = null;

    public ECKeyPairGenerator() {
        this.initialize(SecurityProviderConstants.DEF_EC_KEY_SIZE, null);
    }

    @Override
    public void initialize(int n, SecureRandom secureRandom) {
        this.checkKeySize(n);
        this.params = NamedCurve.getECParameterSpec((int)n);
        if (this.params == null) {
            throw new InvalidParameterException("No EC parameters available for key size " + n + " bits");
        }
        this.random = secureRandom;
    }

    @Override
    public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
        if (algorithmParameterSpec instanceof ECParameterSpec) {
            this.params = ECParameters.getNamedCurve((ECParameterSpec)((ECParameterSpec)algorithmParameterSpec));
            if (this.params == null) {
                throw new InvalidAlgorithmParameterException("Unsupported curve: " + algorithmParameterSpec);
            }
        } else if (algorithmParameterSpec instanceof ECGenParameterSpec) {
            String string = ((ECGenParameterSpec)algorithmParameterSpec).getName();
            this.params = NamedCurve.getECParameterSpec((String)string);
            if (this.params == null) {
                throw new InvalidAlgorithmParameterException("Unknown curve name: " + string);
            }
        } else {
            throw new InvalidAlgorithmParameterException("ECParameterSpec or ECGenParameterSpec required for EC");
        }
        this.keySize = ((ECParameterSpec)this.params).getCurve().getField().getFieldSize();
        this.random = secureRandom;
    }

    @Override
    public KeyPair generateKeyPair() {
        byte[] byArray = ECParameters.encodeParameters((ECParameterSpec)((ECParameterSpec)this.params));
        byte[] byArray2 = new byte[((this.keySize + 7 >> 3) + 1) * 2];
        if (this.random == null) {
            this.random = JCAUtil.getSecureRandom();
        }
        this.random.nextBytes(byArray2);
        try {
            Object[] objectArray = ECKeyPairGenerator.generateECKeyPair(this.keySize, byArray, byArray2);
            BigInteger bigInteger = new BigInteger(1, (byte[])objectArray[0]);
            ECPrivateKeyImpl eCPrivateKeyImpl = new ECPrivateKeyImpl(bigInteger, (ECParameterSpec)this.params);
            ECPoint eCPoint = ECParameters.decodePoint((byte[])((byte[])objectArray[1]), (EllipticCurve)((ECParameterSpec)this.params).getCurve());
            ECPublicKeyImpl eCPublicKeyImpl = new ECPublicKeyImpl(eCPoint, (ECParameterSpec)this.params);
            return new KeyPair(eCPublicKeyImpl, eCPrivateKeyImpl);
        }
        catch (Exception exception) {
            throw new ProviderException(exception);
        }
    }

    private void checkKeySize(int n) throws InvalidParameterException {
        if (n < 112) {
            throw new InvalidParameterException("Key size must be at least 112 bits");
        }
        if (n > 571) {
            throw new InvalidParameterException("Key size must be at most 571 bits");
        }
        this.keySize = n;
    }

    private static native Object[] generateECKeyPair(int var0, byte[] var1, byte[] var2) throws GeneralSecurityException;
}

