/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.util.Random;
import sun.misc.FpUtils;

public final class StrictMath {
    public static final double E = Math.E;
    public static final double PI = Math.PI;
    private static Random randomNumberGenerator;

    private StrictMath() {
    }

    public static native double sin(double var0);

    public static native double cos(double var0);

    public static native double tan(double var0);

    public static native double asin(double var0);

    public static native double acos(double var0);

    public static native double atan(double var0);

    public static strictfp double toRadians(double d) {
        return d / 180.0 * Math.PI;
    }

    public static strictfp double toDegrees(double d) {
        return d * 180.0 / Math.PI;
    }

    public static native double exp(double var0);

    public static native double log(double var0);

    public static native double log10(double var0);

    public static native double sqrt(double var0);

    public static native double cbrt(double var0);

    public static native double IEEEremainder(double var0, double var2);

    public static double ceil(double d) {
        return StrictMath.floorOrCeil(d, -0.0, 1.0, 1.0);
    }

    public static double floor(double d) {
        return StrictMath.floorOrCeil(d, -1.0, 0.0, -1.0);
    }

    private static double floorOrCeil(double d, double d2, double d3, double d4) {
        int n = Math.getExponent(d);
        if (n < 0) {
            return d == 0.0 ? d : (d < 0.0 ? d2 : d3);
        }
        if (n >= 52) {
            return d;
        }
        assert (n >= 0 && n <= 51);
        long l = 0xFFFFFFFFFFFFFL >> n;
        long l2 = Double.doubleToRawLongBits(d);
        if ((l & l2) == 0L) {
            return d;
        }
        double d5 = Double.longBitsToDouble(l2 & (l ^ 0xFFFFFFFFFFFFFFFFL));
        if (d4 * d > 0.0) {
            d5 += d4;
        }
        return d5;
    }

    public static double rint(double d) {
        double d2 = 4.503599627370496E15;
        double d3 = FpUtils.rawCopySign(1.0, d);
        if ((d = Math.abs(d)) < d2) {
            d = d2 + d - d2;
        }
        return d3 * d;
    }

    public static native double atan2(double var0, double var2);

    public static native double pow(double var0, double var2);

    public static int round(float f) {
        return Math.round(f);
    }

    public static long round(double d) {
        return Math.round(d);
    }

    private static synchronized Random initRNG() {
        Random random = randomNumberGenerator;
        return random == null ? (randomNumberGenerator = new Random()) : random;
    }

    public static double random() {
        Random random = randomNumberGenerator;
        if (random == null) {
            random = StrictMath.initRNG();
        }
        return random.nextDouble();
    }

    public static int abs(int n) {
        return n < 0 ? -n : n;
    }

    public static long abs(long l) {
        return l < 0L ? -l : l;
    }

    public static float abs(float f) {
        return f <= 0.0f ? 0.0f - f : f;
    }

    public static double abs(double d) {
        return d <= 0.0 ? 0.0 - d : d;
    }

    public static int max(int n, int n2) {
        return n >= n2 ? n : n2;
    }

    public static long max(long l, long l2) {
        return l >= l2 ? l : l2;
    }

    public static float max(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && 1.0f / f < 0.0f) {
            return f2;
        }
        return f >= f2 ? f : f2;
    }

    public static double max(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && 1.0 / d < 0.0) {
            return d2;
        }
        return d >= d2 ? d : d2;
    }

    public static int min(int n, int n2) {
        return n <= n2 ? n : n2;
    }

    public static long min(long l, long l2) {
        return l <= l2 ? l : l2;
    }

    public static float min(float f, float f2) {
        if (f != f) {
            return f;
        }
        if (f == 0.0f && f2 == 0.0f && 1.0f / f2 < 0.0f) {
            return f2;
        }
        return f <= f2 ? f : f2;
    }

    public static double min(double d, double d2) {
        if (d != d) {
            return d;
        }
        if (d == 0.0 && d2 == 0.0 && 1.0 / d2 < 0.0) {
            return d2;
        }
        return d <= d2 ? d : d2;
    }

    public static double ulp(double d) {
        return FpUtils.ulp(d);
    }

    public static float ulp(float f) {
        return FpUtils.ulp(f);
    }

    public static double signum(double d) {
        return FpUtils.signum(d);
    }

    public static float signum(float f) {
        return FpUtils.signum(f);
    }

    public static native double sinh(double var0);

    public static native double cosh(double var0);

    public static native double tanh(double var0);

    public static native double hypot(double var0, double var2);

    public static native double expm1(double var0);

    public static native double log1p(double var0);

    public static double copySign(double d, double d2) {
        return FpUtils.copySign(d, d2);
    }

    public static float copySign(float f, float f2) {
        return FpUtils.copySign(f, f2);
    }

    public static int getExponent(float f) {
        return FpUtils.getExponent(f);
    }

    public static int getExponent(double d) {
        return FpUtils.getExponent(d);
    }

    public static double nextAfter(double d, double d2) {
        return FpUtils.nextAfter(d, d2);
    }

    public static float nextAfter(float f, double d) {
        return FpUtils.nextAfter(f, d);
    }

    public static double nextUp(double d) {
        return FpUtils.nextUp(d);
    }

    public static float nextUp(float f) {
        return FpUtils.nextUp(f);
    }

    public static double scalb(double d, int n) {
        return FpUtils.scalb(d, n);
    }

    public static float scalb(float f, int n) {
        return FpUtils.scalb(f, n);
    }
}

