/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.lang.ref.ReferenceQueue;
import sun.misc.Cleaner;

public abstract class Reference<T> {
    private T referent;
    ReferenceQueue<? super T> queue;
    Reference next;
    private transient Reference<T> discovered;
    private static Lock lock = new Lock();
    private static Reference pending = null;

    public T get() {
        return this.referent;
    }

    public void clear() {
        this.referent = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEnqueued() {
        Reference reference = this;
        synchronized (reference) {
            return this.queue != ReferenceQueue.NULL && this.next != null;
        }
    }

    public boolean enqueue() {
        return this.queue.enqueue(this);
    }

    Reference(T t) {
        this(t, null);
    }

    Reference(T t, ReferenceQueue<? super T> referenceQueue) {
        this.referent = t;
        this.queue = referenceQueue == null ? ReferenceQueue.NULL : referenceQueue;
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new ReferenceHandler(threadGroup, "Reference Handler");
        ((Thread)object).setPriority(10);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private static class ReferenceHandler
    extends Thread {
        static boolean firstTime = true;
        static final long defaultFinalizerCount = 1L;

        ReferenceHandler(ThreadGroup threadGroup, String string) {
            super(threadGroup, string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Object object;
                Reference reference;
                ReferenceQueue referenceQueue = lock;
                synchronized (referenceQueue) {
                    if (pending == null) {
                        try {
                            lock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    object = reference.next;
                    reference = pending;
                    pending = (Reference)(object == reference ? null : object);
                    reference.next = reference;
                }
                if (reference instanceof Cleaner) {
                    ((Cleaner)reference).clean();
                    continue;
                }
                referenceQueue = reference.queue;
                if (referenceQueue != ReferenceQueue.NULL) {
                    referenceQueue.enqueue(reference);
                }
                if (!firstTime) continue;
                object = this.getClass();
                synchronized (object) {
                    if (firstTime) {
                        Object object2;
                        String string = System.getProperty("java.finalizer.threadCount");
                        long l = 1L;
                        if (string != null && string.length() != 0) {
                            try {
                                object2 = new Long(string);
                                l = (Long)object2;
                            }
                            catch (Exception exception) {
                                System.err.println("Error in java.finalizer.threadCount value");
                            }
                        }
                        object2 = Thread.currentThread().getThreadGroup();
                        ThreadGroup threadGroup = object2;
                        while (threadGroup != null) {
                            object2 = threadGroup;
                            threadGroup = ((ThreadGroup)object2).getParent();
                        }
                        int n = 0;
                        while ((long)n < l - 1L) {
                            ReferenceHandler referenceHandler = new ReferenceHandler((ThreadGroup)object2, "Reference Handler");
                            referenceHandler.setPriority(10);
                            referenceHandler.setDaemon(true);
                            referenceHandler.start();
                            ++n;
                        }
                        firstTime = false;
                    }
                }
            }
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

