/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.Bits;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteOrder;
import java.nio.DirectDoubleBufferRU;
import java.nio.DoubleBuffer;
import sun.misc.Cleaner;
import sun.misc.Unsafe;
import sun.nio.ch.DirectBuffer;

class DirectDoubleBufferU
extends DoubleBuffer
implements DirectBuffer {
    protected static final Unsafe unsafe = Bits.unsafe();
    private static final long arrayBaseOffset = unsafe.arrayBaseOffset(double[].class);
    protected static final boolean unaligned = Bits.unaligned();
    private final Object att;

    @Override
    public Object attachment() {
        return this.att;
    }

    @Override
    public Cleaner cleaner() {
        return null;
    }

    DirectDoubleBufferU(DirectBuffer directBuffer, int n, int n2, int n3, int n4, int n5) {
        super(n, n2, n3, n4);
        this.address = directBuffer.address() + (long)n5;
        this.att = directBuffer;
    }

    @Override
    public DoubleBuffer slice() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        int n4 = n << 3;
        assert (n4 >= 0);
        return new DirectDoubleBufferU(this, -1, 0, n3, n3, n4);
    }

    @Override
    public DoubleBuffer duplicate() {
        return new DirectDoubleBufferU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public DoubleBuffer asReadOnlyBuffer() {
        return new DirectDoubleBufferRU(this, this.markValue(), this.position(), this.limit(), this.capacity(), 0);
    }

    @Override
    public long address() {
        return this.address;
    }

    private long ix(int n) {
        return this.address + ((long)n << 3);
    }

    @Override
    public double get() {
        return unsafe.getDouble(this.ix(this.nextGetIndex()));
    }

    @Override
    public double get(int n) {
        return unsafe.getDouble(this.ix(this.checkIndex(n)));
    }

    @Override
    public DoubleBuffer get(double[] dArray, int n, int n2) {
        if ((long)n2 << 3 > 16L) {
            int n3;
            DirectDoubleBufferU.checkBounds(n, n2, dArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferUnderflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyToLongArray(this.ix(n4), dArray, (long)n << 3, (long)n2 << 3);
            } else {
                Bits.copyToArray(this.ix(n4), dArray, arrayBaseOffset, (long)n << 3, (long)n2 << 3);
            }
            this.position(n4 + n2);
        } else {
            super.get(dArray, n, n2);
        }
        return this;
    }

    @Override
    public DoubleBuffer put(double d) {
        unsafe.putDouble(this.ix(this.nextPutIndex()), d);
        return this;
    }

    @Override
    public DoubleBuffer put(int n, double d) {
        unsafe.putDouble(this.ix(this.checkIndex(n)), d);
        return this;
    }

    @Override
    public DoubleBuffer put(DoubleBuffer doubleBuffer) {
        if (doubleBuffer instanceof DirectDoubleBufferU) {
            int n;
            if (doubleBuffer == this) {
                throw new IllegalArgumentException();
            }
            DirectDoubleBufferU directDoubleBufferU = (DirectDoubleBufferU)doubleBuffer;
            int n2 = directDoubleBufferU.position();
            int n3 = directDoubleBufferU.limit();
            assert (n2 <= n3);
            int n4 = n2 <= n3 ? n3 - n2 : 0;
            int n5 = this.position();
            int n6 = this.limit();
            assert (n5 <= n6);
            int n7 = n = n5 <= n6 ? n6 - n5 : 0;
            if (n4 > n) {
                throw new BufferOverflowException();
            }
            unsafe.copyMemory(directDoubleBufferU.ix(n2), this.ix(n5), (long)n4 << 3);
            directDoubleBufferU.position(n2 + n4);
            this.position(n5 + n4);
        } else if (doubleBuffer.hb != null) {
            int n = doubleBuffer.position();
            int n8 = doubleBuffer.limit();
            assert (n <= n8);
            int n9 = n <= n8 ? n8 - n : 0;
            this.put(doubleBuffer.hb, doubleBuffer.offset + n, n9);
            doubleBuffer.position(n + n9);
        } else {
            super.put(doubleBuffer);
        }
        return this;
    }

    @Override
    public DoubleBuffer put(double[] dArray, int n, int n2) {
        if ((long)n2 << 3 > 16L) {
            int n3;
            DirectDoubleBufferU.checkBounds(n, n2, dArray.length);
            int n4 = this.position();
            int n5 = this.limit();
            assert (n4 <= n5);
            int n6 = n3 = n4 <= n5 ? n5 - n4 : 0;
            if (n2 > n3) {
                throw new BufferOverflowException();
            }
            if (this.order() != ByteOrder.nativeOrder()) {
                Bits.copyFromLongArray(dArray, (long)n << 3, this.ix(n4), (long)n2 << 3);
            } else {
                Bits.copyFromArray(dArray, arrayBaseOffset, (long)n << 3, this.ix(n4), (long)n2 << 3);
            }
            this.position(n4 + n2);
        } else {
            super.put(dArray, n, n2);
        }
        return this;
    }

    @Override
    public DoubleBuffer compact() {
        int n = this.position();
        int n2 = this.limit();
        assert (n <= n2);
        int n3 = n <= n2 ? n2 - n : 0;
        unsafe.copyMemory(this.ix(n), this.ix(0), (long)n3 << 3);
        this.position(n3);
        this.limit(this.capacity());
        this.discardMark();
        return this;
    }

    @Override
    public boolean isDirect() {
        return true;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public ByteOrder order() {
        return ByteOrder.nativeOrder() != ByteOrder.BIG_ENDIAN ? ByteOrder.LITTLE_ENDIAN : ByteOrder.BIG_ENDIAN;
    }
}

