/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleHyperlink;
import javax.accessibility.AccessibleHypertext;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleText;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.LookAndFeel;
import javax.swing.SizeRequirements;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Caret;
import javax.swing.text.ChangedCharSetException;
import javax.swing.text.CompositeView;
import javax.swing.text.DefaultEditorKit;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.GlyphView;
import javax.swing.text.JTextComponent;
import javax.swing.text.ParagraphView;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.text.WrappedPlainView;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import sun.security.action.GetPropertyAction;

public class JEditorPane
extends JTextComponent {
    static final String os_name = AccessController.doPrivileged(new GetPropertyAction("os.name"));
    private SwingWorker<URL, Object> pageLoader;
    private EditorKit kit;
    private boolean isUserSetEditorKit;
    private Hashtable<String, Object> pageProperties;
    static final String PostDataProperty = "javax.swing.JEditorPane.postdata";
    private Hashtable<String, EditorKit> typeHandlers;
    private static final Object kitRegistryKey = new StringBuffer("JEditorPane.kitRegistry");
    private static final Object kitTypeRegistryKey = new StringBuffer("JEditorPane.kitTypeRegistry");
    private static final Object kitLoaderRegistryKey = new StringBuffer("JEditorPane.kitLoaderRegistry");
    private static final String uiClassID = "EditorPaneUI";
    public static final String W3C_LENGTH_UNITS = "JEditorPane.w3cLengthUnits";
    public static final String HONOR_DISPLAY_PROPERTIES = "JEditorPane.honorDisplayProperties";
    static final Map<String, String> defaultEditorKitMap = new HashMap<String, String>(0);

    public JEditorPane() {
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            public Component getComponentAfter(Container container, Component component) {
                if (container != JEditorPane.this || !JEditorPane.this.isEditable() && JEditorPane.this.getComponentCount() > 0) {
                    return super.getComponentAfter(container, component);
                }
                Container container2 = JEditorPane.this.getFocusCycleRootAncestor();
                return container2 != null ? container2.getFocusTraversalPolicy().getComponentAfter(container2, JEditorPane.this) : null;
            }

            @Override
            public Component getComponentBefore(Container container, Component component) {
                if (container != JEditorPane.this || !JEditorPane.this.isEditable() && JEditorPane.this.getComponentCount() > 0) {
                    return super.getComponentBefore(container, component);
                }
                Container container2 = JEditorPane.this.getFocusCycleRootAncestor();
                return container2 != null ? container2.getFocusTraversalPolicy().getComponentBefore(container2, JEditorPane.this) : null;
            }

            @Override
            public Component getDefaultComponent(Container container) {
                return container != JEditorPane.this || !JEditorPane.this.isEditable() && JEditorPane.this.getComponentCount() > 0 ? super.getDefaultComponent(container) : null;
            }

            @Override
            protected boolean accept(Component component) {
                return component != JEditorPane.this ? super.accept(component) : false;
            }
        });
        LookAndFeel.installProperty(this, "focusTraversalKeysForward", JComponent.getManagingFocusForwardTraversalKeys());
        LookAndFeel.installProperty(this, "focusTraversalKeysBackward", JComponent.getManagingFocusBackwardTraversalKeys());
    }

    public JEditorPane(URL uRL) throws IOException {
        this();
        this.setPage(uRL);
    }

    public JEditorPane(String string) throws IOException {
        this();
        this.setPage(string);
    }

    public JEditorPane(String string, String string2) {
        this();
        this.setContentType(string);
        this.setText(string2);
    }

    public synchronized void addHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.add(HyperlinkListener.class, hyperlinkListener);
    }

    public synchronized void removeHyperlinkListener(HyperlinkListener hyperlinkListener) {
        this.listenerList.remove(HyperlinkListener.class, hyperlinkListener);
    }

    public synchronized HyperlinkListener[] getHyperlinkListeners() {
        return (HyperlinkListener[])this.listenerList.getListeners(HyperlinkListener.class);
    }

    public void fireHyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        Object[] objectArray = this.listenerList.getListenerList();
        for (int i = objectArray.length - 2; i >= 0; i -= 2) {
            if (objectArray[i] != HyperlinkListener.class) continue;
            ((HyperlinkListener)objectArray[i + 1]).hyperlinkUpdate(hyperlinkEvent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPage(URL uRL) throws IOException {
        String string;
        if (uRL == null) {
            throw new IOException("invalid url");
        }
        URL uRL2 = this.getPage();
        if (!uRL.equals(uRL2) && uRL.getRef() == null) {
            this.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        }
        boolean bl = false;
        Object object = this.getPostData();
        if (uRL2 == null || !uRL2.sameFile(uRL) || object != null) {
            int n = this.getAsynchronousLoadPriority(this.getDocument());
            if (n < 0) {
                InputStream inputStream = this.getStream(uRL);
                if (this.kit != null) {
                    Document document = this.initializeModel(this.kit, uRL);
                    n = this.getAsynchronousLoadPriority(document);
                    if (n >= 0) {
                        this.setDocument(document);
                        JEditorPane jEditorPane = this;
                        synchronized (jEditorPane) {
                            this.pageLoader = new PageLoader(document, inputStream, uRL2, uRL);
                            this.pageLoader.execute();
                        }
                        return;
                    }
                    this.read(inputStream, document);
                    this.setDocument(document);
                    bl = true;
                }
            } else {
                if (this.pageLoader != null) {
                    this.pageLoader.cancel(true);
                }
                this.pageLoader = new PageLoader(null, null, uRL2, uRL);
                this.pageLoader.execute();
                return;
            }
        }
        if ((string = uRL.getRef()) != null) {
            if (!bl) {
                this.scrollToReference(string);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane.this.scrollToReference(string);
                    }
                });
            }
            this.getDocument().putProperty("stream", uRL);
        }
        this.firePropertyChange("page", uRL2, uRL);
    }

    private Document initializeModel(EditorKit editorKit, URL uRL) {
        Document document = editorKit.createDefaultDocument();
        if (this.pageProperties != null) {
            Enumeration<String> enumeration = this.pageProperties.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                document.putProperty(string, this.pageProperties.get(string));
            }
            this.pageProperties.clear();
        }
        if (document.getProperty("stream") == null) {
            document.putProperty("stream", uRL);
        }
        return document;
    }

    private int getAsynchronousLoadPriority(Document document) {
        return document instanceof AbstractDocument ? ((AbstractDocument)document).getAsynchronousLoadPriority() : -1;
    }

    public void read(InputStream inputStream, Object object) throws IOException {
        if (object instanceof HTMLDocument && this.kit instanceof HTMLEditorKit) {
            HTMLDocument hTMLDocument = (HTMLDocument)object;
            this.setDocument(hTMLDocument);
            this.read(inputStream, hTMLDocument);
        } else {
            String string = (String)this.getClientProperty("charset");
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            super.read(inputStreamReader, object);
        }
    }

    void read(InputStream inputStream, Document document) throws IOException {
        if (!Boolean.TRUE.equals(document.getProperty("IgnoreCharsetDirective"))) {
            inputStream = new BufferedInputStream(inputStream, 10240);
            inputStream.mark(10240);
        }
        try {
            String string = (String)this.getClientProperty("charset");
            InputStreamReader inputStreamReader = string != null ? new InputStreamReader(inputStream, string) : new InputStreamReader(inputStream);
            this.kit.read(inputStreamReader, document, 0);
        }
        catch (BadLocationException badLocationException) {
            throw new IOException(badLocationException.getMessage());
        }
        catch (ChangedCharSetException changedCharSetException) {
            block11: {
                String string = changedCharSetException.getCharSetSpec();
                if (changedCharSetException.keyEqualsCharSet()) {
                    this.putClientProperty("charset", string);
                } else {
                    this.setCharsetFromContentTypeParameters(string);
                }
                try {
                    inputStream.reset();
                }
                catch (IOException iOException) {
                    inputStream.close();
                    URL uRL = (URL)document.getProperty("stream");
                    if (uRL != null) {
                        URLConnection uRLConnection = uRL.openConnection();
                        inputStream = uRLConnection.getInputStream();
                        break block11;
                    }
                    throw changedCharSetException;
                }
            }
            try {
                document.remove(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            document.putProperty("IgnoreCharsetDirective", true);
            this.read(inputStream, document);
        }
    }

    protected InputStream getStream(URL uRL) throws IOException {
        final URLConnection uRLConnection = uRL.openConnection();
        if (uRLConnection instanceof HttpURLConnection) {
            int n;
            boolean bl;
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
            httpURLConnection.setInstanceFollowRedirects(false);
            Object object = this.getPostData();
            if (object != null) {
                this.handlePostData(httpURLConnection, object);
            }
            boolean bl2 = bl = (n = httpURLConnection.getResponseCode()) >= 300 && n <= 399;
            if (bl) {
                String string = uRLConnection.getHeaderField("Location");
                uRL = string.startsWith("http", 0) ? new URL(string) : new URL(uRL, string);
                return this.getStream(uRL);
            }
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.handleConnectionProperties(uRLConnection);
        } else {
            try {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        JEditorPane.this.handleConnectionProperties(uRLConnection);
                    }
                });
            }
            catch (InterruptedException interruptedException) {
                throw new RuntimeException(interruptedException);
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new RuntimeException(invocationTargetException);
            }
        }
        return uRLConnection.getInputStream();
    }

    private void handleConnectionProperties(URLConnection uRLConnection) {
        String string;
        if (this.pageProperties == null) {
            this.pageProperties = new Hashtable();
        }
        if ((string = uRLConnection.getContentType()) != null) {
            this.setContentType(string);
            this.pageProperties.put("content-type", string);
        }
        this.pageProperties.put("stream", uRLConnection.getURL());
        String string2 = uRLConnection.getContentEncoding();
        if (string2 != null) {
            this.pageProperties.put("content-encoding", string2);
        }
    }

    private Object getPostData() {
        return this.getDocument().getProperty(PostDataProperty);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePostData(HttpURLConnection httpURLConnection, Object object) throws IOException {
        httpURLConnection.setDoOutput(true);
        try (FilterOutputStream filterOutputStream = null;){
            httpURLConnection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            filterOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBytes((String)object);
        }
    }

    public void scrollToReference(String string) {
        Document document = this.getDocument();
        if (document instanceof HTMLDocument) {
            HTMLDocument hTMLDocument = (HTMLDocument)document;
            HTMLDocument.Iterator iterator = hTMLDocument.getIterator(HTML.Tag.A);
            while (iterator.isValid()) {
                AttributeSet attributeSet = iterator.getAttributes();
                String string2 = (String)attributeSet.getAttribute(HTML.Attribute.NAME);
                if (string2 != null && string2.equals(string)) {
                    try {
                        int n = iterator.getStartOffset();
                        Rectangle rectangle = this.modelToView(n);
                        if (rectangle != null) {
                            Rectangle rectangle2 = this.getVisibleRect();
                            rectangle.height = rectangle2.height;
                            this.scrollRectToVisible(rectangle);
                            this.setCaretPosition(n);
                        }
                    }
                    catch (BadLocationException badLocationException) {
                        UIManager.getLookAndFeel().provideErrorFeedback(this);
                    }
                }
                iterator.next();
            }
        }
    }

    public URL getPage() {
        return (URL)this.getDocument().getProperty("stream");
    }

    public void setPage(String string) throws IOException {
        if (string == null) {
            throw new IOException("invalid url");
        }
        URL uRL = new URL(string);
        this.setPage(uRL);
    }

    @Override
    public String getUIClassID() {
        return uiClassID;
    }

    protected EditorKit createDefaultEditorKit() {
        return new PlainEditorKit();
    }

    public EditorKit getEditorKit() {
        if (this.kit == null) {
            this.kit = this.createDefaultEditorKit();
            this.isUserSetEditorKit = false;
        }
        return this.kit;
    }

    public final String getContentType() {
        return this.kit != null ? this.kit.getContentType() : null;
    }

    public final void setContentType(String string) {
        Object object;
        int n = string.indexOf(";");
        if (n > -1) {
            object = string.substring(n);
            if ((string = string.substring(0, n).trim()).toLowerCase().startsWith("text/")) {
                this.setCharsetFromContentTypeParameters((String)object);
            }
        }
        if (!(this.kit != null && string.equals(this.kit.getContentType()) && this.isUserSetEditorKit || (object = this.getEditorKitForContentType(string)) == null || object == this.kit)) {
            this.setEditorKit((EditorKit)object);
            this.isUserSetEditorKit = false;
        }
    }

    private void setCharsetFromContentTypeParameters(String string) {
        try {
            HeaderParser headerParser;
            String string2;
            int n = string.indexOf(59);
            if (n > -1 && n < string.length() - 1) {
                string = string.substring(n + 1);
            }
            if (string.length() > 0 && (string2 = (headerParser = new HeaderParser(string)).findValue("charset")) != null) {
                this.putClientProperty("charset", string2);
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (Exception exception) {
            System.err.println("JEditorPane.getCharsetFromContentTypeParameters failed on: " + string);
            exception.printStackTrace();
        }
    }

    public void setEditorKit(EditorKit editorKit) {
        EditorKit editorKit2 = this.kit;
        this.isUserSetEditorKit = true;
        if (editorKit2 != null) {
            editorKit2.deinstall(this);
        }
        this.kit = editorKit;
        if (this.kit != null) {
            this.kit.install(this);
            this.setDocument(this.kit.createDefaultDocument());
        }
        this.firePropertyChange("editorKit", editorKit2, editorKit);
    }

    public EditorKit getEditorKitForContentType(String string) {
        EditorKit editorKit;
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        if ((editorKit = this.typeHandlers.get(string)) == null && (editorKit = JEditorPane.createEditorKitForContentType(string)) != null) {
            this.setEditorKitForContentType(string, editorKit);
        }
        if (editorKit == null) {
            editorKit = this.createDefaultEditorKit();
        }
        return editorKit;
    }

    public void setEditorKitForContentType(String string, EditorKit editorKit) {
        if (this.typeHandlers == null) {
            this.typeHandlers = new Hashtable(3);
        }
        this.typeHandlers.put(string, editorKit);
    }

    @Override
    public void replaceSelection(String string) {
        if (!this.isEditable()) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
            return;
        }
        EditorKit editorKit = this.getEditorKit();
        if (editorKit instanceof StyledEditorKit) {
            try {
                Document document = this.getDocument();
                Caret caret = this.getCaret();
                boolean bl = this.saveComposedText(caret.getDot());
                int n = Math.min(caret.getDot(), caret.getMark());
                int n2 = Math.max(caret.getDot(), caret.getMark());
                if (document instanceof AbstractDocument) {
                    ((AbstractDocument)document).replace(n, n2 - n, string, ((StyledEditorKit)editorKit).getInputAttributes());
                } else {
                    if (n != n2) {
                        document.remove(n, n2 - n);
                    }
                    if (string != null && string.length() > 0) {
                        document.insertString(n, string, ((StyledEditorKit)editorKit).getInputAttributes());
                    }
                }
                if (bl) {
                    this.restoreComposedText();
                }
            }
            catch (BadLocationException badLocationException) {
                UIManager.getLookAndFeel().provideErrorFeedback(this);
            }
        } else {
            super.replaceSelection(string);
        }
    }

    public static EditorKit createEditorKitForContentType(String string) {
        Hashtable<String, EditorKit> hashtable = JEditorPane.getKitRegisty();
        EditorKit editorKit = hashtable.get(string);
        if (editorKit == null) {
            String string2 = JEditorPane.getKitTypeRegistry().get(string);
            ClassLoader classLoader = JEditorPane.getKitLoaderRegistry().get(string);
            try {
                Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2, true, Thread.currentThread().getContextClassLoader());
                editorKit = (EditorKit)clazz.newInstance();
                hashtable.put(string, editorKit);
            }
            catch (Throwable throwable) {
                editorKit = null;
            }
        }
        if (editorKit != null) {
            return (EditorKit)editorKit.clone();
        }
        return null;
    }

    public static void registerEditorKitForContentType(String string, String string2) {
        JEditorPane.registerEditorKitForContentType(string, string2, Thread.currentThread().getContextClassLoader());
    }

    public static void registerEditorKitForContentType(String string, String string2, ClassLoader classLoader) {
        JEditorPane.getKitTypeRegistry().put(string, string2);
        if (classLoader != null) {
            JEditorPane.getKitLoaderRegistry().put(string, classLoader);
        } else {
            JEditorPane.getKitLoaderRegistry().remove(string);
        }
        JEditorPane.getKitRegisty().remove(string);
    }

    public static String getEditorKitClassNameForContentType(String string) {
        return JEditorPane.getKitTypeRegistry().get(string);
    }

    private static Hashtable<String, String> getKitTypeRegistry() {
        JEditorPane.loadDefaultKitsIfNecessary();
        return (Hashtable)SwingUtilities.appContextGet(kitTypeRegistryKey);
    }

    private static Hashtable<String, ClassLoader> getKitLoaderRegistry() {
        JEditorPane.loadDefaultKitsIfNecessary();
        return (Hashtable)SwingUtilities.appContextGet(kitLoaderRegistryKey);
    }

    private static Hashtable<String, EditorKit> getKitRegisty() {
        Hashtable hashtable = (Hashtable)SwingUtilities.appContextGet(kitRegistryKey);
        if (hashtable == null) {
            hashtable = new Hashtable(3);
            SwingUtilities.appContextPut(kitRegistryKey, hashtable);
        }
        return hashtable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadDefaultKitsIfNecessary() {
        if (SwingUtilities.appContextGet(kitTypeRegistryKey) == null) {
            Map<String, String> map = defaultEditorKitMap;
            synchronized (map) {
                if (defaultEditorKitMap.size() == 0) {
                    defaultEditorKitMap.put("text/plain", "javax.swing.JEditorPane$PlainEditorKit");
                    defaultEditorKitMap.put("text/html", "javax.swing.text.html.HTMLEditorKit");
                    defaultEditorKitMap.put("text/rtf", "javax.swing.text.rtf.RTFEditorKit");
                    defaultEditorKitMap.put("application/rtf", "javax.swing.text.rtf.RTFEditorKit");
                }
            }
            map = new Hashtable<String, String>();
            SwingUtilities.appContextPut(kitTypeRegistryKey, map);
            map = new Hashtable<String, String>();
            SwingUtilities.appContextPut(kitLoaderRegistryKey, map);
            for (String string : defaultEditorKitMap.keySet()) {
                JEditorPane.registerEditorKitForContentType(string, defaultEditorKitMap.get(string));
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            Dimension dimension2;
            int n;
            JViewport jViewport = (JViewport)container;
            TextUI textUI = this.getUI();
            int n2 = dimension.width;
            int n3 = dimension.height;
            if (!this.getScrollableTracksViewportWidth()) {
                n = jViewport.getWidth();
                dimension2 = textUI.getMinimumSize(this);
                if (n != 0 && n < dimension2.width) {
                    n2 = dimension2.width;
                }
            }
            if (!this.getScrollableTracksViewportHeight()) {
                n = jViewport.getHeight();
                dimension2 = textUI.getMinimumSize(this);
                if (n != 0 && n < dimension2.height) {
                    n3 = dimension2.height;
                }
            }
            if (n2 != dimension.width || n3 != dimension.height) {
                dimension = new Dimension(n2, n3);
            }
        }
        return dimension;
    }

    @Override
    public void setText(String string) {
        try {
            Document document = this.getDocument();
            document.remove(0, document.getLength());
            if (string == null || string.equals("")) {
                return;
            }
            if ("HP-UX".compareTo(os_name) == 0) {
                string = string.replace('\u00a0', ' ');
            }
            StringReader stringReader = new StringReader(string);
            EditorKit editorKit = this.getEditorKit();
            editorKit.read(stringReader, document, 0);
        }
        catch (IOException iOException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
        catch (BadLocationException badLocationException) {
            UIManager.getLookAndFeel().provideErrorFeedback(this);
        }
    }

    @Override
    public String getText() {
        String string;
        try {
            StringWriter stringWriter = new StringWriter();
            this.write(stringWriter);
            string = stringWriter.toString();
        }
        catch (IOException iOException) {
            string = null;
        }
        return string;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            TextUI textUI = this.getUI();
            int n = jViewport.getWidth();
            Dimension dimension = textUI.getMinimumSize(this);
            Dimension dimension2 = textUI.getMaximumSize(this);
            if (n >= dimension.width && n <= dimension2.width) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        Container container = SwingUtilities.getUnwrappedParent(this);
        if (container instanceof JViewport) {
            JViewport jViewport = (JViewport)container;
            TextUI textUI = this.getUI();
            int n = jViewport.getHeight();
            Dimension dimension = textUI.getMinimumSize(this);
            if (n >= dimension.height) {
                Dimension dimension2 = textUI.getMaximumSize(this);
                if (n <= dimension2.height) {
                    return true;
                }
            }
        }
        return false;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    @Override
    protected String paramString() {
        String string = this.kit != null ? this.kit.toString() : "";
        String string2 = this.typeHandlers != null ? this.typeHandlers.toString() : "";
        return super.paramString() + ",kit=" + string + ",typeHandlers=" + string2;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.getEditorKit() instanceof HTMLEditorKit) {
            if (this.accessibleContext == null || this.accessibleContext.getClass() != AccessibleJEditorPaneHTML.class) {
                this.accessibleContext = new AccessibleJEditorPaneHTML();
            }
        } else if (this.accessibleContext == null || this.accessibleContext.getClass() != AccessibleJEditorPane.class) {
            this.accessibleContext = new AccessibleJEditorPane();
        }
        return this.accessibleContext;
    }

    static class HeaderParser {
        String raw;
        String[][] tab;

        public HeaderParser(String string) {
            this.raw = string;
            this.tab = new String[10][2];
            this.parse();
        }

        private void parse() {
            if (this.raw != null) {
                this.raw = this.raw.trim();
                char[] cArray = this.raw.toCharArray();
                int n = 0;
                int n2 = 0;
                int n3 = 0;
                boolean bl = true;
                boolean bl2 = false;
                int n4 = cArray.length;
                while (n2 < n4) {
                    char c = cArray[n2];
                    if (c == '=') {
                        this.tab[n3][0] = new String(cArray, n, n2 - n).toLowerCase();
                        bl = false;
                        n = ++n2;
                        continue;
                    }
                    if (c == '\"') {
                        if (bl2) {
                            this.tab[n3++][1] = new String(cArray, n, n2 - n);
                            bl2 = false;
                            while (++n2 < n4 && (cArray[n2] == ' ' || cArray[n2] == ',')) {
                            }
                            bl = true;
                            n = n2;
                            continue;
                        }
                        bl2 = true;
                        n = ++n2;
                        continue;
                    }
                    if (c == ' ' || c == ',') {
                        if (bl2) {
                            ++n2;
                            continue;
                        }
                        if (bl) {
                            this.tab[n3++][0] = new String(cArray, n, n2 - n).toLowerCase();
                        } else {
                            this.tab[n3++][1] = new String(cArray, n, n2 - n);
                        }
                        while (n2 < n4 && (cArray[n2] == ' ' || cArray[n2] == ',')) {
                            ++n2;
                        }
                        bl = true;
                        n = n2;
                        continue;
                    }
                    ++n2;
                }
                if (--n2 > n) {
                    if (!bl) {
                        this.tab[n3++][1] = cArray[n2] == '\"' ? new String(cArray, n, n2 - n) : new String(cArray, n, n2 - n + 1);
                    } else {
                        this.tab[n3][0] = new String(cArray, n, n2 - n + 1).toLowerCase();
                    }
                } else if (n2 == n) {
                    if (!bl) {
                        this.tab[n3++][1] = cArray[n2] == '\"' ? String.valueOf(cArray[n2 - 1]) : String.valueOf(cArray[n2]);
                    } else {
                        this.tab[n3][0] = String.valueOf(cArray[n2]).toLowerCase();
                    }
                }
            }
        }

        public String findKey(int n) {
            if (n < 0 || n > 10) {
                return null;
            }
            return this.tab[n][0];
        }

        public String findValue(int n) {
            if (n < 0 || n > 10) {
                return null;
            }
            return this.tab[n][1];
        }

        public String findValue(String string) {
            return this.findValue(string, null);
        }

        public String findValue(String string, String string2) {
            if (string == null) {
                return string2;
            }
            string = string.toLowerCase();
            for (int i = 0; i < 10; ++i) {
                if (this.tab[i][0] == null) {
                    return string2;
                }
                if (!string.equals(this.tab[i][0])) continue;
                return this.tab[i][1];
            }
            return string2;
        }

        public int findInt(String string, int n) {
            try {
                return Integer.parseInt(this.findValue(string, String.valueOf(n)));
            }
            catch (Throwable throwable) {
                return n;
            }
        }
    }

    static class PlainEditorKit
    extends DefaultEditorKit
    implements ViewFactory {
        PlainEditorKit() {
        }

        @Override
        public ViewFactory getViewFactory() {
            return this;
        }

        @Override
        public View create(Element element) {
            Document document = element.getDocument();
            Object object = document.getProperty("i18n");
            if (object != null && object.equals(Boolean.TRUE)) {
                return this.createI18N(element);
            }
            return new WrappedPlainView(element);
        }

        View createI18N(Element element) {
            String string = element.getName();
            if (string != null) {
                if (string.equals("content")) {
                    return new PlainParagraph(element);
                }
                if (string.equals("paragraph")) {
                    return new BoxView(element, 1);
                }
            }
            return null;
        }

        static class PlainParagraph
        extends ParagraphView {
            PlainParagraph(Element element) {
                super(element);
                this.layoutPool = new LogicalView(element);
                this.layoutPool.setParent(this);
            }

            @Override
            protected void setPropertiesFromAttributes() {
                Container container = this.getContainer();
                if (container != null && !container.getComponentOrientation().isLeftToRight()) {
                    this.setJustification(2);
                } else {
                    this.setJustification(0);
                }
            }

            @Override
            public int getFlowSpan(int n) {
                JTextArea jTextArea;
                Container container = this.getContainer();
                if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                    return Integer.MAX_VALUE;
                }
                return super.getFlowSpan(n);
            }

            @Override
            protected SizeRequirements calculateMinorAxisRequirements(int n, SizeRequirements sizeRequirements) {
                JTextArea jTextArea;
                SizeRequirements sizeRequirements2 = super.calculateMinorAxisRequirements(n, sizeRequirements);
                Container container = this.getContainer();
                if (container instanceof JTextArea && !(jTextArea = (JTextArea)container).getLineWrap()) {
                    sizeRequirements2.minimum = sizeRequirements2.preferred;
                }
                return sizeRequirements2;
            }

            static class LogicalView
            extends CompositeView {
                LogicalView(Element element) {
                    super(element);
                }

                @Override
                protected int getViewIndexAtPosition(int n) {
                    Element element = this.getElement();
                    if (element.getElementCount() > 0) {
                        return element.getElementIndex(n);
                    }
                    return 0;
                }

                @Override
                protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
                    return false;
                }

                @Override
                protected void loadChildren(ViewFactory viewFactory) {
                    Element element = this.getElement();
                    if (element.getElementCount() > 0) {
                        super.loadChildren(viewFactory);
                    } else {
                        GlyphView glyphView = new GlyphView(element);
                        this.append(glyphView);
                    }
                }

                @Override
                public float getPreferredSpan(int n) {
                    if (this.getViewCount() != 1) {
                        throw new Error("One child view is assumed.");
                    }
                    View view = this.getView(0);
                    return view.getPreferredSpan(n);
                }

                @Override
                protected void forwardUpdateToView(View view, DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
                    view.setParent(this);
                    super.forwardUpdateToView(view, documentEvent, shape, viewFactory);
                }

                @Override
                public void paint(Graphics graphics, Shape shape) {
                }

                @Override
                protected boolean isBefore(int n, int n2, Rectangle rectangle) {
                    return false;
                }

                @Override
                protected boolean isAfter(int n, int n2, Rectangle rectangle) {
                    return false;
                }

                @Override
                protected View getViewAtPoint(int n, int n2, Rectangle rectangle) {
                    return null;
                }

                @Override
                protected void childAllocation(int n, Rectangle rectangle) {
                }
            }
        }
    }

    protected class JEditorPaneAccessibleHypertextSupport
    extends AccessibleJEditorPane
    implements AccessibleHypertext {
        LinkVector hyperlinks;
        boolean linksValid;

        private void buildLinkTable() {
            this.hyperlinks.removeAllElements();
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                Element element;
                ElementIterator elementIterator = new ElementIterator(document);
                while ((element = elementIterator.next()) != null) {
                    AttributeSet attributeSet;
                    AttributeSet attributeSet2;
                    String string;
                    if (!element.isLeaf() || (string = (attributeSet2 = (AttributeSet)(attributeSet = element.getAttributes()).getAttribute(HTML.Tag.A)) != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null) == null) continue;
                    this.hyperlinks.addElement(new HTMLLink(element));
                }
            }
            this.linksValid = true;
        }

        public JEditorPaneAccessibleHypertextSupport() {
            this.linksValid = false;
            this.hyperlinks = new LinkVector();
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                document.addDocumentListener(new DocumentListener(){

                    @Override
                    public void changedUpdate(DocumentEvent documentEvent) {
                        JEditorPaneAccessibleHypertextSupport.this.linksValid = false;
                    }

                    @Override
                    public void insertUpdate(DocumentEvent documentEvent) {
                        JEditorPaneAccessibleHypertextSupport.this.linksValid = false;
                    }

                    @Override
                    public void removeUpdate(DocumentEvent documentEvent) {
                        JEditorPaneAccessibleHypertextSupport.this.linksValid = false;
                    }
                });
            }
        }

        @Override
        public int getLinkCount() {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            return this.hyperlinks.size();
        }

        @Override
        public int getLinkIndex(int n) {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            Element element = null;
            Document document = JEditorPane.this.getDocument();
            if (document != null) {
                element = document.getDefaultRootElement();
                while (!element.isLeaf()) {
                    int n2 = element.getElementIndex(n);
                    element = element.getElement(n2);
                }
            }
            return this.hyperlinks.baseElementIndex(element);
        }

        @Override
        public AccessibleHyperlink getLink(int n) {
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            if (n >= 0 && n < this.hyperlinks.size()) {
                return (AccessibleHyperlink)this.hyperlinks.elementAt(n);
            }
            return null;
        }

        public String getLinkText(int n) {
            Document document;
            Element element;
            if (!this.linksValid) {
                this.buildLinkTable();
            }
            if ((element = (Element)this.hyperlinks.elementAt(n)) != null && (document = JEditorPane.this.getDocument()) != null) {
                try {
                    return document.getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                }
                catch (BadLocationException badLocationException) {
                    return null;
                }
            }
            return null;
        }

        private class LinkVector
        extends Vector<HTMLLink> {
            private LinkVector() {
            }

            public int baseElementIndex(Element element) {
                for (int i = 0; i < this.elementCount; ++i) {
                    HTMLLink hTMLLink = (HTMLLink)this.elementAt(i);
                    if (hTMLLink.element != element) continue;
                    return i;
                }
                return -1;
            }
        }

        public class HTMLLink
        extends AccessibleHyperlink {
            Element element;

            public HTMLLink(Element element) {
                this.element = element;
            }

            @Override
            public boolean isValid() {
                return JEditorPaneAccessibleHypertextSupport.this.linksValid;
            }

            @Override
            public int getAccessibleActionCount() {
                return 1;
            }

            @Override
            public boolean doAccessibleAction(int n) {
                URL uRL;
                if (n == 0 && this.isValid() && (uRL = (URL)this.getAccessibleActionObject(n)) != null) {
                    HyperlinkEvent hyperlinkEvent = new HyperlinkEvent(JEditorPane.this, HyperlinkEvent.EventType.ACTIVATED, uRL);
                    JEditorPane.this.fireHyperlinkUpdate(hyperlinkEvent);
                    return true;
                }
                return false;
            }

            @Override
            public String getAccessibleActionDescription(int n) {
                Document document;
                if (n == 0 && this.isValid() && (document = JEditorPane.this.getDocument()) != null) {
                    try {
                        return document.getText(this.getStartIndex(), this.getEndIndex() - this.getStartIndex());
                    }
                    catch (BadLocationException badLocationException) {
                        return null;
                    }
                }
                return null;
            }

            @Override
            public Object getAccessibleActionObject(int n) {
                if (n == 0 && this.isValid()) {
                    String string;
                    AttributeSet attributeSet = this.element.getAttributes();
                    AttributeSet attributeSet2 = (AttributeSet)attributeSet.getAttribute(HTML.Tag.A);
                    String string2 = string = attributeSet2 != null ? (String)attributeSet2.getAttribute(HTML.Attribute.HREF) : null;
                    if (string != null) {
                        URL uRL;
                        try {
                            uRL = new URL(JEditorPane.this.getPage(), string);
                        }
                        catch (MalformedURLException malformedURLException) {
                            uRL = null;
                        }
                        return uRL;
                    }
                }
                return null;
            }

            @Override
            public Object getAccessibleActionAnchor(int n) {
                return this.getAccessibleActionDescription(n);
            }

            @Override
            public int getStartIndex() {
                return this.element.getStartOffset();
            }

            @Override
            public int getEndIndex() {
                return this.element.getEndOffset();
            }
        }
    }

    protected class AccessibleJEditorPaneHTML
    extends AccessibleJEditorPane {
        private AccessibleContext accessibleContext;

        @Override
        public AccessibleText getAccessibleText() {
            return new JEditorPaneAccessibleHypertextSupport();
        }

        protected AccessibleJEditorPaneHTML() {
            HTMLEditorKit hTMLEditorKit = (HTMLEditorKit)JEditorPane.this.getEditorKit();
            this.accessibleContext = hTMLEditorKit.getAccessibleContext();
        }

        @Override
        public int getAccessibleChildrenCount() {
            if (this.accessibleContext != null) {
                return this.accessibleContext.getAccessibleChildrenCount();
            }
            return 0;
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            if (this.accessibleContext != null) {
                return this.accessibleContext.getAccessibleChild(n);
            }
            return null;
        }

        @Override
        public Accessible getAccessibleAt(Point point) {
            if (this.accessibleContext != null && point != null) {
                try {
                    AccessibleComponent accessibleComponent = this.accessibleContext.getAccessibleComponent();
                    if (accessibleComponent != null) {
                        return accessibleComponent.getAccessibleAt(point);
                    }
                    return null;
                }
                catch (IllegalComponentStateException illegalComponentStateException) {
                    return null;
                }
            }
            return null;
        }
    }

    protected class AccessibleJEditorPane
    extends JTextComponent.AccessibleJTextComponent {
        protected AccessibleJEditorPane() {
            super(JEditorPane.this);
        }

        @Override
        public String getAccessibleDescription() {
            String string = this.accessibleDescription;
            if (string == null) {
                string = (String)JEditorPane.this.getClientProperty("AccessibleDescription");
            }
            if (string == null) {
                string = JEditorPane.this.getContentType();
            }
            return string;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.MULTI_LINE);
            return accessibleStateSet;
        }
    }

    class PageLoader
    extends SwingWorker<URL, Object> {
        InputStream in;
        URL old;
        URL page;
        Document doc;

        PageLoader(Document document, InputStream inputStream, URL uRL, URL uRL2) {
            this.in = inputStream;
            this.old = uRL;
            this.page = uRL2;
            this.doc = document;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected URL doInBackground() {
            var1_1 = false;
            if (this.in != null) ** GOTO lbl30
            this.in = JEditorPane.this.getStream(this.page);
            if (JEditorPane.access$000(JEditorPane.this) != null) ** GOTO lbl30
            UIManager.getLookAndFeel().provideErrorFeedback(JEditorPane.this);
            var2_2 = this.old;
            if (!var1_1) ** GOTO lbl25
            ** GOTO lbl24
            {
                catch (IOException var2_6) {
                    block20: {
                        block22: {
                            block21: {
                                try {
                                    UIManager.getLookAndFeel().provideErrorFeedback(JEditorPane.this);
                                    if (var1_1) {
                                    }
                                    break block20;
                                }
                                catch (Throwable var5_11) {
                                    if (var1_1) {
                                        SwingUtilities.invokeLater(new Runnable(){

                                            @Override
                                            public void run() {
                                                JEditorPane.this.firePropertyChange("page", PageLoader.this.old, PageLoader.this.page);
                                            }
                                        });
                                    }
                                    if (var1_1) {
                                        v0 = this.page;
                                        return v0;
                                    }
                                    v0 = this.old;
                                    return v0;
                                }
lbl24:
                                // 1 sources

                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
lbl25:
                                // 2 sources

                                if (var1_1) {
                                    v1 = this.page;
                                    return v1;
                                }
                                v1 = this.old;
                                return v1;
lbl30:
                                // 2 sources

                                if (this.doc != null) ** GOTO lbl-1000
                                try {
                                    SwingUtilities.invokeAndWait(new Runnable(){

                                        @Override
                                        public void run() {
                                            PageLoader.this.doc = JEditorPane.this.initializeModel(JEditorPane.this.kit, PageLoader.this.page);
                                            JEditorPane.this.setDocument(PageLoader.this.doc);
                                        }
                                    });
                                    ** GOTO lbl-1000
                                }
                                catch (InvocationTargetException var2_3) {
                                    UIManager.getLookAndFeel().provideErrorFeedback(JEditorPane.this);
                                    var3_7 = this.old;
                                    if (var1_1) {
                                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                                    }
                                    if (var1_1) {
                                        v2 = this.page;
                                        return v2;
                                    }
                                    v2 = this.old;
                                    return v2;
                                }
                                catch (InterruptedException var2_4) {}
                                {
                                    UIManager.getLookAndFeel().provideErrorFeedback(JEditorPane.this);
                                    var3_8 = this.old;
                                    if (!var1_1) break block21;
                                }
                                SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            }
                            if (var1_1) {
                                v3 = this.page;
                                return v3;
                            }
                            v3 = this.old;
                            return v3;
lbl-1000:
                            // 2 sources

                            {
                                JEditorPane.this.read(this.in, this.doc);
                                var2_5 = (URL)this.doc.getProperty("stream");
                                var3_9 = var2_5.getRef();
                                if (var3_9 != null) {
                                    var4_10 = new Runnable(){

                                        @Override
                                        public void run() {
                                            URL uRL = (URL)JEditorPane.this.getDocument().getProperty("stream");
                                            String string = uRL.getRef();
                                            JEditorPane.this.scrollToReference(string);
                                        }
                                    };
                                    SwingUtilities.invokeLater(var4_10);
                                }
                                if (!(var1_1 = true)) break block22;
                            }
                            SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        }
                        if (var1_1) {
                            v4 = this.page;
                            return v4;
                        }
                        v4 = this.old;
                        return v4;
                        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    }
                    if (var1_1) {
                        v5 = this.page;
                        return v5;
                    }
                    v5 = this.old;
                    return v5;
                }
            }
        }
    }
}

