/*
 * Decompiled with CFR 0.152.
 */
package sun.io;

import sun.io.CharToByteConverter;
import sun.io.ConversionBufferFullException;
import sun.io.MalformedInputException;
import sun.io.UnknownCharacterException;

public class CharToByteRoman9
extends CharToByteConverter {
    private static final char REPLACEMENT_CHARACTER = '\ufffd';

    @Override
    public String getCharacterEncoding() {
        return "Roman9";
    }

    @Override
    public int flush(byte[] byArray, int n, int n2) throws MalformedInputException {
        this.charOff = 0;
        this.byteOff = 0;
        return 0;
    }

    @Override
    public int convert(char[] cArray, int n, int n2, byte[] byArray, int n3, int n4) throws MalformedInputException, UnknownCharacterException, ConversionBufferFullException {
        this.charOff = n;
        this.byteOff = n3;
        while (this.charOff < n2) {
            if (this.byteOff < n4) {
                char c = cArray[this.charOff];
                ++this.charOff;
                if (c >= '\u0000') {
                    char c2 = this.mapUnicodeToRoman9(c);
                    if (c2 != '\ufffd') {
                        byArray[this.byteOff] = (byte)c2;
                        ++this.byteOff;
                        continue;
                    }
                    throw new UnknownCharacterException();
                }
                if (!this.subMode) {
                    this.badInputLength = 1;
                    throw new UnknownCharacterException();
                }
                throw new UnknownCharacterException();
            }
            throw new ConversionBufferFullException();
        }
        return this.byteOff - n3;
    }

    private char mapUnicodeToRoman9(int n) {
        if (n < 161) {
            return (char)n;
        }
        switch (n) {
            case 8901: {
                return '\u00f2';
            }
            case 164: {
                return '\u00ba';
            }
            case 161: {
                return '\u00b8';
            }
            case 162: {
                return '\u00bf';
            }
            case 163: {
                return '\u00bb';
            }
            case 165: {
                return '\u00bc';
            }
            case 167: {
                return '\u00bd';
            }
            case 168: {
                return '\u00ab';
            }
            case 170: {
                return '\u00f9';
            }
            case 171: {
                return '\u00fb';
            }
            case 173: {
                return '\u00f6';
            }
            case 175: {
                return '\u00b0';
            }
            case 176: {
                return '\u00b3';
            }
            case 177: {
                return '\u00fe';
            }
            case 180: {
                return '\u00a8';
            }
            case 181: {
                return '\u00f3';
            }
            case 182: {
                return '\u00f4';
            }
            case 183: {
                return '\u00f2';
            }
            case 186: {
                return '\u00fa';
            }
            case 187: {
                return '\u00fd';
            }
            case 188: {
                return '\u00f7';
            }
            case 189: {
                return '\u00f8';
            }
            case 190: {
                return '\u00f5';
            }
            case 191: {
                return '\u00b9';
            }
            case 192: {
                return '\u00a1';
            }
            case 193: {
                return '\u00e0';
            }
            case 194: {
                return '\u00a2';
            }
            case 195: {
                return '\u00e1';
            }
            case 196: {
                return '\u00d8';
            }
            case 197: {
                return '\u00d0';
            }
            case 198: {
                return '\u00d3';
            }
            case 199: {
                return '\u00b4';
            }
            case 200: {
                return '\u00a3';
            }
            case 201: {
                return '\u00dc';
            }
            case 202: {
                return '\u00a4';
            }
            case 203: {
                return '\u00a5';
            }
            case 204: {
                return '\u00e6';
            }
            case 205: {
                return '\u00e5';
            }
            case 206: {
                return '\u00a6';
            }
            case 207: {
                return '\u00a7';
            }
            case 208: {
                return '\u00e3';
            }
            case 209: {
                return '\u00b6';
            }
            case 210: {
                return '\u00e8';
            }
            case 211: {
                return '\u00e7';
            }
            case 212: {
                return '\u00df';
            }
            case 213: {
                return '\u00e9';
            }
            case 214: {
                return '\u00da';
            }
            case 216: {
                return '\u00d2';
            }
            case 217: {
                return '\u00ad';
            }
            case 218: {
                return '\u00ed';
            }
            case 219: {
                return '\u00ae';
            }
            case 220: {
                return '\u00db';
            }
            case 221: {
                return '\u00b1';
            }
            case 222: {
                return '\u00f0';
            }
            case 223: {
                return '\u00de';
            }
            case 224: {
                return '\u00c8';
            }
            case 225: {
                return '\u00c4';
            }
            case 226: {
                return '\u00c0';
            }
            case 227: {
                return '\u00e2';
            }
            case 228: {
                return '\u00cc';
            }
            case 229: {
                return '\u00d4';
            }
            case 230: {
                return '\u00d7';
            }
            case 231: {
                return '\u00b5';
            }
            case 232: {
                return '\u00c9';
            }
            case 233: {
                return '\u00c5';
            }
            case 234: {
                return '\u00c1';
            }
            case 235: {
                return '\u00cd';
            }
            case 236: {
                return '\u00d9';
            }
            case 237: {
                return '\u00d5';
            }
            case 238: {
                return '\u00d1';
            }
            case 239: {
                return '\u00dd';
            }
            case 240: {
                return '\u00e4';
            }
            case 241: {
                return '\u00b7';
            }
            case 242: {
                return '\u00ca';
            }
            case 243: {
                return '\u00c6';
            }
            case 244: {
                return '\u00c2';
            }
            case 245: {
                return '\u00ea';
            }
            case 246: {
                return '\u00ce';
            }
            case 248: {
                return '\u00d6';
            }
            case 249: {
                return '\u00cb';
            }
            case 250: {
                return '\u00c7';
            }
            case 251: {
                return '\u00c3';
            }
            case 252: {
                return '\u00cf';
            }
            case 253: {
                return '\u00b2';
            }
            case 254: {
                return '\u00f1';
            }
            case 255: {
                return '\u00ef';
            }
            case 715: {
                return '\u00a9';
            }
            case 710: {
                return '\u00aa';
            }
            case 732: {
                return '\u00ac';
            }
            case 8356: {
                return '\u00af';
            }
            case 8364: {
                return '\u00ba';
            }
            case 402: {
                return '\u00be';
            }
            case 352: {
                return '\u00eb';
            }
            case 353: {
                return '\u00ec';
            }
            case 376: {
                return '\u00ee';
            }
            case 8718: {
                return '\u00fc';
            }
        }
        return '\ufffd';
    }

    @Override
    public boolean canConvert(char c) {
        if (c < '\u00a1') {
            return true;
        }
        if (c > '\u00ff') {
            switch (c) {
                case '\u0160': 
                case '\u0161': 
                case '\u0178': 
                case '\u0192': 
                case '\u02c6': 
                case '\u02cb': 
                case '\u02dc': 
                case '\u20a4': 
                case '\u20ac': 
                case '\u220e': 
                case '\u22c5': {
                    return true;
                }
            }
            return false;
        }
        switch (c) {
            case '\u00a4': 
            case '\u00a6': 
            case '\u00a9': 
            case '\u00ac': 
            case '\u00ae': 
            case '\u00b2': 
            case '\u00b3': 
            case '\u00b8': 
            case '\u00b9': 
            case '\u00d7': 
            case '\u00f7': {
                return false;
            }
        }
        return true;
    }

    @Override
    public void reset() {
        this.charOff = 0;
        this.byteOff = 0;
    }

    @Override
    public int getMaxBytesPerChar() {
        return 1;
    }
}

