/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.io.FileDescriptor;
import java.io.IOException;
import java.nio.channels.AsynchronousChannelGroup;
import java.nio.channels.Channel;
import java.nio.channels.spi.AsynchronousChannelProvider;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import sun.nio.ch.Invoker;
import sun.nio.ch.ThreadPool;
import sun.security.action.GetIntegerAction;

abstract class AsynchronousChannelGroupImpl
extends AsynchronousChannelGroup
implements Executor {
    private static final int internalThreadCount = AccessController.doPrivileged(new GetIntegerAction("sun.nio.ch.internalThreadPoolSize", 1));
    private final ThreadPool pool;
    private final AtomicInteger threadCount = new AtomicInteger();
    private ScheduledThreadPoolExecutor timeoutExecutor;
    private final Queue<Runnable> taskQueue;
    private final AtomicBoolean shutdown = new AtomicBoolean();
    private final Object shutdownNowLock = new Object();
    private volatile boolean terminateInitiated;

    AsynchronousChannelGroupImpl(AsynchronousChannelProvider asynchronousChannelProvider, ThreadPool threadPool) {
        super(asynchronousChannelProvider);
        this.pool = threadPool;
        this.taskQueue = threadPool.isFixedThreadPool() ? new ConcurrentLinkedQueue<Runnable>() : null;
        this.timeoutExecutor = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, ThreadPool.defaultThreadFactory());
        this.timeoutExecutor.setRemoveOnCancelPolicy(true);
    }

    final ExecutorService executor() {
        return this.pool.executor();
    }

    final boolean isFixedThreadPool() {
        return this.pool.isFixedThreadPool();
    }

    final int fixedThreadCount() {
        if (this.isFixedThreadPool()) {
            return this.pool.poolSize();
        }
        return this.pool.poolSize() + internalThreadCount;
    }

    private Runnable bindToGroup(final Runnable runnable) {
        final AsynchronousChannelGroupImpl asynchronousChannelGroupImpl = this;
        return new Runnable(){

            @Override
            public void run() {
                Invoker.bindToGroup(asynchronousChannelGroupImpl);
                runnable.run();
            }
        };
    }

    private void startInternalThread(final Runnable runnable) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ThreadPool.defaultThreadFactory().newThread(runnable).start();
                return null;
            }
        });
    }

    protected final void startThreads(Runnable runnable) {
        int n;
        if (!this.isFixedThreadPool()) {
            for (n = 0; n < internalThreadCount; ++n) {
                this.startInternalThread(runnable);
                this.threadCount.incrementAndGet();
            }
        }
        if (this.pool.poolSize() > 0) {
            runnable = this.bindToGroup(runnable);
            try {
                for (n = 0; n < this.pool.poolSize(); ++n) {
                    this.pool.executor().execute(runnable);
                    this.threadCount.incrementAndGet();
                }
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
    }

    final int threadCount() {
        return this.threadCount.get();
    }

    final int threadExit(Runnable runnable, boolean bl) {
        if (bl) {
            try {
                if (Invoker.isBoundToAnyGroup()) {
                    this.pool.executor().execute(this.bindToGroup(runnable));
                } else {
                    this.startInternalThread(runnable);
                }
                return this.threadCount.get();
            }
            catch (RejectedExecutionException rejectedExecutionException) {
                // empty catch block
            }
        }
        return this.threadCount.decrementAndGet();
    }

    abstract void executeOnHandlerTask(Runnable var1);

    final void executeOnPooledThread(Runnable runnable) {
        if (this.isFixedThreadPool()) {
            this.executeOnHandlerTask(runnable);
        } else {
            this.pool.executor().execute(this.bindToGroup(runnable));
        }
    }

    final void offerTask(Runnable runnable) {
        this.taskQueue.offer(runnable);
    }

    final Runnable pollTask() {
        return this.taskQueue == null ? null : this.taskQueue.poll();
    }

    final Future<?> schedule(Runnable runnable, long l, TimeUnit timeUnit) {
        try {
            return this.timeoutExecutor.schedule(runnable, l, timeUnit);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            if (this.terminateInitiated) {
                return null;
            }
            throw new AssertionError((Object)rejectedExecutionException);
        }
    }

    @Override
    public final boolean isShutdown() {
        return this.shutdown.get();
    }

    @Override
    public final boolean isTerminated() {
        return this.pool.executor().isTerminated();
    }

    abstract boolean isEmpty();

    abstract Object attachForeignChannel(Channel var1, FileDescriptor var2) throws IOException;

    abstract void detachForeignChannel(Object var1);

    abstract void closeAllChannels() throws IOException;

    abstract void shutdownHandlerTasks();

    private void shutdownExecutors() {
        Permissions permissions = new Permissions();
        permissions.add(new RuntimePermission("modifyThread"));
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{new ProtectionDomain(null, permissions)};
        AccessControlContext accessControlContext = new AccessControlContext(protectionDomainArray);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                AsynchronousChannelGroupImpl.this.pool.executor().shutdown();
                AsynchronousChannelGroupImpl.this.timeoutExecutor.shutdown();
                return null;
            }
        }, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        if (this.shutdown.getAndSet(true)) {
            return;
        }
        if (!this.isEmpty()) {
            return;
        }
        Object object = this.shutdownNowLock;
        synchronized (object) {
            if (!this.terminateInitiated) {
                this.terminateInitiated = true;
                this.shutdownHandlerTasks();
                this.shutdownExecutors();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdownNow() throws IOException {
        this.shutdown.set(true);
        Object object = this.shutdownNowLock;
        synchronized (object) {
            if (!this.terminateInitiated) {
                this.terminateInitiated = true;
                this.closeAllChannels();
                this.shutdownHandlerTasks();
                this.shutdownExecutors();
            }
        }
    }

    final void detachFromThreadPool() {
        if (this.shutdown.getAndSet(true)) {
            throw new AssertionError((Object)"Already shutdown");
        }
        if (!this.isEmpty()) {
            throw new AssertionError((Object)"Group not empty");
        }
        this.shutdownHandlerTasks();
    }

    @Override
    public final boolean awaitTermination(long l, TimeUnit timeUnit) throws InterruptedException {
        return this.pool.executor().awaitTermination(l, timeUnit);
    }

    @Override
    public final void execute(Runnable runnable) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            final AccessControlContext accessControlContext = AccessController.getContext();
            final Runnable runnable2 = runnable;
            runnable = new Runnable(){

                @Override
                public void run() {
                    AccessController.doPrivileged(new PrivilegedAction<Void>(){

                        @Override
                        public Void run() {
                            runnable2.run();
                            return null;
                        }
                    }, accessControlContext);
                }
            };
        }
        this.executeOnPooledThread(runnable);
    }
}

