/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import sun.nio.ch.AbstractPollArrayWrapper;
import sun.nio.ch.AllocatedNativeObject;
import sun.nio.ch.IOUtil;
import sun.nio.ch.SelChImpl;

class PollArrayWrapper
extends AbstractPollArrayWrapper {
    static final short POLLCONN = 4;
    int interruptFD;
    private int[] backingBox;

    @Override
    int getDescriptor(int n) {
        return this.backingBox[n * 2];
    }

    @Override
    void putDescriptor(int n, int n2) {
        this.backingBox[n * 2] = n2;
    }

    @Override
    synchronized int getEventOps(int n) {
        return this.backingBox[n * 2 + 1];
    }

    @Override
    synchronized void putEventOps(int n, int n2) {
        this.backingBox[n * 2 + 1] = n2;
    }

    private synchronized void preparePoll(int n) {
        int n2 = 0;
        int n3 = n * 2;
        for (int i = 0; i < n3; i += 2) {
            this.pollArray.putInt(n2 + 0, this.backingBox[i]);
            this.pollArray.putShort(n2 + 4, (short)this.backingBox[i + 1]);
            n2 += 8;
        }
    }

    PollArrayWrapper(int n) {
        n = (n + 1) * 8;
        this.pollArray = new AllocatedNativeObject(n, false);
        this.pollArrayAddress = this.pollArray.address();
        this.totalChannels = 1;
        this.backingBox = new int[2 * n + 2];
    }

    void initInterrupt(int n, int n2) {
        this.interruptFD = n2;
        this.putDescriptor(0, n);
        this.putEventOps(0, 1);
        this.putReventOps(0, 0);
    }

    void release(int n) {
    }

    void free() {
        this.backingBox = null;
        this.pollArray.free();
    }

    synchronized void addEntry(SelChImpl selChImpl) {
        this.putDescriptor(this.totalChannels, IOUtil.fdVal(selChImpl.getFD()));
        this.backingBox[this.totalChannels * 2 + 1] = 0;
        this.putReventOps(this.totalChannels, 0);
        ++this.totalChannels;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void replaceEntry(PollArrayWrapper pollArrayWrapper, int n, PollArrayWrapper pollArrayWrapper2, int n2) {
        PollArrayWrapper pollArrayWrapper3 = pollArrayWrapper2;
        synchronized (pollArrayWrapper3) {
            pollArrayWrapper2.backingBox[n2 * 2] = pollArrayWrapper.backingBox[n * 2];
            pollArrayWrapper2.backingBox[n2 * 2 + 1] = pollArrayWrapper.backingBox[n * 2 + 1];
            pollArrayWrapper2.putReventOps(n2, pollArrayWrapper.getReventOps(n));
        }
    }

    synchronized void grow(int n) {
        PollArrayWrapper pollArrayWrapper = new PollArrayWrapper(n);
        for (int i = 0; i < this.totalChannels; ++i) {
            PollArrayWrapper.replaceEntry(this, i, pollArrayWrapper, i);
        }
        this.pollArray.free();
        this.pollArray = pollArrayWrapper.pollArray;
        this.pollArrayAddress = this.pollArray.address();
        this.backingBox = pollArrayWrapper.backingBox;
    }

    int poll(int n, int n2, long l) {
        this.preparePoll(n + n2);
        return this.poll0(this.pollArrayAddress + (long)(n2 * 8), n, l);
    }

    public void interrupt() {
        PollArrayWrapper.interrupt(this.interruptFD);
    }

    private native int poll0(long var1, int var3, long var4);

    private static native void interrupt(int var0);
}

