/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.WatchService;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import sun.nio.fs.HPUserDefinedFileAttributeView;
import sun.nio.fs.PollingWatchService;
import sun.nio.fs.SolarisFileStore;
import sun.nio.fs.SolarisNativeDispatcher;
import sun.nio.fs.SolarisUserDefinedFileAttributeView;
import sun.nio.fs.SolarisWatchService;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileSystem;
import sun.nio.fs.UnixFileSystemProvider;
import sun.nio.fs.UnixMountEntry;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;
import sun.security.action.GetPropertyAction;

class SolarisFileSystem
extends UnixFileSystem {
    private final boolean hasSolaris11Features;

    SolarisFileSystem(UnixFileSystemProvider unixFileSystemProvider, String string) {
        super(unixFileSystemProvider, string);
        String string2 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        if (string2.equals("HP-UX")) {
            this.hasSolaris11Features = false;
        } else {
            String string3 = AccessController.doPrivileged(new GetPropertyAction("os.version"));
            String[] stringArray = Util.split(string3, '.');
            assert (stringArray.length >= 2);
            int n = Integer.parseInt(stringArray[0]);
            int n2 = Integer.parseInt(stringArray[1]);
            this.hasSolaris11Features = n > 5 || n == 5 && n2 >= 11;
        }
    }

    @Override
    boolean isSolaris() {
        return true;
    }

    @Override
    public WatchService newWatchService() throws IOException {
        if (this.hasSolaris11Features) {
            return new SolarisWatchService(this);
        }
        return new PollingWatchService();
    }

    @Override
    public Set<String> supportedFileAttributeViews() {
        return SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews;
    }

    @Override
    void copyNonPosixAttributes(int n, int n2) {
        SolarisUserDefinedFileAttributeView.copyExtendedAttributes(n, n2);
    }

    @Override
    void copyNonPosixAttributes(UnixPath unixPath, UnixPath unixPath2) {
        HPUserDefinedFileAttributeView.copyExtendedAttributes(unixPath, unixPath2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Iterable<UnixMountEntry> getMountEntries() {
        ArrayList<UnixMountEntry> arrayList = new ArrayList<UnixMountEntry>();
        try {
            UnixPath unixPath = new UnixPath((UnixFileSystem)this, "/etc/mnttab");
            long l = SolarisNativeDispatcher.fopen(unixPath, "r");
            try {
                UnixMountEntry unixMountEntry;
                int n;
                while ((n = SolarisNativeDispatcher.getextmntent(l, unixMountEntry = new UnixMountEntry())) >= 0) {
                    arrayList.add(unixMountEntry);
                }
            }
            finally {
                SolarisNativeDispatcher.fclose(l);
            }
        }
        catch (UnixException unixException) {
            System.out.println("Exception throws " + unixException);
        }
        return arrayList;
    }

    @Override
    FileStore getFileStore(UnixMountEntry unixMountEntry) throws IOException {
        return new SolarisFileStore(this, unixMountEntry);
    }

    private static class SupportedFileFileAttributeViewsHolder {
        static final Set<String> supportedFileAttributeViews = SupportedFileFileAttributeViewsHolder.supportedFileAttributeViews();

        private SupportedFileFileAttributeViewsHolder() {
        }

        private static Set<String> supportedFileAttributeViews() {
            String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.addAll(UnixFileSystem.standardFileAttributeViews());
            if (!string.equals("HP-UX")) {
                hashSet.add("acl");
            }
            hashSet.add("user");
            return Collections.unmodifiableSet(hashSet);
        }
    }
}

