/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRLReason;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.Extension;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.misc.CharacterEncoder;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.OCSPChecker;
import sun.security.provider.certpath.ResponderId;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CertImpl;

public final class OCSPResponse {
    private static final ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean dump = Debug.isOn("ocsp");
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private static final int DEFAULT_MAX_CLOCK_SKEW = 900000;
    private static final int MAX_CLOCK_SKEW = OCSPResponse.initializeClockSkew();
    private static final CRLReason[] values = CRLReason.values();
    private final byte[] responseNonce;
    private final ResponderId respId;
    private Date producedAtDate = null;
    private final Map<String, Extension> responseExtensions;

    private static int initializeClockSkew() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.clockSkew"));
        if (n == null || n < 0) {
            return 900000;
        }
        return n * 1000;
    }

    public OCSPResponse(byte[] byArray, Date date, List<X509Certificate> list, IssuerInfo issuerInfo, String string) throws IOException, CertPathValidatorException {
        Object object;
        Object object2;
        X509CertImpl[] x509CertImplArray;
        Object object4;
        if (dump) {
            object4 = new HexDumpEncoder();
            debug.println("\nOCSPResponse bytes...");
            debug.println(((CharacterEncoder)object4).encode(byArray) + "\n");
        }
        object4 = new DerValue(byArray);
        if (((DerValue)object4).tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream = ((DerValue)object4).getData();
        int n = derInputStream.getEnumerated();
        if (n < 0 || n >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + n);
        }
        this.responseStatus = rsvalues[n];
        if (debug != null) {
            debug.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            this.responseNonce = null;
            this.responseExtensions = Collections.emptyMap();
            this.respId = null;
            return;
        }
        object4 = derInputStream.getDerValue();
        if (!((DerValue)object4).isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue derValue = ((DerValue)object4).data.getDerValue();
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derInputStream = derValue.data;
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (objectIdentifier.equals((Object)OCSP_BASIC_RESPONSE_OID)) {
            if (debug != null) {
                debug.println("OCSP response type: basic");
            }
        } else {
            if (debug != null) {
                debug.println("OCSP response type: " + objectIdentifier);
            }
            throw new IOException("Unsupported OCSP response type: " + objectIdentifier);
        }
        DerInputStream derInputStream2 = new DerInputStream(derInputStream.getOctetString());
        DerValue[] derValueArray = derInputStream2.getSequence(2);
        if (derValueArray.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue derValue2 = derValueArray[0];
        byte[] byArray2 = derValueArray[0].toByteArray();
        if (derValue2.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream3 = derValue2.data;
        DerValue derValue3 = derInputStream3.getDerValue();
        if (derValue3.isContextSpecific((byte)0) && derValue3.isConstructed() && derValue3.isContextSpecific()) {
            derValue3 = derValue3.data.getDerValue();
            int n2 = derValue3.getInteger();
            if (derValue3.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            derValue3 = derInputStream3.getDerValue();
        }
        this.respId = new ResponderId(derValue3.toByteArray());
        if (debug != null) {
            debug.println("Responder ID: " + this.respId);
        }
        derValue3 = derInputStream3.getDerValue();
        this.producedAtDate = derValue3.getGeneralizedTime();
        if (debug != null) {
            debug.println("OCSP response produced at: " + this.producedAtDate);
        }
        DerValue[] derValueArray2 = derInputStream3.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(derValueArray2.length);
        if (debug != null) {
            debug.println("OCSP number of SingleResponses: " + derValueArray2.length);
        }
        for (DerValue object32 : derValueArray2) {
            x509CertImplArray = new SingleResponse(object32);
            this.singleResponseMap.put(x509CertImplArray.getCertId(), (SingleResponse)x509CertImplArray);
        }
        Object object5 = new HashMap();
        if (derInputStream3.available() > 0 && (derValue3 = derInputStream3.getDerValue()).isContextSpecific((byte)1)) {
            object5 = OCSPResponse.parseExtensions(derValue3);
        }
        this.responseExtensions = object5;
        Extension extension = (Extension)object5.get(PKIXExtensions.OCSPNonce_Id.toString());
        byte[] byArray3 = this.responseNonce = extension != null ? extension.getValue() : null;
        if (debug != null && this.responseNonce != null) {
            debug.println("Response nonce: " + Arrays.toString(this.responseNonce));
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray[1]);
        byte[] byArray4 = derValueArray[2].getBitString();
        x509CertImplArray = null;
        if (derValueArray.length > 3) {
            object2 = derValueArray[3];
            if (!((DerValue)object2).isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            object = ((DerValue)object2).getData().getSequence(3);
            x509CertImplArray = new X509CertImpl[((DerValue[])object).length];
            try {
                for (int certificateException = 0; certificateException < ((DerValue[])object).length; ++certificateException) {
                    x509CertImplArray[certificateException] = new X509CertImpl(((DerValue)object[certificateException]).toByteArray());
                }
            }
            catch (CertificateException byArray42) {
                throw new IOException("Bad encoding in X509 Certificate", byArray42);
            }
        }
        object2 = list.get(0);
        if (x509CertImplArray != null && x509CertImplArray[0] != null) {
            object = x509CertImplArray[0];
            if (debug != null) {
                debug.println("Signer certificate name: " + ((X509CertImpl)object).getSubjectX500Principal());
                byte[] byArray5 = ((X509CertImpl)object).getSubjectKeyIdentifier();
                if (byArray5 != null) {
                    debug.println("Signer certificate key ID: " + String.format("0x%0" + byArray5.length * 2 + "x", new BigInteger(1, byArray5)));
                }
            }
            byte[] byArray5 = null;
            for (X509Certificate x509Certificate : list) {
                List<String> certificateParsingException;
                if (((X509CertImpl)object).getSubjectX500Principal().equals(issuerInfo.getName()) && ((X509CertImpl)object).getPublicKey().equals(issuerInfo.getPublicKey())) {
                    object2 = x509Certificate;
                    if (debug == null) break;
                    debug.println("Signer certificate is a trusted responder");
                    break;
                }
                if (!((X509CertImpl)object).getIssuerX500Principal().equals(issuerInfo.getName())) continue;
                if (byArray5 == null && (byArray5 = ((X509CertImpl)object).getIssuerKeyIdentifier()) == null && debug != null) {
                    debug.println("No issuer key identifier (AKID) in the signer certificate");
                }
                byte[] byArray6 = null;
                if (byArray5 != null && (byArray6 = OCSPChecker.getKeyId(x509Certificate)) != null) {
                    if (!Arrays.equals(byArray5, byArray6)) continue;
                    if (debug != null) {
                        debug.println("Issuer certificate key ID: " + String.format("0x%0" + byArray5.length * 2 + "x", new BigInteger(1, byArray5)));
                    }
                }
                try {
                    certificateParsingException = ((X509CertImpl)object).getExtendedKeyUsage();
                    if (certificateParsingException == null) continue;
                    if (!certificateParsingException.contains(KP_OCSP_SIGNING_OID)) {
                    }
                }
                catch (CertificateParsingException certificateParsingException2) {}
                continue;
                certificateParsingException = new AlgorithmChecker(issuerInfo.getAnchor(), date, string);
                ((AlgorithmChecker)((Object)certificateParsingException)).init(false);
                ((AlgorithmChecker)((Object)certificateParsingException)).check((Certificate)object, Collections.emptySet());
                try {
                    if (date == null) {
                        ((X509CertImpl)object).checkValidity();
                    } else {
                        ((X509CertImpl)object).checkValidity(date);
                    }
                }
                catch (GeneralSecurityException generalSecurityException) {
                    if (debug == null) continue;
                    debug.println("Responder's certificate not within the validity period " + generalSecurityException);
                    continue;
                }
                sun.security.x509.Extension generalSecurityException = ((X509CertImpl)object).getExtension(PKIXExtensions.OCSPNoCheck_Id);
                if (generalSecurityException != null && debug != null) {
                    debug.println("Responder's certificate includes the extension id-pkix-ocsp-nocheck.");
                }
                try {
                    ((X509CertImpl)object).verify(x509Certificate.getPublicKey());
                    object2 = object;
                    if (debug == null) break;
                    debug.println("Signer certificate was issued by a trusted responder");
                    break;
                }
                catch (GeneralSecurityException generalSecurityException2) {
                    object2 = null;
                }
            }
        }
        if (object2 != null) {
            AlgorithmChecker.check(((Certificate)object2).getPublicKey(), algorithmId, string);
            if (!this.verifyResponse(byArray2, (X509Certificate)object2, algorithmId, byArray4)) {
                throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
            }
        } else {
            throw new CertPathValidatorException("Responder's certificate is not trusted for signing OCSP responses");
        }
    }

    public ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifyResponse(byte[] byArray, X509Certificate x509Certificate, AlgorithmId algorithmId, byte[] byArray2) throws CertPathValidatorException {
        try {
            Signature signature = Signature.getInstance(algorithmId.getName());
            signature.initVerify(x509Certificate.getPublicKey());
            signature.update(byArray);
            if (signature.verify(byArray2)) {
                if (debug != null) {
                    debug.println("Verified signature of OCSP Responder");
                }
                return true;
            }
            if (debug != null) {
                debug.println("Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertPathValidatorException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertPathValidatorException(noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new CertPathValidatorException(signatureException);
        }
    }

    public SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    public Set<CertId> getCertIds() {
        return Collections.unmodifiableSet(this.singleResponseMap.keySet());
    }

    public ResponderId getResponderId() {
        return this.respId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCSP Response:\n");
        stringBuilder.append("Response Status: ").append((Object)this.responseStatus).append("\n");
        stringBuilder.append("Responder ID: ").append(this.respId).append("\n");
        stringBuilder.append("Produced at: ").append(this.producedAtDate).append("\n");
        int n = this.singleResponseMap.size();
        stringBuilder.append(n).append(n == 1 ? " response:\n" : " responses:\n");
        for (SingleResponse object : this.singleResponseMap.values()) {
            stringBuilder.append(object).append("\n");
        }
        if (this.responseExtensions != null && this.responseExtensions.size() > 0) {
            n = this.responseExtensions.size();
            stringBuilder.append(n).append(n == 1 ? " extension:\n" : " extensions:\n");
            for (String string : this.responseExtensions.keySet()) {
                stringBuilder.append(this.responseExtensions.get(string)).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    private static Map<String, Extension> parseExtensions(DerValue derValue) throws IOException {
        DerValue[] derValueArray = derValue.data.getSequence(3);
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>(derValueArray.length);
        for (DerValue derValue2 : derValueArray) {
            sun.security.x509.Extension extension = new sun.security.x509.Extension(derValue2);
            if (debug != null) {
                debug.println("Extension: " + extension);
            }
            if (extension.isCritical()) {
                throw new IOException("Unsupported OCSP critical extension: " + extension.getExtensionId());
            }
            hashMap.put(extension.getId(), extension);
        }
        return hashMap;
    }

    static final class IssuerInfo {
        private final TrustAnchor anchor;
        private final X509Certificate certificate;
        private final X500Principal name;
        private final PublicKey pubKey;

        IssuerInfo(TrustAnchor trustAnchor) {
            this(trustAnchor, trustAnchor != null ? trustAnchor.getTrustedCert() : null);
        }

        IssuerInfo(X509Certificate x509Certificate) {
            this(null, x509Certificate);
        }

        IssuerInfo(TrustAnchor trustAnchor, X509Certificate x509Certificate) {
            if (trustAnchor == null && x509Certificate == null) {
                throw new NullPointerException("TrustAnchor and issuerCert cannot be null");
            }
            this.anchor = trustAnchor;
            if (x509Certificate != null) {
                this.name = x509Certificate.getSubjectX500Principal();
                this.pubKey = x509Certificate.getPublicKey();
                this.certificate = x509Certificate;
            } else {
                this.name = trustAnchor.getCA();
                this.pubKey = trustAnchor.getCAPublicKey();
                this.certificate = trustAnchor.getTrustedCert();
            }
        }

        X509Certificate getCertificate() {
            return this.certificate;
        }

        X500Principal getName() {
            return this.name;
        }

        PublicKey getPublicKey() {
            return this.pubKey;
        }

        TrustAnchor getAnchor() {
            return this.anchor;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Issuer Info:\n");
            stringBuilder.append("Name: ").append(this.name.toString()).append("\n");
            stringBuilder.append("Public Key:\n").append(this.pubKey.toString()).append("\n");
            return stringBuilder.toString();
        }
    }

    public static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private final CRLReason revocationReason;
        private final Map<String, Extension> singleExtensions;

        private SingleResponse(DerValue derValue) throws IOException {
            this(derValue, (Date)null);
        }

        private SingleResponse(DerValue derValue, Date date) throws IOException {
            Object object;
            if (derValue.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream derInputStream = derValue.data;
            this.certId = new CertId(derInputStream.getDerValue().data);
            DerValue derValue2 = derInputStream.getDerValue();
            short s = (byte)(derValue2.tag & 0x1F);
            if (s == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derValue2.data.getGeneralizedTime();
                if (derValue2.data.available() != 0) {
                    int n;
                    object = derValue2.data.getDerValue();
                    s = (byte)(((DerValue)object).tag & 0x1F);
                    this.revocationReason = s == 0 ? ((n = ((DerValue)object).data.getEnumerated()) >= 0 && n < values.length ? values[n] : CRLReason.UNSPECIFIED) : CRLReason.UNSPECIFIED;
                } else {
                    this.revocationReason = CRLReason.UNSPECIFIED;
                }
                if (debug != null) {
                    debug.println("Revocation time: " + this.revocationTime);
                    debug.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = null;
                if (s == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (s == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = derInputStream.getGeneralizedTime();
            if (debug != null) {
                debug.println("thisUpdate: " + this.thisUpdate);
            }
            object = null;
            Map map = null;
            if (derInputStream.available() > 0) {
                derValue2 = derInputStream.getDerValue();
                if (derValue2.isContextSpecific((byte)0)) {
                    object = derValue2.data.getGeneralizedTime();
                    if (debug != null) {
                        debug.println("nextUpdate: " + object);
                    }
                    DerValue derValue3 = derValue2 = derInputStream.available() > 0 ? derInputStream.getDerValue() : null;
                }
                if (derValue2 != null) {
                    if (derValue2.isContextSpecific((byte)1)) {
                        map = OCSPResponse.parseExtensions(derValue2);
                        if (derInputStream.available() > 0) {
                            throw new IOException(derInputStream.available() + " bytes of additional data in singleResponse");
                        }
                    } else {
                        throw new IOException("Unsupported singleResponse item, tag = " + String.format("%02X", derValue2.tag));
                    }
                }
            }
            this.nextUpdate = object;
            Map<String, Extension> map2 = this.singleExtensions = map != null ? map : Collections.emptyMap();
            if (debug != null) {
                for (Extension extension : this.singleExtensions.values()) {
                    debug.println("singleExtension: " + extension);
                }
            }
            long l = System.currentTimeMillis();
            Date date2 = new Date(l + (long)MAX_CLOCK_SKEW);
            Date date3 = new Date(l - (long)MAX_CLOCK_SKEW);
            if (debug != null) {
                String string = "";
                if (this.nextUpdate != null) {
                    string = " until " + this.nextUpdate;
                }
                debug.println("OCSP response validity interval is from " + this.thisUpdate + string);
                debug.println("Checking validity of OCSP response on: " + new Date(l));
            }
            if (date2.before(this.thisUpdate) || date3.after(this.nextUpdate != null ? this.nextUpdate : this.thisUpdate)) {
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        @Override
        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        public CertId getCertId() {
            return this.certId;
        }

        public Date getThisUpdate() {
            return this.thisUpdate != null ? (Date)this.thisUpdate.clone() : null;
        }

        public Date getNextUpdate() {
            return this.nextUpdate != null ? (Date)this.nextUpdate.clone() : null;
        }

        @Override
        public Date getRevocationTime() {
            return this.revocationTime != null ? (Date)this.revocationTime.clone() : null;
        }

        @Override
        public CRLReason getRevocationReason() {
            return this.revocationReason;
        }

        @Override
        public Map<String, Extension> getSingleExtensions() {
            return Collections.unmodifiableMap(this.singleExtensions);
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SingleResponse:\n");
            stringBuilder.append(this.certId);
            stringBuilder.append("\nCertStatus: ").append((Object)this.certStatus).append("\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                stringBuilder.append("revocationTime is ");
                stringBuilder.append(this.revocationTime).append("\n");
                stringBuilder.append("revocationReason is ");
                stringBuilder.append((Object)this.revocationReason).append("\n");
            }
            stringBuilder.append("thisUpdate is ").append(this.thisUpdate).append("\n");
            if (this.nextUpdate != null) {
                stringBuilder.append("nextUpdate is ").append(this.nextUpdate).append("\n");
            }
            for (Extension extension : this.singleExtensions.values()) {
                stringBuilder.append("singleExtension: ");
                stringBuilder.append(extension.toString()).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

