/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.DefaultResponseControlFactory;
import com.sun.jndi.ldap.EventSupport;
import com.sun.jndi.ldap.LdapAttribute;
import com.sun.jndi.ldap.LdapBindingEnumeration;
import com.sun.jndi.ldap.LdapClient;
import com.sun.jndi.ldap.LdapEntry;
import com.sun.jndi.ldap.LdapNameParser;
import com.sun.jndi.ldap.LdapNamingEnumeration;
import com.sun.jndi.ldap.LdapReferralContext;
import com.sun.jndi.ldap.LdapReferralException;
import com.sun.jndi.ldap.LdapResult;
import com.sun.jndi.ldap.LdapSchemaCtx;
import com.sun.jndi.ldap.LdapSearchEnumeration;
import com.sun.jndi.ldap.LdapURL;
import com.sun.jndi.ldap.ManageReferralControl;
import com.sun.jndi.ldap.Obj;
import com.sun.jndi.ldap.ext.StartTlsResponseImpl;
import com.sun.jndi.toolkit.ctx.ComponentDirContext;
import com.sun.jndi.toolkit.ctx.Continuation;
import com.sun.jndi.toolkit.dir.HierMemDirCtx;
import com.sun.jndi.toolkit.dir.SearchFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.stream.Collectors;
import javax.naming.AuthenticationException;
import javax.naming.AuthenticationNotSupportedException;
import javax.naming.Binding;
import javax.naming.CommunicationException;
import javax.naming.CompositeName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.ContextNotEmptyException;
import javax.naming.InvalidNameException;
import javax.naming.LimitExceededException;
import javax.naming.Name;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.NoPermissionException;
import javax.naming.OperationNotSupportedException;
import javax.naming.PartialResultException;
import javax.naming.ServiceUnavailableException;
import javax.naming.SizeLimitExceededException;
import javax.naming.TimeLimitExceededException;
import javax.naming.directory.Attribute;
import javax.naming.directory.AttributeInUseException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InvalidAttributeIdentifierException;
import javax.naming.directory.InvalidAttributeValueException;
import javax.naming.directory.InvalidSearchFilterException;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.NoSuchAttributeException;
import javax.naming.directory.SchemaViolationException;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.event.EventDirContext;
import javax.naming.event.NamingListener;
import javax.naming.ldap.Control;
import javax.naming.ldap.ControlFactory;
import javax.naming.ldap.ExtendedRequest;
import javax.naming.ldap.ExtendedResponse;
import javax.naming.ldap.LdapContext;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.naming.ldap.UnsolicitedNotificationListener;
import javax.naming.spi.DirectoryManager;

public final class LdapCtx
extends ComponentDirContext
implements EventDirContext,
LdapContext {
    private static final boolean debug = false;
    private static final boolean HARD_CLOSE = true;
    private static final boolean SOFT_CLOSE = false;
    public static final int DEFAULT_PORT = 389;
    public static final int DEFAULT_SSL_PORT = 636;
    public static final String DEFAULT_HOST = "localhost";
    private static final boolean DEFAULT_DELETE_RDN = true;
    private static final boolean DEFAULT_TYPES_ONLY = false;
    private static final int DEFAULT_DEREF_ALIASES = 3;
    private static final int DEFAULT_LDAP_VERSION = 32;
    private static final int DEFAULT_BATCH_SIZE = 1;
    private static final int DEFAULT_REFERRAL_MODE = 3;
    private static final char DEFAULT_REF_SEPARATOR = '#';
    static final String DEFAULT_SSL_FACTORY = "javax.net.ssl.SSLSocketFactory";
    private static final int DEFAULT_REFERRAL_LIMIT = 10;
    private static final String STARTTLS_REQ_OID = "1.3.6.1.4.1.1466.20037";
    private static final String[] SCHEMA_ATTRIBUTES = new String[]{"objectClasses", "attributeTypes", "matchingRules", "ldapSyntaxes"};
    private static final String VERSION = "java.naming.ldap.version";
    private static final String BINARY_ATTRIBUTES = "java.naming.ldap.attributes.binary";
    private static final String DELETE_RDN = "java.naming.ldap.deleteRDN";
    private static final String DEREF_ALIASES = "java.naming.ldap.derefAliases";
    private static final String TYPES_ONLY = "java.naming.ldap.typesOnly";
    private static final String REF_SEPARATOR = "java.naming.ldap.ref.separator";
    private static final String SOCKET_FACTORY = "java.naming.ldap.factory.socket";
    static final String BIND_CONTROLS = "java.naming.ldap.control.connect";
    private static final String REFERRAL_LIMIT = "java.naming.ldap.referral.limit";
    private static final String TRACE_BER = "com.sun.jndi.ldap.trace.ber";
    private static final String NETSCAPE_SCHEMA_BUG = "com.sun.jndi.ldap.netscape.schemaBugs";
    private static final String OLD_NETSCAPE_SCHEMA_BUG = "com.sun.naming.netscape.schemaBugs";
    private static final String CONNECT_TIMEOUT = "com.sun.jndi.ldap.connect.timeout";
    private static final String READ_TIMEOUT = "com.sun.jndi.ldap.read.timeout";
    private static final String ENABLE_POOL = "com.sun.jndi.ldap.connect.pool";
    private static final String DOMAIN_NAME = "com.sun.jndi.ldap.domainname";
    private static final String WAIT_FOR_REPLY = "com.sun.jndi.ldap.search.waitForReply";
    private static final String REPLY_QUEUE_SIZE = "com.sun.jndi.ldap.search.replyQueueSize";
    static final String DNS_PROVIDER = "com.sun.jndi.ldap.dnsProvider";
    private static final String ALLOWED_MECHS_SP = "jdk.jndi.ldap.mechsAllowedToSendCredentials";
    private static final String ALLOWED_MECHS_SP_VALUE = LdapCtx.getMechsAllowedToSendCredentials();
    private static final Set<String> MECHS_ALLOWED_BY_SP = LdapCtx.getMechsFromPropertyValue(ALLOWED_MECHS_SP_VALUE);
    private static final String UNSECURED_CRED_TRANSMIT_MSG = "Transmission of credentials over unsecured connection is not allowed";
    private static final NameParser parser = new LdapNameParser();
    private static final ControlFactory myResponseControlFactory = new DefaultResponseControlFactory();
    private static final Control manageReferralControl = new ManageReferralControl(false);
    private static final HierMemDirCtx EMPTY_SCHEMA = new HierMemDirCtx();
    int port_number;
    String hostname = null;
    LdapClient clnt = null;
    Hashtable<String, Object> envprops = null;
    int handleReferrals = 3;
    boolean hasLdapsScheme = false;
    String currentDN;
    Name currentParsedDN;
    Vector<Control> respCtls = null;
    Control[] reqCtls = null;
    volatile boolean contextSeenStartTlsEnabled;
    private OutputStream trace = null;
    private boolean netscapeSchemaBug = false;
    private Control[] bindCtls = null;
    private int referralHopLimit = 10;
    private Hashtable<String, DirContext> schemaTrees = null;
    private int batchSize = 1;
    private boolean deleteRDN = true;
    private boolean typesOnly = false;
    private int derefAliases = 3;
    private char addrEncodingSeparator = (char)35;
    private Hashtable<String, Boolean> binaryAttrs = null;
    private int connectTimeout = -1;
    private int readTimeout = -1;
    private boolean waitForReply = true;
    private int replyQueueSize = -1;
    private boolean useSsl = false;
    private boolean useDefaultPortNumber = false;
    private boolean parentIsLdapCtx = false;
    private int hopCount = 1;
    private String url = null;
    private EventSupport eventSupport;
    private boolean unsolicited = false;
    private boolean sharable = true;
    private int enumCount = 0;
    private boolean closeRequested = false;

    public LdapCtx(String string, String string2, int n, Hashtable<?, ?> hashtable, boolean bl) throws NamingException {
        this.useSsl = this.hasLdapsScheme = bl;
        if (hashtable != null) {
            this.envprops = (Hashtable)hashtable.clone();
            if ("ssl".equals(this.envprops.get("java.naming.security.protocol"))) {
                this.useSsl = true;
            }
            this.trace = (OutputStream)this.envprops.get(TRACE_BER);
            if (hashtable.get(NETSCAPE_SCHEMA_BUG) != null || hashtable.get(OLD_NETSCAPE_SCHEMA_BUG) != null) {
                this.netscapeSchemaBug = true;
            }
        }
        this.currentDN = string != null ? string : "";
        this.currentParsedDN = parser.parse(this.currentDN);
        String string3 = this.hostname = string2 != null && string2.length() > 0 ? string2 : DEFAULT_HOST;
        if (this.hostname.charAt(0) == '[') {
            this.hostname = this.hostname.substring(1, this.hostname.length() - 1);
        }
        if (n > 0) {
            this.port_number = n;
        } else {
            this.port_number = this.useSsl ? 636 : 389;
            this.useDefaultPortNumber = true;
        }
        this.schemaTrees = new Hashtable(11, 0.75f);
        this.initEnv();
        try {
            this.connect(false);
        }
        catch (NamingException namingException) {
            try {
                this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw namingException;
        }
    }

    LdapCtx(LdapCtx ldapCtx, String string) throws NamingException {
        this.useSsl = ldapCtx.useSsl;
        this.hasLdapsScheme = ldapCtx.hasLdapsScheme;
        this.useDefaultPortNumber = ldapCtx.useDefaultPortNumber;
        this.hostname = ldapCtx.hostname;
        this.port_number = ldapCtx.port_number;
        this.currentDN = string;
        this.currentParsedDN = ldapCtx.currentDN == this.currentDN ? ldapCtx.currentParsedDN : parser.parse(this.currentDN);
        this.envprops = ldapCtx.envprops;
        this.schemaTrees = ldapCtx.schemaTrees;
        this.clnt = ldapCtx.clnt;
        this.clnt.incRefCount();
        this.parentIsLdapCtx = string == null || string.equals(ldapCtx.currentDN) ? ldapCtx.parentIsLdapCtx : true;
        this.trace = ldapCtx.trace;
        this.netscapeSchemaBug = ldapCtx.netscapeSchemaBug;
        this.initEnv();
    }

    @Override
    public LdapContext newInstance(Control[] controlArray) throws NamingException {
        LdapCtx ldapCtx = new LdapCtx(this, this.currentDN);
        ldapCtx.setRequestControls(controlArray);
        return ldapCtx;
    }

    @Override
    protected void c_bind(Name name, Object object, Continuation continuation) throws NamingException {
        this.c_bind(name, object, null, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_bind(Name var1_1, Object var2_2, Attributes var3_3, Continuation var4_4) throws NamingException {
        var4_4.setError((Object)this, var1_1);
        var5_5 = var3_3;
        try {
            this.ensureOpen();
            if (var2_2 == null) {
                if (var3_3 == null) {
                    throw new IllegalArgumentException("cannot bind null object with no attributes");
                }
            } else {
                var3_3 = Obj.determineBindAttrs(this.addrEncodingSeparator, var2_2, var3_3, false, var1_1, this, this.envprops);
            }
            var6_6 = this.fullyQualifiedName(var1_1);
            var3_3 = LdapCtx.addRdnAttributes(var6_6, var3_3, var5_5 != var3_3);
            var7_11 = new LdapEntry(var6_6, var3_3);
            var8_14 = this.clnt.add(var7_11, this.reqCtls);
            this.respCtls = var8_14.resControls;
            if (var8_14.status != 0) {
                this.processReturnCode(var8_14, var1_1);
            }
        }
        catch (LdapReferralException var6_7) {
            if (this.handleReferrals == 2) {
                throw var4_4.fillInException(var6_7);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var7_12 = (LdapReferralContext)var6_8.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var7_12.bind(var1_1, var2_2, var5_5);
                    return;
                }
                catch (LdapReferralException var8_15) {
                    var6_8 = var8_15;
                }
                finally {
                    var7_12.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var6_9) {
            var7_13 = new CommunicationException(var6_9.getMessage());
            var7_13.setRootCause(var6_9);
            throw var4_4.fillInException(var7_13);
        }
        catch (NamingException var6_10) {
            throw var4_4.fillInException(var6_10);
        }
    }

    @Override
    protected void c_rebind(Name name, Object object, Continuation continuation) throws NamingException {
        this.c_rebind(name, object, null, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_rebind(Name var1_1, Object var2_2, Attributes var3_3, Continuation var4_4) throws NamingException {
        var4_4.setError((Object)this, var1_1);
        var5_5 = var3_3;
        try {
            var6_6 = null;
            try {
                var6_6 = this.c_getAttributes(var1_1, null, var4_4);
            }
            catch (NameNotFoundException var7_11) {
                // empty catch block
            }
            if (var6_6 == null) {
                this.c_bind(var1_1, var2_2, var3_3, var4_4);
                return;
            }
            if (var3_3 == null && var2_2 instanceof DirContext) {
                var3_3 = ((DirContext)var2_2).getAttributes("");
            }
            var7_12 = (Attributes)var6_6.clone();
            if (var3_3 == null) {
                var8_15 = var6_6.get(Obj.JAVA_ATTRIBUTES[0]);
                if (var8_15 != null) {
                    var8_15 = (Attribute)var8_15.clone();
                    for (var9_17 = 0; var9_17 < Obj.JAVA_OBJECT_CLASSES.length; ++var9_17) {
                        var8_15.remove(Obj.JAVA_OBJECT_CLASSES_LOWER[var9_17]);
                        var8_15.remove(Obj.JAVA_OBJECT_CLASSES[var9_17]);
                    }
                    var6_6.put((Attribute)var8_15);
                }
                for (var9_17 = 1; var9_17 < Obj.JAVA_ATTRIBUTES.length; ++var9_17) {
                    var6_6.remove(Obj.JAVA_ATTRIBUTES[var9_17]);
                }
                var3_3 = var6_6;
            }
            if (var2_2 != null) {
                var3_3 = Obj.determineBindAttrs(this.addrEncodingSeparator, var2_2, var3_3, var5_5 != var3_3, var1_1, this, this.envprops);
            }
            var8_15 = this.fullyQualifiedName(var1_1);
            var9_18 = this.clnt.delete((String)var8_15, this.reqCtls);
            this.respCtls = var9_18.resControls;
            if (var9_18.status != 0) {
                this.processReturnCode(var9_18, var1_1);
                return;
            }
            var10_19 = null;
            try {
                var3_3 = LdapCtx.addRdnAttributes((String)var8_15, var3_3, var5_5 != var3_3);
                var11_20 = new LdapEntry((String)var8_15, var3_3);
                var9_18 = this.clnt.add((LdapEntry)var11_20, this.reqCtls);
                if (var9_18.resControls != null) {
                    this.respCtls = LdapCtx.appendVector(this.respCtls, var9_18.resControls);
                }
            }
            catch (IOException | NamingException var11_21) {
                var10_19 = var11_21;
            }
            if (var10_19 != null && !(var10_19 instanceof LdapReferralException) || var9_18.status != 0) {
                var11_20 = this.clnt.add(new LdapEntry((String)var8_15, var7_12), this.reqCtls);
                if (var11_20.resControls != null) {
                    this.respCtls = LdapCtx.appendVector(this.respCtls, var11_20.resControls);
                }
                if (var10_19 == null) {
                    this.processReturnCode(var9_18, var1_1);
                }
            }
            if (var10_19 instanceof NamingException) {
                throw (NamingException)var10_19;
            }
            if (var10_19 instanceof IOException) {
                throw (IOException)var10_19;
            }
        }
        catch (LdapReferralException var6_7) {
            if (this.handleReferrals == 2) {
                throw var4_4.fillInException(var6_7);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var7_13 = (LdapReferralContext)var6_8.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var7_13.rebind(var1_1, var2_2, var5_5);
                    return;
                }
                catch (LdapReferralException var8_16) {
                    var6_8 = var8_16;
                }
                finally {
                    var7_13.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var6_9) {
            var7_14 = new CommunicationException(var6_9.getMessage());
            var7_14.setRootCause(var6_9);
            throw var4_4.fillInException(var7_14);
        }
        catch (NamingException var6_10) {
            throw var4_4.fillInException(var6_10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_unbind(Name var1_1, Continuation var2_2) throws NamingException {
        var2_2.setError((Object)this, var1_1);
        try {
            this.ensureOpen();
            var3_3 = this.fullyQualifiedName(var1_1);
            var4_8 = this.clnt.delete(var3_3, this.reqCtls);
            this.respCtls = var4_8.resControls;
            this.adjustDeleteStatus(var3_3, var4_8);
            if (var4_8.status != 0) {
                this.processReturnCode(var4_8, var1_1);
            }
        }
        catch (LdapReferralException var3_4) {
            if (this.handleReferrals == 2) {
                throw var2_2.fillInException(var3_4);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var4_9 = (LdapReferralContext)var3_5.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var4_9.unbind(var1_1);
                    return;
                }
                catch (LdapReferralException var5_11) {
                    var3_5 = var5_11;
                }
                finally {
                    var4_9.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var3_6) {
            var4_10 = new CommunicationException(var3_6.getMessage());
            var4_10.setRootCause(var3_6);
            throw var2_2.fillInException(var4_10);
        }
        catch (NamingException var3_7) {
            throw var2_2.fillInException(var3_7);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_rename(Name var1_1, Name var2_2, Continuation var3_3) throws NamingException {
        var8_4 = null;
        var9_5 = null;
        var3_3.setError((Object)this, var1_1);
        try {
            this.ensureOpen();
            if (var1_1.isEmpty()) {
                var6_6 = LdapCtx.parser.parse("");
            } else {
                var4_7 = LdapCtx.parser.parse(var1_1.get(0));
                var6_6 = var4_7.getPrefix(var4_7.size() - 1);
            }
            var5_8 = var2_2 instanceof CompositeName != false ? LdapCtx.parser.parse(var2_2.get(0)) : var2_2;
            var7_9 = var5_8.getPrefix(var5_8.size() - 1);
            if (!var6_6.equals(var7_9)) {
                if (!this.clnt.isLdapv3) {
                    throw new InvalidNameException("LDAPv2 doesn't support changing the parent as a result of a rename");
                }
                var9_5 = this.fullyQualifiedName(var7_9.toString());
            }
            var8_4 = var5_8.get(var5_8.size() - 1);
            var10_10 = this.clnt.moddn(this.fullyQualifiedName(var1_1), var8_4, this.deleteRDN, var9_5, this.reqCtls);
            this.respCtls = var10_10.resControls;
            if (var10_10.status != 0) {
                this.processReturnCode(var10_10, var1_1);
            }
        }
        catch (LdapReferralException var10_11) {
            var10_11.setNewRdn(var8_4);
            if (var9_5 != null) {
                var11_15 = new PartialResultException("Cannot continue referral processing when newSuperior is nonempty: " + var9_5);
                var11_15.setRootCause(var3_3.fillInException(var10_11));
                throw var3_3.fillInException(var11_15);
            }
            if (this.handleReferrals == 2) {
                throw var3_3.fillInException(var10_11);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var11_16 = (LdapReferralContext)var10_12.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var11_16.rename(var1_1, var2_2);
                    return;
                }
                catch (LdapReferralException var12_18) {
                    var10_12 = var12_18;
                }
                finally {
                    var11_16.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var10_13) {
            var11_17 = new CommunicationException(var10_13.getMessage());
            var11_17.setRootCause(var10_13);
            throw var3_3.fillInException(var11_17);
        }
        catch (NamingException var10_14) {
            throw var3_3.fillInException(var10_14);
        }
    }

    @Override
    protected Context c_createSubcontext(Name name, Continuation continuation) throws NamingException {
        return this.c_createSubcontext(name, null, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected DirContext c_createSubcontext(Name var1_1, Attributes var2_2, Continuation var3_3) throws NamingException {
        var3_3.setError((Object)this, var1_1);
        var4_4 = var2_2;
        try {
            this.ensureOpen();
            if (var2_2 == null) {
                var5_5 = new BasicAttribute(Obj.JAVA_ATTRIBUTES[0], Obj.JAVA_OBJECT_CLASSES[0]);
                var5_5.add("top");
                var2_2 = new BasicAttributes(true);
                var2_2.put((Attribute)var5_5);
            }
            var5_5 = this.fullyQualifiedName(var1_1);
            var2_2 = LdapCtx.addRdnAttributes((String)var5_5, var2_2, var4_4 != var2_2);
            var6_10 = new LdapEntry((String)var5_5, var2_2);
            var7_13 = this.clnt.add(var6_10, this.reqCtls);
            this.respCtls = var7_13.resControls;
            if (var7_13.status != 0) {
                this.processReturnCode(var7_13, var1_1);
                return null;
            }
            return new LdapCtx(this, (String)var5_5);
        }
        catch (LdapReferralException var5_6) {
            if (this.handleReferrals == 2) {
                throw var3_3.fillInException(var5_6);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var6_11 = (LdapReferralContext)var5_7.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var7_15 = var6_11.createSubcontext(var1_1, var4_4);
                    return var7_15;
                }
                catch (LdapReferralException var7_14) {
                    var5_7 = var7_14;
                }
                finally {
                    var6_11.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var5_8) {
            var6_12 = new CommunicationException(var5_8.getMessage());
            var6_12.setRootCause(var5_8);
            throw var3_3.fillInException(var6_12);
        }
        catch (NamingException var5_9) {
            throw var3_3.fillInException(var5_9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_destroySubcontext(Name var1_1, Continuation var2_2) throws NamingException {
        var2_2.setError((Object)this, var1_1);
        try {
            this.ensureOpen();
            var3_3 = this.fullyQualifiedName(var1_1);
            var4_8 = this.clnt.delete(var3_3, this.reqCtls);
            this.respCtls = var4_8.resControls;
            this.adjustDeleteStatus(var3_3, var4_8);
            if (var4_8.status != 0) {
                this.processReturnCode(var4_8, var1_1);
            }
        }
        catch (LdapReferralException var3_4) {
            if (this.handleReferrals == 2) {
                throw var2_2.fillInException(var3_4);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var4_9 = (LdapReferralContext)var3_5.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var4_9.destroySubcontext(var1_1);
                    return;
                }
                catch (LdapReferralException var5_11) {
                    var3_5 = var5_11;
                }
                finally {
                    var4_9.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var3_6) {
            var4_10 = new CommunicationException(var3_6.getMessage());
            var4_10.setRootCause(var3_6);
            throw var2_2.fillInException(var4_10);
        }
        catch (NamingException var3_7) {
            throw var2_2.fillInException(var3_7);
        }
    }

    private static Attributes addRdnAttributes(String string, Attributes attributes, boolean bl) throws NamingException {
        if (string.equals("")) {
            return attributes;
        }
        List<Rdn> list = new LdapName(string).getRdns();
        Rdn rdn = list.get(list.size() - 1);
        Attributes attributes2 = rdn.toAttributes();
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes2.getAll();
        while (namingEnumeration.hasMore()) {
            Attribute attribute = namingEnumeration.next();
            if (attributes.get(attribute.getID()) != null || !attributes.isCaseIgnored() && LdapCtx.containsIgnoreCase(attributes.getIDs(), attribute.getID())) continue;
            if (!bl) {
                attributes = (Attributes)attributes.clone();
                bl = true;
            }
            attributes.put(attribute);
        }
        return attributes;
    }

    private static boolean containsIgnoreCase(NamingEnumeration<String> namingEnumeration, String string) throws NamingException {
        while (namingEnumeration.hasMore()) {
            String string2 = namingEnumeration.next();
            if (!string2.equalsIgnoreCase(string)) continue;
            return true;
        }
        return false;
    }

    private void adjustDeleteStatus(String string, LdapResult ldapResult) {
        if (ldapResult.status == 32 && ldapResult.matchedDN != null) {
            try {
                Name name = parser.parse(string);
                Name name2 = parser.parse(ldapResult.matchedDN);
                if (name.size() - name2.size() == 1) {
                    ldapResult.status = 0;
                }
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    private static <T> Vector<T> appendVector(Vector<T> vector, Vector<T> vector2) {
        if (vector == null) {
            vector = vector2;
        } else {
            for (int i = 0; i < vector2.size(); ++i) {
                vector.addElement(vector2.elementAt(i));
            }
        }
        return vector;
    }

    @Override
    protected Object c_lookupLink(Name name, Continuation continuation) throws NamingException {
        return this.c_lookup(name, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @Override
    protected Object c_lookup(Name var1_1, Continuation var2_2) throws NamingException {
        var2_2.setError((Object)this, var1_1);
        var3_3 = null;
        try {
            var5_4 = new SearchControls();
            var5_4.setSearchScope(0);
            var5_4.setReturningAttributes(null);
            var5_4.setReturningObjFlag(true);
            var6_10 = this.doSearchOnce(var1_1, "(objectClass=*)", var5_4, true);
            this.respCtls = var6_10.resControls;
            if (var6_10.status != 0) {
                this.processReturnCode((LdapResult)var6_10, var1_1);
            }
            if (var6_10.entries == null || var6_10.entries.size() != 1) {
                var4_12 /* !! */  = new BasicAttributes(true);
            } else {
                var7_13 = var6_10.entries.elementAt(0);
                var4_12 /* !! */  = var7_13.attributes;
                var8_16 = var7_13.respCtls;
                if (var8_16 != null) {
                    LdapCtx.appendVector(this.respCtls, var8_16);
                }
            }
            if (var4_12 /* !! */ .get(Obj.JAVA_ATTRIBUTES[2]) != null) {
                var3_3 = Obj.decodeObject(var4_12 /* !! */ );
            }
            if (var3_3 == null) {
                var3_3 = new LdapCtx(this, this.fullyQualifiedName(var1_1));
            }
        }
        catch (LdapReferralException var5_5) {
            if (this.handleReferrals == 2) {
                throw var2_2.fillInException(var5_5);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var6_11 = (LdapReferralContext)var5_6.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var7_15 = var6_11.lookup(var1_1);
                    return var7_15;
                }
                catch (LdapReferralException var7_14) {
                    var5_6 = var7_14;
                }
                finally {
                    var6_11.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (NamingException var5_7) {
            throw var2_2.fillInException(var5_7);
        }
        try {
            return DirectoryManager.getObjectInstance(var3_3, var1_1, this, this.envprops, var4_12 /* !! */ );
        }
        catch (NamingException var5_8) {
            throw var2_2.fillInException(var5_8);
        }
        catch (Exception var5_9) {
            var6_10 = new NamingException("problem generating object using object factory");
            var6_10.setRootCause(var5_9);
            throw var2_2.fillInException((NamingException)var6_10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected NamingEnumeration<NameClassPair> c_list(Name var1_1, Continuation var2_2) throws NamingException {
        var3_3 = new SearchControls();
        var4_4 = new String[]{Obj.JAVA_ATTRIBUTES[0], Obj.JAVA_ATTRIBUTES[2]};
        var3_3.setReturningAttributes(var4_4);
        var3_3.setReturningObjFlag(true);
        var2_2.setError((Object)this, var1_1);
        var5_5 = null;
        try {
            var5_5 = this.doSearch(var1_1, "(objectClass=*)", var3_3, true, true);
            if (var5_5.status != 0 || var5_5.referrals != null) {
                this.processReturnCode(var5_5, var1_1);
            }
            return new LdapNamingEnumeration(this, var5_5, var1_1, var2_2);
        }
        catch (LdapReferralException var6_6) {
            if (this.handleReferrals == 2) {
                throw var2_2.fillInException(var6_6);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var7_11 = (LdapReferralContext)var6_7.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var8_15 = var7_11.list(var1_1);
                    return var8_15;
                }
                catch (LdapReferralException var8_14) {
                    var6_7 = var8_14;
                }
                finally {
                    var7_11.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (LimitExceededException var6_8) {
            var7_12 = new LdapNamingEnumeration(this, var5_5, var1_1, var2_2);
            var7_12.setNamingException((LimitExceededException)var2_2.fillInException(var6_8));
            return var7_12;
        }
        catch (PartialResultException var6_9) {
            var7_13 = new LdapNamingEnumeration(this, var5_5, var1_1, var2_2);
            var7_13.setNamingException((PartialResultException)var2_2.fillInException(var6_9));
            return var7_13;
        }
        catch (NamingException var6_10) {
            throw var2_2.fillInException(var6_10);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected NamingEnumeration<Binding> c_listBindings(Name var1_1, Continuation var2_2) throws NamingException {
        var3_3 = new SearchControls();
        var3_3.setReturningAttributes(null);
        var3_3.setReturningObjFlag(true);
        var2_2.setError((Object)this, var1_1);
        var4_4 = null;
        try {
            var4_4 = this.doSearch(var1_1, "(objectClass=*)", var3_3, true, true);
            if (var4_4.status != 0 || var4_4.referrals != null) {
                this.processReturnCode(var4_4, var1_1);
            }
            return new LdapBindingEnumeration(this, var4_4, var1_1, var2_2);
        }
        catch (LdapReferralException var5_5) {
            if (this.handleReferrals == 2) {
                throw var2_2.fillInException(var5_5);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var6_10 = (LdapReferralContext)var5_6.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var7_14 = var6_10.listBindings(var1_1);
                    return var7_14;
                }
                catch (LdapReferralException var7_13) {
                    var5_6 = var7_13;
                }
                finally {
                    var6_10.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (LimitExceededException var5_7) {
            var6_11 = new LdapBindingEnumeration(this, var4_4, var1_1, var2_2);
            var6_11.setNamingException(var2_2.fillInException(var5_7));
            return var6_11;
        }
        catch (PartialResultException var5_8) {
            var6_12 = new LdapBindingEnumeration(this, var4_4, var1_1, var2_2);
            var6_12.setNamingException(var2_2.fillInException(var5_8));
            return var6_12;
        }
        catch (NamingException var5_9) {
            throw var2_2.fillInException(var5_9);
        }
    }

    @Override
    protected NameParser c_getNameParser(Name name, Continuation continuation) throws NamingException {
        continuation.setSuccess();
        return parser;
    }

    @Override
    public String getNameInNamespace() {
        return this.currentDN;
    }

    @Override
    public Name composeName(Name name, Name name2) throws NamingException {
        if (name instanceof LdapName && name2 instanceof LdapName) {
            Name name3 = (Name)name2.clone();
            name3.addAll(name);
            return new CompositeName().add(name3.toString());
        }
        if (!(name instanceof CompositeName)) {
            name = new CompositeName().add(name.toString());
        }
        if (!(name2 instanceof CompositeName)) {
            name2 = new CompositeName().add(name2.toString());
        }
        int n = name2.size() - 1;
        if (name.isEmpty() || name2.isEmpty() || name.get(0).equals("") || name2.get(n).equals("")) {
            return super.composeName(name, name2);
        }
        Name name4 = (Name)name2.clone();
        name4.addAll(name);
        if (this.parentIsLdapCtx) {
            String string = LdapCtx.concatNames(name4.get(n + 1), name4.get(n));
            name4.remove(n + 1);
            name4.remove(n);
            name4.add(n, string);
        }
        return name4;
    }

    private String fullyQualifiedName(Name name) {
        return name.isEmpty() ? this.currentDN : this.fullyQualifiedName(name.get(0));
    }

    private String fullyQualifiedName(String string) {
        return LdapCtx.concatNames(string, this.currentDN);
    }

    private static String concatNames(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        if (string2 == null || string2.equals("")) {
            return string;
        }
        return string + "," + string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected Attributes c_getAttributes(Name var1_1, String[] var2_2, Continuation var3_3) throws NamingException {
        var3_3.setError((Object)this, var1_1);
        var4_4 = new SearchControls();
        var4_4.setSearchScope(0);
        var4_4.setReturningAttributes(var2_2);
        try {
            var5_5 = this.doSearchOnce(var1_1, "(objectClass=*)", var4_4, true);
            this.respCtls = var5_5.resControls;
            if (var5_5.status != 0) {
                this.processReturnCode(var5_5, var1_1);
            }
            if (var5_5.entries == null || var5_5.entries.size() != 1) {
                return new BasicAttributes(true);
            }
            var6_9 = var5_5.entries.elementAt(0);
            var7_11 = var6_9.respCtls;
            if (var7_11 != null) {
                LdapCtx.appendVector(this.respCtls, var7_11);
            }
            this.setParents(var6_9.attributes, (Name)var1_1.clone());
            return var6_9.attributes;
        }
        catch (LdapReferralException var5_6) {
            if (this.handleReferrals == 2) {
                throw var3_3.fillInException(var5_6);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var6_10 = (LdapReferralContext)var5_7.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var7_13 = var6_10.getAttributes(var1_1, var2_2);
                    return var7_13;
                }
                catch (LdapReferralException var7_12) {
                    var5_7 = var7_12;
                }
                finally {
                    var6_10.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (NamingException var5_8) {
            throw var3_3.fillInException(var5_8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_modifyAttributes(Name var1_1, int var2_2, Attributes var3_3, Continuation var4_4) throws NamingException {
        var4_4.setError((Object)this, var1_1);
        try {
            this.ensureOpen();
            if (var3_3 == null || var3_3.size() == 0) {
                return;
            }
            var5_5 = this.fullyQualifiedName(var1_1);
            var6_10 = LdapCtx.convertToLdapModCode(var2_2);
            var7_13 = new int[var3_3.size()];
            var8_15 = new Attribute[var3_3.size()];
            var9_16 = var3_3.getAll();
            for (var10_17 = 0; var10_17 < var7_13.length && var9_16.hasMore(); ++var10_17) {
                var7_13[var10_17] = var6_10;
                var8_15[var10_17] = var9_16.next();
            }
            var10_18 = this.clnt.modify(var5_5, var7_13, var8_15, this.reqCtls);
            this.respCtls = var10_18.resControls;
            if (var10_18.status != 0) {
                this.processReturnCode(var10_18, var1_1);
                return;
            }
        }
        catch (LdapReferralException var5_6) {
            if (this.handleReferrals == 2) {
                throw var4_4.fillInException(var5_6);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var6_11 = (LdapReferralContext)var5_7.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var6_11.modifyAttributes(var1_1, var2_2, var3_3);
                    return;
                }
                catch (LdapReferralException var7_14) {
                    var5_7 = var7_14;
                }
                finally {
                    var6_11.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var5_8) {
            var6_12 = new CommunicationException(var5_8.getMessage());
            var6_12.setRootCause(var5_8);
            throw var4_4.fillInException(var6_12);
        }
        catch (NamingException var5_9) {
            throw var4_4.fillInException(var5_9);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    protected void c_modifyAttributes(Name var1_1, ModificationItem[] var2_2, Continuation var3_3) throws NamingException {
        var3_3.setError((Object)this, var1_1);
        try {
            this.ensureOpen();
            if (var2_2 == null || var2_2.length == 0) {
                return;
            }
            var4_4 = this.fullyQualifiedName(var1_1);
            var5_9 = new int[var2_2.length];
            var6_12 = new Attribute[var2_2.length];
            for (var8_14 = 0; var8_14 < var5_9.length; ++var8_14) {
                var7_16 = var2_2[var8_14];
                var5_9[var8_14] = LdapCtx.convertToLdapModCode(var7_16.getModificationOp());
                var6_12[var8_14] = var7_16.getAttribute();
            }
            var8_15 = this.clnt.modify(var4_4, var5_9, var6_12, this.reqCtls);
            this.respCtls = var8_15.resControls;
            if (var8_15.status != 0) {
                this.processReturnCode(var8_15, var1_1);
            }
        }
        catch (LdapReferralException var4_5) {
            if (this.handleReferrals == 2) {
                throw var3_3.fillInException(var4_5);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var5_10 = (LdapReferralContext)var4_6.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var5_10.modifyAttributes(var1_1, var2_2);
                    return;
                }
                catch (LdapReferralException var6_13) {
                    var4_6 = var6_13;
                }
                finally {
                    var5_10.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var4_7) {
            var5_11 = new CommunicationException(var4_7.getMessage());
            var5_11.setRootCause(var4_7);
            throw var3_3.fillInException(var5_11);
        }
        catch (NamingException var4_8) {
            throw var3_3.fillInException(var4_8);
        }
    }

    private static int convertToLdapModCode(int n) {
        switch (n) {
            case 1: {
                return 0;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 1;
            }
        }
        throw new IllegalArgumentException("Invalid modification code");
    }

    @Override
    protected DirContext c_getSchema(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            return this.getSchemaTree(name);
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    @Override
    protected DirContext c_getSchemaClassDefinition(Name name, Continuation continuation) throws NamingException {
        continuation.setError((Object)this, name);
        try {
            Attribute attribute = this.c_getAttributes(name, new String[]{"objectclass"}, continuation).get("objectclass");
            if (attribute == null || attribute.size() == 0) {
                return EMPTY_SCHEMA;
            }
            Context context = (Context)this.c_getSchema(name, continuation).lookup("ClassDefinition");
            HierMemDirCtx hierMemDirCtx = new HierMemDirCtx();
            NamingEnumeration<?> namingEnumeration = attribute.getAll();
            while (namingEnumeration.hasMoreElements()) {
                String string = (String)namingEnumeration.nextElement();
                DirContext dirContext = (DirContext)context.lookup(string);
                hierMemDirCtx.bind(string, (Object)dirContext);
            }
            hierMemDirCtx.setReadOnly(new SchemaViolationException("Cannot update schema object"));
            return hierMemDirCtx;
        }
        catch (NamingException namingException) {
            throw continuation.fillInException(namingException);
        }
    }

    private DirContext getSchemaTree(Name name) throws NamingException {
        String string = this.getSchemaEntry(name, true);
        DirContext dirContext = this.schemaTrees.get(string);
        if (dirContext == null) {
            dirContext = this.buildSchemaTree(string);
            this.schemaTrees.put(string, dirContext);
        }
        return dirContext;
    }

    private DirContext buildSchemaTree(String string) throws NamingException {
        SearchControls searchControls = new SearchControls(0, 0L, 0, SCHEMA_ATTRIBUTES, true, false);
        Name name = new CompositeName().add(string);
        NamingEnumeration<SearchResult> namingEnumeration = this.searchAux(name, "(objectClass=subschema)", searchControls, false, true, new Continuation());
        if (!namingEnumeration.hasMore()) {
            throw new OperationNotSupportedException("Cannot get read subschemasubentry: " + string);
        }
        SearchResult searchResult = namingEnumeration.next();
        namingEnumeration.close();
        Object object = searchResult.getObject();
        if (!(object instanceof LdapCtx)) {
            throw new NamingException("Cannot get schema object as DirContext: " + string);
        }
        return LdapSchemaCtx.createSchemaTree(this.envprops, string, (LdapCtx)object, searchResult.getAttributes(), this.netscapeSchemaBug);
    }

    private String getSchemaEntry(Name name, boolean bl) throws NamingException {
        NamingEnumeration<SearchResult> namingEnumeration;
        SearchControls searchControls = new SearchControls(0, 0L, 0, new String[]{"subschemasubentry"}, false, false);
        try {
            namingEnumeration = this.searchAux(name, "objectclass=*", searchControls, bl, true, new Continuation());
        }
        catch (NamingException namingException) {
            if (!this.clnt.isLdapv3 && this.currentDN.length() == 0 && name.isEmpty()) {
                throw new OperationNotSupportedException("Cannot get schema information from server");
            }
            throw namingException;
        }
        if (!namingEnumeration.hasMoreElements()) {
            throw new ConfigurationException("Requesting schema of nonexistent entry: " + name);
        }
        SearchResult searchResult = namingEnumeration.next();
        namingEnumeration.close();
        Attribute attribute = searchResult.getAttributes().get("subschemasubentry");
        if (attribute == null || attribute.size() < 0) {
            if (this.currentDN.length() == 0 && name.isEmpty()) {
                throw new OperationNotSupportedException("Cannot read subschemasubentry of root DSE");
            }
            return this.getSchemaEntry(new CompositeName(), false);
        }
        return (String)attribute.get();
    }

    void setParents(Attributes attributes, Name name) throws NamingException {
        NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
        while (namingEnumeration.hasMore()) {
            ((LdapAttribute)namingEnumeration.next()).setParent(this, name);
        }
    }

    String getURL() {
        if (this.url == null) {
            this.url = LdapURL.toUrlString(this.hostname, this.port_number, this.currentDN, this.hasLdapsScheme);
        }
        return this.url;
    }

    protected NamingEnumeration<SearchResult> c_search(Name name, Attributes attributes, Continuation continuation) throws NamingException {
        return this.c_search(name, attributes, null, continuation);
    }

    @Override
    protected NamingEnumeration<SearchResult> c_search(Name name, Attributes attributes, String[] stringArray, Continuation continuation) throws NamingException {
        String string;
        SearchControls searchControls = new SearchControls();
        searchControls.setReturningAttributes(stringArray);
        try {
            string = SearchFilter.format(attributes);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        return this.c_search(name, string, searchControls, continuation);
    }

    @Override
    protected NamingEnumeration<SearchResult> c_search(Name name, String string, SearchControls searchControls, Continuation continuation) throws NamingException {
        return this.searchAux(name, string, LdapCtx.cloneSearchControls(searchControls), true, this.waitForReply, continuation);
    }

    @Override
    protected NamingEnumeration<SearchResult> c_search(Name name, String string, Object[] objectArray, SearchControls searchControls, Continuation continuation) throws NamingException {
        String string2;
        try {
            string2 = SearchFilter.format(string, objectArray);
        }
        catch (NamingException namingException) {
            continuation.setError((Object)this, name);
            throw continuation.fillInException(namingException);
        }
        return this.c_search(name, string2, searchControls, continuation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    NamingEnumeration<SearchResult> searchAux(Name var1_1, String var2_2, SearchControls var3_3, boolean var4_4, boolean var5_5, Continuation var6_6) throws NamingException {
        var7_7 = null;
        var8_8 = new String[2];
        if (var3_3 == null) {
            var3_3 = new SearchControls();
        }
        var9_9 = var3_3.getReturningAttributes();
        if (var3_3.getReturningObjFlag() && var9_9 != null) {
            var10_10 = false;
            for (var11_12 = var9_9.length - 1; var11_12 >= 0; --var11_12) {
                if (!var9_9[var11_12].equals("*")) continue;
                var10_10 = true;
                break;
            }
            if (!var10_10) {
                var11_13 = new String[var9_9.length + Obj.JAVA_ATTRIBUTES.length];
                System.arraycopy(var9_9, 0, var11_13, 0, var9_9.length);
                System.arraycopy(Obj.JAVA_ATTRIBUTES, 0, var11_13, var9_9.length, Obj.JAVA_ATTRIBUTES.length);
                var3_3.setReturningAttributes(var11_13);
            }
        }
        var10_11 = new SearchArgs(var1_1, var2_2, var3_3, var9_9);
        var6_6.setError((Object)this, var1_1);
        try {
            if (LdapCtx.searchToCompare(var2_2, var3_3, var8_8)) {
                var7_7 = this.compare(var1_1, var8_8[0], var8_8[1]);
                if (!var7_7.compareToSearchResult(this.fullyQualifiedName(var1_1))) {
                    this.processReturnCode(var7_7, var1_1);
                }
            } else {
                var7_7 = this.doSearch(var1_1, var2_2, var3_3, var4_4, var5_5);
                this.processReturnCode(var7_7, var1_1);
            }
            return new LdapSearchEnumeration(this, var7_7, this.fullyQualifiedName(var1_1), var10_11, var6_6);
        }
        catch (LdapReferralException var11_14) {
            if (this.handleReferrals == 2) {
                throw var6_6.fillInException(var11_14);
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var12_20 = (LdapReferralContext)var11_15.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var13_25 = var12_20.search(var1_1, var2_2, var3_3);
                    return var13_25;
                }
                catch (LdapReferralException var13_24) {
                    var11_15 = var13_24;
                }
                finally {
                    var12_20.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (LimitExceededException var11_16) {
            var12_21 = new LdapSearchEnumeration(this, var7_7, this.fullyQualifiedName(var1_1), var10_11, var6_6);
            var12_21.setNamingException(var11_16);
            return var12_21;
        }
        catch (PartialResultException var11_17) {
            var12_22 = new LdapSearchEnumeration(this, var7_7, this.fullyQualifiedName(var1_1), var10_11, var6_6);
            var12_22.setNamingException(var11_17);
            return var12_22;
        }
        catch (IOException var11_18) {
            var12_23 = new CommunicationException(var11_18.getMessage());
            var12_23.setRootCause(var11_18);
            throw var6_6.fillInException(var12_23);
        }
        catch (NamingException var11_19) {
            throw var6_6.fillInException(var11_19);
        }
    }

    LdapResult getSearchReply(LdapClient ldapClient, LdapResult ldapResult) throws NamingException {
        if (this.clnt != ldapClient) {
            throw new CommunicationException("Context's connection changed; unable to continue enumeration");
        }
        try {
            return ldapClient.getSearchReply(this.batchSize, ldapResult, this.binaryAttrs);
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    private LdapResult doSearchOnce(Name name, String string, SearchControls searchControls, boolean bl) throws NamingException {
        int n = this.batchSize;
        this.batchSize = 2;
        LdapResult ldapResult = this.doSearch(name, string, searchControls, bl, true);
        this.batchSize = n;
        return ldapResult;
    }

    private LdapResult doSearch(Name name, String string, SearchControls searchControls, boolean bl, boolean bl2) throws NamingException {
        this.ensureOpen();
        try {
            int n;
            switch (searchControls.getSearchScope()) {
                case 0: {
                    n = 0;
                    break;
                }
                default: {
                    n = 1;
                    break;
                }
                case 2: {
                    n = 2;
                }
            }
            String[] stringArray = searchControls.getReturningAttributes();
            if (stringArray != null && stringArray.length == 0) {
                stringArray = new String[]{"1.1"};
            }
            String string2 = bl ? this.fullyQualifiedName(name) : (name.isEmpty() ? "" : name.get(0));
            int n2 = searchControls.getTimeLimit();
            int n3 = 0;
            if (n2 > 0) {
                n3 = n2 / 1000 + 1;
            }
            LdapResult ldapResult = this.clnt.search(string2, n, this.derefAliases, (int)searchControls.getCountLimit(), n3, searchControls.getReturningObjFlag() ? false : this.typesOnly, stringArray, string, this.batchSize, this.reqCtls, this.binaryAttrs, bl2, this.replyQueueSize);
            this.respCtls = ldapResult.resControls;
            return ldapResult;
        }
        catch (IOException iOException) {
            CommunicationException communicationException = new CommunicationException(iOException.getMessage());
            communicationException.setRootCause(iOException);
            throw communicationException;
        }
    }

    private static boolean searchToCompare(String string, SearchControls searchControls, String[] stringArray) {
        if (searchControls.getSearchScope() != 0) {
            return false;
        }
        String[] stringArray2 = searchControls.getReturningAttributes();
        if (stringArray2 == null || stringArray2.length != 0) {
            return false;
        }
        return LdapCtx.filterToAssertion(string, stringArray);
    }

    private static boolean filterToAssertion(String string, String[] stringArray) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "=");
        if (stringTokenizer.countTokens() != 2) {
            return false;
        }
        stringArray[0] = stringTokenizer.nextToken();
        stringArray[1] = stringTokenizer.nextToken();
        if (stringArray[1].indexOf(42) != -1) {
            return false;
        }
        boolean bl = false;
        int n = stringArray[1].length();
        if (stringArray[0].charAt(0) == '(' && stringArray[1].charAt(n - 1) == ')') {
            bl = true;
        } else if (stringArray[0].charAt(0) == '(' || stringArray[1].charAt(n - 1) == ')') {
            return false;
        }
        StringTokenizer stringTokenizer2 = new StringTokenizer(stringArray[0], "()&|!=~><*", true);
        if (stringTokenizer2.countTokens() != (bl ? 2 : 1)) {
            return false;
        }
        stringTokenizer2 = new StringTokenizer(stringArray[1], "()&|!=~><*", true);
        if (stringTokenizer2.countTokens() != (bl ? 2 : 1)) {
            return false;
        }
        if (bl) {
            stringArray[0] = stringArray[0].substring(1);
            stringArray[1] = stringArray[1].substring(0, n - 1);
        }
        return true;
    }

    private LdapResult compare(Name name, String string, String string2) throws IOException, NamingException {
        this.ensureOpen();
        String string3 = this.fullyQualifiedName(name);
        LdapResult ldapResult = this.clnt.compare(string3, string, string2, this.reqCtls);
        this.respCtls = ldapResult.resControls;
        return ldapResult;
    }

    private static SearchControls cloneSearchControls(SearchControls searchControls) {
        if (searchControls == null) {
            return null;
        }
        String[] stringArray = searchControls.getReturningAttributes();
        if (stringArray != null) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            stringArray = stringArray2;
        }
        return new SearchControls(searchControls.getSearchScope(), searchControls.getCountLimit(), searchControls.getTimeLimit(), stringArray, searchControls.getReturningObjFlag(), searchControls.getDerefLinkFlag());
    }

    protected Hashtable<String, Object> p_getEnvironment() {
        return this.envprops;
    }

    public Hashtable<String, Object> getEnvironment() throws NamingException {
        return this.envprops == null ? new Hashtable<String, Object>(5, 0.75f) : (Hashtable)this.envprops.clone();
    }

    @Override
    public Object removeFromEnvironment(String string) throws NamingException {
        if (this.envprops == null || this.envprops.get(string) == null) {
            return null;
        }
        switch (string) {
            case "java.naming.ldap.ref.separator": {
                this.addrEncodingSeparator = (char)35;
                break;
            }
            case "java.naming.ldap.typesOnly": {
                this.typesOnly = false;
                break;
            }
            case "java.naming.ldap.deleteRDN": {
                this.deleteRDN = true;
                break;
            }
            case "java.naming.ldap.derefAliases": {
                this.derefAliases = 3;
                break;
            }
            case "java.naming.batchsize": {
                this.batchSize = 1;
                break;
            }
            case "java.naming.ldap.referral.limit": {
                this.referralHopLimit = 10;
                break;
            }
            case "java.naming.referral": {
                this.setReferralMode(null, true);
                break;
            }
            case "java.naming.ldap.attributes.binary": {
                this.setBinaryAttributes(null);
                break;
            }
            case "com.sun.jndi.ldap.connect.timeout": {
                this.connectTimeout = -1;
                break;
            }
            case "com.sun.jndi.ldap.read.timeout": {
                this.readTimeout = -1;
                break;
            }
            case "com.sun.jndi.ldap.search.waitForReply": {
                this.waitForReply = true;
                break;
            }
            case "com.sun.jndi.ldap.search.replyQueueSize": {
                this.replyQueueSize = -1;
                break;
            }
            case "java.naming.security.protocol": {
                this.closeConnection(false);
                if (!this.useSsl || this.hasLdapsScheme) break;
                this.useSsl = false;
                this.url = null;
                if (!this.useDefaultPortNumber) break;
                this.port_number = 389;
                break;
            }
            case "java.naming.ldap.version": 
            case "java.naming.ldap.factory.socket": {
                this.closeConnection(false);
                break;
            }
            case "java.naming.security.authentication": 
            case "java.naming.security.principal": 
            case "java.naming.security.credentials": {
                this.sharable = false;
            }
        }
        this.envprops = (Hashtable)this.envprops.clone();
        return this.envprops.remove(string);
    }

    @Override
    public Object addToEnvironment(String string, Object object) throws NamingException {
        if (object == null) {
            return this.removeFromEnvironment(string);
        }
        switch (string) {
            case "java.naming.ldap.ref.separator": {
                this.setRefSeparator((String)object);
                break;
            }
            case "java.naming.ldap.typesOnly": {
                this.setTypesOnly((String)object);
                break;
            }
            case "java.naming.ldap.deleteRDN": {
                this.setDeleteRDN((String)object);
                break;
            }
            case "java.naming.ldap.derefAliases": {
                this.setDerefAliases((String)object);
                break;
            }
            case "java.naming.batchsize": {
                this.setBatchSize((String)object);
                break;
            }
            case "java.naming.ldap.referral.limit": {
                this.setReferralLimit((String)object);
                break;
            }
            case "java.naming.referral": {
                this.setReferralMode((String)object, true);
                break;
            }
            case "java.naming.ldap.attributes.binary": {
                this.setBinaryAttributes((String)object);
                break;
            }
            case "com.sun.jndi.ldap.connect.timeout": {
                this.setConnectTimeout((String)object);
                break;
            }
            case "com.sun.jndi.ldap.read.timeout": {
                this.setReadTimeout((String)object);
                break;
            }
            case "com.sun.jndi.ldap.search.waitForReply": {
                this.setWaitForReply((String)object);
                break;
            }
            case "com.sun.jndi.ldap.search.replyQueueSize": {
                this.setReplyQueueSize((String)object);
                break;
            }
            case "java.naming.security.protocol": {
                this.closeConnection(false);
                if (!"ssl".equals(object)) break;
                this.useSsl = true;
                this.url = null;
                if (!this.useDefaultPortNumber) break;
                this.port_number = 636;
                break;
            }
            case "java.naming.ldap.version": 
            case "java.naming.ldap.factory.socket": {
                this.closeConnection(false);
                break;
            }
            case "java.naming.security.authentication": 
            case "java.naming.security.principal": 
            case "java.naming.security.credentials": {
                this.sharable = false;
            }
        }
        this.envprops = this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
        return this.envprops.put(string, object);
    }

    void setProviderUrl(String string) {
        if (this.envprops != null) {
            this.envprops.put("java.naming.provider.url", string);
        }
    }

    void setDomainName(String string) {
        if (this.envprops != null) {
            this.envprops.put(DOMAIN_NAME, string);
        }
    }

    private void initEnv() throws NamingException {
        if (this.envprops == null) {
            this.setReferralMode(null, false);
            return;
        }
        this.setBatchSize((String)this.envprops.get("java.naming.batchsize"));
        this.setRefSeparator((String)this.envprops.get(REF_SEPARATOR));
        this.setDeleteRDN((String)this.envprops.get(DELETE_RDN));
        this.setTypesOnly((String)this.envprops.get(TYPES_ONLY));
        this.setDerefAliases((String)this.envprops.get(DEREF_ALIASES));
        this.setReferralLimit((String)this.envprops.get(REFERRAL_LIMIT));
        this.setBinaryAttributes((String)this.envprops.get(BINARY_ATTRIBUTES));
        this.bindCtls = LdapCtx.cloneControls((Control[])this.envprops.get(BIND_CONTROLS));
        this.setReferralMode((String)this.envprops.get("java.naming.referral"), false);
        this.setConnectTimeout((String)this.envprops.get(CONNECT_TIMEOUT));
        this.setReadTimeout((String)this.envprops.get(READ_TIMEOUT));
        this.setWaitForReply((String)this.envprops.get(WAIT_FOR_REPLY));
        this.setReplyQueueSize((String)this.envprops.get(REPLY_QUEUE_SIZE));
    }

    private void setDeleteRDN(String string) {
        this.deleteRDN = string == null || !string.equalsIgnoreCase("false");
    }

    private void setTypesOnly(String string) {
        this.typesOnly = string != null && string.equalsIgnoreCase("true");
    }

    private void setBatchSize(String string) {
        this.batchSize = string != null ? Integer.parseInt(string) : 1;
    }

    private void setReferralMode(String string, boolean bl) {
        if (string != null) {
            switch (string) {
                case "follow-scheme": {
                    this.handleReferrals = 4;
                    break;
                }
                case "follow": {
                    this.handleReferrals = 1;
                    break;
                }
                case "throw": {
                    this.handleReferrals = 2;
                    break;
                }
                case "ignore": {
                    this.handleReferrals = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value for java.naming.referral property.");
                }
            }
        } else {
            this.handleReferrals = 3;
        }
        if (this.handleReferrals == 3) {
            this.reqCtls = LdapCtx.addControl(this.reqCtls, manageReferralControl);
        } else if (bl) {
            this.reqCtls = LdapCtx.removeControl(this.reqCtls, manageReferralControl);
        }
    }

    private void setDerefAliases(String string) {
        if (string != null) {
            switch (string) {
                case "never": {
                    this.derefAliases = 0;
                    break;
                }
                case "searching": {
                    this.derefAliases = 1;
                    break;
                }
                case "finding": {
                    this.derefAliases = 2;
                    break;
                }
                case "always": {
                    this.derefAliases = 3;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value for java.naming.ldap.derefAliases property.");
                }
            }
        } else {
            this.derefAliases = 3;
        }
    }

    private void setRefSeparator(String string) throws NamingException {
        this.addrEncodingSeparator = string != null && string.length() > 0 ? string.charAt(0) : (char)35;
    }

    private void setReferralLimit(String string) {
        if (string != null) {
            this.referralHopLimit = Integer.parseInt(string);
            if (this.referralHopLimit == 0) {
                this.referralHopLimit = Integer.MAX_VALUE;
            }
        } else {
            this.referralHopLimit = 10;
        }
    }

    void setHopCount(int n) {
        this.hopCount = n;
    }

    private void setConnectTimeout(String string) {
        this.connectTimeout = string != null ? Integer.parseInt(string) : -1;
    }

    private void setReplyQueueSize(String string) {
        if (string != null) {
            this.replyQueueSize = Integer.parseInt(string);
            if (this.replyQueueSize <= 0) {
                this.replyQueueSize = -1;
            }
        } else {
            this.replyQueueSize = -1;
        }
    }

    private void setWaitForReply(String string) {
        this.waitForReply = string == null || !string.equalsIgnoreCase("false");
    }

    private void setReadTimeout(String string) {
        this.readTimeout = string != null ? Integer.parseInt(string) : -1;
    }

    private static Vector<Vector<String>> extractURLs(String string) {
        Vector<String> vector;
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf(10, n)) >= 0) {
            ++n;
            ++n2;
        }
        Vector<Vector<String>> vector2 = new Vector<Vector<String>>(n2);
        boolean bl = false;
        n = string.indexOf(10);
        int n3 = n + 1;
        while ((n = string.indexOf(10, n3)) >= 0) {
            vector = new Vector<String>(1);
            vector.addElement(string.substring(n3, n));
            vector2.addElement(vector);
            n3 = n + 1;
        }
        vector = new Vector(1);
        vector.addElement(string.substring(n3));
        vector2.addElement(vector);
        return vector2;
    }

    private void setBinaryAttributes(String string) {
        if (string == null) {
            this.binaryAttrs = null;
        } else {
            this.binaryAttrs = new Hashtable(11, 0.75f);
            StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(Locale.ENGLISH), " ");
            while (stringTokenizer.hasMoreTokens()) {
                this.binaryAttrs.put(stringTokenizer.nextToken(), Boolean.TRUE);
            }
        }
    }

    protected void finalize() {
        try {
            this.close();
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void close() throws NamingException {
        if (this.eventSupport != null) {
            this.eventSupport.cleanup();
            this.removeUnsolicited();
        }
        if (this.enumCount > 0) {
            this.closeRequested = true;
            return;
        }
        this.closeConnection(false);
    }

    @Override
    public void reconnect(Control[] controlArray) throws NamingException {
        Hashtable<Object, Object> hashtable = this.envprops = this.envprops == null ? new Hashtable(5, 0.75f) : (Hashtable)this.envprops.clone();
        if (controlArray == null) {
            this.envprops.remove(BIND_CONTROLS);
            this.bindCtls = null;
        } else {
            this.bindCtls = LdapCtx.cloneControls(controlArray);
            this.envprops.put(BIND_CONTROLS, this.bindCtls);
        }
        this.sharable = false;
        this.ensureOpen();
    }

    private static String getMechsAllowedToSendCredentials() {
        PrivilegedAction<String> privilegedAction = () -> System.getProperty(ALLOWED_MECHS_SP);
        return System.getSecurityManager() == null ? privilegedAction.run() : AccessController.doPrivileged(privilegedAction);
    }

    private static Set<String> getMechsFromPropertyValue(String string2) {
        if (string2 == null || string2.trim().isEmpty()) {
            return Collections.emptySet();
        }
        Set set = Arrays.stream(string2.split(",")).map(String::trim).filter(string -> !string.trim().isEmpty()).collect(Collectors.toSet());
        return Collections.unmodifiableSet(set);
    }

    private boolean isConnectionEncrypted() {
        return this.hasLdapsScheme || this.clnt.isUpgradedToStartTls();
    }

    private void ensureCanTransmitCredentials(String string) throws NamingException {
        boolean bl;
        if ("none".equalsIgnoreCase(string) || "anonymous".equalsIgnoreCase(string)) {
            return;
        }
        String string2 = (String)this.envprops.get(ALLOWED_MECHS_SP);
        boolean bl2 = false;
        boolean bl3 = bl = ALLOWED_MECHS_SP_VALUE != null || string2 != null;
        if (!this.isConnectionEncrypted() && (this.contextSeenStartTlsEnabled || bl)) {
            Set<String> set;
            if ("simple".equalsIgnoreCase(string) && !this.envprops.containsKey("java.naming.security.principal")) {
                return;
            }
            if (string2 == null) {
                bl2 = true;
                string2 = ALLOWED_MECHS_SP_VALUE;
            }
            if ("all".equalsIgnoreCase(string2)) {
                return;
            }
            Set<String> set2 = set = bl2 ? MECHS_ALLOWED_BY_SP : LdapCtx.getMechsFromPropertyValue(string2);
            if (!set.contains(string)) {
                throw new NamingException(UNSECURED_CRED_TRANSMIT_MSG);
            }
        }
    }

    private void ensureOpen() throws NamingException {
        this.ensureOpen(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureOpen(boolean bl) throws NamingException {
        block8: {
            try {
                if (this.clnt == null) {
                    this.schemaTrees = new Hashtable(11, 0.75f);
                    this.connect(bl);
                    break block8;
                }
                if (this.sharable && !bl) break block8;
                LdapClient ldapClient = this.clnt;
                synchronized (ldapClient) {
                    if (!this.clnt.isLdapv3 || this.clnt.referenceCount > 1 || this.clnt.usingSaslStreams() || !this.clnt.conn.useable) {
                        this.closeConnection(false);
                    }
                }
                this.schemaTrees = new Hashtable(11, 0.75f);
                this.connect(bl);
            }
            finally {
                this.sharable = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(boolean bl) throws NamingException {
        String string = null;
        Object object = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        boolean bl2 = false;
        if (this.envprops != null) {
            string = (String)this.envprops.get("java.naming.security.principal");
            object = this.envprops.get("java.naming.security.credentials");
            string5 = (String)this.envprops.get(VERSION);
            string2 = this.useSsl ? "ssl" : (String)this.envprops.get("java.naming.security.protocol");
            string3 = (String)this.envprops.get(SOCKET_FACTORY);
            string4 = (String)this.envprops.get("java.naming.security.authentication");
            bl2 = "true".equalsIgnoreCase((String)this.envprops.get(ENABLE_POOL));
        }
        if (string3 == null) {
            String string6 = string3 = "ssl".equals(string2) ? DEFAULT_SSL_FACTORY : null;
        }
        if (string4 == null) {
            string4 = string == null ? "none" : "simple";
        }
        try {
            LdapResult ldapResult;
            int n;
            boolean bl3;
            boolean bl4 = bl3 = this.clnt == null;
            if (bl3) {
                n = string5 != null ? Integer.parseInt(string5) : 32;
                this.clnt = LdapClient.getInstance(bl2, this.hostname, this.port_number, string3, this.connectTimeout, this.readTimeout, this.trace, n, string4, this.bindCtls, string2, string, object, this.envprops);
                this.contextSeenStartTlsEnabled |= this.clnt.isUpgradedToStartTls();
                if (this.clnt.authenticateCalled()) {
                    return;
                }
            } else {
                if (this.sharable && bl) {
                    return;
                }
                n = 3;
            }
            Object object2 = this.clnt.conn.startTlsLock;
            synchronized (object2) {
                this.ensureCanTransmitCredentials(string4);
                ldapResult = this.clnt.authenticate(bl3, string, object, n, string4, this.bindCtls, this.envprops);
            }
            this.respCtls = ldapResult.resControls;
            if (ldapResult.status != 0) {
                if (bl3) {
                    this.closeConnection(true);
                }
                this.processReturnCode(ldapResult);
            }
        }
        catch (LdapReferralException ldapReferralException) {
            if (this.handleReferrals == 2) {
                throw ldapReferralException;
            }
            Throwable throwable = null;
            while (true) {
                String string7;
                if ((string7 = ldapReferralException.getNextReferral()) == null) {
                    if (throwable != null) {
                        throw (NamingException)throwable.fillInStackTrace();
                    }
                    throw new NamingException("Internal error processing referral during connection");
                }
                LdapURL ldapURL = new LdapURL(string7);
                this.hostname = ldapURL.getHost();
                if (this.hostname != null && this.hostname.charAt(0) == '[') {
                    this.hostname = this.hostname.substring(1, this.hostname.length() - 1);
                }
                this.port_number = ldapURL.getPort();
                try {
                    this.connect(bl);
                }
                catch (NamingException namingException) {
                    throwable = namingException;
                    continue;
                }
                break;
            }
        }
    }

    private void closeConnection(boolean bl) {
        this.removeUnsolicited();
        if (this.clnt != null) {
            this.clnt.close(this.reqCtls, bl);
            this.clnt = null;
        }
    }

    synchronized void incEnumCount() {
        ++this.enumCount;
    }

    synchronized void decEnumCount() {
        --this.enumCount;
        if (this.enumCount == 0 && this.closeRequested) {
            try {
                this.close();
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
    }

    protected void processReturnCode(LdapResult ldapResult) throws NamingException {
        this.processReturnCode(ldapResult, null, this, null, this.envprops, null);
    }

    void processReturnCode(LdapResult ldapResult, Name name) throws NamingException {
        this.processReturnCode(ldapResult, new CompositeName().add(this.currentDN), this, name, this.envprops, this.fullyQualifiedName(name));
    }

    protected void processReturnCode(LdapResult ldapResult, Name name, Object object, Name name2, Hashtable<?, ?> hashtable, String string) throws NamingException {
        Object object2;
        String string2 = LdapClient.getErrorMessage(ldapResult.status, ldapResult.errorMessage);
        LdapReferralException ldapReferralException = null;
        switch (ldapResult.status) {
            case 0: {
                if (ldapResult.referrals != null) {
                    string2 = "Unprocessed Continuation Reference(s)";
                    if (this.handleReferrals == 3) {
                        object2 = new PartialResultException(string2);
                        break;
                    }
                    int n = ldapResult.referrals.size();
                    LdapReferralException ldapReferralException2 = null;
                    LdapReferralException ldapReferralException3 = null;
                    string2 = "Continuation Reference";
                    for (int i = 0; i < n; ++i) {
                        ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string, this.handleReferrals, this.reqCtls);
                        ldapReferralException.setReferralInfo(ldapResult.referrals.elementAt(i), true);
                        if (this.hopCount > 1) {
                            ldapReferralException.setHopCount(this.hopCount);
                        }
                        if (ldapReferralException2 == null) {
                            ldapReferralException2 = ldapReferralException3 = ldapReferralException;
                            continue;
                        }
                        ldapReferralException3.nextReferralEx = ldapReferralException;
                        ldapReferralException3 = ldapReferralException;
                    }
                    ldapResult.referrals = null;
                    if (ldapResult.refEx == null) {
                        ldapResult.refEx = ldapReferralException2;
                    } else {
                        ldapReferralException3 = ldapResult.refEx;
                        while (ldapReferralException3.nextReferralEx != null) {
                            ldapReferralException3 = ldapReferralException3.nextReferralEx;
                        }
                        ldapReferralException3.nextReferralEx = ldapReferralException2;
                    }
                    if (this.hopCount > this.referralHopLimit) {
                        LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                        limitExceededException.setRootCause(ldapReferralException);
                        throw limitExceededException;
                    }
                }
                return;
            }
            case 10: {
                Vector<Object> vector;
                if (this.handleReferrals == 3) {
                    object2 = new PartialResultException(string2);
                    break;
                }
                ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string, this.handleReferrals, this.reqCtls);
                if (ldapResult.referrals == null) {
                    vector = null;
                } else if (this.handleReferrals == 4) {
                    vector = new Vector();
                    for (String string3 : ldapResult.referrals.elementAt(0)) {
                        if (!string3.startsWith("ldap:")) continue;
                        vector.add(string3);
                    }
                    if (vector.isEmpty()) {
                        vector = null;
                    }
                } else {
                    vector = ldapResult.referrals.elementAt(0);
                }
                ldapReferralException.setReferralInfo(vector, false);
                if (this.hopCount > 1) {
                    ldapReferralException.setHopCount(this.hopCount);
                }
                if (this.hopCount > this.referralHopLimit) {
                    LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                    limitExceededException.setRootCause(ldapReferralException);
                    object2 = limitExceededException;
                    break;
                }
                object2 = ldapReferralException;
                break;
            }
            case 9: {
                if (this.handleReferrals == 3) {
                    object2 = new PartialResultException(string2);
                    break;
                }
                if (ldapResult.errorMessage == null || ldapResult.errorMessage.equals("")) {
                    object2 = new PartialResultException(string2);
                    break;
                }
                ldapResult.referrals = LdapCtx.extractURLs(ldapResult.errorMessage);
                ldapReferralException = new LdapReferralException(name, object, name2, string2, hashtable, string, this.handleReferrals, this.reqCtls);
                if (this.hopCount > 1) {
                    ldapReferralException.setHopCount(this.hopCount);
                }
                if ((ldapResult.entries == null || ldapResult.entries.isEmpty()) && ldapResult.referrals != null && ldapResult.referrals.size() == 1) {
                    ldapReferralException.setReferralInfo(ldapResult.referrals, false);
                    if (this.hopCount > this.referralHopLimit) {
                        LimitExceededException limitExceededException = new LimitExceededException("Referral limit exceeded");
                        limitExceededException.setRootCause(ldapReferralException);
                        object2 = limitExceededException;
                        break;
                    }
                    object2 = ldapReferralException;
                    break;
                }
                ldapReferralException.setReferralInfo(ldapResult.referrals, true);
                ldapResult.refEx = ldapReferralException;
                return;
            }
            case 34: 
            case 64: {
                if (name2 != null) {
                    object2 = new InvalidNameException(name2.toString() + ": " + string2);
                    break;
                }
                object2 = new InvalidNameException(string2);
                break;
            }
            default: {
                object2 = LdapCtx.mapErrorCode(ldapResult.status, ldapResult.errorMessage);
            }
        }
        ((NamingException)object2).setResolvedName(name);
        ((NamingException)object2).setResolvedObj(object);
        ((NamingException)object2).setRemainingName(name2);
        throw object2;
    }

    public static NamingException mapErrorCode(int n, String string) {
        if (n == 0) {
            return null;
        }
        NamingException namingException = null;
        String string2 = LdapClient.getErrorMessage(n, string);
        switch (n) {
            case 36: {
                namingException = new NamingException(string2);
                break;
            }
            case 33: {
                namingException = new NamingException(string2);
                break;
            }
            case 20: {
                namingException = new AttributeInUseException(string2);
                break;
            }
            case 7: 
            case 8: 
            case 13: 
            case 48: {
                namingException = new AuthenticationNotSupportedException(string2);
                break;
            }
            case 68: {
                namingException = new NameAlreadyBoundException(string2);
                break;
            }
            case 14: 
            case 49: {
                namingException = new AuthenticationException(string2);
                break;
            }
            case 18: {
                namingException = new InvalidSearchFilterException(string2);
                break;
            }
            case 50: {
                namingException = new NoPermissionException(string2);
                break;
            }
            case 19: 
            case 21: {
                namingException = new InvalidAttributeValueException(string2);
                break;
            }
            case 54: {
                namingException = new NamingException(string2);
                break;
            }
            case 16: {
                namingException = new NoSuchAttributeException(string2);
                break;
            }
            case 32: {
                namingException = new NameNotFoundException(string2);
                break;
            }
            case 65: 
            case 67: 
            case 69: {
                namingException = new SchemaViolationException(string2);
                break;
            }
            case 66: {
                namingException = new ContextNotEmptyException(string2);
                break;
            }
            case 1: {
                namingException = new NamingException(string2);
                break;
            }
            case 80: {
                namingException = new NamingException(string2);
                break;
            }
            case 2: {
                namingException = new CommunicationException(string2);
                break;
            }
            case 4: {
                namingException = new SizeLimitExceededException(string2);
                break;
            }
            case 3: {
                namingException = new TimeLimitExceededException(string2);
                break;
            }
            case 12: {
                namingException = new OperationNotSupportedException(string2);
                break;
            }
            case 51: 
            case 52: {
                namingException = new ServiceUnavailableException(string2);
                break;
            }
            case 17: {
                namingException = new InvalidAttributeIdentifierException(string2);
                break;
            }
            case 53: {
                namingException = new OperationNotSupportedException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 35: {
                namingException = new NamingException(string2);
                break;
            }
            case 11: {
                namingException = new LimitExceededException(string2);
                break;
            }
            case 10: {
                namingException = new NamingException(string2);
                break;
            }
            case 9: {
                namingException = new NamingException(string2);
                break;
            }
            case 34: 
            case 64: {
                namingException = new InvalidNameException(string2);
                break;
            }
            default: {
                namingException = new NamingException(string2);
            }
        }
        return namingException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    public ExtendedResponse extendedOperation(ExtendedRequest var1_1) throws NamingException {
        var2_2 = var1_1.getID().equals("1.3.6.1.4.1.1466.20037");
        this.ensureOpen(var2_2);
        try {
            var3_3 = this.clnt.extendedOp(var1_1.getID(), var1_1.getEncodedValue(), this.reqCtls, var2_2);
            this.respCtls = var3_3.resControls;
            if (var3_3.status != 0) {
                this.processReturnCode(var3_3, new CompositeName());
            }
            if ((var5_10 = var1_1.createExtendedResponse(var3_3.extensionId, var3_3.extensionValue, 0, var4_7 = var3_3.extensionValue == null ? 0 : var3_3.extensionValue.length)) instanceof StartTlsResponseImpl) {
                var6_13 = (String)(this.envprops != null ? this.envprops.get("com.sun.jndi.ldap.domainname") : null);
                ((StartTlsResponseImpl)var5_10).setConnection(this.clnt.conn, var6_13);
                this.contextSeenStartTlsEnabled |= var2_2;
            }
            return var5_10;
        }
        catch (LdapReferralException var3_4) {
            if (this.handleReferrals == 2) {
                throw var3_4;
            }
            while (true) lbl-1000:
            // 3 sources

            {
                var4_8 = (LdapReferralContext)var3_5.getReferralContext(this.envprops, this.bindCtls);
                try {
                    var5_12 = var4_8.extendedOperation(var1_1);
                    return var5_12;
                }
                catch (LdapReferralException var5_11) {
                    var3_5 = var5_11;
                }
                finally {
                    var4_8.close();
                    continue;
                }
                break;
            }
        }
        ** GOTO lbl-1000
        catch (IOException var3_6) {
            var4_9 = new CommunicationException(var3_6.getMessage());
            var4_9.setRootCause(var3_6);
            throw var4_9;
        }
    }

    @Override
    public void setRequestControls(Control[] controlArray) throws NamingException {
        this.reqCtls = this.handleReferrals == 3 ? LdapCtx.addControl(controlArray, manageReferralControl) : LdapCtx.cloneControls(controlArray);
    }

    @Override
    public Control[] getRequestControls() throws NamingException {
        return LdapCtx.cloneControls(this.reqCtls);
    }

    @Override
    public Control[] getConnectControls() throws NamingException {
        return LdapCtx.cloneControls(this.bindCtls);
    }

    @Override
    public Control[] getResponseControls() throws NamingException {
        return this.respCtls != null ? this.convertControls(this.respCtls) : null;
    }

    Control[] convertControls(Vector<Control> vector) throws NamingException {
        int n = vector.size();
        if (n == 0) {
            return null;
        }
        Control[] controlArray = new Control[n];
        for (int i = 0; i < n; ++i) {
            controlArray[i] = myResponseControlFactory.getControlInstance(vector.elementAt(i));
            if (controlArray[i] != null) continue;
            controlArray[i] = ControlFactory.getControlInstance(vector.elementAt(i), this, this.envprops);
        }
        return controlArray;
    }

    private static Control[] addControl(Control[] controlArray, Control control) {
        if (controlArray == null) {
            return new Control[]{control};
        }
        int n = LdapCtx.findControl(controlArray, control);
        if (n != -1) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[controlArray.length + 1];
        System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
        controlArray2[controlArray.length] = control;
        return controlArray2;
    }

    private static int findControl(Control[] controlArray, Control control) {
        for (int i = 0; i < controlArray.length; ++i) {
            if (controlArray[i] != control) continue;
            return i;
        }
        return -1;
    }

    private static Control[] removeControl(Control[] controlArray, Control control) {
        if (controlArray == null) {
            return null;
        }
        int n = LdapCtx.findControl(controlArray, control);
        if (n == -1) {
            return controlArray;
        }
        Control[] controlArray2 = new Control[controlArray.length - 1];
        System.arraycopy(controlArray, 0, controlArray2, 0, n);
        System.arraycopy(controlArray, n + 1, controlArray2, n, controlArray.length - n - 1);
        return controlArray2;
    }

    private static Control[] cloneControls(Control[] controlArray) {
        if (controlArray == null) {
            return null;
        }
        Control[] controlArray2 = new Control[controlArray.length];
        System.arraycopy(controlArray, 0, controlArray2, 0, controlArray.length);
        return controlArray2;
    }

    @Override
    public void addNamingListener(Name name, int n, NamingListener namingListener) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(name), n, namingListener);
    }

    @Override
    public void addNamingListener(String string, int n, NamingListener namingListener) throws NamingException {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport(this);
        }
        this.eventSupport.addNamingListener(LdapCtx.getTargetName(new CompositeName(string)), n, namingListener);
        if (namingListener instanceof UnsolicitedNotificationListener && !this.unsolicited) {
            this.addUnsolicited();
        }
    }

    @Override
    public void removeNamingListener(NamingListener namingListener) throws NamingException {
        if (this.eventSupport == null) {
            return;
        }
        this.eventSupport.removeNamingListener(namingListener);
        if (namingListener instanceof UnsolicitedNotificationListener && !this.eventSupport.hasUnsolicited()) {
            this.removeUnsolicited();
        }
    }

    @Override
    public void addNamingListener(String string, String string2, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        if (this.eventSupport == null) {
            this.eventSupport = new EventSupport(this);
        }
        this.eventSupport.addNamingListener(LdapCtx.getTargetName(new CompositeName(string)), string2, LdapCtx.cloneSearchControls(searchControls), namingListener);
        if (namingListener instanceof UnsolicitedNotificationListener && !this.unsolicited) {
            this.addUnsolicited();
        }
    }

    @Override
    public void addNamingListener(Name name, String string, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(name), string, searchControls, namingListener);
    }

    @Override
    public void addNamingListener(Name name, String string, Object[] objectArray, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        this.addNamingListener(LdapCtx.getTargetName(name), string, objectArray, searchControls, namingListener);
    }

    @Override
    public void addNamingListener(String string, String string2, Object[] objectArray, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        String string3 = SearchFilter.format(string2, objectArray);
        this.addNamingListener(LdapCtx.getTargetName(new CompositeName(string)), string3, searchControls, namingListener);
    }

    @Override
    public boolean targetMustExist() {
        return true;
    }

    private static String getTargetName(Name name) throws NamingException {
        if (name instanceof CompositeName) {
            if (name.size() > 1) {
                throw new InvalidNameException("Target cannot span multiple namespaces: " + name);
            }
            if (name.isEmpty()) {
                return "";
            }
            return name.get(0);
        }
        return name.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addUnsolicited() throws NamingException {
        this.ensureOpen();
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            this.clnt.addUnsolicited(this);
            this.unsolicited = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeUnsolicited() {
        if (this.eventSupport == null) {
            return;
        }
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            if (this.unsolicited && this.clnt != null) {
                this.clnt.removeUnsolicited(this);
            }
            this.unsolicited = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void fireUnsolicited(Object object) {
        EventSupport eventSupport = this.eventSupport;
        synchronized (eventSupport) {
            if (this.unsolicited) {
                this.eventSupport.fireUnsolicited(object);
                if (object instanceof NamingException) {
                    this.unsolicited = false;
                }
            }
        }
    }

    static {
        EMPTY_SCHEMA.setReadOnly(new SchemaViolationException("Cannot update schema object"));
    }

    static final class SearchArgs {
        Name name;
        String filter;
        SearchControls cons;
        String[] reqAttrs;

        SearchArgs(Name name, String string, SearchControls searchControls, String[] stringArray) {
            this.name = name;
            this.filter = string;
            this.cons = searchControls;
            this.reqAttrs = stringArray;
        }
    }
}

