/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.signature;

import com.sun.org.apache.xml.internal.security.algorithms.SignatureAlgorithm;
import com.sun.org.apache.xml.internal.security.c14n.CanonicalizationException;
import com.sun.org.apache.xml.internal.security.c14n.Canonicalizer;
import com.sun.org.apache.xml.internal.security.c14n.InvalidCanonicalizerException;
import com.sun.org.apache.xml.internal.security.exceptions.XMLSecurityException;
import com.sun.org.apache.xml.internal.security.signature.Manifest;
import com.sun.org.apache.xml.internal.security.signature.MissingResourceFailureException;
import com.sun.org.apache.xml.internal.security.transforms.params.InclusiveNamespaces;
import com.sun.org.apache.xml.internal.security.utils.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class SignedInfo
extends Manifest {
    private SignatureAlgorithm signatureAlgorithm;
    private byte[] c14nizedBytes;
    private Element c14nMethod;
    private Element signatureMethod;

    public SignedInfo(Document document) throws XMLSecurityException {
        this(document, "http://www.w3.org/2000/09/xmldsig#dsa-sha1", "http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
    }

    public SignedInfo(Document document, String string, String string2) throws XMLSecurityException {
        this(document, string, 0, string2);
    }

    public SignedInfo(Document document, String string, int n, String string2) throws XMLSecurityException {
        super(document);
        this.c14nMethod = XMLUtils.createElementInSignatureSpace(this.getDocument(), "CanonicalizationMethod");
        this.c14nMethod.setAttributeNS(null, "Algorithm", string2);
        this.appendSelf(this.c14nMethod);
        this.addReturnToSelf();
        this.signatureAlgorithm = n > 0 ? new SignatureAlgorithm(this.getDocument(), string, n) : new SignatureAlgorithm(this.getDocument(), string);
        this.signatureMethod = this.signatureAlgorithm.getElement();
        this.appendSelf(this.signatureMethod);
        this.addReturnToSelf();
    }

    public SignedInfo(Document document, Element element, Element element2) throws XMLSecurityException {
        super(document);
        this.c14nMethod = element2;
        this.appendSelf(this.c14nMethod);
        this.addReturnToSelf();
        this.signatureAlgorithm = new SignatureAlgorithm(element, null);
        this.signatureMethod = this.signatureAlgorithm.getElement();
        this.appendSelf(this.signatureMethod);
        this.addReturnToSelf();
    }

    public SignedInfo(Element element, String string) throws XMLSecurityException {
        this(element, string, true);
    }

    public SignedInfo(Element element, String string, boolean bl) throws XMLSecurityException {
        super(SignedInfo.reparseSignedInfoElem(element, bl), string, bl);
        this.c14nMethod = XMLUtils.getNextElement(element.getFirstChild());
        this.signatureMethod = XMLUtils.getNextElement(this.c14nMethod.getNextSibling());
        this.signatureAlgorithm = new SignatureAlgorithm(this.signatureMethod, this.getBaseURI(), bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Element reparseSignedInfoElem(Element element, boolean bl) throws XMLSecurityException {
        Element element2 = XMLUtils.getNextElement(element.getFirstChild());
        String string = element2.getAttributeNS(null, "Algorithm");
        if (string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315")) return element;
        if (string.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) return element;
        if (string.equals("http://www.w3.org/2001/10/xml-exc-c14n#")) return element;
        if (string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) return element;
        if (string.equals("http://www.w3.org/2006/12/xml-c14n11")) return element;
        if (string.equals("http://www.w3.org/2006/12/xml-c14n11#WithComments")) return element;
        try {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(string);
            canonicalizer.setSecureValidation(bl);
            byte[] byArray = canonicalizer.canonicalizeSubtree(element);
            try (ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);){
                Document document = XMLUtils.read(byteArrayInputStream, bl);
                Node node = element.getOwnerDocument().importNode(document.getDocumentElement(), true);
                element.getParentNode().replaceChild(node, element);
                Element element3 = (Element)node;
                return element3;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XMLSecurityException(parserConfigurationException);
        }
        catch (IOException iOException) {
            throw new XMLSecurityException(iOException);
        }
        catch (SAXException sAXException) {
            throw new XMLSecurityException(sAXException);
        }
    }

    public boolean verify() throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(false);
    }

    public boolean verify(boolean bl) throws MissingResourceFailureException, XMLSecurityException {
        return super.verifyReferences(bl);
    }

    public byte[] getCanonicalizedOctetStream() throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this.c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            canonicalizer.setSecureValidation(this.isSecureValidation());
            String string = this.getInclusiveNamespaces();
            this.c14nizedBytes = string == null ? canonicalizer.canonicalizeSubtree(this.getElement()) : canonicalizer.canonicalizeSubtree(this.getElement(), string);
        }
        return (byte[])this.c14nizedBytes.clone();
    }

    public void signInOctetStream(OutputStream outputStream) throws CanonicalizationException, InvalidCanonicalizerException, XMLSecurityException {
        if (this.c14nizedBytes == null) {
            Canonicalizer canonicalizer = Canonicalizer.getInstance(this.getCanonicalizationMethodURI());
            canonicalizer.setSecureValidation(this.isSecureValidation());
            canonicalizer.setWriter(outputStream);
            String string = this.getInclusiveNamespaces();
            if (string == null) {
                canonicalizer.canonicalizeSubtree(this.getElement());
            } else {
                canonicalizer.canonicalizeSubtree(this.getElement(), string);
            }
        } else {
            try {
                outputStream.write(this.c14nizedBytes);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public String getCanonicalizationMethodURI() {
        return this.c14nMethod.getAttributeNS(null, "Algorithm");
    }

    public String getSignatureMethodURI() {
        Element element = this.getSignatureMethodElement();
        if (element != null) {
            return element.getAttributeNS(null, "Algorithm");
        }
        return null;
    }

    public Element getSignatureMethodElement() {
        return this.signatureMethod;
    }

    public SecretKey createSecretKey(byte[] byArray) {
        return new SecretKeySpec(byArray, this.signatureAlgorithm.getJCEAlgorithmString());
    }

    public SignatureAlgorithm getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }

    @Override
    public String getBaseLocalName() {
        return "SignedInfo";
    }

    public String getInclusiveNamespaces() {
        String string = this.getCanonicalizationMethodURI();
        if (!string.equals("http://www.w3.org/2001/10/xml-exc-c14n#") && !string.equals("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
            return null;
        }
        Element element = XMLUtils.getNextElement(this.c14nMethod.getFirstChild());
        if (element != null) {
            try {
                String string2 = new InclusiveNamespaces(element, "http://www.w3.org/2001/10/xml-exc-c14n#").getInclusiveNamespaces();
                return string2;
            }
            catch (XMLSecurityException xMLSecurityException) {
                return null;
            }
        }
        return null;
    }
}

