/*
 * Decompiled with CFR 0.152.
 */
package java.lang.ref;

import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.lang.ref.FinalReference;
import java.lang.ref.ReferenceQueue;
import java.security.AccessController;
import java.security.PrivilegedAction;
import sun.misc.JavaLangAccess;
import sun.misc.SharedSecrets;
import sun.misc.VM;

final class Finalizer
extends FinalReference<Object> {
    private static ReferenceQueue<Object> queue = new ReferenceQueue();
    private static Finalizer unfinalized = null;
    private static final Object lock = new Object();
    private static long runningCount = 0L;
    private Finalizer next = null;
    private Finalizer prev = null;

    private boolean hasBeenFinalized() {
        return this.next == this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized != null) {
                this.next = unfinalized;
                Finalizer.unfinalized.prev = this;
            }
            unfinalized = this;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove() {
        Object object = lock;
        synchronized (object) {
            if (unfinalized == this) {
                unfinalized = this.next != null ? this.next : this.prev;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            this.next = this;
            this.prev = this;
        }
    }

    private Finalizer(Object object) {
        super(object, queue);
        this.add();
    }

    static ReferenceQueue<Object> getQueue() {
        return queue;
    }

    static void register(Object object) {
        new Finalizer(object);
        ++runningCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runFinalizer(JavaLangAccess javaLangAccess) {
        Finalizer finalizer = this;
        synchronized (finalizer) {
            if (this.hasBeenFinalized()) {
                return;
            }
            this.remove();
        }
        try {
            finalizer = this.get();
            if (finalizer != null && !(finalizer instanceof Enum)) {
                javaLangAccess.invokeFinalize(finalizer);
                finalizer = null;
                --runningCount;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.clear();
    }

    private static void forkSecondaryFinalizer(final Runnable runnable) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
                Object object = threadGroup;
                while (object != null) {
                    threadGroup = object;
                    object = threadGroup.getParent();
                }
                object = new Thread(threadGroup, runnable, "Secondary finalizer");
                ((Thread)object).start();
                try {
                    ((Thread)object).join();
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                }
                return null;
            }
        });
    }

    static void runFinalization() {
        if (!VM.isBooted()) {
            return;
        }
        Finalizer.forkSecondaryFinalizer(new Runnable(){
            private volatile boolean running;

            @Override
            public void run() {
                Finalizer finalizer;
                if (this.running) {
                    return;
                }
                JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
                this.running = true;
                while ((finalizer = (Finalizer)queue.poll()) != null) {
                    finalizer.runFinalizer(javaLangAccess);
                }
            }
        });
    }

    static void runAllFinalizers() {
        if (!VM.isBooted()) {
            return;
        }
        Finalizer.forkSecondaryFinalizer(new Runnable(){
            private volatile boolean running;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (this.running) {
                    return;
                }
                JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
                this.running = true;
                while (true) {
                    Finalizer finalizer;
                    Object object = lock;
                    synchronized (object) {
                        finalizer = unfinalized;
                        if (finalizer == null) {
                            break;
                        }
                        unfinalized = finalizer.next;
                    }
                    finalizer.runFinalizer(javaLangAccess);
                }
            }
        });
    }

    static {
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        Object object = threadGroup;
        while (object != null) {
            threadGroup = object;
            object = threadGroup.getParent();
        }
        object = new FinalizerThread(threadGroup);
        ((Thread)object).setPriority(8);
        ((Thread)object).setDaemon(true);
        ((Thread)object).start();
    }

    private static class FinalizerThread
    extends Thread {
        static boolean firstTime = true;
        boolean isFirstThread = false;
        static long prevMillis;
        static long sampleCount;
        static long startTime;
        static boolean doFinalizerStats;
        static long finalizerStatsRate;
        static PrintStream finalizerStatsFile;
        static final long defaultFinalizerCount = 1L;
        static final long defaultFinalizerStatsRate = 10L;
        private volatile boolean running;

        FinalizerThread(ThreadGroup threadGroup) {
            super(threadGroup, "Finalizer");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (this.running) {
                return;
            }
            while (!VM.isBooted()) {
                try {
                    VM.awaitBooted();
                }
                catch (InterruptedException interruptedException) {}
            }
            JavaLangAccess javaLangAccess = SharedSecrets.getJavaLangAccess();
            this.running = true;
            while (true) {
                Object object;
                try {
                    long l;
                    object = (Finalizer)queue.remove();
                    ((Finalizer)object).runFinalizer(javaLangAccess);
                    if (doFinalizerStats && this.isFirstThread && (l = System.currentTimeMillis()) > prevMillis + finalizerStatsRate) {
                        finalizerStatsFile.println("<F: " + ++sampleCount + " " + (System.currentTimeMillis() - startTime) + " " + runningCount + " " + queue.getQueueDepth() + " >");
                        finalizerStatsFile.flush();
                        prevMillis = l;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!firstTime) continue;
                object = this.getClass();
                synchronized (object) {
                    if (firstTime) {
                        Object object2;
                        Object object3;
                        Object object4;
                        String string = System.getProperty("java.finalizer.threadCount");
                        long l = 1L;
                        if (string != null && string.length() != 0) {
                            try {
                                object4 = new Long(string);
                                l = (Long)object4;
                            }
                            catch (Exception exception) {
                                System.err.println("Error in java.finalizer.threadCount value");
                            }
                        }
                        object4 = System.getProperty("java.finalizer.verbose.rate");
                        finalizerStatsRate = 10L;
                        if (object4 != null && ((String)object4).length() != 0) {
                            try {
                                object3 = new Long((String)object4);
                                finalizerStatsRate = (Long)object3;
                            }
                            catch (Exception exception) {
                                System.err.println("Error in java.finalizer.verbose.rate value");
                            }
                        }
                        finalizerStatsRate *= 1000L;
                        object3 = System.getProperty("java.finalizer.verbose");
                        if (object3 != null && ((String)object3).length() != 0) {
                            try {
                                if (((String)object3).equals("true")) {
                                    doFinalizerStats = true;
                                }
                            }
                            catch (Exception exception) {
                                System.err.println("Error in java.finalizer.verbose value");
                            }
                        }
                        String string2 = System.getProperty("java.finalizer.verbose.output");
                        if (doFinalizerStats) {
                            if (string2 != null && string2.length() != 0) {
                                try {
                                    object2 = new File(string2);
                                    finalizerStatsFile = new PrintStream(new FileOutputStream((File)object2));
                                }
                                catch (Exception exception) {
                                    System.err.println("Error in java.finalizer.verbose.output value");
                                }
                            } else {
                                finalizerStatsFile = System.err;
                            }
                        }
                        object2 = Thread.currentThread().getThreadGroup();
                        ThreadGroup threadGroup = object2;
                        while (threadGroup != null) {
                            object2 = threadGroup;
                            threadGroup = ((ThreadGroup)object2).getParent();
                        }
                        int n = 0;
                        while ((long)n < l - 1L) {
                            FinalizerThread finalizerThread = new FinalizerThread((ThreadGroup)object2);
                            finalizerThread.setPriority(8);
                            finalizerThread.setDaemon(true);
                            finalizerThread.start();
                            ++n;
                        }
                        prevMillis = startTime = System.currentTimeMillis();
                        firstTime = false;
                        this.isFirstThread = true;
                        if (doFinalizerStats) {
                            finalizerStatsFile.println("<F: version = " + System.getProperty("java.version") + " >");
                            finalizerStatsFile.println("<F: java.finalizer.threadCount = " + l + " >");
                        }
                    }
                }
            }
        }

        static {
            sampleCount = 0L;
            startTime = 0L;
            doFinalizerStats = false;
        }
    }
}

