/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CodingErrorAction;
import java.util.HashMap;

class XMap {
    private static HashMap xMappers = new HashMap();
    char[] convertedGlyphs;
    static final int SINGLE_BYTE = 1;
    static final int DOUBLE_BYTE = 2;
    private static final char SURR_MIN = '\ud800';
    private static final char SURR_MAX = '\udfff';

    static synchronized XMap getXMapper(String string) {
        XMap xMap = (XMap)xMappers.get(string);
        if (xMap == null) {
            xMap = XMap.getXMapperInternal(string);
            xMappers.put(string, xMap);
        }
        return xMap;
    }

    private static XMap getXMapperInternal(String string) {
        String string2 = null;
        int n = 1;
        int n2 = 65535;
        int n3 = 0;
        boolean bl = false;
        boolean bl2 = false;
        if (string.equals("dingbats")) {
            string2 = "sun.awt.motif.X11Dingbats";
            n3 = 9985;
            n2 = 10174;
        } else if (string.equals("symbol")) {
            string2 = "sun.awt.Symbol";
            n3 = 913;
            n2 = 8943;
        } else if (string.equals("iso8859-1")) {
            n2 = 255;
        } else if (string.equals("iso8859-2")) {
            string2 = "ISO8859_2";
        } else if (string.equals("jisx0208.1983-0")) {
            string2 = "sun.awt.motif.X11JIS0208";
            n = 2;
        } else if (string.equals("jisx0201.1976-0")) {
            string2 = "sun.awt.motif.X11JIS0201";
            bl = true;
            bl2 = true;
        } else if (string.equals("jisx0212.1990-0")) {
            string2 = "sun.awt.motif.X11JIS0212";
            n = 2;
        } else if (string.equals("iso8859-4")) {
            string2 = "ISO8859_4";
        } else if (string.equals("iso8859-5")) {
            string2 = "ISO8859_5";
        } else if (string.equals("koi8-r")) {
            string2 = "KOI8_R";
        } else if (string.equals("ansi-1251")) {
            string2 = "windows-1251";
        } else if (string.equals("iso8859-6")) {
            string2 = "ISO8859_6";
        } else if (string.equals("iso8859-7")) {
            string2 = "ISO8859_7";
        } else if (string.equals("iso8859-8")) {
            string2 = "ISO8859_8";
        } else if (string.equals("iso8859-9")) {
            string2 = "ISO8859_9";
        } else if (string.equals("iso8859-13")) {
            string2 = "ISO8859_13";
        } else if (string.equals("iso8859-15")) {
            string2 = "ISO8859_15";
        } else if (string.equals("ksc5601.1987-0")) {
            string2 = "sun.awt.motif.X11KSC5601";
            n = 2;
        } else if (string.equals("ksc5601.1992-3")) {
            string2 = "sun.awt.motif.X11Johab";
            n = 2;
        } else if (string.equals("ksc5601.1987-1")) {
            string2 = "EUC_KR";
            n = 2;
        } else if (string.equals("cns11643-1")) {
            string2 = "sun.awt.motif.X11CNS11643P1";
            n = 2;
        } else if (string.equals("cns11643-2")) {
            string2 = "sun.awt.motif.X11CNS11643P2";
            n = 2;
        } else if (string.equals("cns11643-3")) {
            string2 = "sun.awt.motif.X11CNS11643P3";
            n = 2;
        } else if (string.equals("gb2312.1980-0")) {
            string2 = "sun.awt.motif.X11GB2312";
            n = 2;
        } else if (string.indexOf("big5") >= 0) {
            string2 = "Big5";
            n = 2;
            bl = true;
        } else if (string.equals("tis620.2533-0")) {
            string2 = "TIS620";
        } else if (string.equals("gbk-0")) {
            string2 = "sun.awt.motif.X11GBK";
            n = 2;
        } else if (string.equals("ksc5636.1989-0")) {
            string2 = "EUC_KR";
            n = 2;
        } else if (string.equals("gb2312.1980-1")) {
            string2 = "GBK";
            n = 2;
        } else if (string.equals("iso10646.2000-cn")) {
            string2 = "HPGB18030";
            n = 2;
        } else if (string.equals("cns11643.1992-1")) {
            string2 = "sun.awt.motif.X11CNS11643P1";
            n = 2;
        } else if (string.equals("cns11643.1992-2")) {
            string2 = "sun.awt.motif.X11CNS11643P2";
            n = 2;
        } else if (string.equals("cns11643.1992-3")) {
            string2 = "sun.awt.motif.X11CNS11643P3";
            n = 2;
        } else if (string.equals("jisx0208.1990-0")) {
            string2 = "sun.awt.motif.X11JIS0208";
            n = 2;
        } else if (string.indexOf("hpbig5") >= 0) {
            string2 = "Big5";
            n = 2;
            bl = true;
        } else if (string.indexOf("hphkbig5") >= 0) {
            string2 = "Big5_HKSCS";
            n = 2;
            bl = true;
        } else if (string.indexOf("sun.unicode-0") >= 0) {
            string2 = "sun.awt.motif.X11SunUnicode_0";
            n = 2;
        } else if (string.indexOf("gb18030.2000-1") >= 0) {
            string2 = "sun.awt.motif.X11GB18030_1";
            n = 2;
        } else if (string.indexOf("gb18030.2000-0") >= 0) {
            string2 = "sun.awt.motif.X11GB18030_0";
            n = 2;
        } else if (string.indexOf("hkscs") >= 0) {
            string2 = "sun.awt.HKSCS";
            n = 2;
        }
        return new XMap(string2, n3, n2, n, bl, bl2);
    }

    private XMap(String string, int n, int n2, int n3, boolean bl, boolean bl2) {
        int n4;
        CharsetEncoder charsetEncoder = null;
        if (string != null) {
            try {
                charsetEncoder = string.startsWith("sun.awt") ? ((Charset)Class.forName(string).newInstance()).newEncoder() : Charset.forName(string).newEncoder();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (charsetEncoder == null) {
            this.convertedGlyphs = new char[256];
            for (int i = 0; i < 256; ++i) {
                this.convertedGlyphs[i] = (char)i;
            }
            return;
        }
        int n5 = n2 - n + 1;
        byte[] byArray = new byte[n5 * n3];
        char[] cArray = new char[n5];
        for (n4 = 0; n4 < n5; ++n4) {
            cArray[n4] = (char)(n + n4);
        }
        n4 = 0;
        if (n3 > 1 && n < 256) {
            n4 = 256 - n;
        }
        byte[] byArray2 = new byte[n3];
        try {
            int n6 = 0;
            int n7 = 0;
            if (n4 < 55296 && n4 + n5 > 57343) {
                n6 = 55296 - n4;
                n7 = n6 * n3;
                charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(byArray2).encode(CharBuffer.wrap(cArray, n4, n6), ByteBuffer.wrap(byArray, n4 * n3, n7), true);
                n4 = 57344;
            }
            n6 = n5 - n4;
            n7 = n6 * n3;
            charsetEncoder.onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE).replaceWith(byArray2).encode(CharBuffer.wrap(cArray, n4, n6), ByteBuffer.wrap(byArray, n4 * n3, n7), true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.convertedGlyphs = new char[65536];
        for (int i = 0; i < n5; ++i) {
            this.convertedGlyphs[i + n] = n3 == 1 ? (char)(byArray[i] & 0xFF) : (char)(((byArray[i * 2] & 0xFF) << 8) + (byArray[i * 2 + 1] & 0xFF));
        }
        int n8 = n5 = bl2 ? 128 : 256;
        if (bl && this.convertedGlyphs.length >= 256) {
            for (int i = 0; i < n5; ++i) {
                if (this.convertedGlyphs[i] != '\u0000') continue;
                this.convertedGlyphs[i] = (char)i;
            }
        }
    }
}

