/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.NetworkInterface;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Random;
import sun.security.provider.NativeSeedGenerator;
import sun.security.provider.SunEntries;
import sun.security.util.Debug;

abstract class SeedGenerator {
    private static SeedGenerator instance;
    private static final Debug debug;
    static final String URL_DEV_RANDOM = "file:/dev/random";
    static final String URL_DEV_URANDOM = "file:/dev/urandom";

    SeedGenerator() {
    }

    public static void generateSeed(byte[] byArray) {
        instance.getSeedBytes(byArray);
    }

    abstract void getSeedBytes(byte[] var1);

    static byte[] getSystemEntropy() {
        MessageDigest messageDigest;
        try {
            messageDigest = MessageDigest.getInstance("SHA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new InternalError("internal error: SHA-1 not available.", noSuchAlgorithmException);
        }
        byte by = (byte)System.currentTimeMillis();
        messageDigest.update(by);
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Object object;
                Object object2;
                try {
                    object2 = System.getProperties();
                    Enumeration<?> enumeration = ((Properties)object2).propertyNames();
                    while (enumeration.hasMoreElements()) {
                        object = (String)enumeration.nextElement();
                        messageDigest.update(((String)object).getBytes());
                        messageDigest.update(((Properties)object2).getProperty((String)object).getBytes());
                    }
                    SeedGenerator.addNetworkAdapterInfo(messageDigest);
                    File file = new File(((Properties)object2).getProperty("java.io.tmpdir"));
                    int n = 0;
                    try (DirectoryStream<Path> directoryStream = Files.newDirectoryStream(file.toPath());){
                        Random random = new Random();
                        for (Path path : directoryStream) {
                            if (n < 512 || random.nextBoolean()) {
                                messageDigest.update(path.getFileName().toString().getBytes());
                            }
                            if (n++ <= 1024) continue;
                            break;
                        }
                    }
                }
                catch (Exception exception) {
                    messageDigest.update((byte)exception.hashCode());
                }
                object = Runtime.getRuntime();
                object2 = SeedGenerator.longToByteArray(((Runtime)object).totalMemory());
                messageDigest.update((byte[])object2, 0, ((Object)object2).length);
                object2 = SeedGenerator.longToByteArray(((Runtime)object).freeMemory());
                messageDigest.update((byte[])object2, 0, ((Object)object2).length);
                return null;
            }
        });
        return messageDigest.digest();
    }

    private static void addNetworkAdapterInfo(MessageDigest messageDigest) {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                byte[] byArray;
                NetworkInterface networkInterface = enumeration.nextElement();
                messageDigest.update(networkInterface.toString().getBytes());
                if (networkInterface.isVirtual() || (byArray = networkInterface.getHardwareAddress()) == null) continue;
                messageDigest.update(byArray);
                break;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static byte[] longToByteArray(long l) {
        byte[] byArray = new byte[8];
        for (int i = 0; i < 8; ++i) {
            byArray[i] = (byte)l;
            l >>= 8;
        }
        return byArray;
    }

    static {
        block11: {
            debug = Debug.getInstance("provider");
            String string = SunEntries.getSeedSource();
            if (string.equals(URL_DEV_RANDOM) || string.equals(URL_DEV_URANDOM)) {
                try {
                    instance = new NativeSeedGenerator(string);
                    if (debug != null) {
                        debug.println("Using operating system seed generator");
                    }
                    break block11;
                }
                catch (IOException iOException) {
                    if (debug != null) {
                        debug.println("Failed to use operating system seed generator: " + iOException.toString());
                    }
                    break block11;
                }
            }
            if (!string.isEmpty()) {
                try {
                    instance = new URLSeedGenerator(string);
                    if (debug != null) {
                        debug.println("Using URL seed generator reading from " + string);
                    }
                }
                catch (IOException iOException) {
                    if (debug == null) break block11;
                    debug.println("Failed to create seed generator with " + string + ": " + iOException.toString());
                }
            }
        }
        if (instance == null) {
            if (debug != null) {
                debug.println("Using default threaded seed generator");
            }
            instance = new ThreadedSeedGenerator();
        }
    }

    static class URLSeedGenerator
    extends SeedGenerator {
        private String deviceName;
        private InputStream devRandom;

        URLSeedGenerator(String string) throws IOException {
            if (string == null) {
                throw new IOException("No random source specified");
            }
            this.deviceName = string;
            this.init();
        }

        URLSeedGenerator() throws IOException {
            this(SeedGenerator.URL_DEV_RANDOM);
        }

        private void init() throws IOException {
            final URL uRL = new URL(this.deviceName);
            try {
                this.devRandom = AccessController.doPrivileged(new PrivilegedExceptionAction<InputStream>(){

                    @Override
                    public InputStream run() throws IOException {
                        if (uRL.getProtocol().equalsIgnoreCase("file")) {
                            File file = this.getDeviceFile(uRL);
                            return new FileInputStream(file);
                        }
                        return uRL.openStream();
                    }
                });
            }
            catch (Exception exception) {
                throw new IOException("Failed to open " + this.deviceName, exception.getCause());
            }
        }

        private File getDeviceFile(URL uRL) throws IOException {
            try {
                URI uRI = uRL.toURI();
                if (uRI.isOpaque()) {
                    URI uRI2 = new File(System.getProperty("user.dir")).toURI();
                    String string = uRI2.toString() + uRI.toString().substring(5);
                    return new File(URI.create(string));
                }
                return new File(uRI);
            }
            catch (URISyntaxException uRISyntaxException) {
                return new File(uRL.getPath());
            }
        }

        @Override
        void getSeedBytes(byte[] byArray) {
            int n = byArray.length;
            try {
                int n2;
                for (int i = 0; i < n; i += n2) {
                    n2 = this.devRandom.read(byArray, i, n - i);
                    if (n2 >= 0) continue;
                    throw new InternalError("URLSeedGenerator " + this.deviceName + " reached end of file");
                }
            }
            catch (IOException iOException) {
                throw new InternalError("URLSeedGenerator " + this.deviceName + " generated exception: " + iOException.getMessage(), iOException);
            }
        }
    }

    private static class ThreadedSeedGenerator
    extends SeedGenerator
    implements Runnable {
        private byte[] pool = new byte[20];
        private int start = 0;
        private int end = 0;
        private int count;
        BogusThread noisyThread;
        private static byte[] rndTab = new byte[]{56, 30, -107, -6, -86, 25, -83, 75, -12, -64, 5, -128, 78, 21, 16, 32, 70, -81, 37, -51, -43, -46, -108, 87, 29, 17, -55, 22, -11, -111, -115, 84, -100, 108, -45, -15, -98, 72, -33, -28, 31, -52, -37, -117, -97, -27, 93, -123, 47, 126, -80, -62, -93, -79, 61, -96, -65, -5, -47, -119, 14, 89, 81, -118, -88, 20, 67, -126, -113, 60, -102, 55, 110, 28, 85, 121, 122, -58, 2, 45, 43, 24, -9, 103, -13, 102, -68, -54, -101, -104, 19, 13, -39, -26, -103, 62, 77, 51, 44, 111, 73, 18, -127, -82, 4, -30, 11, -99, -74, 40, -89, 42, -76, -77, -94, -35, -69, 35, 120, 76, 33, -73, -7, 82, -25, -10, 88, 125, -112, 58, 83, 95, 6, 10, 98, -34, 80, 15, -91, 86, -19, 52, -17, 117, 49, -63, 118, -90, 36, -116, -40, -71, 97, -53, -109, -85, 109, -16, -3, 104, -95, 68, 54, 34, 26, 114, -1, 106, -121, 3, 66, 0, 100, -84, 57, 107, 119, -42, 112, -61, 1, 48, 38, 12, -56, -57, 39, -106, -72, 41, 7, 71, -29, -59, -8, -38, 79, -31, 124, -124, 8, 91, 116, 99, -4, 9, -36, -78, 63, -49, -67, -87, 59, 101, -32, 92, 94, 53, -41, 115, -66, -70, -122, 50, -50, -22, -20, -18, -21, 23, -2, -48, 96, 65, -105, 123, -14, -110, 69, -24, -120, -75, 74, 127, -60, 113, 90, -114, 105, 46, 27, -125, -23, -44, 64, -92};

        ThreadedSeedGenerator() {
            try {
                MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new InternalError("internal error: SHA-1 not available.", noSuchAlgorithmException);
            }
            Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ThreadGroup threadGroup;
                    ThreadGroup threadGroup2 = Thread.currentThread().getThreadGroup();
                    while ((threadGroup = threadGroup2.getParent()) != null) {
                        threadGroup2 = threadGroup;
                    }
                    ThreadGroup threadGroup3 = new ThreadGroup(threadGroup2, "SeedGenerator ThreadGroup");
                    noisyThread = new BogusThread(threadGroup3, "Noisy Thread");
                    noisyThread.setDaemon(true);
                    noisyThread.setPriority(5);
                    Thread thread = new Thread(threadGroup3, this, "SeedGenerator Thread");
                    thread.setDaemon(true);
                    thread.setPriority(4);
                    return thread;
                }
            });
            this.noisyThread.start();
            thread.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public final void run() {
            try {
                long l = System.currentTimeMillis();
                int n = this.hashCode();
                int n2 = (int)l;
                int n3 = 0;
                BogusThread bogusThread = this.noisyThread;
                while (true) {
                    int n4 = 0;
                    while (n4 >= 0 && n4 < 64000) {
                        int n5 = 0;
                        long l2 = System.currentTimeMillis();
                        long l3 = l2 + 240L;
                        bogusThread.wakeup();
                        while (true) {
                            n5 += bogusThread.getNum();
                            l = System.currentTimeMillis();
                            if (l == l2) continue;
                            n4 += n5;
                            n += ~(n + n5 << 15);
                            n ^= n >>> 10;
                            n += n << 3;
                            n ^= n >>> 6;
                            n += ~(n << 11);
                            n ^= n >>> 16;
                            n3 = (byte)(n3 + rndTab[n & 0xFF]);
                            l2 = l;
                            if (l2 >= l3) break;
                        }
                    }
                    n2 += n >>> 24;
                    n2 = 36969 * (n2 & 0xFFFF) + (n2 >>> 16);
                    ThreadedSeedGenerator threadedSeedGenerator = this;
                    synchronized (threadedSeedGenerator) {
                        while (this.count >= this.pool.length) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException interruptedException) {}
                        }
                        this.pool[this.end] = (byte)(n3 ^ n2 + n >>> 9);
                        ++this.end;
                        ++this.count;
                        if (this.end >= this.pool.length) {
                            this.end = 0;
                        }
                        if (this.count == this.pool.length) {
                            this.notifyAll();
                        } else {
                            this.notify();
                        }
                    }
                }
            }
            catch (Exception exception) {
                throw new InternalError("internal SeedGenerator error: " + exception);
            }
        }

        @Override
        void getSeedBytes(byte[] byArray) {
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = this.getSeedByte();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        byte getSeedByte() {
            byte by = 0;
            ThreadedSeedGenerator threadedSeedGenerator = this;
            synchronized (threadedSeedGenerator) {
                while (this.count <= 0) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                by = this.pool[this.start];
                this.pool[this.start] = 0;
                ++this.start;
                --this.count;
                if (this.start == this.pool.length) {
                    this.start = 0;
                }
                if (this.count + 1 >= this.pool.length) {
                    this.notifyAll();
                }
            }
            return by;
        }

        private static class BogusThread
        extends Thread {
            boolean wakeupflag = false;
            int oneOrTwo = 1;

            public BogusThread(ThreadGroup threadGroup, String string) {
                super(threadGroup, string);
            }

            public final synchronized int getNum() {
                return this.oneOrTwo;
            }

            /*
             * Exception decompiling
             */
            @Override
            public final void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [12[DOLOOP]], but top level block is 14[UNCONDITIONALDOLOOP]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final synchronized void wakeup() {
                this.wakeupflag = true;
                this.notifyAll();
            }
        }
    }
}

