/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantObject;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ConstantLong
extends Constant
implements ConstantObject {
    private long bytes;

    public ConstantLong(long bytes) {
        super((byte)5);
        this.bytes = bytes;
    }

    public ConstantLong(ConstantLong c) {
        this(c.getBytes());
    }

    ConstantLong(DataInput file) throws IOException {
        this(file.readLong());
    }

    @Override
    public void accept(Visitor v) {
        v.visitConstantLong(this);
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        file.writeByte(super.getTag());
        file.writeLong(this.bytes);
    }

    public long getBytes() {
        return this.bytes;
    }

    public void setBytes(long bytes) {
        this.bytes = bytes;
    }

    @Override
    public String toString() {
        return super.toString() + "(bytes = " + this.bytes + ")";
    }

    @Override
    public Object getConstantValue(ConstantPool cp) {
        return this.bytes;
    }
}

