/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LineNumber
implements Cloneable,
Node {
    private short startPc;
    private short lineNumber;

    public LineNumber(LineNumber c) {
        this(c.getStartPC(), c.getLineNumber());
    }

    LineNumber(DataInput file) throws IOException {
        this(file.readUnsignedShort(), file.readUnsignedShort());
    }

    public LineNumber(int startPc, int lineNumber) {
        this.startPc = (short)startPc;
        this.lineNumber = (short)lineNumber;
    }

    @Override
    public void accept(Visitor v) {
        v.visitLineNumber(this);
    }

    public void dump(DataOutputStream file) throws IOException {
        file.writeShort(this.startPc);
        file.writeShort(this.lineNumber);
    }

    public int getLineNumber() {
        return 0xFFFF & this.lineNumber;
    }

    public int getStartPC() {
        return 0xFFFF & this.startPc;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = (short)lineNumber;
    }

    public void setStartPC(int startPc) {
        this.startPc = (short)startPc;
    }

    public String toString() {
        return "LineNumber(" + this.startPc + ", " + this.lineNumber + ")";
    }

    public LineNumber copy() {
        try {
            return (LineNumber)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

