/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.concurrent.locks.ReentrantLock;
import sun.security.ssl.Authenticator;
import sun.security.ssl.Ciphertext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLCipher;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.TransportContext;

abstract class OutputRecord
extends ByteArrayOutputStream
implements Record,
Closeable {
    SSLCipher.SSLWriteCipher writeCipher;
    TransportContext tc;
    final HandshakeHash handshakeHash;
    boolean firstMessage;
    ProtocolVersion protocolVersion;
    ProtocolVersion helloVersion;
    boolean isFirstAppOutputRecord = true;
    int packetSize;
    private int fragmentSize;
    volatile boolean isClosed;
    final ReentrantLock recordLock = new ReentrantLock();
    private static final int[] V3toV2CipherMap1 = new int[]{-1, -1, -1, 2, 1, -1, 4, 5, -1, 6, 7};
    private static final int[] V3toV2CipherMap3 = new int[]{-1, -1, -1, 128, 128, -1, 128, 128, -1, 64, 192};
    private static final byte[] HANDSHAKE_MESSAGE_KEY_UPDATE = new byte[]{SSLHandshake.KEY_UPDATE.id, 0, 0, 1, 0};

    OutputRecord(HandshakeHash handshakeHash, SSLCipher.SSLWriteCipher sSLWriteCipher) {
        this.writeCipher = sSLWriteCipher;
        this.firstMessage = true;
        this.fragmentSize = 16384;
        this.handshakeHash = handshakeHash;
    }

    void setVersion(ProtocolVersion protocolVersion) {
        this.recordLock.lock();
        try {
            this.protocolVersion = protocolVersion;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    void setHelloVersion(ProtocolVersion protocolVersion) {
        this.recordLock.lock();
        try {
            this.helloVersion = protocolVersion;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    boolean isEmpty() {
        return false;
    }

    boolean seqNumIsHuge() {
        this.recordLock.lock();
        try {
            boolean bl = this.writeCipher.authenticator != null && this.writeCipher.authenticator.seqNumIsHuge();
            return bl;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    abstract void encodeAlert(byte var1, byte var2) throws IOException;

    abstract void encodeHandshake(byte[] var1, int var2, int var3) throws IOException;

    abstract void encodeChangeCipherSpec() throws IOException;

    void disposeWriteCipher() {
        throw new UnsupportedOperationException();
    }

    Ciphertext encode(ByteBuffer[] byteBufferArray, int n, int n2, ByteBuffer[] byteBufferArray2, int n3, int n4) throws IOException {
        throw new UnsupportedOperationException();
    }

    void encodeV2NoCipher() throws IOException {
        throw new UnsupportedOperationException();
    }

    void deliver(byte[] byArray, int n, int n2) throws IOException {
        throw new UnsupportedOperationException();
    }

    void setDeliverStream(OutputStream outputStream) {
        throw new UnsupportedOperationException();
    }

    void changeWriteCiphers(SSLCipher.SSLWriteCipher sSLWriteCipher, boolean bl) throws IOException {
        this.recordLock.lock();
        try {
            if (this.isClosed()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("outbound has closed, ignore outbound change_cipher_spec message", new Object[0]);
                }
                return;
            }
            if (bl) {
                this.encodeChangeCipherSpec();
            }
            this.disposeWriteCipher();
            this.writeCipher = sSLWriteCipher;
            this.isFirstAppOutputRecord = true;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void changeWriteCiphers(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by) throws IOException {
        this.recordLock.lock();
        try {
            if (this.isClosed()) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl")) {
                    SSLLogger.warning("outbound has closed, ignore outbound key_update handshake message", new Object[0]);
                }
                return;
            }
            byte[] byArray = (byte[])HANDSHAKE_MESSAGE_KEY_UPDATE.clone();
            byArray[byArray.length - 1] = by;
            this.encodeHandshake(byArray, 0, byArray.length);
            this.flush();
            this.disposeWriteCipher();
            this.writeCipher = sSLWriteCipher;
            this.isFirstAppOutputRecord = true;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    void changePacketSize(int n) {
        this.recordLock.lock();
        try {
            this.packetSize = n;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    void changeFragmentSize(int n) {
        this.recordLock.lock();
        try {
            this.fragmentSize = n;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    int getMaxPacketSize() {
        this.recordLock.lock();
        try {
            int n = this.packetSize;
            return n;
        }
        finally {
            this.recordLock.unlock();
        }
    }

    void initHandshaker() {
    }

    @Override
    public void close() throws IOException {
        this.recordLock.lock();
        try {
            if (this.isClosed) {
                return;
            }
            this.isClosed = true;
            this.writeCipher.dispose();
        }
        finally {
            this.recordLock.unlock();
        }
    }

    boolean isClosed() {
        return this.isClosed;
    }

    int calculateFragmentSize(int n) {
        if (this.fragmentSize > 0) {
            n = Math.min(n, this.fragmentSize);
        }
        if (this.protocolVersion.useTLS13PlusSpec()) {
            return n - T13PaddingHolder.zeros.length - 1;
        }
        return n;
    }

    static long encrypt(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by, ByteBuffer byteBuffer, int n, int n2, int n3, ProtocolVersion protocolVersion) {
        if (protocolVersion.useTLS13PlusSpec()) {
            return OutputRecord.t13Encrypt(sSLWriteCipher, by, byteBuffer, n, n2, n3, protocolVersion);
        }
        return OutputRecord.t10Encrypt(sSLWriteCipher, by, byteBuffer, n, n2, n3, protocolVersion);
    }

    private static long d13Encrypt(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by, ByteBuffer byteBuffer, int n, int n2, int n3, ProtocolVersion protocolVersion) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    private static long d10Encrypt(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by, ByteBuffer byteBuffer, int n, int n2, int n3, ProtocolVersion protocolVersion) {
        byte[] byArray = sSLWriteCipher.authenticator.sequenceNumber();
        sSLWriteCipher.encrypt(by, byteBuffer);
        int n4 = byteBuffer.limit() - n - n3;
        byteBuffer.put(n, by);
        byteBuffer.put(n + 1, protocolVersion.major);
        byteBuffer.put(n + 2, protocolVersion.minor);
        byteBuffer.put(n + 3, byArray[0]);
        byteBuffer.put(n + 4, byArray[1]);
        byteBuffer.put(n + 5, byArray[2]);
        byteBuffer.put(n + 6, byArray[3]);
        byteBuffer.put(n + 7, byArray[4]);
        byteBuffer.put(n + 8, byArray[5]);
        byteBuffer.put(n + 9, byArray[6]);
        byteBuffer.put(n + 10, byArray[7]);
        byteBuffer.put(n + 11, (byte)(n4 >> 8));
        byteBuffer.put(n + 12, (byte)n4);
        byteBuffer.position(byteBuffer.limit());
        return Authenticator.toLong(byArray);
    }

    private static long t13Encrypt(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by, ByteBuffer byteBuffer, int n, int n2, int n3, ProtocolVersion protocolVersion) {
        if (!sSLWriteCipher.isNullCipher()) {
            int n4 = byteBuffer.limit();
            int n5 = byteBuffer.position();
            byteBuffer.position(n4);
            byteBuffer.limit(n4 + 1 + T13PaddingHolder.zeros.length);
            byteBuffer.put(by);
            byteBuffer.put(T13PaddingHolder.zeros);
            byteBuffer.position(n5);
        }
        ProtocolVersion protocolVersion2 = protocolVersion;
        if (!sSLWriteCipher.isNullCipher()) {
            protocolVersion2 = ProtocolVersion.TLS12;
            by = ContentType.APPLICATION_DATA.id;
        } else if (protocolVersion.useTLS13PlusSpec()) {
            protocolVersion2 = ProtocolVersion.TLS12;
        }
        byte[] byArray = sSLWriteCipher.authenticator.sequenceNumber();
        sSLWriteCipher.encrypt(by, byteBuffer);
        int n6 = byteBuffer.limit() - n - n3;
        byteBuffer.put(n, by);
        byteBuffer.put(n + 1, protocolVersion2.major);
        byteBuffer.put(n + 2, protocolVersion2.minor);
        byteBuffer.put(n + 3, (byte)(n6 >> 8));
        byteBuffer.put(n + 4, (byte)n6);
        byteBuffer.position(byteBuffer.limit());
        return Authenticator.toLong(byArray);
    }

    private static long t10Encrypt(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by, ByteBuffer byteBuffer, int n, int n2, int n3, ProtocolVersion protocolVersion) {
        byte[] byArray = sSLWriteCipher.authenticator.sequenceNumber();
        sSLWriteCipher.encrypt(by, byteBuffer);
        int n4 = byteBuffer.limit() - n - n3;
        byteBuffer.put(n, by);
        byteBuffer.put(n + 1, protocolVersion.major);
        byteBuffer.put(n + 2, protocolVersion.minor);
        byteBuffer.put(n + 3, (byte)(n4 >> 8));
        byteBuffer.put(n + 4, (byte)n4);
        byteBuffer.position(byteBuffer.limit());
        return Authenticator.toLong(byArray);
    }

    long encrypt(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by, int n) {
        if (this.protocolVersion.useTLS13PlusSpec()) {
            return this.t13Encrypt(sSLWriteCipher, by, n);
        }
        return this.t10Encrypt(sSLWriteCipher, by, n);
    }

    private long t13Encrypt(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by, int n) {
        Object object;
        if (!sSLWriteCipher.isNullCipher()) {
            this.write(by);
            this.write(T13PaddingHolder.zeros, 0, T13PaddingHolder.zeros.length);
        }
        byte[] byArray = sSLWriteCipher.authenticator.sequenceNumber();
        int n2 = n;
        int n3 = this.count - n2;
        int n4 = sSLWriteCipher.calculatePacketSize(n3, n);
        if (n4 > this.buf.length) {
            object = new byte[n4];
            System.arraycopy(this.buf, 0, object, 0, this.count);
            this.buf = object;
        }
        object = (Object)this.protocolVersion;
        if (!sSLWriteCipher.isNullCipher()) {
            object = (Object)ProtocolVersion.TLS12;
            by = ContentType.APPLICATION_DATA.id;
        } else {
            object = (Object)ProtocolVersion.TLS12;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buf, n2, n3);
        this.count = n + sSLWriteCipher.encrypt(by, byteBuffer);
        int n5 = this.count - n;
        this.buf[0] = by;
        this.buf[1] = object.major;
        this.buf[2] = object.minor;
        this.buf[3] = (byte)(n5 >> 8 & 0xFF);
        this.buf[4] = (byte)(n5 & 0xFF);
        return Authenticator.toLong(byArray);
    }

    private long t10Encrypt(SSLCipher.SSLWriteCipher sSLWriteCipher, byte by, int n) {
        Object object;
        byte[] byArray = sSLWriteCipher.authenticator.sequenceNumber();
        int n2 = n + this.writeCipher.getExplicitNonceSize();
        int n3 = this.count - n2;
        int n4 = sSLWriteCipher.calculatePacketSize(n3, n);
        if (n4 > this.buf.length) {
            object = new byte[n4];
            System.arraycopy(this.buf, 0, object, 0, this.count);
            this.buf = object;
        }
        object = ByteBuffer.wrap(this.buf, n2, n3);
        this.count = n + sSLWriteCipher.encrypt(by, (ByteBuffer)object);
        int n5 = this.count - n;
        this.buf[0] = by;
        this.buf[1] = this.protocolVersion.major;
        this.buf[2] = this.protocolVersion.minor;
        this.buf[3] = (byte)(n5 >> 8 & 0xFF);
        this.buf[4] = (byte)(n5 & 0xFF);
        return Authenticator.toLong(byArray);
    }

    static ByteBuffer encodeV2ClientHello(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        int n4 = n + 34;
        byte by = byArray[n4];
        int n5 = n4 + 1 + by;
        int n6 = ((byArray[n5] & 0xFF) << 8) + (byArray[n5 + 1] & 0xFF);
        int n7 = n6 / 2;
        int n8 = 11 + n7 * 6 + 3 + 32;
        byte[] byArray2 = new byte[n8];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        int n9 = n5 + 2;
        int n10 = 0;
        byteBuffer.position(11);
        boolean bl = false;
        for (n3 = 0; n3 < n7; ++n3) {
            byte by2 = byArray[n9++];
            byte by3 = byArray[n9++];
            n10 += OutputRecord.V3toV2CipherSuite(byteBuffer, by2, by3);
            if (bl || by2 != 0 || by3 != -1) continue;
            bl = true;
        }
        if (!bl) {
            n10 += OutputRecord.V3toV2CipherSuite(byteBuffer, (byte)0, (byte)-1);
        }
        byteBuffer.put(byArray, n + 2, 32);
        n3 = byteBuffer.position() - 2;
        byteBuffer.position(0);
        byteBuffer.put((byte)(0x80 | n3 >>> 8 & 0xFF));
        byteBuffer.put((byte)(n3 & 0xFF));
        byteBuffer.put(SSLHandshake.CLIENT_HELLO.id);
        byteBuffer.put(byArray[n]);
        byteBuffer.put(byArray[n + 1]);
        byteBuffer.put((byte)(n10 >>> 8));
        byteBuffer.put((byte)(n10 & 0xFF));
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)32);
        byteBuffer.position(0);
        byteBuffer.limit(n3 + 2);
        return byteBuffer;
    }

    private static int V3toV2CipherSuite(ByteBuffer byteBuffer, byte by, byte by2) {
        byteBuffer.put((byte)0);
        byteBuffer.put(by);
        byteBuffer.put(by2);
        if ((by2 & 0xFF) > 10 || V3toV2CipherMap1[by2] == -1) {
            return 3;
        }
        byteBuffer.put((byte)V3toV2CipherMap1[by2]);
        byteBuffer.put((byte)0);
        byteBuffer.put((byte)V3toV2CipherMap3[by2]);
        return 6;
    }

    private static final class T13PaddingHolder {
        private static final byte[] zeros = new byte[16];

        private T13PaddingHolder() {
        }
    }
}

