/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ModuleExports;
import com.sun.org.apache.bcel.internal.classfile.ModuleOpens;
import com.sun.org.apache.bcel.internal.classfile.ModuleProvides;
import com.sun.org.apache.bcel.internal.classfile.ModuleRequires;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Module
extends Attribute {
    private final int moduleNameIndex;
    private final int moduleFlags;
    private final int moduleVersionIndex;
    private ModuleRequires[] requiresTable;
    private ModuleExports[] exportsTable;
    private ModuleOpens[] opensTable;
    private final int usesCount;
    private final int[] usesIndex;
    private ModuleProvides[] providesTable;

    Module(int name_index, int length, DataInput input, ConstantPool constant_pool) throws IOException {
        super((byte)22, name_index, length, constant_pool);
        int i;
        this.moduleNameIndex = input.readUnsignedShort();
        this.moduleFlags = input.readUnsignedShort();
        this.moduleVersionIndex = input.readUnsignedShort();
        int requires_count = input.readUnsignedShort();
        this.requiresTable = new ModuleRequires[requires_count];
        for (int i2 = 0; i2 < requires_count; ++i2) {
            this.requiresTable[i2] = new ModuleRequires(input);
        }
        int exports_count = input.readUnsignedShort();
        this.exportsTable = new ModuleExports[exports_count];
        for (int i3 = 0; i3 < exports_count; ++i3) {
            this.exportsTable[i3] = new ModuleExports(input);
        }
        int opens_count = input.readUnsignedShort();
        this.opensTable = new ModuleOpens[opens_count];
        for (i = 0; i < opens_count; ++i) {
            this.opensTable[i] = new ModuleOpens(input);
        }
        this.usesCount = input.readUnsignedShort();
        this.usesIndex = new int[this.usesCount];
        for (i = 0; i < this.usesCount; ++i) {
            this.usesIndex[i] = input.readUnsignedShort();
        }
        int provides_count = input.readUnsignedShort();
        this.providesTable = new ModuleProvides[provides_count];
        for (int i4 = 0; i4 < provides_count; ++i4) {
            this.providesTable[i4] = new ModuleProvides(input);
        }
    }

    @Override
    public void accept(Visitor v) {
        v.visitModule(this);
    }

    public ModuleRequires[] getRequiresTable() {
        return this.requiresTable;
    }

    public ModuleExports[] getExportsTable() {
        return this.exportsTable;
    }

    public ModuleOpens[] getOpensTable() {
        return this.opensTable;
    }

    public ModuleProvides[] getProvidesTable() {
        return this.providesTable;
    }

    @Override
    public void dump(DataOutputStream file) throws IOException {
        super.dump(file);
        file.writeShort(this.moduleNameIndex);
        file.writeShort(this.moduleFlags);
        file.writeShort(this.moduleVersionIndex);
        file.writeShort(this.requiresTable.length);
        for (ModuleRequires moduleRequires : this.requiresTable) {
            moduleRequires.dump(file);
        }
        file.writeShort(this.exportsTable.length);
        for (ModuleExports moduleExports : this.exportsTable) {
            moduleExports.dump(file);
        }
        file.writeShort(this.opensTable.length);
        for (ModuleOpens moduleOpens : this.opensTable) {
            moduleOpens.dump(file);
        }
        file.writeShort(this.usesIndex.length);
        for (int n : this.usesIndex) {
            file.writeShort(n);
        }
        file.writeShort(this.providesTable.length);
        for (ModuleProvides moduleProvides : this.providesTable) {
            moduleProvides.dump(file);
        }
    }

    @Override
    public String toString() {
        ConstantPool cp = super.getConstantPool();
        StringBuilder buf = new StringBuilder();
        buf.append("Module:\n");
        buf.append("  name:    ").append(cp.getConstantString(this.moduleNameIndex, (byte)19).replace('/', '.')).append("\n");
        buf.append("  flags:   ").append(String.format("%04x", this.moduleFlags)).append("\n");
        String version = this.moduleVersionIndex == 0 ? "0" : cp.getConstantString(this.moduleVersionIndex, (byte)1);
        buf.append("  version: ").append(version).append("\n");
        buf.append("  requires(").append(this.requiresTable.length).append("):\n");
        for (ModuleRequires moduleRequires : this.requiresTable) {
            buf.append("    ").append(moduleRequires.toString(cp)).append("\n");
        }
        buf.append("  exports(").append(this.exportsTable.length).append("):\n");
        for (ModuleExports moduleExports : this.exportsTable) {
            buf.append("    ").append(moduleExports.toString(cp)).append("\n");
        }
        buf.append("  opens(").append(this.opensTable.length).append("):\n");
        for (ModuleOpens moduleOpens : this.opensTable) {
            buf.append("    ").append(moduleOpens.toString(cp)).append("\n");
        }
        buf.append("  uses(").append(this.usesIndex.length).append("):\n");
        for (int n : this.usesIndex) {
            String class_name = cp.getConstantString(n, (byte)7);
            buf.append("    ").append(Utility.compactClassName(class_name, false)).append("\n");
        }
        buf.append("  provides(").append(this.providesTable.length).append("):\n");
        for (ModuleProvides moduleProvides : this.providesTable) {
            buf.append("    ").append(moduleProvides.toString(cp)).append("\n");
        }
        return buf.substring(0, buf.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool _constant_pool) {
        int i;
        Module c = (Module)this.clone();
        c.requiresTable = new ModuleRequires[this.requiresTable.length];
        for (i = 0; i < this.requiresTable.length; ++i) {
            c.requiresTable[i] = this.requiresTable[i].copy();
        }
        c.exportsTable = new ModuleExports[this.exportsTable.length];
        for (i = 0; i < this.exportsTable.length; ++i) {
            c.exportsTable[i] = this.exportsTable[i].copy();
        }
        c.opensTable = new ModuleOpens[this.opensTable.length];
        for (i = 0; i < this.opensTable.length; ++i) {
            c.opensTable[i] = this.opensTable[i].copy();
        }
        c.providesTable = new ModuleProvides[this.providesTable.length];
        for (i = 0; i < this.providesTable.length; ++i) {
            c.providesTable[i] = this.providesTable[i].copy();
        }
        c.setConstantPool(_constant_pool);
        return c;
    }
}

