/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.Krb5Helper;
import sun.security.ssl.SSLAuthentication;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLPossessionGenerator;
import sun.security.ssl.ServerHandshakeContext;

enum Krb5Authentication implements SSLAuthentication
{
    KRB5("KRB5", new Krb5PossessionGenerator());

    final String keyType;
    final SSLPossessionGenerator possessionGenerator;

    private Krb5Authentication(String string2, SSLPossessionGenerator sSLPossessionGenerator) {
        this.keyType = string2;
        this.possessionGenerator = sSLPossessionGenerator;
    }

    @Override
    public SSLPossession createPossession(HandshakeContext handshakeContext) {
        return this.possessionGenerator.createPossession(handshakeContext);
    }

    private static Object setupKerberosKeys(ServerHandshakeContext serverHandshakeContext) {
        try {
            final AccessControlContext accessControlContext = serverHandshakeContext.conContext.acc;
            Object object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){

                @Override
                public Object run() throws Exception {
                    return Krb5Helper.getServiceCreds(accessControlContext);
                }
            });
            if (object != null) {
                String string;
                if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                    SSLLogger.fine("Using Kerberos creds", new Object[0]);
                }
                if ((string = Krb5Helper.getServerPrincipalName(object)) != null) {
                    SecurityManager securityManager = System.getSecurityManager();
                    try {
                        if (securityManager != null) {
                            securityManager.checkPermission(Krb5Helper.getServicePermission(string, "accept"), accessControlContext);
                        }
                    }
                    catch (SecurityException securityException) {
                        object = null;
                        if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                            SSLLogger.fine("Permission to access Kerberos secret key denied", new Object[0]);
                        }
                    }
                }
            } else if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                SSLLogger.fine("No Kerberos creds obtained", new Object[0]);
            }
            return object;
        }
        catch (PrivilegedActionException privilegedActionException) {
            if (SSLLogger.isOn && SSLLogger.isOn("handshake")) {
                SSLLogger.fine("Attempt to obtain Kerberos key failed: " + privilegedActionException.toString(), new Object[0]);
            }
            return null;
        }
    }

    private static final class Krb5PossessionGenerator
    implements SSLPossessionGenerator {
        private Krb5PossessionGenerator() {
        }

        @Override
        public SSLPossession createPossession(HandshakeContext handshakeContext) {
            if (handshakeContext.sslConfig.isClientMode) {
                return null;
            }
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)handshakeContext;
            Object object = Krb5Authentication.setupKerberosKeys((ServerHandshakeContext)handshakeContext);
            return object == null ? null : new Krb5Possession(object);
        }
    }

    static final class Krb5Possession
    implements SSLPossession {
        final Object serviceCreds;

        Krb5Possession(Object object) {
            this.serviceCreds = object;
        }
    }
}

