/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.AccessFlags;
import com.sun.org.apache.bcel.internal.classfile.AnnotationEntry;
import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ClassFormatException;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Signature;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public abstract class FieldOrMethod
extends AccessFlags
implements Cloneable,
Node {
    private int name_index;
    private int signature_index;
    private Attribute[] attributes;
    private int attributes_count;
    private AnnotationEntry[] annotationEntries;
    private ConstantPool constant_pool;
    private String signatureAttributeString = null;
    private boolean searchedForSignatureAttribute = false;

    FieldOrMethod() {
    }

    protected FieldOrMethod(FieldOrMethod fieldOrMethod) {
        this(fieldOrMethod.getAccessFlags(), fieldOrMethod.getNameIndex(), fieldOrMethod.getSignatureIndex(), fieldOrMethod.getAttributes(), fieldOrMethod.getConstantPool());
    }

    @Deprecated
    protected FieldOrMethod(DataInputStream dataInputStream, ConstantPool constantPool) throws IOException, ClassFormatException {
        this((DataInput)dataInputStream, constantPool);
    }

    protected FieldOrMethod(DataInput dataInput, ConstantPool constantPool) throws IOException, ClassFormatException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), null, constantPool);
        int n = dataInput.readUnsignedShort();
        this.attributes = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            this.attributes[i] = Attribute.readAttribute(dataInput, constantPool);
        }
        this.attributes_count = n;
    }

    protected FieldOrMethod(int n, int n2, int n3, Attribute[] attributeArray, ConstantPool constantPool) {
        super(n);
        this.name_index = n2;
        this.signature_index = n3;
        this.constant_pool = constantPool;
        this.setAttributes(attributeArray);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(super.getAccessFlags());
        dataOutputStream.writeShort(this.name_index);
        dataOutputStream.writeShort(this.signature_index);
        dataOutputStream.writeShort(this.attributes_count);
        if (this.attributes != null) {
            for (Attribute attribute : this.attributes) {
                attribute.dump(dataOutputStream);
            }
        }
    }

    public final Attribute[] getAttributes() {
        return this.attributes;
    }

    public final void setAttributes(Attribute[] attributeArray) {
        this.attributes = attributeArray;
        this.attributes_count = attributeArray != null ? attributeArray.length : 0;
    }

    public final ConstantPool getConstantPool() {
        return this.constant_pool;
    }

    public final void setConstantPool(ConstantPool constantPool) {
        this.constant_pool = constantPool;
    }

    public final int getNameIndex() {
        return this.name_index;
    }

    public final void setNameIndex(int n) {
        this.name_index = n;
    }

    public final int getSignatureIndex() {
        return this.signature_index;
    }

    public final void setSignatureIndex(int n) {
        this.signature_index = n;
    }

    public final String getName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.name_index, (byte)1);
        return constantUtf8.getBytes();
    }

    public final String getSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constant_pool.getConstant(this.signature_index, (byte)1);
        return constantUtf8.getBytes();
    }

    protected FieldOrMethod copy_(ConstantPool constantPool) {
        FieldOrMethod fieldOrMethod = null;
        try {
            fieldOrMethod = (FieldOrMethod)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        fieldOrMethod.constant_pool = this.constant_pool;
        fieldOrMethod.attributes = new Attribute[this.attributes.length];
        fieldOrMethod.attributes_count = this.attributes_count;
        for (int i = 0; i < this.attributes.length; ++i) {
            fieldOrMethod.attributes[i] = this.attributes[i].copy(this.constant_pool);
        }
        return fieldOrMethod;
    }

    public AnnotationEntry[] getAnnotationEntries() {
        if (this.annotationEntries == null) {
            this.annotationEntries = AnnotationEntry.createAnnotationEntries(this.getAttributes());
        }
        return this.annotationEntries;
    }

    public final String getGenericSignature() {
        if (!this.searchedForSignatureAttribute) {
            boolean bl = false;
            for (int i = 0; !bl && i < this.attributes.length; ++i) {
                if (!(this.attributes[i] instanceof Signature)) continue;
                this.signatureAttributeString = ((Signature)this.attributes[i]).getSignature();
                bl = true;
            }
            this.searchedForSignatureAttribute = true;
        }
        return this.signatureAttributeString;
    }
}

