/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.LocalVariable;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class LocalVariableTypeTable
extends Attribute {
    private LocalVariable[] localVariableTypeTable;

    public LocalVariableTypeTable(LocalVariableTypeTable localVariableTypeTable) {
        this(localVariableTypeTable.getNameIndex(), localVariableTypeTable.getLength(), localVariableTypeTable.getLocalVariableTypeTable(), localVariableTypeTable.getConstantPool());
    }

    public LocalVariableTypeTable(int n, int n2, LocalVariable[] localVariableArray, ConstantPool constantPool) {
        super((byte)17, n, n2, constantPool);
        this.localVariableTypeTable = localVariableArray;
    }

    LocalVariableTypeTable(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (LocalVariable[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.localVariableTypeTable = new LocalVariable[n3];
        for (int i = 0; i < n3; ++i) {
            this.localVariableTypeTable[i] = new LocalVariable(dataInput, constantPool);
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariableTypeTable(this);
    }

    @Override
    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.localVariableTypeTable.length);
        for (LocalVariable localVariable : this.localVariableTypeTable) {
            localVariable.dump(dataOutputStream);
        }
    }

    public final LocalVariable[] getLocalVariableTypeTable() {
        return this.localVariableTypeTable;
    }

    public final LocalVariable getLocalVariable(int n) {
        for (LocalVariable localVariable : this.localVariableTypeTable) {
            if (localVariable.getIndex() != n) continue;
            return localVariable;
        }
        return null;
    }

    public final void setLocalVariableTable(LocalVariable[] localVariableArray) {
        this.localVariableTypeTable = localVariableArray;
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.localVariableTypeTable.length; ++i) {
            stringBuilder.append(this.localVariableTypeTable[i].toStringShared(true));
            if (i >= this.localVariableTypeTable.length - 1) continue;
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        LocalVariableTypeTable localVariableTypeTable = (LocalVariableTypeTable)this.clone();
        localVariableTypeTable.localVariableTypeTable = new LocalVariable[this.localVariableTypeTable.length];
        for (int i = 0; i < this.localVariableTypeTable.length; ++i) {
            localVariableTypeTable.localVariableTypeTable[i] = this.localVariableTypeTable[i].copy();
        }
        localVariableTypeTable.setConstantPool(constantPool);
        return localVariableTypeTable;
    }

    public final int getTableLength() {
        return this.localVariableTypeTable == null ? 0 : this.localVariableTypeTable.length;
    }
}

