/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.generic;

import com.sun.org.apache.bcel.internal.ExceptionConst;
import com.sun.org.apache.bcel.internal.classfile.Constant;
import com.sun.org.apache.bcel.internal.classfile.ConstantClass;
import com.sun.org.apache.bcel.internal.classfile.ConstantFloat;
import com.sun.org.apache.bcel.internal.classfile.ConstantInteger;
import com.sun.org.apache.bcel.internal.classfile.ConstantString;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.generic.CPInstruction;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.ExceptionThrower;
import com.sun.org.apache.bcel.internal.generic.ObjectType;
import com.sun.org.apache.bcel.internal.generic.PushInstruction;
import com.sun.org.apache.bcel.internal.generic.Type;
import com.sun.org.apache.bcel.internal.generic.Visitor;
import com.sun.org.apache.bcel.internal.util.ByteSequence;
import java.io.DataOutputStream;
import java.io.IOException;

public class LDC
extends CPInstruction
implements PushInstruction,
ExceptionThrower {
    LDC() {
    }

    public LDC(int n) {
        super((short)19, n);
        this.setSize();
    }

    protected final void setSize() {
        if (super.getIndex() <= 255) {
            super.setOpcode((short)18);
            super.setLength(2);
        } else {
            super.setOpcode((short)19);
            super.setLength(3);
        }
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeByte(super.getOpcode());
        if (super.getLength() == 2) {
            dataOutputStream.writeByte(super.getIndex());
        } else {
            dataOutputStream.writeShort(super.getIndex());
        }
    }

    @Override
    public final void setIndex(int n) {
        super.setIndex(n);
        this.setSize();
    }

    @Override
    protected void initFromFile(ByteSequence byteSequence, boolean bl) throws IOException {
        super.setLength(2);
        super.setIndex(byteSequence.readUnsignedByte());
    }

    public Object getValue(ConstantPoolGen constantPoolGen) {
        Constant constant = constantPoolGen.getConstantPool().getConstant(super.getIndex());
        switch (constant.getTag()) {
            case 8: {
                int n = ((ConstantString)constant).getStringIndex();
                constant = constantPoolGen.getConstantPool().getConstant(n);
                return ((ConstantUtf8)constant).getBytes();
            }
            case 4: {
                return new Float(((ConstantFloat)constant).getBytes());
            }
            case 3: {
                return ((ConstantInteger)constant).getBytes();
            }
            case 7: {
                int n = ((ConstantClass)constant).getNameIndex();
                constant = constantPoolGen.getConstantPool().getConstant(n);
                return new ObjectType(((ConstantUtf8)constant).getBytes());
            }
        }
        throw new IllegalArgumentException("Unknown or invalid constant type at " + super.getIndex());
    }

    @Override
    public Type getType(ConstantPoolGen constantPoolGen) {
        switch (constantPoolGen.getConstantPool().getConstant(super.getIndex()).getTag()) {
            case 8: {
                return Type.STRING;
            }
            case 4: {
                return Type.FLOAT;
            }
            case 3: {
                return Type.INT;
            }
            case 7: {
                return Type.CLASS;
            }
        }
        throw new IllegalArgumentException("Unknown or invalid constant type at " + super.getIndex());
    }

    @Override
    public Class<?>[] getExceptions() {
        return ExceptionConst.createExceptions(ExceptionConst.EXCS.EXCS_STRING_RESOLUTION, new Class[0]);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitStackProducer(this);
        visitor.visitPushInstruction(this);
        visitor.visitExceptionThrower(this);
        visitor.visitTypedInstruction(this);
        visitor.visitCPInstruction(this);
        visitor.visitLDC(this);
    }
}

