/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.wsdl.parser;

import com.sun.xml.internal.ws.api.addressing.AddressingVersion;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLFeaturedObject;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLBoundOperation;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLBoundPortType;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLFault;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLInput;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLModel;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLOperation;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLOutput;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLPort;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLPortType;
import com.sun.xml.internal.ws.api.model.wsdl.editable.EditableWSDLService;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtension;
import com.sun.xml.internal.ws.api.wsdl.parser.WSDLParserExtensionContext;
import com.sun.xml.internal.ws.streaming.XMLStreamReaderUtil;
import com.sun.xml.internal.ws.wsdl.parser.ParserUtil;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.AddressingFeature;

public class W3CAddressingWSDLParserExtension
extends WSDLParserExtension {
    protected static final String COLON_DELIMITER = ":";
    protected static final String SLASH_DELIMITER = "/";

    @Override
    public boolean bindingElements(EditableWSDLBoundPortType editableWSDLBoundPortType, XMLStreamReader xMLStreamReader) {
        return this.addressibleElement(xMLStreamReader, editableWSDLBoundPortType);
    }

    @Override
    public boolean portElements(EditableWSDLPort editableWSDLPort, XMLStreamReader xMLStreamReader) {
        return this.addressibleElement(xMLStreamReader, editableWSDLPort);
    }

    private boolean addressibleElement(XMLStreamReader xMLStreamReader, WSDLFeaturedObject wSDLFeaturedObject) {
        QName qName = xMLStreamReader.getName();
        if (qName.equals(AddressingVersion.W3C.wsdlExtensionTag)) {
            String string = xMLStreamReader.getAttributeValue("http://schemas.xmlsoap.org/wsdl/", "required");
            wSDLFeaturedObject.addFeature(new AddressingFeature(true, Boolean.parseBoolean(string)));
            XMLStreamReaderUtil.skipElement(xMLStreamReader);
            return true;
        }
        return false;
    }

    @Override
    public boolean bindingOperationElements(EditableWSDLBoundOperation editableWSDLBoundOperation, XMLStreamReader xMLStreamReader) {
        EditableWSDLBoundOperation editableWSDLBoundOperation2 = editableWSDLBoundOperation;
        QName qName = xMLStreamReader.getName();
        if (qName.equals(AddressingVersion.W3C.wsdlAnonymousTag)) {
            block7: {
                try {
                    String string = xMLStreamReader.getElementText();
                    if (string == null || string.trim().equals("")) {
                        throw new WebServiceException("Null values not permitted in wsaw:Anonymous.");
                    }
                    if (string.equals("optional")) {
                        editableWSDLBoundOperation2.setAnonymous(WSDLBoundOperation.ANONYMOUS.optional);
                        break block7;
                    }
                    if (string.equals("required")) {
                        editableWSDLBoundOperation2.setAnonymous(WSDLBoundOperation.ANONYMOUS.required);
                        break block7;
                    }
                    if (string.equals("prohibited")) {
                        editableWSDLBoundOperation2.setAnonymous(WSDLBoundOperation.ANONYMOUS.prohibited);
                        break block7;
                    }
                    throw new WebServiceException("wsaw:Anonymous value \"" + string + "\" not understood.");
                }
                catch (XMLStreamException xMLStreamException) {
                    throw new WebServiceException(xMLStreamException);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void portTypeOperationInputAttributes(EditableWSDLInput editableWSDLInput, XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getAttribute(xMLStreamReader, this.getWsdlActionTag());
        if (string != null) {
            editableWSDLInput.setAction(string);
            editableWSDLInput.setDefaultAction(false);
        }
    }

    @Override
    public void portTypeOperationOutputAttributes(EditableWSDLOutput editableWSDLOutput, XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getAttribute(xMLStreamReader, this.getWsdlActionTag());
        if (string != null) {
            editableWSDLOutput.setAction(string);
            editableWSDLOutput.setDefaultAction(false);
        }
    }

    @Override
    public void portTypeOperationFaultAttributes(EditableWSDLFault editableWSDLFault, XMLStreamReader xMLStreamReader) {
        String string = ParserUtil.getAttribute(xMLStreamReader, this.getWsdlActionTag());
        if (string != null) {
            editableWSDLFault.setAction(string);
            editableWSDLFault.setDefaultAction(false);
        }
    }

    @Override
    public void finished(WSDLParserExtensionContext wSDLParserExtensionContext) {
        EditableWSDLModel editableWSDLModel = wSDLParserExtensionContext.getWSDLModel();
        for (EditableWSDLService editableWSDLService : editableWSDLModel.getServices().values()) {
            for (EditableWSDLPort editableWSDLPort : editableWSDLService.getPorts()) {
                EditableWSDLBoundPortType editableWSDLBoundPortType = editableWSDLPort.getBinding();
                this.populateActions(editableWSDLBoundPortType);
                this.patchAnonymousDefault(editableWSDLBoundPortType);
            }
        }
    }

    protected String getNamespaceURI() {
        return AddressingVersion.W3C.wsdlNsUri;
    }

    protected QName getWsdlActionTag() {
        return AddressingVersion.W3C.wsdlActionTag;
    }

    private void populateActions(EditableWSDLBoundPortType editableWSDLBoundPortType) {
        EditableWSDLPortType editableWSDLPortType = editableWSDLBoundPortType.getPortType();
        for (EditableWSDLOperation editableWSDLOperation : editableWSDLPortType.getOperations()) {
            EditableWSDLBoundOperation editableWSDLBoundOperation = editableWSDLBoundPortType.get(editableWSDLOperation.getName());
            if (editableWSDLBoundOperation == null) {
                editableWSDLOperation.getInput().setAction(this.defaultInputAction(editableWSDLOperation));
                continue;
            }
            String string = editableWSDLBoundOperation.getSOAPAction();
            if (editableWSDLOperation.getInput().getAction() == null || editableWSDLOperation.getInput().getAction().equals("")) {
                if (string != null && !string.equals("")) {
                    editableWSDLOperation.getInput().setAction(string);
                } else {
                    editableWSDLOperation.getInput().setAction(this.defaultInputAction(editableWSDLOperation));
                }
            }
            if (editableWSDLOperation.getOutput() == null) continue;
            if (editableWSDLOperation.getOutput().getAction() == null || editableWSDLOperation.getOutput().getAction().equals("")) {
                editableWSDLOperation.getOutput().setAction(this.defaultOutputAction(editableWSDLOperation));
            }
            if (editableWSDLOperation.getFaults() == null || !editableWSDLOperation.getFaults().iterator().hasNext()) continue;
            for (EditableWSDLFault editableWSDLFault : editableWSDLOperation.getFaults()) {
                if (editableWSDLFault.getAction() != null && !editableWSDLFault.getAction().equals("")) continue;
                editableWSDLFault.setAction(this.defaultFaultAction(editableWSDLFault.getName(), editableWSDLOperation));
            }
        }
    }

    protected void patchAnonymousDefault(EditableWSDLBoundPortType editableWSDLBoundPortType) {
        for (EditableWSDLBoundOperation editableWSDLBoundOperation : editableWSDLBoundPortType.getBindingOperations()) {
            if (editableWSDLBoundOperation.getAnonymous() != null) continue;
            editableWSDLBoundOperation.setAnonymous(WSDLBoundOperation.ANONYMOUS.optional);
        }
    }

    private String defaultInputAction(EditableWSDLOperation editableWSDLOperation) {
        return W3CAddressingWSDLParserExtension.buildAction(editableWSDLOperation.getInput().getName(), editableWSDLOperation, false);
    }

    private String defaultOutputAction(EditableWSDLOperation editableWSDLOperation) {
        return W3CAddressingWSDLParserExtension.buildAction(editableWSDLOperation.getOutput().getName(), editableWSDLOperation, false);
    }

    private String defaultFaultAction(String string, EditableWSDLOperation editableWSDLOperation) {
        return W3CAddressingWSDLParserExtension.buildAction(string, editableWSDLOperation, true);
    }

    protected static final String buildAction(String string, EditableWSDLOperation editableWSDLOperation, boolean bl) {
        String string2 = editableWSDLOperation.getName().getNamespaceURI();
        String string3 = SLASH_DELIMITER;
        if (!string2.startsWith("http")) {
            string3 = COLON_DELIMITER;
        }
        if (string2.endsWith(string3)) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (editableWSDLOperation.getPortTypeName() == null) {
            throw new WebServiceException("\"" + editableWSDLOperation.getName() + "\" operation's owning portType name is null.");
        }
        return string2 + string3 + editableWSDLOperation.getPortTypeName().getLocalPart() + string3 + (bl ? editableWSDLOperation.getName().getLocalPart() + string3 + "Fault" + string3 : "") + string;
    }
}

