/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AlgorithmConstraints;
import java.security.CryptoPrimitive;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import javax.crypto.SecretKey;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLHandshakeException;
import javax.security.auth.x500.X500Principal;
import sun.security.ssl.Alert;
import sun.security.ssl.CipherSuite;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.ContentType;
import sun.security.ssl.HandshakeHash;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.Plaintext;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.RandomCookie;
import sun.security.ssl.Record;
import sun.security.ssl.SSLAlgorithmConstraints;
import sun.security.ssl.SSLConfiguration;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLContextImpl;
import sun.security.ssl.SSLCredentials;
import sun.security.ssl.SSLExtension;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLSessionImpl;
import sun.security.ssl.SignatureScheme;
import sun.security.ssl.SupportedGroupsExtension;
import sun.security.ssl.TransportContext;
import sun.security.ssl.Utilities;

abstract class HandshakeContext
implements ConnectionContext {
    static final boolean allowUnsafeRenegotiation = Utilities.getBooleanProperty("sun.security.ssl.allowUnsafeRenegotiation", false);
    static final boolean allowLegacyHelloMessages = Utilities.getBooleanProperty("sun.security.ssl.allowLegacyHelloMessages", true);
    LinkedHashMap<Byte, SSLConsumer> handshakeConsumers;
    final HashMap<Byte, HandshakeProducer> handshakeProducers;
    final SSLContextImpl sslContext;
    final TransportContext conContext;
    final SSLConfiguration sslConfig;
    final List<ProtocolVersion> activeProtocols;
    final List<CipherSuite> activeCipherSuites;
    final AlgorithmConstraints algorithmConstraints;
    final ProtocolVersion maximumActiveProtocol;
    final HandshakeOutStream handshakeOutput;
    final HandshakeHash handshakeHash;
    SSLSessionImpl handshakeSession;
    boolean handshakeFinished;
    boolean kickstartMessageDelivered;
    boolean isResumption;
    SSLSessionImpl resumingSession;
    final Queue<Map.Entry<Byte, ByteBuffer>> delegatedActions;
    volatile boolean taskDelegated = false;
    volatile Exception delegatedThrown = null;
    ProtocolVersion negotiatedProtocol;
    CipherSuite negotiatedCipherSuite;
    final List<SSLPossession> handshakePossessions;
    final List<SSLCredentials> handshakeCredentials;
    SSLKeyDerivation handshakeKeyDerivation;
    SSLKeyExchange handshakeKeyExchange;
    SecretKey baseReadSecret;
    SecretKey baseWriteSecret;
    int clientHelloVersion;
    String applicationProtocol;
    RandomCookie clientHelloRandom;
    RandomCookie serverHelloRandom;
    byte[] certRequestContext;
    final Map<SSLExtension, SSLExtension.SSLExtensionSpec> handshakeExtensions;
    int maxFragmentLength;
    List<SignatureScheme> localSupportedSignAlgs;
    List<SignatureScheme> peerRequestedSignatureSchemes;
    List<SignatureScheme> peerRequestedCertSignSchemes;
    X500Principal[] peerSupportedAuthorities = null;
    List<SupportedGroupsExtension.NamedGroup> clientRequestedNamedGroups;
    SupportedGroupsExtension.NamedGroup serverSelectedNamedGroup;
    List<SNIServerName> requestedServerNames;
    SNIServerName negotiatedServerName;
    boolean staplingActive = false;

    protected HandshakeContext(SSLContextImpl sSLContextImpl, TransportContext transportContext) throws IOException {
        this.sslContext = sSLContextImpl;
        this.conContext = transportContext;
        this.sslConfig = (SSLConfiguration)transportContext.sslConfig.clone();
        this.algorithmConstraints = SSLAlgorithmConstraints.wrap(this.sslConfig.userSpecifiedAlgorithmConstraints);
        this.activeProtocols = HandshakeContext.getActiveProtocols(this.sslConfig.enabledProtocols, this.sslConfig.enabledCipherSuites, this.algorithmConstraints);
        if (this.activeProtocols.isEmpty()) {
            throw new SSLHandshakeException("No appropriate protocol (protocol is disabled or cipher suites are inappropriate)");
        }
        ProtocolVersion protocolVersion = ProtocolVersion.NONE;
        for (ProtocolVersion protocolVersion2 : this.activeProtocols) {
            if (protocolVersion != ProtocolVersion.NONE && protocolVersion2.compare(protocolVersion) <= 0) continue;
            protocolVersion = protocolVersion2;
        }
        this.maximumActiveProtocol = protocolVersion;
        this.activeCipherSuites = HandshakeContext.getActiveCipherSuites(this.activeProtocols, this.sslConfig.enabledCipherSuites, this.algorithmConstraints);
        if (this.activeCipherSuites.isEmpty()) {
            throw new SSLHandshakeException("No appropriate cipher suite");
        }
        this.handshakeConsumers = new LinkedHashMap();
        this.handshakeProducers = new HashMap();
        this.handshakeHash = transportContext.inputRecord.handshakeHash;
        this.handshakeOutput = new HandshakeOutStream(transportContext.outputRecord);
        this.handshakeFinished = false;
        this.kickstartMessageDelivered = false;
        this.delegatedActions = new LinkedList<Map.Entry<Byte, ByteBuffer>>();
        this.handshakeExtensions = new HashMap<SSLExtension, SSLExtension.SSLExtensionSpec>();
        this.handshakePossessions = new LinkedList<SSLPossession>();
        this.handshakeCredentials = new LinkedList<SSLCredentials>();
        this.requestedServerNames = null;
        this.negotiatedServerName = null;
        this.negotiatedCipherSuite = transportContext.cipherSuite;
        this.initialize();
    }

    protected HandshakeContext(TransportContext transportContext) {
        this.sslContext = transportContext.sslContext;
        this.conContext = transportContext;
        this.sslConfig = transportContext.sslConfig;
        this.negotiatedProtocol = transportContext.protocolVersion;
        this.negotiatedCipherSuite = transportContext.cipherSuite;
        this.handshakeOutput = new HandshakeOutStream(transportContext.outputRecord);
        this.delegatedActions = new LinkedList<Map.Entry<Byte, ByteBuffer>>();
        this.handshakeConsumers = new LinkedHashMap();
        this.handshakeProducers = null;
        this.handshakeHash = null;
        this.activeProtocols = null;
        this.activeCipherSuites = null;
        this.algorithmConstraints = null;
        this.maximumActiveProtocol = null;
        this.handshakeExtensions = Collections.emptyMap();
        this.handshakePossessions = null;
        this.handshakeCredentials = null;
    }

    private void initialize() {
        ProtocolVersion protocolVersion;
        ProtocolVersion protocolVersion2;
        if (this.conContext.isNegotiated) {
            protocolVersion2 = this.conContext.protocolVersion;
            protocolVersion = this.conContext.protocolVersion;
        } else if (this.activeProtocols.contains((Object)ProtocolVersion.SSL20Hello)) {
            protocolVersion2 = ProtocolVersion.SSL20Hello;
            protocolVersion = this.maximumActiveProtocol.useTLS13PlusSpec() ? this.maximumActiveProtocol : ProtocolVersion.SSL20Hello;
        } else {
            protocolVersion2 = this.maximumActiveProtocol;
            protocolVersion = this.maximumActiveProtocol;
        }
        this.conContext.inputRecord.setHelloVersion(protocolVersion2);
        this.conContext.outputRecord.setHelloVersion(protocolVersion);
        if (!this.conContext.isNegotiated) {
            this.conContext.protocolVersion = this.maximumActiveProtocol;
        }
        this.conContext.outputRecord.setVersion(this.conContext.protocolVersion);
    }

    private static List<ProtocolVersion> getActiveProtocols(List<ProtocolVersion> list, List<CipherSuite> list2, AlgorithmConstraints algorithmConstraints) {
        boolean bl = false;
        ArrayList<ProtocolVersion> arrayList = new ArrayList<ProtocolVersion>(4);
        for (ProtocolVersion protocolVersion : list) {
            if (!bl && protocolVersion == ProtocolVersion.SSL20Hello) {
                bl = true;
                continue;
            }
            if (!algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), protocolVersion.name, null)) continue;
            boolean bl2 = false;
            EnumMap<SupportedGroupsExtension.NamedGroupType, Boolean> enumMap = new EnumMap<SupportedGroupsExtension.NamedGroupType, Boolean>(SupportedGroupsExtension.NamedGroupType.class);
            for (CipherSuite cipherSuite : list2) {
                if (cipherSuite.isAvailable() && cipherSuite.supports(protocolVersion)) {
                    if (!HandshakeContext.isActivatable(cipherSuite, algorithmConstraints, enumMap)) continue;
                    arrayList.add(protocolVersion);
                    bl2 = true;
                    break;
                }
                if (!SSLLogger.isOn || !SSLLogger.isOn("verbose")) continue;
                SSLLogger.fine("Ignore unsupported cipher suite: " + (Object)((Object)cipherSuite) + " for " + (Object)((Object)protocolVersion), new Object[0]);
            }
            if (bl2 || !SSLLogger.isOn || !SSLLogger.isOn("handshake")) continue;
            SSLLogger.fine("No available cipher suite for " + (Object)((Object)protocolVersion), new Object[0]);
        }
        if (!arrayList.isEmpty()) {
            if (bl) {
                arrayList.add(ProtocolVersion.SSL20Hello);
            }
            Collections.sort(arrayList);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static List<CipherSuite> getActiveCipherSuites(List<ProtocolVersion> list, List<CipherSuite> list2, AlgorithmConstraints algorithmConstraints) {
        LinkedList<CipherSuite> linkedList = new LinkedList<CipherSuite>();
        if (list != null && !list.isEmpty()) {
            EnumMap<SupportedGroupsExtension.NamedGroupType, Boolean> enumMap = new EnumMap<SupportedGroupsExtension.NamedGroupType, Boolean>(SupportedGroupsExtension.NamedGroupType.class);
            for (CipherSuite cipherSuite : list2) {
                if (!cipherSuite.isAvailable()) continue;
                boolean bl = false;
                for (ProtocolVersion protocolVersion : list) {
                    if (!cipherSuite.supports(protocolVersion) || !HandshakeContext.isActivatable(cipherSuite, algorithmConstraints, enumMap)) continue;
                    linkedList.add(cipherSuite);
                    bl = true;
                    break;
                }
                if (bl || !SSLLogger.isOn || !SSLLogger.isOn("verbose")) continue;
                SSLLogger.finest("Ignore unsupported cipher suite: " + (Object)((Object)cipherSuite), new Object[0]);
            }
        }
        return Collections.unmodifiableList(linkedList);
    }

    static byte getHandshakeType(TransportContext transportContext, Plaintext plaintext) throws IOException {
        if (plaintext.contentType != ContentType.HANDSHAKE.id) {
            throw transportContext.fatal(Alert.INTERNAL_ERROR, "Unexpected operation for record: " + plaintext.contentType);
        }
        if (plaintext.fragment == null || plaintext.fragment.remaining() < 4) {
            throw transportContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid handshake message: insufficient data");
        }
        byte by = (byte)Record.getInt8(plaintext.fragment);
        int n = Record.getInt24(plaintext.fragment);
        if (n != plaintext.fragment.remaining()) {
            throw transportContext.fatal(Alert.UNEXPECTED_MESSAGE, "Invalid handshake message: insufficient handshake body");
        }
        return by;
    }

    void dispatch(byte by, Plaintext plaintext) throws IOException {
        if (this.conContext.transport.useDelegatedTask()) {
            boolean bl;
            boolean bl2 = bl = !this.delegatedActions.isEmpty();
            if (bl || by != SSLHandshake.FINISHED.id && by != SSLHandshake.KEY_UPDATE.id && by != SSLHandshake.NEW_SESSION_TICKET.id) {
                if (!bl) {
                    this.taskDelegated = false;
                    this.delegatedThrown = null;
                }
                ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[plaintext.fragment.remaining()]);
                byteBuffer.put(plaintext.fragment);
                byteBuffer = (ByteBuffer)byteBuffer.rewind();
                this.delegatedActions.add(new AbstractMap.SimpleImmutableEntry<Byte, ByteBuffer>(by, byteBuffer));
                if (bl && !this.conContext.sslConfig.isClientMode && by == SSLHandshake.FINISHED.id) {
                    this.conContext.hasDelegatedFinished = true;
                }
            } else {
                this.dispatch(by, plaintext.fragment);
            }
        } else {
            this.dispatch(by, plaintext.fragment);
        }
    }

    void dispatch(byte by, ByteBuffer byteBuffer) throws IOException {
        SSLConsumer sSLConsumer = by == SSLHandshake.HELLO_REQUEST.id ? SSLHandshake.HELLO_REQUEST : this.handshakeConsumers.get(by);
        if (sSLConsumer == null) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unexpected handshake message: " + SSLHandshake.nameOf(by));
        }
        try {
            sSLConsumer.consume(this, byteBuffer);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            throw this.conContext.fatal(Alert.UNEXPECTED_MESSAGE, "Unsupported handshake message: " + SSLHandshake.nameOf(by), unsupportedOperationException);
        }
        catch (BufferOverflowException | BufferUnderflowException runtimeException) {
            throw this.conContext.fatal(Alert.DECODE_ERROR, "Illegal handshake message: " + SSLHandshake.nameOf(by), runtimeException);
        }
        this.handshakeHash.consume();
    }

    abstract void kickstart() throws IOException;

    boolean isNegotiable(CipherSuite cipherSuite) {
        return HandshakeContext.isNegotiable(this.activeCipherSuites, cipherSuite);
    }

    static final boolean isNegotiable(List<CipherSuite> list, CipherSuite cipherSuite) {
        return list.contains((Object)cipherSuite) && cipherSuite.isNegotiable();
    }

    static final boolean isNegotiable(List<CipherSuite> list, ProtocolVersion protocolVersion, CipherSuite cipherSuite) {
        return list.contains((Object)cipherSuite) && cipherSuite.isNegotiable() && cipherSuite.supports(protocolVersion);
    }

    boolean isNegotiable(ProtocolVersion protocolVersion) {
        return this.activeProtocols.contains((Object)protocolVersion);
    }

    private static boolean isActivatable(CipherSuite cipherSuite, AlgorithmConstraints algorithmConstraints, Map<SupportedGroupsExtension.NamedGroupType, Boolean> map) {
        if (algorithmConstraints.permits(EnumSet.of(CryptoPrimitive.KEY_AGREEMENT), cipherSuite.name, null)) {
            if (cipherSuite.keyExchange == null) {
                return true;
            }
            SupportedGroupsExtension.NamedGroupType namedGroupType = cipherSuite.keyExchange.groupType;
            if (namedGroupType != SupportedGroupsExtension.NamedGroupType.NAMED_GROUP_NONE) {
                boolean bl;
                Boolean bl2 = map.get((Object)namedGroupType);
                if (bl2 == null) {
                    bl = SupportedGroupsExtension.SupportedGroups.isActivatable(algorithmConstraints, namedGroupType);
                    map.put(namedGroupType, bl);
                    if (!bl && SSLLogger.isOn && SSLLogger.isOn("verbose")) {
                        SSLLogger.fine("No activated named group", new Object[0]);
                    }
                } else {
                    bl = bl2;
                }
                if (!bl && SSLLogger.isOn && SSLLogger.isOn("verbose")) {
                    SSLLogger.fine("No active named group, ignore " + (Object)((Object)cipherSuite), new Object[0]);
                }
                return bl;
            }
            return true;
        }
        if (SSLLogger.isOn && SSLLogger.isOn("verbose")) {
            SSLLogger.fine("Ignore disabled cipher suite: " + (Object)((Object)cipherSuite), new Object[0]);
        }
        return false;
    }

    List<SNIServerName> getRequestedServerNames() {
        if (this.requestedServerNames == null) {
            return Collections.emptyList();
        }
        return this.requestedServerNames;
    }
}

