/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class LocalVariable
implements Cloneable,
Node {
    private int startPc;
    private int length;
    private int nameIndex;
    private int signatureIndex;
    private int index;
    private ConstantPool constantPool;
    private int origIndex;

    public LocalVariable(LocalVariable localVariable) {
        this(localVariable.getStartPC(), localVariable.getLength(), localVariable.getNameIndex(), localVariable.getSignatureIndex(), localVariable.getIndex(), localVariable.getConstantPool());
        this.origIndex = localVariable.getOrigIndex();
    }

    LocalVariable(DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), constantPool);
    }

    public LocalVariable(int n, int n2, int n3, int n4, int n5, ConstantPool constantPool) {
        this.startPc = n;
        this.length = n2;
        this.nameIndex = n3;
        this.signatureIndex = n4;
        this.index = n5;
        this.constantPool = constantPool;
        this.origIndex = n5;
    }

    public LocalVariable(int n, int n2, int n3, int n4, int n5, ConstantPool constantPool, int n6) {
        this.startPc = n;
        this.length = n2;
        this.nameIndex = n3;
        this.signatureIndex = n4;
        this.index = n5;
        this.constantPool = constantPool;
        this.origIndex = n6;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitLocalVariable(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.startPc);
        dataOutputStream.writeShort(this.length);
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.signatureIndex);
        dataOutputStream.writeShort(this.index);
    }

    public ConstantPool getConstantPool() {
        return this.constantPool;
    }

    public int getLength() {
        return this.length;
    }

    public String getName() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constantPool.getConstant(this.nameIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public String getSignature() {
        ConstantUtf8 constantUtf8 = (ConstantUtf8)this.constantPool.getConstant(this.signatureIndex, (byte)1);
        return constantUtf8.getBytes();
    }

    public int getSignatureIndex() {
        return this.signatureIndex;
    }

    public int getIndex() {
        return this.index;
    }

    public int getOrigIndex() {
        return this.origIndex;
    }

    public int getStartPC() {
        return this.startPc;
    }

    String toStringShared(boolean bl) {
        String string = this.getName();
        String string2 = Utility.signatureToString(this.getSignature(), false);
        String string3 = "LocalVariable" + (bl ? "Types" : "");
        return string3 + "(startPc = " + this.startPc + ", length = " + this.length + ", index = " + this.index + ":" + string2 + " " + string + ")";
    }

    public void setConstantPool(ConstantPool constantPool) {
        this.constantPool = constantPool;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public void setSignatureIndex(int n) {
        this.signatureIndex = n;
    }

    public void setIndex(int n) {
        this.index = n;
    }

    public void setStartPC(int n) {
        this.startPc = n;
    }

    public String toString() {
        return this.toStringShared(false);
    }

    public LocalVariable copy() {
        try {
            return (LocalVariable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

