/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.encoding;

import com.sun.xml.internal.ws.api.SOAPVersion;
import com.sun.xml.internal.ws.api.WSFeatureList;
import com.sun.xml.internal.ws.api.client.SelectOptimalEncodingFeature;
import com.sun.xml.internal.ws.api.fastinfoset.FastInfosetFeature;
import com.sun.xml.internal.ws.api.message.ExceptionHasMessage;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.pipe.Codec;
import com.sun.xml.internal.ws.api.pipe.Codecs;
import com.sun.xml.internal.ws.api.pipe.ContentType;
import com.sun.xml.internal.ws.api.pipe.StreamSOAPCodec;
import com.sun.xml.internal.ws.binding.WebServiceFeatureList;
import com.sun.xml.internal.ws.client.ContentNegotiation;
import com.sun.xml.internal.ws.encoding.ContentTypeImpl;
import com.sun.xml.internal.ws.encoding.MimeCodec;
import com.sun.xml.internal.ws.encoding.MimeMultipartParser;
import com.sun.xml.internal.ws.encoding.MtomCodec;
import com.sun.xml.internal.ws.encoding.SwACodec;
import com.sun.xml.internal.ws.protocol.soap.MessageCreationException;
import com.sun.xml.internal.ws.resources.StreamingMessages;
import com.sun.xml.internal.ws.server.UnsupportedMediaException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.soap.MTOMFeature;

public class SOAPBindingCodec
extends MimeCodec
implements com.sun.xml.internal.ws.api.pipe.SOAPBindingCodec {
    public static final String UTF8_ENCODING = "utf-8";
    public static final String DEFAULT_ENCODING = "utf-8";
    private boolean isFastInfosetDisabled;
    private boolean useFastInfosetForEncoding;
    private boolean ignoreContentNegotiationProperty;
    private final StreamSOAPCodec xmlSoapCodec;
    private final Codec fiSoapCodec;
    private final MimeCodec xmlMtomCodec;
    private final MimeCodec xmlSwaCodec;
    private final MimeCodec fiSwaCodec;
    private final String xmlMimeType;
    private final String fiMimeType;
    private final String xmlAccept;
    private final String connegXmlAccept;

    @Override
    public StreamSOAPCodec getXMLCodec() {
        return this.xmlSoapCodec;
    }

    private ContentTypeImpl setAcceptHeader(Packet packet, ContentTypeImpl contentTypeImpl) {
        String string = !this.ignoreContentNegotiationProperty && packet.contentNegotiation != ContentNegotiation.none ? this.connegXmlAccept : this.xmlAccept;
        contentTypeImpl.setAcceptHeader(string);
        return contentTypeImpl;
    }

    public SOAPBindingCodec(WSFeatureList wSFeatureList) {
        this(wSFeatureList, Codecs.createSOAPEnvelopeXmlCodec(wSFeatureList));
    }

    public SOAPBindingCodec(WSFeatureList wSFeatureList, StreamSOAPCodec streamSOAPCodec) {
        super(WebServiceFeatureList.getSoapVersion(wSFeatureList), wSFeatureList);
        this.xmlSoapCodec = streamSOAPCodec;
        this.xmlMimeType = streamSOAPCodec.getMimeType();
        this.xmlMtomCodec = new MtomCodec(this.version, streamSOAPCodec, wSFeatureList);
        this.xmlSwaCodec = new SwACodec(this.version, wSFeatureList, streamSOAPCodec);
        String string = streamSOAPCodec.getMimeType() + ", " + this.xmlMtomCodec.getMimeType();
        FastInfosetFeature fastInfosetFeature = wSFeatureList.get(FastInfosetFeature.class);
        boolean bl = this.isFastInfosetDisabled = fastInfosetFeature != null && !fastInfosetFeature.isEnabled();
        if (!this.isFastInfosetDisabled) {
            this.fiSoapCodec = SOAPBindingCodec.getFICodec(streamSOAPCodec, this.version);
            if (this.fiSoapCodec != null) {
                this.fiMimeType = this.fiSoapCodec.getMimeType();
                this.fiSwaCodec = new SwACodec(this.version, wSFeatureList, this.fiSoapCodec);
                this.connegXmlAccept = this.fiMimeType + ", " + string;
                SelectOptimalEncodingFeature selectOptimalEncodingFeature = wSFeatureList.get(SelectOptimalEncodingFeature.class);
                if (selectOptimalEncodingFeature != null) {
                    this.ignoreContentNegotiationProperty = true;
                    if (selectOptimalEncodingFeature.isEnabled()) {
                        if (fastInfosetFeature != null) {
                            this.useFastInfosetForEncoding = true;
                        }
                        string = this.connegXmlAccept;
                    } else {
                        this.isFastInfosetDisabled = true;
                    }
                }
            } else {
                this.isFastInfosetDisabled = true;
                this.fiSwaCodec = null;
                this.fiMimeType = "";
                this.connegXmlAccept = string;
                this.ignoreContentNegotiationProperty = true;
            }
        } else {
            this.fiSwaCodec = null;
            this.fiSoapCodec = null;
            this.fiMimeType = "";
            this.connegXmlAccept = string;
            this.ignoreContentNegotiationProperty = true;
        }
        this.xmlAccept = string;
        if (WebServiceFeatureList.getSoapVersion(wSFeatureList) == null) {
            throw new WebServiceException("Expecting a SOAP binding but found ");
        }
    }

    @Override
    public String getMimeType() {
        return null;
    }

    @Override
    public ContentType getStaticContentType(Packet packet) {
        ContentType contentType = this.getEncoder(packet).getStaticContentType(packet);
        return this.setAcceptHeader(packet, (ContentTypeImpl)contentType);
    }

    @Override
    public ContentType encode(Packet packet, OutputStream outputStream) throws IOException {
        this.preEncode(packet);
        ContentType contentType = this.getEncoder(packet).encode(packet, outputStream);
        contentType = this.setAcceptHeader(packet, (ContentTypeImpl)contentType);
        this.postEncode();
        return contentType;
    }

    @Override
    public ContentType encode(Packet packet, WritableByteChannel writableByteChannel) {
        this.preEncode(packet);
        ContentType contentType = this.getEncoder(packet).encode(packet, writableByteChannel);
        contentType = this.setAcceptHeader(packet, (ContentTypeImpl)contentType);
        this.postEncode();
        return contentType;
    }

    private void preEncode(Packet packet) {
    }

    private void postEncode() {
    }

    private void preDecode(Packet packet) {
        if (packet.contentNegotiation == null) {
            this.useFastInfosetForEncoding = false;
        }
    }

    private void postDecode(Packet packet) {
        MTOMFeature mTOMFeature;
        packet.setFastInfosetDisabled(this.isFastInfosetDisabled);
        if (this.features.isEnabled(MTOMFeature.class)) {
            packet.checkMtomAcceptable();
        }
        if ((mTOMFeature = this.features.get(MTOMFeature.class)) != null) {
            packet.setMtomFeature(mTOMFeature);
        }
        if (!this.useFastInfosetForEncoding) {
            this.useFastInfosetForEncoding = packet.getFastInfosetAcceptable(this.fiMimeType);
        }
    }

    @Override
    public void decode(InputStream inputStream, String string, Packet packet) throws IOException {
        if (string == null) {
            string = this.xmlMimeType;
        }
        packet.setContentType(new ContentTypeImpl(string));
        this.preDecode(packet);
        try {
            if (this.isMultipartRelated(string)) {
                super.decode(inputStream, string, packet);
            } else if (this.isFastInfoset(string)) {
                if (!this.ignoreContentNegotiationProperty && packet.contentNegotiation == ContentNegotiation.none) {
                    throw this.noFastInfosetForDecoding();
                }
                this.useFastInfosetForEncoding = true;
                this.fiSoapCodec.decode(inputStream, string, packet);
            } else {
                this.xmlSoapCodec.decode(inputStream, string, packet);
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof ExceptionHasMessage || runtimeException instanceof UnsupportedMediaException) {
                throw runtimeException;
            }
            throw new MessageCreationException(this.version, runtimeException);
        }
        this.postDecode(packet);
    }

    @Override
    public void decode(ReadableByteChannel readableByteChannel, String string, Packet packet) {
        if (string == null) {
            throw new UnsupportedMediaException();
        }
        this.preDecode(packet);
        try {
            if (this.isMultipartRelated(string)) {
                super.decode(readableByteChannel, string, packet);
            } else if (this.isFastInfoset(string)) {
                if (packet.contentNegotiation == ContentNegotiation.none) {
                    throw this.noFastInfosetForDecoding();
                }
                this.useFastInfosetForEncoding = true;
                this.fiSoapCodec.decode(readableByteChannel, string, packet);
            } else {
                this.xmlSoapCodec.decode(readableByteChannel, string, packet);
            }
        }
        catch (RuntimeException runtimeException) {
            if (runtimeException instanceof ExceptionHasMessage || runtimeException instanceof UnsupportedMediaException) {
                throw runtimeException;
            }
            throw new MessageCreationException(this.version, runtimeException);
        }
        this.postDecode(packet);
    }

    @Override
    public SOAPBindingCodec copy() {
        return new SOAPBindingCodec(this.features, (StreamSOAPCodec)this.xmlSoapCodec.copy());
    }

    @Override
    protected void decode(MimeMultipartParser mimeMultipartParser, Packet packet) throws IOException {
        String string = mimeMultipartParser.getRootPart().getContentType();
        boolean bl = this.isApplicationXopXml(string);
        packet.setMtomRequest(bl);
        if (bl) {
            this.xmlMtomCodec.decode(mimeMultipartParser, packet);
        } else if (this.isFastInfoset(string)) {
            if (packet.contentNegotiation == ContentNegotiation.none) {
                throw this.noFastInfosetForDecoding();
            }
            this.useFastInfosetForEncoding = true;
            this.fiSwaCodec.decode(mimeMultipartParser, packet);
        } else if (this.isXml(string)) {
            this.xmlSwaCodec.decode(mimeMultipartParser, packet);
        } else {
            throw new IOException("");
        }
    }

    private boolean isMultipartRelated(String string) {
        return this.compareStrings(string, "multipart/related");
    }

    private boolean isApplicationXopXml(String string) {
        return this.compareStrings(string, "application/xop+xml");
    }

    private boolean isXml(String string) {
        return this.compareStrings(string, this.xmlMimeType);
    }

    private boolean isFastInfoset(String string) {
        if (this.isFastInfosetDisabled) {
            return false;
        }
        return this.compareStrings(string, this.fiMimeType);
    }

    private boolean compareStrings(String string, String string2) {
        return string.length() >= string2.length() && string2.equalsIgnoreCase(string.substring(0, string2.length()));
    }

    private Codec getEncoder(Packet packet) {
        if (!this.ignoreContentNegotiationProperty) {
            if (packet.contentNegotiation == ContentNegotiation.none) {
                this.useFastInfosetForEncoding = false;
            } else if (packet.contentNegotiation == ContentNegotiation.optimistic) {
                this.useFastInfosetForEncoding = true;
            }
        }
        if (this.useFastInfosetForEncoding) {
            Message message = packet.getMessage();
            if (message == null || message.getAttachments().isEmpty() || this.features.isEnabled(MTOMFeature.class)) {
                return this.fiSoapCodec;
            }
            return this.fiSwaCodec;
        }
        if (packet.getBinding() == null && this.features != null) {
            packet.setMtomFeature(this.features.get(MTOMFeature.class));
        }
        if (packet.shouldUseMtom()) {
            return this.xmlMtomCodec;
        }
        Message message = packet.getMessage();
        if (message == null || message.getAttachments().isEmpty()) {
            return this.xmlSoapCodec;
        }
        return this.xmlSwaCodec;
    }

    private RuntimeException noFastInfosetForDecoding() {
        return new RuntimeException(StreamingMessages.FASTINFOSET_DECODING_NOT_ACCEPTED());
    }

    private static Codec getFICodec(StreamSOAPCodec streamSOAPCodec, SOAPVersion sOAPVersion) {
        try {
            Class<?> clazz = Class.forName("com.sun.xml.internal.ws.encoding.fastinfoset.FastInfosetStreamSOAPCodec");
            Method method = clazz.getMethod("create", StreamSOAPCodec.class, SOAPVersion.class);
            return (Codec)method.invoke(null, new Object[]{streamSOAPCodec, sOAPVersion});
        }
        catch (Exception exception) {
            return null;
        }
    }
}

