/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.https;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.HandshakeCompletedEvent;
import javax.net.ssl.HandshakeCompletedListener;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.security.cert.X509Certificate;
import sun.net.www.http.HttpClient;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.security.action.GetPropertyAction;
import sun.security.ssl.SSLSocketImpl;
import sun.security.util.HostnameChecker;
import sun.util.logging.PlatformLogger;

final class HttpsClient
extends HttpClient
implements HandshakeCompletedListener {
    private static final int httpsPortNumber = 443;
    private static final String defaultHVCanonicalName = "javax.net.ssl.HttpsURLConnection.DefaultHostnameVerifier";
    private HostnameVerifier hv;
    private SSLSocketFactory sslSocketFactory;
    private SSLSession session;

    @Override
    protected int getDefaultPort() {
        return 443;
    }

    private String[] getCipherSuites() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("https.cipherSuites"));
        if (string == null || string.isEmpty()) {
            stringArray = null;
        } else {
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    private String[] getProtocols() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new GetPropertyAction("https.protocols"));
        if (string == null || string.isEmpty()) {
            stringArray = null;
        } else {
            Vector<String> vector = new Vector<String>();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            while (stringTokenizer.hasMoreTokens()) {
                vector.addElement(stringTokenizer.nextToken());
            }
            stringArray = new String[vector.size()];
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = (String)vector.elementAt(i);
            }
        }
        return stringArray;
    }

    private String getUserAgent() {
        String string = AccessController.doPrivileged(new GetPropertyAction("https.agent"));
        if (string == null || string.isEmpty()) {
            string = "JSSE";
        }
        return string;
    }

    private HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL) throws IOException {
        this(sSLSocketFactory, uRL, (String)null, -1);
    }

    HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL, String string, int n) throws IOException {
        this(sSLSocketFactory, uRL, string, n, -1);
    }

    HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL, String string, int n, int n2) throws IOException {
        this(sSLSocketFactory, uRL, string == null ? null : HttpClient.newHttpProxy(string, n, "https"), n2);
    }

    HttpsClient(SSLSocketFactory sSLSocketFactory, URL uRL, Proxy proxy, int n) throws IOException {
        PlatformLogger platformLogger = HttpURLConnection.getHttpLogger();
        if (platformLogger.isLoggable(PlatformLogger.Level.FINEST)) {
            platformLogger.finest("Creating new HttpsClient with url:" + uRL + " and proxy:" + proxy + " with connect timeout:" + n);
        }
        this.proxy = proxy;
        this.setSSLSocketFactory(sSLSocketFactory);
        this.proxyDisabled = true;
        this.host = uRL.getHost();
        this.url = uRL;
        this.port = uRL.getPort();
        if (this.port == -1) {
            this.port = this.getDefaultPort();
        }
        this.setConnectTimeout(n);
        this.openServer();
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, HttpURLConnection httpURLConnection) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, true, httpURLConnection);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, boolean bl, HttpURLConnection httpURLConnection) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, (String)null, -1, bl, httpURLConnection);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n, HttpURLConnection httpURLConnection) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, string, n, true, httpURLConnection);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n, boolean bl, HttpURLConnection httpURLConnection) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, string, n, bl, -1, httpURLConnection);
    }

    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, String string, int n, boolean bl, int n2, HttpURLConnection httpURLConnection) throws IOException {
        return HttpsClient.New(sSLSocketFactory, uRL, hostnameVerifier, string == null ? null : HttpClient.newHttpProxy(string, n, "https"), bl, n2, httpURLConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static HttpClient New(SSLSocketFactory sSLSocketFactory, URL uRL, HostnameVerifier hostnameVerifier, Proxy proxy, boolean bl, int n, HttpURLConnection httpURLConnection) throws IOException {
        Object object;
        PlatformLogger platformLogger;
        if (proxy == null) {
            proxy = Proxy.NO_PROXY;
        }
        if ((platformLogger = HttpURLConnection.getHttpLogger()).isLoggable(PlatformLogger.Level.FINEST)) {
            platformLogger.finest("Looking for HttpClient for URL " + uRL + " and proxy value of " + proxy);
        }
        HttpsClient httpsClient = null;
        if (bl) {
            httpsClient = (HttpsClient)kac.get(uRL, sSLSocketFactory);
            if (httpsClient != null && httpURLConnection != null && httpURLConnection.streaming() && "POST".equals(httpURLConnection.getRequestMethod()) && !httpsClient.available()) {
                httpsClient = null;
            }
            if (httpsClient != null) {
                if (httpsClient.proxy != null && httpsClient.proxy.equals(proxy) || httpsClient.proxy == null && proxy == Proxy.NO_PROXY) {
                    object = httpsClient;
                    synchronized (object) {
                        httpsClient.cachedHttpClient = true;
                        assert (httpsClient.inCache);
                        httpsClient.inCache = false;
                        if (httpURLConnection != null && httpsClient.needsTunneling()) {
                            httpURLConnection.setTunnelState(HttpURLConnection.TunnelState.TUNNELING);
                        }
                        if (platformLogger.isLoggable(PlatformLogger.Level.FINEST)) {
                            platformLogger.finest("KeepAlive stream retrieved from the cache, " + httpsClient);
                        }
                    }
                }
                object = httpsClient;
                synchronized (object) {
                    if (platformLogger.isLoggable(PlatformLogger.Level.FINEST)) {
                        platformLogger.finest("Not returning this connection to cache: " + httpsClient);
                    }
                    httpsClient.inCache = false;
                    httpsClient.closeServer();
                }
                httpsClient = null;
            }
        }
        if (httpsClient == null) {
            httpsClient = new HttpsClient(sSLSocketFactory, uRL, proxy, n);
        } else {
            object = System.getSecurityManager();
            if (object != null) {
                if (httpsClient.proxy == Proxy.NO_PROXY || httpsClient.proxy == null) {
                    ((SecurityManager)object).checkConnect(InetAddress.getByName(uRL.getHost()).getHostAddress(), uRL.getPort());
                } else {
                    ((SecurityManager)object).checkConnect(uRL.getHost(), uRL.getPort());
                }
            }
            httpsClient.url = uRL;
        }
        httpsClient.setHostnameVerifier(hostnameVerifier);
        return httpsClient;
    }

    void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hv = hostnameVerifier;
    }

    void setSSLSocketFactory(SSLSocketFactory sSLSocketFactory) {
        this.sslSocketFactory = sSLSocketFactory;
    }

    SSLSocketFactory getSSLSocketFactory() {
        return this.sslSocketFactory;
    }

    @Override
    protected Socket createSocket() throws IOException {
        try {
            return this.sslSocketFactory.createSocket();
        }
        catch (SocketException socketException) {
            Throwable throwable = socketException.getCause();
            if (throwable != null && throwable instanceof UnsupportedOperationException) {
                return super.createSocket();
            }
            throw socketException;
        }
    }

    @Override
    public boolean needsTunneling() {
        return this.proxy != null && this.proxy.type() != Proxy.Type.DIRECT && this.proxy.type() != Proxy.Type.SOCKS;
    }

    @Override
    public void afterConnect() throws IOException, UnknownHostException {
        if (!this.isCachedConnection()) {
            SSLSocket sSLSocket = null;
            SSLSocketFactory sSLSocketFactory = this.sslSocketFactory;
            try {
                if (!(this.serverSocket instanceof SSLSocket)) {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.serverSocket, this.host, this.port, true);
                } else {
                    sSLSocket = (SSLSocket)this.serverSocket;
                    if (sSLSocket instanceof SSLSocketImpl) {
                        ((SSLSocketImpl)sSLSocket).setHost(this.host);
                    }
                }
            }
            catch (IOException iOException) {
                try {
                    sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(this.host, this.port);
                }
                catch (IOException iOException2) {
                    throw iOException;
                }
            }
            String[] stringArray = this.getProtocols();
            String[] stringArray2 = this.getCipherSuites();
            if (stringArray != null) {
                sSLSocket.setEnabledProtocols(stringArray);
            }
            if (stringArray2 != null) {
                sSLSocket.setEnabledCipherSuites(stringArray2);
            }
            sSLSocket.addHandshakeCompletedListener(this);
            boolean bl = true;
            String string = sSLSocket.getSSLParameters().getEndpointIdentificationAlgorithm();
            if (string != null && string.length() != 0) {
                if (string.equalsIgnoreCase("HTTPS")) {
                    bl = false;
                }
            } else {
                Object object;
                boolean bl2 = false;
                if (this.hv != null) {
                    object = this.hv.getClass().getCanonicalName();
                    if (object != null && ((String)object).equalsIgnoreCase(defaultHVCanonicalName)) {
                        bl2 = true;
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    object = sSLSocket.getSSLParameters();
                    ((SSLParameters)object).setEndpointIdentificationAlgorithm("HTTPS");
                    sSLSocket.setSSLParameters((SSLParameters)object);
                    bl = false;
                }
            }
            sSLSocket.startHandshake();
            this.session = sSLSocket.getSession();
            this.serverSocket = sSLSocket;
            try {
                this.serverOutput = new PrintStream(new BufferedOutputStream(this.serverSocket.getOutputStream()), false, encoding);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new InternalError(encoding + " encoding not found");
            }
            if (bl) {
                this.checkURLSpoofing(this.hv);
            }
        } else {
            this.session = ((SSLSocket)this.serverSocket).getSession();
        }
    }

    private void checkURLSpoofing(HostnameVerifier hostnameVerifier) throws IOException {
        String string = this.url.getHost();
        if (string != null && string.startsWith("[") && string.endsWith("]")) {
            string = string.substring(1, string.length() - 1);
        }
        Certificate[] certificateArray = null;
        String string2 = this.session.getCipherSuite();
        try {
            HostnameChecker hostnameChecker = HostnameChecker.getInstance((byte)1);
            if (string2.startsWith("TLS_KRB5")) {
                if (!HostnameChecker.match(string, this.getPeerPrincipal())) {
                    throw new SSLPeerUnverifiedException("Hostname checker failed for Kerberos");
                }
            } else {
                certificateArray = this.session.getPeerCertificates();
                if (!(certificateArray[0] instanceof java.security.cert.X509Certificate)) {
                    throw new SSLPeerUnverifiedException("");
                }
                java.security.cert.X509Certificate x509Certificate = (java.security.cert.X509Certificate)certificateArray[0];
                hostnameChecker.match(string, x509Certificate);
            }
            return;
        }
        catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
        }
        catch (CertificateException certificateException) {
            // empty catch block
        }
        if (string2 != null && string2.indexOf("_anon_") != -1) {
            return;
        }
        if (hostnameVerifier != null && hostnameVerifier.verify(string, this.session)) {
            return;
        }
        this.serverSocket.close();
        this.session.invalidate();
        throw new IOException("HTTPS hostname wrong:  should be <" + this.url.getHost() + ">");
    }

    @Override
    protected void putInKeepAliveCache() {
        if (this.inCache) {
            assert (false) : "Duplicate put to keep alive cache";
            return;
        }
        this.inCache = true;
        kac.put(this.url, this.sslSocketFactory, this);
    }

    @Override
    public void closeIdleConnection() {
        HttpClient httpClient = kac.get(this.url, this.sslSocketFactory);
        if (httpClient != null) {
            httpClient.closeServer();
        }
    }

    String getCipherSuite() {
        return this.session.getCipherSuite();
    }

    public Certificate[] getLocalCertificates() {
        return this.session.getLocalCertificates();
    }

    Certificate[] getServerCertificates() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificates();
    }

    X509Certificate[] getServerCertificateChain() throws SSLPeerUnverifiedException {
        return this.session.getPeerCertificateChain();
    }

    Principal getPeerPrincipal() throws SSLPeerUnverifiedException {
        Principal principal;
        try {
            principal = this.session.getPeerPrincipal();
        }
        catch (AbstractMethodError abstractMethodError) {
            Certificate[] certificateArray = this.session.getPeerCertificates();
            principal = ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
        }
        return principal;
    }

    Principal getLocalPrincipal() {
        Principal principal;
        block2: {
            try {
                principal = this.session.getLocalPrincipal();
            }
            catch (AbstractMethodError abstractMethodError) {
                principal = null;
                Certificate[] certificateArray = this.session.getLocalCertificates();
                if (certificateArray == null) break block2;
                principal = ((java.security.cert.X509Certificate)certificateArray[0]).getSubjectX500Principal();
            }
        }
        return principal;
    }

    @Override
    public void handshakeCompleted(HandshakeCompletedEvent handshakeCompletedEvent) {
        this.session = handshakeCompletedEvent.getSession();
    }

    @Override
    public String getProxyHostUsed() {
        if (!this.needsTunneling()) {
            return null;
        }
        return super.getProxyHostUsed();
    }

    @Override
    public int getProxyPortUsed() {
        return this.proxy == null || this.proxy.type() == Proxy.Type.DIRECT || this.proxy.type() == Proxy.Type.SOCKS ? -1 : ((InetSocketAddress)this.proxy.address()).getPort();
    }

    SSLSession getSSLSession() {
        return this.session;
    }
}

