/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.Attribute;
import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class NestMembers
extends Attribute {
    private int[] classes;

    public NestMembers(NestMembers nestMembers) {
        this(nestMembers.getNameIndex(), nestMembers.getLength(), nestMembers.getClasses(), nestMembers.getConstantPool());
    }

    public NestMembers(int n, int n2, int[] nArray, ConstantPool constantPool) {
        super((byte)26, n, n2, constantPool);
        this.classes = nArray != null ? nArray : new int[]{};
    }

    NestMembers(int n, int n2, DataInput dataInput, ConstantPool constantPool) throws IOException {
        this(n, n2, (int[])null, constantPool);
        int n3 = dataInput.readUnsignedShort();
        this.classes = new int[n3];
        for (int i = 0; i < n3; ++i) {
            this.classes[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitNestMembers(this);
    }

    @Override
    public void dump(DataOutputStream dataOutputStream) throws IOException {
        super.dump(dataOutputStream);
        dataOutputStream.writeShort(this.classes.length);
        for (int n : this.classes) {
            dataOutputStream.writeShort(n);
        }
    }

    public int[] getClasses() {
        return this.classes;
    }

    public int getNumberClasses() {
        return this.classes == null ? 0 : this.classes.length;
    }

    public String[] getClassNames() {
        String[] stringArray = new String[this.classes.length];
        for (int i = 0; i < this.classes.length; ++i) {
            stringArray[i] = super.getConstantPool().getConstantString(this.classes[i], (byte)7).replace('/', '.');
        }
        return stringArray;
    }

    public void setClasses(int[] nArray) {
        this.classes = nArray != null ? nArray : new int[]{};
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("NestMembers(");
        stringBuilder.append(this.classes.length);
        stringBuilder.append("):\n");
        for (int n : this.classes) {
            String string = super.getConstantPool().getConstantString(n, (byte)7);
            stringBuilder.append("  ").append(Utility.compactClassName(string, false)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    @Override
    public Attribute copy(ConstantPool constantPool) {
        NestMembers nestMembers = (NestMembers)this.clone();
        if (this.classes != null) {
            nestMembers.classes = new int[this.classes.length];
            System.arraycopy(this.classes, 0, nestMembers.classes, 0, this.classes.length);
        }
        nestMembers.setConstantPool(constantPool);
        return nestMembers;
    }
}

