/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.util.exception;

import com.sun.istack.internal.localization.Localizable;
import com.sun.istack.internal.localization.LocalizableMessage;
import com.sun.istack.internal.localization.LocalizableMessageFactory;
import com.sun.istack.internal.localization.Localizer;
import com.sun.istack.internal.localization.NullLocalizable;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.xml.ws.WebServiceException;

public abstract class JAXWSExceptionBase
extends WebServiceException
implements Localizable {
    private static final long serialVersionUID = 1L;
    private transient Localizable msg;

    protected JAXWSExceptionBase(String string, Object ... objectArray) {
        super(JAXWSExceptionBase.findNestedException(objectArray));
        this.msg = new LocalizableMessage(this.getDefaultResourceBundleName(), string, objectArray);
    }

    protected JAXWSExceptionBase(String string) {
        this(new NullLocalizable(string));
    }

    protected JAXWSExceptionBase(Throwable throwable) {
        this(new NullLocalizable(throwable.toString()), throwable);
    }

    protected JAXWSExceptionBase(Localizable localizable) {
        this.msg = localizable;
    }

    protected JAXWSExceptionBase(Localizable localizable, Throwable throwable) {
        super(throwable);
        this.msg = localizable;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeObject(this.msg.getResourceBundleName());
        objectOutputStream.writeObject(this.msg.getKey());
        Object[] objectArray = this.msg.getArguments();
        if (objectArray == null) {
            objectOutputStream.writeInt(-1);
            return;
        }
        objectOutputStream.writeInt(objectArray.length);
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null || objectArray[i] instanceof Serializable) {
                objectOutputStream.writeObject(objectArray[i]);
                continue;
            }
            objectOutputStream.writeObject(objectArray[i].toString());
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object[] objectArray;
        objectInputStream.defaultReadObject();
        String string = (String)objectInputStream.readObject();
        String string2 = (String)objectInputStream.readObject();
        int n = objectInputStream.readInt();
        if (n < -1) {
            throw new NegativeArraySizeException();
        }
        if (n == -1) {
            objectArray = null;
        } else if (n < 255) {
            objectArray = new Object[n];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray[i] = objectInputStream.readObject();
            }
        } else {
            ArrayList<Object> arrayList = new ArrayList<Object>(Math.min(n, 1024));
            for (int i = 0; i < n; ++i) {
                arrayList.add(objectInputStream.readObject());
            }
            objectArray = arrayList.toArray(new Object[arrayList.size()]);
        }
        this.msg = new LocalizableMessageFactory(string).getMessage(string2, objectArray);
    }

    private static Throwable findNestedException(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        for (Object object : objectArray) {
            if (!(object instanceof Throwable)) continue;
            return (Throwable)object;
        }
        return null;
    }

    @Override
    public String getMessage() {
        Localizer localizer = new Localizer();
        return localizer.localize(this);
    }

    protected abstract String getDefaultResourceBundleName();

    @Override
    public final String getKey() {
        return this.msg.getKey();
    }

    @Override
    public final Object[] getArguments() {
        return this.msg.getArguments();
    }

    @Override
    public final String getResourceBundleName() {
        return this.msg.getResourceBundleName();
    }
}

