/*
 * Decompiled with CFR 0.152.
 */
package oracle.jrockit.jfr.settings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.SchemaFactory;
import oracle.jrockit.jfr.settings.EventDefault;
import oracle.jrockit.jfr.settings.EventDefaultSet;
import oracle.jrockit.jfr.settings.EventSetting;
import oracle.jrockit.jfr.settings.PresetFile;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import sun.security.action.GetPropertyAction;

@Deprecated
final class JFCParser {
    public static final String FILE_EXTENSION = ".jfc";
    private static final String XSD = JFCParser.getSchema();

    JFCParser() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getSchema() {
        String string = null;
        InputStream inputStream = JFCParser.getSchemaInputStream();
        if (inputStream != null) {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                string = new String(byteArrayOutputStream.toByteArray(), Charset.forName("UTF-8"));
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        return string;
    }

    private static InputStream getSchemaInputStream() {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.home"));
        return AccessController.doPrivileged(new PrivilegedAction<InputStream>(){

            @Override
            public InputStream run() {
                return PresetFile.class.getResourceAsStream("/oracle/jrockit/jfr/settings/jfc.xsd");
            }
        }, null, new FilePermission(string + "/lib/jfr.jar", "read"));
    }

    public static boolean hasValidFileExtension(File file) {
        return file.getAbsolutePath().toLowerCase().endsWith(FILE_EXTENSION);
    }

    public static EventDefaultSet createEventDefaultSet(String string) throws IOException, ParseException {
        return JFCParser.createPresetFile(string).getSettings();
    }

    public static PresetFile createPresetFile(File file) throws IOException, ParseException {
        return JFCParser.createPresetFile(PresetFile.readContent(file));
    }

    public static PresetFile createPresetFile(String string) throws IOException, ParseException {
        Object object;
        block7: {
            try {
                JFCParser.validateXML(string);
            }
            catch (ParserConfigurationException | SAXException exception) {
                throw new IOException("Error trying to read jfc-file.", exception);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                object = AccessController.doPrivileged(new GetPropertyAction("javax.xml.parsers.SAXParserFactory"));
                if (object != null) break block7;
                throw new UnsupportedOperationException("This parser does not support parsing of jfc-file.", unsupportedOperationException);
            }
        }
        try {
            ConfigurationHandler configurationHandler = new ConfigurationHandler();
            JFCParser.parseXML(string, configurationHandler);
            object = new EventDefaultSet(configurationHandler.eventDefaults);
            return new PresetFile(configurationHandler.configurationName, configurationHandler.configurationDescription, configurationHandler.configurationProvider, (EventDefaultSet)object, string);
        }
        catch (SAXParseException sAXParseException) {
            throw new ParseException(sAXParseException.getMessage(), sAXParseException.getLineNumber());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParseException(illegalArgumentException.getMessage(), -1);
        }
        catch (ParserConfigurationException | SAXException exception) {
            throw new IOException("Error trying to read jfc-file.", exception);
        }
    }

    private static void parseXML(String string, ConfigurationHandler configurationHandler) throws SAXException, IOException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
        SAXParserFactory.newInstance().newSAXParser().parse(new InputSource(charArrayReader), (DefaultHandler)configurationHandler);
    }

    private static void validateXML(String string) throws IOException, SAXException, ParserConfigurationException {
        if (XSD == null) {
            throw new IOException("Could not load schema resource for validating jfc-file");
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        sAXParserFactory.setNamespaceAware(true);
        SchemaFactory schemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        byte[] byArray = XSD.getBytes(Charset.forName("UTF-8"));
        Object object = new ByteArrayInputStream(byArray);
        Object object2 = null;
        try {
            sAXParserFactory.setSchema(schemaFactory.newSchema(new Source[]{new StreamSource((InputStream)object)}));
        }
        catch (Throwable throwable) {
            object2 = throwable;
            throw throwable;
        }
        finally {
            if (object != null) {
                if (object2 != null) {
                    try {
                        ((ByteArrayInputStream)object).close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object2).addSuppressed(throwable);
                    }
                } else {
                    ((ByteArrayInputStream)object).close();
                }
            }
        }
        object = sAXParserFactory.newSAXParser();
        object2 = ((SAXParser)object).getXMLReader();
        object2.setErrorHandler(new RethrowErrorHandler());
        CharArrayReader charArrayReader = new CharArrayReader(string.toCharArray());
        object2.parse(new InputSource(charArrayReader));
    }

    private static final class ConfigurationHandler
    extends DefaultHandler {
        private static final String ELEMENT_CONFIGURATION = "configuration";
        private static final String ELEMENT_PRODUCER = "producer";
        private static final String ELEMENT_EVENT_TYPE = "event";
        private static final String ELEMENT_SETTING = "setting";
        private static final String ATTRIBUTE_NAME = "name";
        private static final String ATTRIBUTE_URI = "uri";
        private static final String ATTRIBUTE_DESCRIPTION = "description";
        private static final String ATTRIBUTE_PATH = "path";
        private static final String ATTRIBUTE_PROVIDER = "provider";
        private final List<EventDefault> eventDefaults = new ArrayList<EventDefault>();
        private final Set<String> usedURIPaths = new HashSet<String>();
        private String configurationDescription;
        private String configurationName;
        private String configurationProvider;
        private URI currentProducerURI;
        private int currentEventId = 0;
        private String currentEventPath;
        private Map<String, String> currentSettings = new LinkedHashMap<String, String>();
        private String currentSettingsName;
        private StringBuilder currentCharacters;

        private ConfigurationHandler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
            switch (string3.toLowerCase()) {
                case "configuration": {
                    this.configurationName = attributes.getValue(ATTRIBUTE_NAME);
                    this.configurationDescription = this.getOptional(attributes, ATTRIBUTE_DESCRIPTION, "");
                    this.configurationProvider = this.getOptional(attributes, ATTRIBUTE_PROVIDER, "");
                    break;
                }
                case "producer": {
                    this.currentProducerURI = this.createURI(attributes.getValue(ATTRIBUTE_URI));
                    break;
                }
                case "event": {
                    this.currentSettings = new LinkedHashMap<String, String>();
                    this.currentEventPath = attributes.getValue(ATTRIBUTE_PATH);
                    break;
                }
                case "setting": {
                    this.currentSettingsName = attributes.getValue(ATTRIBUTE_NAME);
                }
            }
            this.currentCharacters = null;
        }

        private String getOptional(Attributes attributes, String string, String string2) {
            String string3 = attributes.getValue(string);
            return string3 == null ? string2 : string3;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) throws SAXException {
            if (this.currentCharacters == null) {
                this.currentCharacters = new StringBuilder(n2);
            }
            this.currentCharacters.append(cArray, n, n2);
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            switch (string3.toLowerCase()) {
                case "configuration": {
                    break;
                }
                case "producer": {
                    this.currentProducerURI = null;
                    break;
                }
                case "event": {
                    this.addEventDefaults();
                    this.currentEventPath = null;
                    this.currentSettings = null;
                    break;
                }
                case "setting": {
                    String string4;
                    String string5 = string4 = this.currentCharacters == null ? "" : this.currentCharacters.toString();
                    if (this.currentSettings.containsKey(this.currentSettingsName)) {
                        throw new IllegalArgumentException("Setting '" + this.currentSettingsName + "' already defined for event '" + this.currentProducerURI.toString() + this.currentEventPath + '\"');
                    }
                    this.currentSettings.put(this.currentSettingsName, string4);
                    this.currentSettingsName = null;
                }
            }
        }

        private void addEventDefaults() {
            String string = this.currentProducerURI.toString() + this.currentEventPath;
            if (!this.usedURIPaths.add(string)) {
                throw new IllegalArgumentException("'" + string + "' already used in jfc.");
            }
            URI uRI = this.createURI(string);
            try {
                this.eventDefaults.add(new EventDefault(uRI, new EventSetting(this.currentEventId, this.currentSettings)));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IllegalArgumentException("Event setting for '" + string + "' is incorrect. " + illegalArgumentException.getMessage());
            }
        }

        private URI createURI(String string) throws IllegalArgumentException {
            try {
                if (EventDefault.containsWildcard(string)) {
                    throw new IllegalArgumentException(string + " contains wildcard. All settings must use resolved event URIs");
                }
                return new URI(string);
            }
            catch (URISyntaxException uRISyntaxException) {
                throw new IllegalArgumentException("Not a valid URI " + string, uRISyntaxException);
            }
        }
    }

    private static final class RethrowErrorHandler
    implements ErrorHandler {
        private RethrowErrorHandler() {
        }

        @Override
        public void warning(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void error(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }

        @Override
        public void fatalError(SAXParseException sAXParseException) throws SAXException {
            throw sAXParseException;
        }
    }
}

