/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class InnerClass
implements Cloneable,
Node {
    private int innerClassIndex;
    private int outerClassIndex;
    private int innerNameIndex;
    private int innerAccessFlags;

    public InnerClass(InnerClass innerClass) {
        this(innerClass.getInnerClassIndex(), innerClass.getOuterClassIndex(), innerClass.getInnerNameIndex(), innerClass.getInnerAccessFlags());
    }

    InnerClass(DataInput dataInput) throws IOException {
        this(dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort(), dataInput.readUnsignedShort());
    }

    public InnerClass(int n, int n2, int n3, int n4) {
        this.innerClassIndex = n;
        this.outerClassIndex = n2;
        this.innerNameIndex = n3;
        this.innerAccessFlags = n4;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitInnerClass(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.innerClassIndex);
        dataOutputStream.writeShort(this.outerClassIndex);
        dataOutputStream.writeShort(this.innerNameIndex);
        dataOutputStream.writeShort(this.innerAccessFlags);
    }

    public int getInnerAccessFlags() {
        return this.innerAccessFlags;
    }

    public int getInnerClassIndex() {
        return this.innerClassIndex;
    }

    public int getInnerNameIndex() {
        return this.innerNameIndex;
    }

    public int getOuterClassIndex() {
        return this.outerClassIndex;
    }

    public void setInnerAccessFlags(int n) {
        this.innerAccessFlags = n;
    }

    public void setInnerClassIndex(int n) {
        this.innerClassIndex = n;
    }

    public void setInnerNameIndex(int n) {
        this.innerNameIndex = n;
    }

    public void setOuterClassIndex(int n) {
        this.outerClassIndex = n;
    }

    public String toString() {
        return "InnerClass(" + this.innerClassIndex + ", " + this.outerClassIndex + ", " + this.innerNameIndex + ", " + this.innerAccessFlags + ")";
    }

    public String toString(ConstantPool constantPool) {
        String string;
        String string2 = constantPool.getConstantString(this.innerClassIndex, (byte)7);
        string2 = Utility.compactClassName(string2, false);
        if (this.outerClassIndex != 0) {
            string = constantPool.getConstantString(this.outerClassIndex, (byte)7);
            string = " of class " + Utility.compactClassName(string, false);
        } else {
            string = "";
        }
        String string3 = this.innerNameIndex != 0 ? ((ConstantUtf8)constantPool.getConstant(this.innerNameIndex, (byte)1)).getBytes() : "(anonymous)";
        String string4 = Utility.accessToString(this.innerAccessFlags, true);
        string4 = string4.isEmpty() ? "" : string4 + " ";
        return "  " + string4 + string3 + "=class " + string2 + string;
    }

    public InnerClass copy() {
        try {
            return (InnerClass)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

