/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.ConstantUtf8;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public class MethodParameter
implements Cloneable {
    private int nameIndex;
    private int accessFlags;

    public MethodParameter() {
    }

    MethodParameter(DataInput dataInput) throws IOException {
        this.nameIndex = dataInput.readUnsignedShort();
        this.accessFlags = dataInput.readUnsignedShort();
    }

    public int getNameIndex() {
        return this.nameIndex;
    }

    public void setNameIndex(int n) {
        this.nameIndex = n;
    }

    public String getParameterName(ConstantPool constantPool) {
        if (this.nameIndex == 0) {
            return null;
        }
        return ((ConstantUtf8)constantPool.getConstant(this.nameIndex, (byte)1)).getBytes();
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public void setAccessFlags(int n) {
        this.accessFlags = n;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isSynthetic() {
        return (this.accessFlags & 0x1000) != 0;
    }

    public boolean isMandated() {
        return (this.accessFlags & Short.MIN_VALUE) != 0;
    }

    public void accept(Visitor visitor) {
        visitor.visitMethodParameter(this);
    }

    public final void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.nameIndex);
        dataOutputStream.writeShort(this.accessFlags);
    }

    public MethodParameter copy() {
        try {
            return (MethodParameter)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

