/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.bcel.internal.classfile;

import com.sun.org.apache.bcel.internal.classfile.ConstantPool;
import com.sun.org.apache.bcel.internal.classfile.Node;
import com.sun.org.apache.bcel.internal.classfile.Utility;
import com.sun.org.apache.bcel.internal.classfile.Visitor;
import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;

public final class ModuleOpens
implements Cloneable,
Node {
    private final int opensIndex;
    private final int opensFlags;
    private final int opensToCount;
    private final int[] opensToIndex;

    ModuleOpens(DataInput dataInput) throws IOException {
        this.opensIndex = dataInput.readUnsignedShort();
        this.opensFlags = dataInput.readUnsignedShort();
        this.opensToCount = dataInput.readUnsignedShort();
        this.opensToIndex = new int[this.opensToCount];
        for (int i = 0; i < this.opensToCount; ++i) {
            this.opensToIndex[i] = dataInput.readUnsignedShort();
        }
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitModuleOpens(this);
    }

    public void dump(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.opensIndex);
        dataOutputStream.writeShort(this.opensFlags);
        dataOutputStream.writeShort(this.opensToCount);
        for (int n : this.opensToIndex) {
            dataOutputStream.writeShort(n);
        }
    }

    public String toString() {
        return "opens(" + this.opensIndex + ", " + this.opensFlags + ", " + this.opensToCount + ", ...)";
    }

    public String toString(ConstantPool constantPool) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = constantPool.constantToString(this.opensIndex, (byte)20);
        stringBuilder.append(Utility.compactClassName(string, false));
        stringBuilder.append(", ").append(String.format("%04x", this.opensFlags));
        stringBuilder.append(", to(").append(this.opensToCount).append("):\n");
        for (int n : this.opensToIndex) {
            String string2 = constantPool.getConstantString(n, (byte)19);
            stringBuilder.append("      ").append(Utility.compactClassName(string2, false)).append("\n");
        }
        return stringBuilder.substring(0, stringBuilder.length() - 1);
    }

    public ModuleOpens copy() {
        try {
            return (ModuleOpens)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }
}

