/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.policy.jaxws;

import com.sun.xml.internal.ws.api.policy.ModelUnmarshaller;
import com.sun.xml.internal.ws.policy.PolicyException;
import com.sun.xml.internal.ws.policy.privateutil.PolicyLogger;
import com.sun.xml.internal.ws.policy.sourcemodel.PolicySourceModel;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.NamespaceVersion;
import com.sun.xml.internal.ws.policy.sourcemodel.wspolicy.XmlToken;
import com.sun.xml.internal.ws.resources.PolicyMessages;
import java.io.StringReader;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.ws.WebServiceException;

public class SafePolicyReader {
    private static final PolicyLogger LOGGER = PolicyLogger.getLogger(SafePolicyReader.class);
    private final Set<String> urlsRead = new HashSet<String>();
    private final Set<String> qualifiedPolicyUris = new HashSet<String>();

    public PolicyRecord readPolicyElement(XMLStreamReader xMLStreamReader, String string) {
        if (null == xMLStreamReader || !xMLStreamReader.isStartElement()) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        PolicyRecord policyRecord = new PolicyRecord();
        QName qName = xMLStreamReader.getName();
        int n = 0;
        try {
            do {
                switch (xMLStreamReader.getEventType()) {
                    case 1: {
                        boolean bl;
                        QName qName2 = xMLStreamReader.getName();
                        boolean bl2 = bl = NamespaceVersion.resolveAsToken(qName2) == XmlToken.PolicyReference;
                        if (qName.equals(qName2)) {
                            ++n;
                        }
                        StringBuffer stringBuffer2 = new StringBuffer();
                        HashSet<String> hashSet = new HashSet<String>();
                        if (null == qName2.getPrefix() || "".equals(qName2.getPrefix())) {
                            stringBuffer.append('<').append(qName2.getLocalPart());
                            stringBuffer2.append(" xmlns=\"").append(qName2.getNamespaceURI()).append('\"');
                        } else {
                            stringBuffer.append('<').append(qName2.getPrefix()).append(':').append(qName2.getLocalPart());
                            stringBuffer2.append(" xmlns:").append(qName2.getPrefix()).append("=\"").append(qName2.getNamespaceURI()).append('\"');
                            hashSet.add(qName2.getPrefix());
                        }
                        int n2 = xMLStreamReader.getAttributeCount();
                        StringBuffer stringBuffer3 = new StringBuffer();
                        for (int i = 0; i < n2; ++i) {
                            boolean bl3 = false;
                            if (bl && "URI".equals(xMLStreamReader.getAttributeName(i).getLocalPart())) {
                                bl3 = true;
                                if (null == policyRecord.unresolvedURIs) {
                                    policyRecord.unresolvedURIs = new HashSet<String>();
                                }
                                policyRecord.unresolvedURIs.add(SafePolicyReader.relativeToAbsoluteUrl(xMLStreamReader.getAttributeValue(i), string));
                            }
                            if ("xmlns".equals(xMLStreamReader.getAttributePrefix(i)) && hashSet.contains(xMLStreamReader.getAttributeLocalName(i))) continue;
                            if (null == xMLStreamReader.getAttributePrefix(i) || "".equals(xMLStreamReader.getAttributePrefix(i))) {
                                stringBuffer3.append(' ').append(xMLStreamReader.getAttributeLocalName(i)).append("=\"").append(bl3 ? SafePolicyReader.relativeToAbsoluteUrl(xMLStreamReader.getAttributeValue(i), string) : xMLStreamReader.getAttributeValue(i)).append('\"');
                                continue;
                            }
                            stringBuffer3.append(' ').append(xMLStreamReader.getAttributePrefix(i)).append(':').append(xMLStreamReader.getAttributeLocalName(i)).append("=\"").append(bl3 ? SafePolicyReader.relativeToAbsoluteUrl(xMLStreamReader.getAttributeValue(i), string) : xMLStreamReader.getAttributeValue(i)).append('\"');
                            if (hashSet.contains(xMLStreamReader.getAttributePrefix(i))) continue;
                            stringBuffer2.append(" xmlns:").append(xMLStreamReader.getAttributePrefix(i)).append("=\"").append(xMLStreamReader.getAttributeNamespace(i)).append('\"');
                            hashSet.add(xMLStreamReader.getAttributePrefix(i));
                        }
                        stringBuffer.append(stringBuffer2).append(stringBuffer3).append('>');
                        break;
                    }
                    case 2: {
                        QName qName2 = xMLStreamReader.getName();
                        if (qName.equals(qName2)) {
                            --n;
                        }
                        stringBuffer.append("</").append("".equals(qName2.getPrefix()) ? "" : qName2.getPrefix() + ':').append(qName2.getLocalPart()).append('>');
                        break;
                    }
                    case 4: {
                        stringBuffer.append(xMLStreamReader.getText());
                        break;
                    }
                    case 12: {
                        stringBuffer.append("<![CDATA[").append(xMLStreamReader.getText()).append("]]>");
                        break;
                    }
                    case 5: {
                        break;
                    }
                }
                if (!xMLStreamReader.hasNext() || n <= 0) continue;
                xMLStreamReader.next();
            } while (8 != xMLStreamReader.getEventType() && n > 0);
            policyRecord.policyModel = ModelUnmarshaller.getUnmarshaller().unmarshalModel(new StringReader(stringBuffer.toString()));
            if (null != policyRecord.policyModel.getPolicyId()) {
                policyRecord.setUri(string + "#" + policyRecord.policyModel.getPolicyId(), policyRecord.policyModel.getPolicyId());
            } else if (policyRecord.policyModel.getPolicyName() != null) {
                policyRecord.setUri(policyRecord.policyModel.getPolicyName(), policyRecord.policyModel.getPolicyName());
            }
        }
        catch (Exception exception) {
            throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1013_EXCEPTION_WHEN_READING_POLICY_ELEMENT(stringBuffer.toString()), exception));
        }
        this.urlsRead.add(string);
        return policyRecord;
    }

    public Set<String> getUrlsRead() {
        return this.urlsRead;
    }

    public String readPolicyReferenceElement(XMLStreamReader xMLStreamReader) {
        try {
            if (NamespaceVersion.resolveAsToken(xMLStreamReader.getName()) == XmlToken.PolicyReference) {
                for (int i = 0; i < xMLStreamReader.getAttributeCount(); ++i) {
                    if (XmlToken.resolveToken(xMLStreamReader.getAttributeName(i).getLocalPart()) != XmlToken.Uri) continue;
                    String string = xMLStreamReader.getAttributeValue(i);
                    xMLStreamReader.next();
                    return string;
                }
            }
            xMLStreamReader.next();
            return null;
        }
        catch (XMLStreamException xMLStreamException) {
            throw LOGGER.logSevereException(new WebServiceException(PolicyMessages.WSP_1001_XML_EXCEPTION_WHEN_PROCESSING_POLICY_REFERENCE(), xMLStreamException));
        }
    }

    public static String relativeToAbsoluteUrl(String string, String string2) {
        if ('#' != string.charAt(0)) {
            return string;
        }
        return null == string2 ? string : string2 + string;
    }

    public final class PolicyRecord {
        PolicyRecord next;
        PolicySourceModel policyModel;
        Set<String> unresolvedURIs;
        private String uri;

        PolicyRecord() {
        }

        PolicyRecord insert(PolicyRecord policyRecord) {
            if (null == policyRecord.unresolvedURIs || policyRecord.unresolvedURIs.isEmpty()) {
                policyRecord.next = this;
                return policyRecord;
            }
            PolicyRecord policyRecord2 = this;
            PolicyRecord policyRecord3 = null;
            PolicyRecord policyRecord4 = policyRecord2;
            while (null != policyRecord4.next) {
                if (null != policyRecord4.unresolvedURIs && policyRecord4.unresolvedURIs.contains(policyRecord.uri)) {
                    if (null == policyRecord3) {
                        policyRecord.next = policyRecord4;
                        return policyRecord;
                    }
                    policyRecord3.next = policyRecord;
                    policyRecord.next = policyRecord4;
                    return policyRecord2;
                }
                if (policyRecord.unresolvedURIs.remove(policyRecord4.uri) && policyRecord.unresolvedURIs.isEmpty()) {
                    policyRecord.next = policyRecord4.next;
                    policyRecord4.next = policyRecord;
                    return policyRecord2;
                }
                policyRecord3 = policyRecord4;
                policyRecord4 = policyRecord4.next;
            }
            policyRecord.next = null;
            policyRecord4.next = policyRecord;
            return policyRecord2;
        }

        public void setUri(String string, String string2) throws PolicyException {
            if (SafePolicyReader.this.qualifiedPolicyUris.contains(string)) {
                throw LOGGER.logSevereException(new PolicyException(PolicyMessages.WSP_1020_DUPLICATE_ID(string2)));
            }
            this.uri = string;
            SafePolicyReader.this.qualifiedPolicyUris.add(string);
        }

        public String getUri() {
            return this.uri;
        }

        public String toString() {
            String string = this.uri;
            if (null != this.next) {
                string = string + "->" + this.next.toString();
            }
            return string;
        }
    }
}

