/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.DataStreamException;
import com.ibm.jtopenlite.HostServerConnection;
import com.ibm.jtopenlite.Message;
import com.ibm.jtopenlite.SignonConnection;
import com.ibm.jtopenlite.SystemInfo;
import com.ibm.jtopenlite.command.CommandResult;
import com.ibm.jtopenlite.command.Parameter;
import com.ibm.jtopenlite.command.Program;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import javax.net.ssl.SSLSocketFactory;

public class CommandConnection
extends HostServerConnection {
    public static final int DEFAULT_COMMAND_SERVER_PORT = 8475;
    public static final int DEFAULT_SSL_COMMAND_SERVER_PORT = 9475;
    private int ccsid_;
    private int datastreamLevel_;
    private String NLV_;

    private CommandConnection(SystemInfo systemInfo, Socket socket, HostServerConnection.HostInputStream hostInputStream, HostServerConnection.HostOutputStream hostOutputStream, int n, int n2, String string, String string2, String string3) {
        super(systemInfo, string, string2, socket, hostInputStream, hostOutputStream);
        this.ccsid_ = n;
        this.datastreamLevel_ = n2;
        this.NLV_ = string3;
    }

    protected void sendEndJobRequest() throws IOException {
        this.out_.writeInt(20);
        this.out_.writeShort(0);
        this.out_.writeShort(57352);
        this.out_.writeInt(0);
        this.out_.writeInt(0);
        this.out_.writeShort(0);
        this.out_.writeShort(4100);
        this.out_.flush();
    }

    public String getNLV() {
        return this.NLV_;
    }

    public int getCcsid() {
        return this.ccsid_;
    }

    public static CommandConnection getConnection(String string, String string2, String string3) throws IOException {
        return CommandConnection.getConnection(false, string, string2, string3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandConnection getConnection(boolean bl, String string, String string2, String string3) throws IOException {
        SignonConnection signonConnection = SignonConnection.getConnection(bl, string, string2, string3);
        try {
            CommandConnection commandConnection = CommandConnection.getConnection(bl, signonConnection.getInfo(), string2, string3);
            return commandConnection;
        }
        finally {
            signonConnection.close();
        }
    }

    public static CommandConnection getConnection(SystemInfo systemInfo, String string, String string2) throws IOException {
        return CommandConnection.getConnection(false, systemInfo, string, string2);
    }

    public static CommandConnection getConnection(boolean bl, SystemInfo systemInfo, String string, String string2) throws IOException {
        return CommandConnection.getConnection(bl, systemInfo, string, string2, bl ? 9475 : 8475, false);
    }

    public static CommandConnection getConnection(SystemInfo systemInfo, String string, String string2, int n, boolean bl) throws IOException {
        return CommandConnection.getConnection(false, systemInfo, string, string2, n, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CommandConnection getConnection(boolean bl, SystemInfo systemInfo, String string, String string2, int n, boolean bl2) throws IOException {
        if (n < 0 || n > 65535) {
            throw new IOException("Bad command port: " + n);
        }
        CommandConnection commandConnection = null;
        Socket socket = bl ? SSLSocketFactory.getDefault().createSocket(systemInfo.getSystem(), n) : new Socket(systemInfo.getSystem(), n);
        InputStream inputStream = socket.getInputStream();
        OutputStream outputStream = socket.getOutputStream();
        try {
            if (bl2) {
                throw new IOException("Experimental compression streams not enabled.");
            }
            HostServerConnection.HostOutputStream hostOutputStream = new HostServerConnection.HostOutputStream(bl2 ? outputStream : new BufferedOutputStream(outputStream));
            HostServerConnection.HostInputStream hostInputStream = new HostServerConnection.HostInputStream(new BufferedInputStream(inputStream));
            String string3 = CommandConnection.connect(systemInfo, hostOutputStream, hostInputStream, 57352, string, string2);
            String string4 = Conv.getDefaultNLV();
            CommandConnection.sendExchangeAttributesRequest(hostOutputStream, string4);
            hostOutputStream.flush();
            int n2 = hostInputStream.readInt();
            if (n2 < 20) {
                throw DataStreamException.badLength("commandExchangeAttributes", n2);
            }
            hostInputStream.skipBytes(16);
            int n3 = hostInputStream.readShort();
            if (n3 != 256 && n3 != 260 && n3 != 261 && n3 != 262 && n3 != 263 && n3 != 264 && n3 != 0) {
                throw DataStreamException.badReturnCode("commandExchangeAttributes", n3);
            }
            int n4 = hostInputStream.readInt();
            byte[] byArray = new byte[]{(byte)hostInputStream.readByte(), (byte)hostInputStream.readByte(), (byte)hostInputStream.readByte(), (byte)hostInputStream.readByte()};
            string4 = Conv.ebcdicByteArrayToString(byArray, 0, 4);
            hostInputStream.skipBytes(4);
            int n5 = hostInputStream.readShort();
            hostInputStream.skipBytes(n2 - 36);
            hostInputStream.end();
            CommandConnection commandConnection2 = commandConnection = new CommandConnection(systemInfo, socket, hostInputStream, hostOutputStream, n4, n5, string, string3, string4);
            return commandConnection2;
        }
        finally {
            if (commandConnection == null) {
                inputStream.close();
                outputStream.close();
                socket.close();
            }
        }
    }

    public CommandResult call(String string, String string2, Parameter[] parameterArray) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Connection closed");
        }
        CommandConnection.sendCallProgramRequest(this.out_, string, string2, parameterArray, this.datastreamLevel_);
        this.out_.flush();
        int n = this.in_.readInt();
        if (n < 20) {
            throw DataStreamException.badLength("commandCallProgram", n);
        }
        this.in_.skipBytes(16);
        int n2 = this.in_.readShort();
        boolean bl = n2 == 0;
        Message[] messageArray = null;
        if (n2 == 0) {
            this.in_.skipBytes(2);
            for (int i = 0; i < parameterArray.length; ++i) {
                if (parameterArray[i].getOutputLength() <= 0) continue;
                int n3 = this.in_.readInt();
                this.in_.skipBytes(2);
                int n4 = this.in_.readInt();
                int n5 = this.in_.readShort();
                byte[] byArray = new byte[n3 - 12];
                this.in_.readFully(byArray);
                parameterArray[i].setOutputData(byArray);
            }
            messageArray = new Message[]{};
        } else {
            messageArray = this.getMessages(n);
        }
        this.in_.end();
        return new CommandResult(bl, messageArray, n2);
    }

    public CommandResult call(Program program) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Connection closed");
        }
        program.newCall();
        CommandConnection.sendCallProgramRequest(this.out_, program, this.datastreamLevel_);
        this.out_.flush();
        int n = this.in_.readInt();
        if (n < 20) {
            throw DataStreamException.badLength("commandCallProgram", n);
        }
        this.in_.skipBytes(16);
        int n2 = this.in_.readShort();
        boolean bl = n2 == 0;
        Message[] messageArray = null;
        if (n2 == 0) {
            this.in_.skipBytes(2);
            int n3 = program.getNumberOfParameters();
            for (int i = 0; i < n3; ++i) {
                if (program.getParameterOutputLength(i) <= 0) continue;
                int n4 = this.in_.readInt();
                this.in_.skipBytes(2);
                int n5 = this.in_.readInt();
                int n6 = this.in_.readShort();
                int n7 = n4 - 12;
                byte[] byArray = program.getTempDataBuffer();
                if (byArray == null || byArray.length < n7) {
                    byArray = new byte[n7];
                }
                this.in_.readFully(byArray, 0, n7);
                program.setParameterOutputData(i, byArray, n7);
            }
            messageArray = new Message[]{};
        } else {
            messageArray = this.getMessages(n);
        }
        this.in_.end();
        return new CommandResult(bl, messageArray, n2);
    }

    private static void sendCallProgramRequest(HostServerConnection.HostOutputStream hostOutputStream, Program program, int n) throws IOException {
        int n2;
        int n3 = 43;
        int n4 = program.getNumberOfParameters();
        for (n2 = 0; n2 < n4; ++n2) {
            n3 += 12 + program.getParameterInputLength(n2);
        }
        hostOutputStream.writeInt(n3);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(57352);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(23);
        hostOutputStream.writeShort(4099);
        CommandConnection.writePadEBCDIC10(program.getProgramName(), hostOutputStream);
        CommandConnection.writePadEBCDIC10(program.getProgramLibrary(), hostOutputStream);
        int n5 = n2 = n >= 10 ? 1 : 0;
        int n6 = n2 != 0 ? 4 : (n < 7 ? 0 : 2);
        hostOutputStream.writeByte(n6);
        hostOutputStream.writeShort(n4);
        block7: for (int i = 0; i < n4; ++i) {
            int n7 = program.getParameterInputLength(i);
            int n8 = program.getParameterOutputLength(i);
            hostOutputStream.writeInt(12 + n7);
            hostOutputStream.writeShort(4355);
            int n9 = n7 > n8 ? n7 : n8;
            hostOutputStream.writeInt(n9);
            switch (program.getParameterType(i)) {
                case 0: {
                    if (n < 6) {
                        hostOutputStream.writeShort(1);
                        continue block7;
                    }
                    hostOutputStream.writeShort(255);
                    continue block7;
                }
                case 1: {
                    hostOutputStream.writeShort(11);
                    byte[] byArray = program.getParameterInputData(i);
                    hostOutputStream.write(byArray, 0, n7);
                    continue block7;
                }
                case 2: {
                    hostOutputStream.writeShort(12);
                    continue block7;
                }
                case 3: {
                    hostOutputStream.writeShort(13);
                    byte[] byArray = program.getParameterInputData(i);
                    hostOutputStream.write(byArray, 0, n7);
                }
            }
        }
    }

    private static void sendCallProgramRequest(HostServerConnection.HostOutputStream hostOutputStream, String string, String string2, Parameter[] parameterArray, int n) throws IOException {
        int n2;
        int n3 = 43;
        for (n2 = 0; n2 < parameterArray.length; ++n2) {
            n3 += 12 + parameterArray[n2].getInputLength();
        }
        hostOutputStream.writeInt(n3);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(57352);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(23);
        hostOutputStream.writeShort(4099);
        CommandConnection.writePadEBCDIC10(string2, hostOutputStream);
        CommandConnection.writePadEBCDIC10(string, hostOutputStream);
        int n4 = n2 = n >= 10 ? 1 : 0;
        int n5 = n2 != 0 ? 4 : (n < 7 ? 0 : 2);
        hostOutputStream.writeByte(n5);
        hostOutputStream.writeShort(parameterArray.length);
        block7: for (int i = 0; i < parameterArray.length; ++i) {
            hostOutputStream.writeInt(12 + parameterArray[i].getInputLength());
            hostOutputStream.writeShort(4355);
            hostOutputStream.writeInt(parameterArray[i].getMaxLength());
            switch (parameterArray[i].getType()) {
                case 0: {
                    if (n < 6) {
                        hostOutputStream.writeShort(1);
                        continue block7;
                    }
                    hostOutputStream.writeShort(255);
                    continue block7;
                }
                case 1: {
                    hostOutputStream.writeShort(11);
                    hostOutputStream.write(parameterArray[i].getInputData(), 0, parameterArray[i].getInputLength());
                    continue block7;
                }
                case 2: {
                    hostOutputStream.writeShort(12);
                    continue block7;
                }
                case 3: {
                    hostOutputStream.writeShort(13);
                    hostOutputStream.write(parameterArray[i].getInputData(), 0, parameterArray[i].getInputLength());
                }
            }
        }
    }

    public CommandResult execute(String string) throws IOException {
        if (this.isClosed()) {
            throw new IOException("Connection closed");
        }
        CommandConnection.sendRunCommandRequest(this.out_, string, this.datastreamLevel_);
        this.out_.flush();
        int n = this.in_.readInt();
        if (n < 20) {
            throw DataStreamException.badLength("commandRunCommand", n);
        }
        this.in_.skipBytes(16);
        int n2 = this.in_.readShort();
        if (n2 != 0 && n2 != 1024) {
            this.in_.skipBytes(n - 22);
            throw DataStreamException.badReturnCode("commandRunCommand", n2);
        }
        Message[] messageArray = this.getMessages(n);
        this.in_.end();
        return new CommandResult(n2 == 0, messageArray, n2);
    }

    private Message[] getMessages(int n) throws IOException {
        char[] cArray = new char[1024];
        int n2 = this.in_.readShort();
        Message[] messageArray = new Message[n2];
        int n3 = 24;
        for (int i = 0; i < n2; ++i) {
            Object object;
            byte[] byArray;
            int n4;
            int n5;
            int n6;
            int n7;
            int n8 = n3;
            int n9 = this.in_.readInt();
            n3 += 4;
            int n10 = this.in_.readShort();
            n3 += 2;
            if (n10 == 4358) {
                n7 = this.in_.readInt();
                n6 = this.in_.readInt();
                n5 = this.in_.readShort();
                int n11 = this.in_.readInt();
                int n12 = this.in_.readShort();
                this.in_.skipBytes(n11 - 2);
                n4 = this.in_.readInt();
                byte[] byArray2 = new byte[n4];
                this.in_.readFully(byArray2);
                int n13 = this.in_.readInt();
                byArray = new byte[n13];
                this.in_.readFully(byArray);
                int n14 = this.in_.readInt();
                object = new byte[n14];
                this.in_.readFully((byte[])object);
                int n15 = this.in_.readInt();
                byte[] byArray3 = new byte[n15];
                this.in_.readFully(byArray3);
                int n16 = this.in_.readInt();
                byte[] byArray4 = new byte[n16];
                this.in_.readFully(byArray4);
                int n17 = this.in_.readInt();
                byte[] byArray5 = new byte[n17];
                this.in_.readFully(byArray5);
                if (byArray2.length > cArray.length) {
                    cArray = new char[byArray2.length];
                }
                String string = Conv.ebcdicByteArrayToString(byArray2, cArray);
                if (byArray3.length > cArray.length) {
                    cArray = new char[byArray3.length];
                }
                String string2 = Conv.ebcdicByteArrayToString(byArray3, cArray);
                messageArray[i] = new Message(string, string2);
                n3 += 40 + n11 - 2 + n4 + n13 + n14 + n15 + n16 + n17;
            } else if (n10 == 4354) {
                byte[] byArray6 = new byte[7];
                this.in_.readFully(byArray6);
                n6 = this.in_.readShort();
                n5 = this.in_.readShort();
                byte[] byArray7 = new byte[10];
                this.in_.readFully(byArray7);
                byte[] byArray8 = new byte[10];
                this.in_.readFully(byArray8);
                n4 = this.in_.readShort();
                int n18 = this.in_.readShort();
                byte[] byArray9 = new byte[n4];
                this.in_.readFully(byArray9);
                byArray = new byte[n18];
                this.in_.readFully(byArray);
                n3 += 35 + n4 + n18;
                if (byArray6.length > cArray.length) {
                    cArray = new char[byArray6.length];
                }
                String string = Conv.ebcdicByteArrayToString(byArray6, cArray);
                if (byArray.length > cArray.length) {
                    cArray = new char[byArray.length];
                }
                object = Conv.ebcdicByteArrayToString(byArray, cArray);
                messageArray[i] = new Message(string, (String)object);
            }
            n7 = n9 - (n3 - n8);
            this.in_.skipBytes(n7);
        }
        this.in_.skipBytes(n - n3);
        return messageArray;
    }

    private static void sendRunCommandRequest(HostServerConnection.HostOutputStream hostOutputStream, String string, int n) throws IOException {
        boolean bl = n >= 10;
        byte[] byArray = bl ? Conv.stringToUnicodeByteArray(string) : Conv.stringToEBCDICByteArray37(string);
        hostOutputStream.writeInt(bl ? 31 + byArray.length : 27 + byArray.length);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(57352);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(1);
        hostOutputStream.writeShort(4098);
        int n2 = bl ? 4 : (n < 7 ? 0 : 2);
        hostOutputStream.writeByte(n2);
        if (bl) {
            hostOutputStream.writeInt(10 + byArray.length);
            hostOutputStream.writeShort(4356);
            hostOutputStream.writeInt(1200);
            hostOutputStream.write(byArray);
        } else {
            hostOutputStream.writeInt(6 + byArray.length);
            hostOutputStream.writeShort(4353);
            hostOutputStream.write(byArray);
        }
    }

    private static void sendExchangeAttributesRequest(HostServerConnection.HostOutputStream hostOutputStream, String string) throws IOException {
        hostOutputStream.writeInt(34);
        hostOutputStream.writeShort(0);
        hostOutputStream.writeShort(57352);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeInt(0);
        hostOutputStream.writeShort(14);
        hostOutputStream.writeShort(4097);
        hostOutputStream.writeInt(1200);
        byte[] byArray = Conv.stringToEBCDICByteArray37(string);
        hostOutputStream.write(byArray);
        hostOutputStream.writeInt(1);
        hostOutputStream.writeShort(0);
    }
}

