/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.command;

import com.ibm.jtopenlite.Message;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandResult {
    private boolean success_;
    private Message[] messages_;
    private List<Message> messageList_;
    private int rc_;

    CommandResult(boolean bl, Message[] messageArray, int n) {
        this.success_ = bl;
        this.messages_ = messageArray;
        this.messageList_ = null;
        this.rc_ = n;
    }

    CommandResult(boolean bl, List<Message> list, int n) {
        this.success_ = bl;
        this.messages_ = null;
        this.messageList_ = list;
        this.rc_ = n;
    }

    public boolean succeeded() {
        return this.success_;
    }

    public int getReturnCode() {
        return this.rc_;
    }

    public Message[] getMessages() {
        if (this.messages_ == null && this.messageList_ != null) {
            int n = this.messageList_.size();
            this.messages_ = new Message[n];
            for (int i = 0; i < n; ++i) {
                this.messages_[i] = this.messageList_.get(i);
            }
        }
        return this.messages_;
    }

    public List<Message> getMessagesList() {
        if (this.messageList_ == null && this.messages_ != null) {
            this.messageList_ = new LinkedList<Message>();
            for (int i = 0; i < this.messages_.length; ++i) {
                this.messageList_.add(this.messages_[i]);
            }
        }
        return this.messageList_;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("" + this.success_);
        stringBuffer.append("; rc=0x");
        stringBuffer.append(Integer.toHexString(this.rc_));
        if (this.messageList_ != null) {
            this.getMessages();
        }
        if (this.messages_ != null) {
            for (int i = 0; i < this.messages_.length; ++i) {
                stringBuffer.append("\n");
                stringBuffer.append(this.messages_[i].toString());
            }
        }
        return stringBuffer.toString();
    }
}

