/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.Trace;
import com.ibm.jtopenlite.database.jdbc.JDBCConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;

public class JDBCDriver
implements Driver {
    public static final String DATABASE_PRODUCT_NAME_ = "DB2 UDB for AS/400";
    public static final String DRIVER_NAME_ = "jtopenlite JDBC Driver";
    public static final String DRIVER_LEVEL_ = "01.00";
    public static final int MAJOR_VERSION_ = 1;
    public static final int MINOR_VERSION_ = 0;
    public static final int JDBC_MAJOR_VERSION_ = 3;
    public static final int JDBC_MINOR_VERSION_ = 0;
    public static final String URL_PREFIX_ = "jdbc:jtopenlite://";

    public boolean acceptsURL(String string) throws SQLException {
        if (string == null) {
            return false;
        }
        return string.startsWith(URL_PREFIX_);
    }

    public Connection connect(String string, Properties properties) throws SQLException {
        if (this.acceptsURL(string)) {
            String string2 = string.substring(18);
            int n = string2.indexOf(";");
            if (n >= 0) {
                if (properties == null) {
                    properties = new Properties();
                }
                JDBCDriver.addURLProperties(string2.substring(n + 1), properties);
            }
            int n2 = string2.indexOf("/");
            if (n >= 0 || n2 >= 0) {
                int n3 = n >= 0 && n2 >= 0 ? (n < n2 ? n : n2) : (n >= 0 ? n : n2);
                string2 = string2.substring(0, n3);
            }
            string2 = string2.trim();
            String string3 = properties.getProperty("user");
            String string4 = properties.getProperty("password");
            boolean bl = Boolean.parseBoolean(properties.getProperty("secure", "false"));
            boolean bl2 = properties.getProperty("debug", "false").equals("true");
            if (Trace.isStreamTracingEnabled()) {
                bl2 = true;
            }
            return JDBCConnection.getConnection(bl, string2, string3, string4, bl2);
        }
        return null;
    }

    private static final void addURLProperties(String string, Properties properties) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n < 0) continue;
            properties.setProperty(string2.substring(0, n), string2.substring(n + 1));
        }
    }

    public int getMajorVersion() {
        return 1;
    }

    public int getMinorVersion() {
        return 0;
    }

    public DriverPropertyInfo[] getPropertyInfo(String string, Properties properties) {
        if (properties == null) {
            properties = new Properties();
        }
        return new DriverPropertyInfo[]{new DriverPropertyInfo("debug", properties.getProperty("debug", "false"))};
    }

    public boolean jdbcCompliant() {
        return false;
    }

    public String toString() {
        return DRIVER_NAME_;
    }

    static {
        try {
            DriverManager.registerDriver(new JDBCDriver());
        }
        catch (SQLException sQLException) {
            RuntimeException runtimeException = new RuntimeException("Error registering driver: " + sQLException.toString());
            runtimeException.initCause(sQLException);
            throw runtimeException;
        }
    }
}

