/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.database.jdbc;

import com.ibm.jtopenlite.Conv;
import com.ibm.jtopenlite.Message;
import com.ibm.jtopenlite.database.DatabaseConnection;
import com.ibm.jtopenlite.database.DatabaseFetchCallback;
import com.ibm.jtopenlite.database.DatabaseRequestAttributes;
import com.ibm.jtopenlite.database.jdbc.Column;
import com.ibm.jtopenlite.database.jdbc.DataCache;
import com.ibm.jtopenlite.database.jdbc.JDBCConnection;
import com.ibm.jtopenlite.database.jdbc.JDBCError;
import com.ibm.jtopenlite.database.jdbc.JDBCResultSetMetaData;
import com.ibm.jtopenlite.database.jdbc.JDBCStatement;
import com.ibm.jtopenlite.database.jdbc.NotImplementedException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCResultSet
implements ResultSet,
DatabaseFetchCallback {
    private JDBCStatement statement_;
    private JDBCResultSetMetaData md_;
    private String stName_;
    private String cursorName_;
    private int fetchSize_;
    private boolean closed_;
    private boolean afterLast_ = false;
    private final DataCache dataCache_ = new DataCache();
    private int currentRow_ = 0;
    private boolean lastNull_ = false;
    private byte[] tempDataBuffer_;
    protected boolean isMetadataResultSet_ = false;

    public JDBCResultSet(JDBCStatement jDBCStatement, JDBCResultSetMetaData jDBCResultSetMetaData, String string, String string2, int n) {
        this.statement_ = jDBCStatement;
        this.md_ = jDBCResultSetMetaData;
        this.stName_ = string;
        this.cursorName_ = string2;
        this.fetchSize_ = n;
    }

    @Override
    public byte[] getTempDataBuffer(int n) {
        if (this.tempDataBuffer_ == null || this.tempDataBuffer_.length < n) {
            this.tempDataBuffer_ = new byte[n];
        }
        return this.tempDataBuffer_;
    }

    @Override
    public void newResultData(int n, int n2, int n3) {
        this.dataCache_.init(n, n2, n3);
        if (this.tempDataBuffer_ == null || this.tempDataBuffer_.length < n3) {
            this.tempDataBuffer_ = new byte[n3];
        }
    }

    @Override
    public void newIndicator(int n, int n2, byte[] byArray) {
        short s = Conv.byteArrayToShort(byArray, 0);
        boolean bl = s == -1;
        this.dataCache_.setNull(n, n2, bl);
    }

    @Override
    public void newRowData(int n, byte[] byArray) {
        this.dataCache_.setRow(n, byArray);
    }

    @Override
    public boolean absolute(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void afterLast() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws SQLException {
        block8: {
            try {
                if (this.cursorName_ == null) {
                    return;
                }
                if (this.closed_) break block8;
                DatabaseConnection databaseConnection = this.statement_.getDatabaseConnection();
                DatabaseRequestAttributes databaseRequestAttributes = this.statement_.getRequestAttributes();
                databaseRequestAttributes.setCursorName(this.cursorName_);
                try {
                    databaseConnection.setCurrentRequestParameterBlockID(this.statement_.rpbID_);
                    databaseConnection.closeCursor(databaseRequestAttributes);
                }
                catch (IOException iOException) {
                    throw JDBCConnection.convertException(iOException, this.statement_.getLastSQLCode(), this.statement_.getLastSQLState());
                }
                this.closed_ = true;
                if (this.isMetadataResultSet_) {
                    this.statement_.close();
                }
            }
            finally {
                this.closed_ = true;
                this.statement_ = null;
                this.md_ = null;
            }
        }
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public int findColumn(String string) throws SQLException {
        int n;
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if ((n = this.md_.getColumnIndex(string) + 1) <= 0) {
            throw new SQLException("Column not found", "42703", -206);
        }
        return n;
    }

    @Override
    public boolean first() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public int getConcurrency() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 1007;
    }

    @Override
    public String getCursorName() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.cursorName_;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.fetchSize_;
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.md_;
    }

    @Override
    public int getRow() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.currentRow_;
    }

    @Override
    public Statement getStatement() throws SQLException {
        if (this.isMetadataResultSet_) {
            return null;
        }
        return this.statement_;
    }

    @Override
    public int getType() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return 1003;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return null;
    }

    @Override
    public void insertRow() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        throw new NotImplementedException();
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.currentRow_ <= 0;
    }

    @Override
    public boolean isFirst() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.currentRow_ == 1;
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean last() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean next() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (!(this.dataCache_.nextRow() < this.dataCache_.getNumRows() || this.fetch() && this.dataCache_.nextRow() < this.dataCache_.getNumRows())) {
            return false;
        }
        ++this.currentRow_;
        return true;
    }

    private boolean fetch() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.cursorName_ == null) {
            return false;
        }
        Message message = ((JDBCConnection)this.statement_.getConnection()).getLastWarningMessage();
        if (message != null && message.getID().equals("SQL0100")) {
            this.afterLast_ = true;
            return false;
        }
        DatabaseConnection databaseConnection = this.statement_.getDatabaseConnection();
        DatabaseRequestAttributes databaseRequestAttributes = this.statement_.getRequestAttributes();
        databaseRequestAttributes.setCursorName(this.cursorName_);
        databaseRequestAttributes.setFetchScrollOption(0, 0);
        databaseRequestAttributes.setVariableFieldCompression(232);
        if (this.fetchSize_ > 0) {
            databaseRequestAttributes.setBlockingFactor(this.fetchSize_);
        } else {
            databaseRequestAttributes.setFetchBufferSize(262144L);
        }
        try {
            databaseConnection.setCurrentRequestParameterBlockID(this.statement_.rpbID_);
            databaseConnection.fetch(databaseRequestAttributes, this);
            return true;
        }
        catch (IOException iOException) {
            throw JDBCConnection.convertException(iOException, this.statement_.getLastSQLCode(), this.statement_.getLastSQLState());
        }
    }

    @Override
    public boolean previous() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean relative(int n) throws SQLException {
        if (n < 0) {
            throw new SQLException("Result set is forward only.");
        }
        for (int i = 0; i < n; ++i) {
            if (this.next()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean rowInserted() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new NotImplementedException();
        }
    }

    @Override
    public void setFetchSize(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (n < 0) {
            throw new SQLException("Bad value for fetch size: " + n);
        }
        this.fetchSize_ = n;
    }

    @Override
    public void updateRow() throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.lastNull_;
    }

    @Override
    public Array getArray(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Array getArray(String string) throws SQLException {
        return this.getArray(this.findColumn(string));
    }

    @Override
    public InputStream getAsciiStream(int n) throws SQLException {
        try {
            String string = this.getString(n);
            if (string == null) {
                return null;
            }
            return new ByteArrayInputStream(string.getBytes("ISO8859_1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = JDBCError.getSQLException("07006");
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    @Override
    public InputStream getAsciiStream(String string) throws SQLException {
        return this.getAsciiStream(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n) throws SQLException {
        try {
            String string = this.getString(n);
            if (string == null) {
                return null;
            }
            return new BigDecimal(string.trim());
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006");
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string) throws SQLException {
        return this.getBigDecimal(this.findColumn(string));
    }

    @Override
    public BigDecimal getBigDecimal(int n, int n2) throws SQLException {
        try {
            if (n2 < 0) {
                SQLException sQLException = JDBCError.getSQLException("07006");
                throw sQLException;
            }
            String string = this.getString(n);
            if (string == null) {
                return null;
            }
            BigDecimal bigDecimal = new BigDecimal(string.trim());
            return bigDecimal.setScale(n2, 1);
        }
        catch (NumberFormatException numberFormatException) {
            SQLException sQLException = JDBCError.getSQLException("07006");
            sQLException.initCause(numberFormatException);
            throw sQLException;
        }
    }

    @Override
    public BigDecimal getBigDecimal(String string, int n) throws SQLException {
        return this.getBigDecimal(this.findColumn(string), n);
    }

    @Override
    public InputStream getBinaryStream(int n) throws SQLException {
        byte[] byArray = this.getBytes(n);
        return byArray == null ? null : new ByteArrayInputStream(byArray);
    }

    @Override
    public InputStream getBinaryStream(String string) throws SQLException {
        byte[] byArray = this.getBytes(string);
        return byArray == null ? null : new ByteArrayInputStream(byArray);
    }

    @Override
    public Blob getBlob(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToBlob(this.dataCache_.getData(), this.dataCache_.getRowOffset(), (JDBCConnection)this.statement_.getConnection());
    }

    @Override
    public Blob getBlob(String string) throws SQLException {
        return this.getBlob(this.findColumn(string));
    }

    @Override
    public boolean getBoolean(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return false;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToBoolean(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public boolean getBoolean(String string) throws SQLException {
        return this.getBoolean(this.findColumn(string));
    }

    @Override
    public byte getByte(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return 0;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToByte(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public byte getByte(String string) throws SQLException {
        return this.getByte(this.findColumn(string));
    }

    @Override
    public byte[] getBytes(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToOutputBytes(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public byte[] getBytes(String string) throws SQLException {
        return this.getBytes(this.findColumn(string));
    }

    @Override
    public Reader getCharacterStream(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        return new StringReader(string);
    }

    @Override
    public Reader getCharacterStream(String string) throws SQLException {
        return this.getCharacterStream(this.findColumn(string));
    }

    @Override
    public Clob getClob(int n) throws SQLException {
        if (this.closed_) {
            throw new SQLException("ResultSet closed");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToClob(this.dataCache_.getData(), this.dataCache_.getRowOffset(), (JDBCConnection)this.statement_.getConnection());
    }

    @Override
    public Clob getClob(String string) throws SQLException {
        if (this.closed_) {
            throw new SQLException("ResultSet closed");
        }
        if (this.dataCache_.isNull(this.md_.getColumnIndex(string))) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(string);
        return column.convertToClob(this.dataCache_.getData(), this.dataCache_.getRowOffset(), (JDBCConnection)this.statement_.getConnection());
    }

    @Override
    public Date getDate(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.getDate(n, ((JDBCConnection)this.statement_.getConnection()).getCalendar());
    }

    @Override
    public Date getDate(String string) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.getDate(string, ((JDBCConnection)this.statement_.getConnection()).getCalendar());
    }

    @Override
    public Date getDate(int n, Calendar calendar) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (calendar == null) {
            JDBCError.throwSQLException("07006");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToDate(this.dataCache_.getData(), this.dataCache_.getRowOffset(), calendar);
    }

    @Override
    public Date getDate(String string, Calendar calendar) throws SQLException {
        return this.getDate(this.findColumn(string), calendar);
    }

    @Override
    public double getDouble(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return 0.0;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToDouble(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public double getDouble(String string) throws SQLException {
        return this.getDouble(this.findColumn(string));
    }

    @Override
    public float getFloat(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return 0.0f;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToFloat(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public float getFloat(String string) throws SQLException {
        return this.getFloat(this.findColumn(string));
    }

    @Override
    public int getInt(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return 0;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToInt(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public int getInt(String string) throws SQLException {
        return this.getInt(this.findColumn(string));
    }

    @Override
    public long getLong(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return 0L;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToLong(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public long getLong(String string) throws SQLException {
        return this.getLong(this.findColumn(string));
    }

    @Override
    public Object getObject(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToObject(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public Object getObject(String string) throws SQLException {
        return this.getObject(this.findColumn(string));
    }

    public Object getObject(int n, Map map) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Ref getRef(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public Ref getRef(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public short getShort(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return 0;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToShort(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public short getShort(String string) throws SQLException {
        return this.getShort(this.findColumn(string));
    }

    @Override
    public String getString(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToString(this.dataCache_.getData(), this.dataCache_.getRowOffset());
    }

    @Override
    public String getString(String string) throws SQLException {
        return this.getString(this.findColumn(string));
    }

    @Override
    public Time getTime(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.getTime(n, ((JDBCConnection)this.statement_.getConnection()).getCalendar());
    }

    @Override
    public Time getTime(String string) throws SQLException {
        return this.getTime(this.findColumn(string));
    }

    @Override
    public Time getTime(int n, Calendar calendar) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (calendar == null) {
            JDBCError.throwSQLException("07006");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToTime(this.dataCache_.getData(), this.dataCache_.getRowOffset(), calendar);
    }

    @Override
    public Time getTime(String string, Calendar calendar) throws SQLException {
        return this.getTime(this.findColumn(string), calendar);
    }

    @Override
    public Timestamp getTimestamp(int n) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        return this.getTimestamp(n, ((JDBCConnection)this.statement_.getConnection()).getCalendar());
    }

    @Override
    public Timestamp getTimestamp(String string) throws SQLException {
        return this.getTimestamp(this.findColumn(string));
    }

    @Override
    public Timestamp getTimestamp(int n, Calendar calendar) throws SQLException {
        if (this.closed_) {
            JDBCError.throwSQLException("HY010");
        }
        if (calendar == null) {
            JDBCError.throwSQLException("07006");
        }
        if (this.dataCache_.isNull(n - 1)) {
            this.lastNull_ = true;
            return null;
        }
        this.lastNull_ = false;
        Column column = this.md_.getColumn(n - 1);
        return column.convertToTimestamp(this.dataCache_.getData(), this.dataCache_.getRowOffset(), calendar);
    }

    @Override
    public Timestamp getTimestamp(String string, Calendar calendar) throws SQLException {
        return this.getTimestamp(this.findColumn(string), calendar);
    }

    @Override
    public InputStream getUnicodeStream(int n) throws SQLException {
        String string = this.getString(n);
        try {
            return string == null ? null : new ByteArrayInputStream(string.getBytes("UTF-16"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException(unsupportedEncodingException.toString());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    @Override
    public InputStream getUnicodeStream(String string) throws SQLException {
        String string2 = this.getString(string);
        try {
            return string2 == null ? null : new ByteArrayInputStream(string2.getBytes("UTF-16"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            SQLException sQLException = new SQLException(unsupportedEncodingException.toString());
            sQLException.initCause(unsupportedEncodingException);
            throw sQLException;
        }
    }

    @Override
    public URL getURL(int n) throws SQLException {
        String string = this.getString(n);
        if (string == null) {
            return null;
        }
        try {
            return new URL(string);
        }
        catch (MalformedURLException malformedURLException) {
            SQLException sQLException = new SQLException("Data conversion error");
            sQLException.initCause(malformedURLException);
            throw sQLException;
        }
    }

    @Override
    public URL getURL(String string) throws SQLException {
        return this.getURL(this.findColumn(string));
    }

    @Override
    public void updateArray(int n, Array array) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateArray(String string, Array array) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBigDecimal(String string, BigDecimal bigDecimal) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(int n, Blob blob) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(String string, Blob blob) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBoolean(int n, boolean bl) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBoolean(String string, boolean bl) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateByte(int n, byte by) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateByte(String string, byte by) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBytes(int n, byte[] byArray) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBytes(String string, byte[] byArray) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(int n, Clob clob) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(String string, Clob clob) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateDate(int n, Date date) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateDate(String string, Date date) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateDouble(int n, double d) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateDouble(String string, double d) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateFloat(int n, float f) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateFloat(String string, float f) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateInt(int n, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateInt(String string, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateLong(int n, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateLong(String string, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNull(int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNull(String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateObject(int n, Object object) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateObject(String string, Object object) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateObject(int n, Object object, int n2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateObject(String string, Object object, int n) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateRef(int n, Ref ref) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateRef(String string, Ref ref) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateShort(int n, short s) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateShort(String string, short s) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateString(int n, String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateString(String string, String string2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateTime(int n, Time time) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateTime(String string, Time time) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateTimestamp(int n, Timestamp timestamp) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateTimestamp(String string, Timestamp timestamp) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        return this.statement_.getResultSetHoldability();
    }

    @Override
    public Reader getNCharacterStream(int n) throws SQLException {
        return this.getCharacterStream(n);
    }

    @Override
    public Reader getNCharacterStream(String string) throws SQLException {
        return this.getNCharacterStream(this.findColumn(string));
    }

    @Override
    public String getNString(int n) throws SQLException {
        return this.getString(n);
    }

    @Override
    public String getNString(String string) throws SQLException {
        return this.getNString(this.findColumn(string));
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed_;
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateAsciiStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(int n, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBinaryStream(String string, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(int n, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateBlob(String string, InputStream inputStream, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(int n, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(String string, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(int n, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateClob(String string, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNCharacterStream(int n, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNCharacterStream(String string, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(int n, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(String string, Reader reader) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(int n, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNClob(String string, Reader reader, long l) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNString(int n, String string) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public void updateNString(String string, String string2) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public boolean isWrapperFor(Class<?> clazz) throws SQLException {
        throw new NotImplementedException();
    }

    @Override
    public <T> T unwrap(Class<T> clazz) throws SQLException {
        throw new NotImplementedException();
    }

    public Object getObject(String string, Map map) throws SQLException {
        return this.getObject(this.findColumn(string), map);
    }
}

