/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jtopenlite.ddm;

import com.ibm.jtopenlite.ByteArrayKey;
import com.ibm.jtopenlite.Conv;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.HashMap;

public final class DDMField {
    public static final char TYPE_CHARACTER = 'A';
    public static final char TYPE_DBCS_EITHER = 'E';
    public static final char TYPE_DBCS_GRAPHIC = 'G';
    public static final char TYPE_DBCS_ONLY = 'J';
    public static final char TYPE_DBCS_OPEN = 'O';
    public static final char TYPE_BINARY = 'B';
    public static final char TYPE_FLOAT = 'F';
    public static final char TYPE_DECIMAL_FLOAT = '6';
    public static final char TYPE_HEXADECIMAL = 'H';
    public static final char TYPE_BINARY_CHARACTER = '5';
    public static final char TYPE_DATE = 'L';
    public static final char TYPE_PACKED_DECIMAL = 'P';
    public static final char TYPE_ZONED_DECIMAL = 'S';
    public static final char TYPE_TIME = 'T';
    public static final char TYPE_TIMESTAMP = 'Z';
    private final int offset_;
    private final String name_;
    private final int length_;
    private final int numDigits_;
    private final int decimalPositions_;
    private final String text_;
    private final char type_;
    private final String defaultValue_;
    private final int ccsid_;
    private final String variableLengthField_;
    private final int allocatedLength_;
    private final String allowNulls_;
    private final String dateTimeFormat_;
    private final String dateTimeSeparator_;
    private final char[] buffer_;
    private HashMap<ByteArrayKey, String> cache_;
    private final ByteArrayKey key_ = new ByteArrayKey();
    private final char[] buf2 = new char[2];

    DDMField(int n, String string, int n2, int n3, int n4, String string2, char c, String string3, int n5, String string4, int n6, String string5, String string6, String string7) {
        this.offset_ = n;
        this.name_ = string;
        this.length_ = n2;
        this.numDigits_ = n3;
        this.decimalPositions_ = n4;
        this.text_ = string2;
        this.type_ = c;
        this.defaultValue_ = string3;
        this.ccsid_ = n5;
        this.variableLengthField_ = string4;
        this.allocatedLength_ = n6;
        this.allowNulls_ = string5;
        this.dateTimeFormat_ = string6;
        this.dateTimeSeparator_ = string7;
        this.buffer_ = new char[this.length_ * 2 + 2];
    }

    public DDMField newCopy() {
        DDMField dDMField = new DDMField(this.offset_, this.name_, this.length_, this.numDigits_, this.decimalPositions_, this.text_, this.type_, this.defaultValue_, this.ccsid_, this.variableLengthField_, this.allocatedLength_, this.allowNulls_, this.dateTimeFormat_, this.dateTimeSeparator_);
        dDMField.setCacheStrings(this.isCacheStrings());
        return dDMField;
    }

    public String getName() {
        return this.name_;
    }

    public char getType() {
        return this.type_;
    }

    public int getLength() {
        return this.length_;
    }

    public int getOffset() {
        return this.offset_;
    }

    public String getText() {
        return this.text_;
    }

    public int getCCSID() {
        return this.ccsid_;
    }

    public String getDefaultValue() {
        return this.defaultValue_;
    }

    public boolean isVariableLength() {
        return this.variableLengthField_.equals("Y");
    }

    public boolean isNullAllowed() {
        return this.allowNulls_.equals("Y");
    }

    public int getAllocatedLength() {
        return this.allocatedLength_;
    }

    public int getNumberOfDigits() {
        return this.numDigits_;
    }

    public int getDecimalPositions() {
        return this.decimalPositions_;
    }

    public String getDateTimeFormat() {
        return this.dateTimeFormat_;
    }

    public String getDateTimeSeparator() {
        return this.dateTimeSeparator_;
    }

    public boolean isCacheStrings() {
        return this.cache_ != null;
    }

    public void setCacheStrings(boolean bl) {
        this.cache_ = bl ? new HashMap() : null;
    }

    public long getLong(byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'B': {
                if (this.numDigits_ < 5) {
                    return Conv.byteArrayToShort(byArray, this.offset_);
                }
                if (this.numDigits_ < 10) {
                    return Conv.byteArrayToInt(byArray, this.offset_);
                }
                return Conv.byteArrayToLong(byArray, this.offset_);
            }
            case 'F': {
                if (this.length_ == 4) {
                    return (long)Conv.byteArrayToFloat(byArray, this.offset_);
                }
                return (long)Conv.byteArrayToDouble(byArray, this.offset_);
            }
            case '6': {
                if (this.length_ == 8) {
                    String string = Conv.decfloat16ByteArrayToString(byArray, this.offset_);
                    return new BigDecimal(string).longValue();
                }
                String string = Conv.decfloat34ByteArrayToString(byArray, this.offset_);
                return new BigDecimal(string).longValue();
            }
        }
        return Long.parseLong(this.getString(byArray));
    }

    public short getShort(byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'B': {
                if (this.numDigits_ < 5) {
                    return Conv.byteArrayToShort(byArray, this.offset_);
                }
                if (this.numDigits_ < 10) {
                    return (short)Conv.byteArrayToInt(byArray, this.offset_);
                }
                return (short)Conv.byteArrayToLong(byArray, this.offset_);
            }
            case 'F': {
                if (this.length_ == 4) {
                    return (short)Conv.byteArrayToFloat(byArray, this.offset_);
                }
                return (short)Conv.byteArrayToDouble(byArray, this.offset_);
            }
            case '6': {
                if (this.length_ == 8) {
                    String string = Conv.decfloat16ByteArrayToString(byArray, this.offset_);
                    return (short)new BigDecimal(string).intValue();
                }
                String string = Conv.decfloat34ByteArrayToString(byArray, this.offset_);
                return (short)new BigDecimal(string).intValue();
            }
        }
        return Short.parseShort(this.getString(byArray));
    }

    public int getInt(byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'B': {
                if (this.numDigits_ < 5) {
                    return Conv.byteArrayToShort(byArray, this.offset_);
                }
                if (this.numDigits_ < 10) {
                    return Conv.byteArrayToInt(byArray, this.offset_);
                }
                return (int)Conv.byteArrayToLong(byArray, this.offset_);
            }
            case 'F': {
                if (this.length_ == 4) {
                    return (int)Conv.byteArrayToFloat(byArray, this.offset_);
                }
                return (int)Conv.byteArrayToDouble(byArray, this.offset_);
            }
            case '6': {
                if (this.length_ == 8) {
                    String string = Conv.decfloat16ByteArrayToString(byArray, this.offset_);
                    return new BigDecimal(string).intValue();
                }
                String string = Conv.decfloat34ByteArrayToString(byArray, this.offset_);
                return new BigDecimal(string).intValue();
            }
        }
        return Integer.parseInt(this.getString(byArray));
    }

    public byte getByte(byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'B': {
                if (this.numDigits_ < 5) {
                    return (byte)Conv.byteArrayToShort(byArray, this.offset_);
                }
                if (this.numDigits_ < 10) {
                    return (byte)Conv.byteArrayToInt(byArray, this.offset_);
                }
                return (byte)Conv.byteArrayToLong(byArray, this.offset_);
            }
            case 'F': {
                if (this.length_ == 4) {
                    return (byte)Conv.byteArrayToFloat(byArray, this.offset_);
                }
                return (byte)Conv.byteArrayToDouble(byArray, this.offset_);
            }
            case '6': {
                if (this.length_ == 8) {
                    String string = Conv.decfloat16ByteArrayToString(byArray, this.offset_);
                    return (byte)new BigDecimal(string).intValue();
                }
                String string = Conv.decfloat34ByteArrayToString(byArray, this.offset_);
                return (byte)new BigDecimal(string).intValue();
            }
        }
        return Byte.parseByte(this.getString(byArray));
    }

    public byte[] getBytes(byte[] byArray) throws IOException {
        boolean bl = this.isVariableLength();
        int n = bl ? this.length_ - 2 : this.length_;
        int n2 = bl ? this.offset_ + 2 : this.offset_;
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, n2, byArray2, 0, n);
        return byArray2;
    }

    public void setBytes(byte[] byArray, byte[] byArray2) throws IOException {
        boolean bl = this.isVariableLength();
        int n = bl ? this.length_ - 2 : this.length_;
        int n2 = bl ? this.offset_ + 2 : this.offset_;
        int n3 = byArray.length;
        int n4 = n3 < n ? n3 : n;
        System.arraycopy(byArray, 0, byArray2, n2, n4);
        if (bl) {
            Conv.shortToByteArray(n4, byArray2, this.offset_);
        } else if (n3 < n) {
            int n5 = n - n3;
            int n6 = n2 + n4;
            for (int i = 0; i < n5; ++i) {
                byArray2[n6++] = 0;
            }
        }
    }

    private String lookup(byte[] byArray) {
        this.key_.setHashData(byArray, this.offset_, this.length_);
        return this.cache_.get(this.key_);
    }

    private void cache(byte[] byArray, String string) {
        byte[] byArray2 = new byte[this.length_];
        System.arraycopy(byArray, this.offset_, byArray2, 0, this.length_);
        this.cache_.put(new ByteArrayKey(byArray2), string);
    }

    public float getFloat(byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'B': {
                if (this.numDigits_ < 5) {
                    return Conv.byteArrayToShort(byArray, this.offset_);
                }
                if (this.numDigits_ < 10) {
                    return Conv.byteArrayToInt(byArray, this.offset_);
                }
                return Conv.byteArrayToLong(byArray, this.offset_);
            }
            case 'F': {
                if (this.length_ == 4) {
                    return Conv.byteArrayToFloat(byArray, this.offset_);
                }
                return (float)Conv.byteArrayToDouble(byArray, this.offset_);
            }
            case '6': {
                if (this.length_ == 8) {
                    String string = Conv.decfloat16ByteArrayToString(byArray, this.offset_);
                    return new BigDecimal(string).floatValue();
                }
                String string = Conv.decfloat34ByteArrayToString(byArray, this.offset_);
                return new BigDecimal(string).floatValue();
            }
        }
        return Float.parseFloat(this.getString(byArray));
    }

    public double getDouble(byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'B': {
                if (this.numDigits_ < 5) {
                    return Conv.byteArrayToShort(byArray, this.offset_);
                }
                if (this.numDigits_ < 10) {
                    return Conv.byteArrayToInt(byArray, this.offset_);
                }
                return Conv.byteArrayToLong(byArray, this.offset_);
            }
            case 'F': {
                if (this.length_ == 4) {
                    return Conv.byteArrayToFloat(byArray, this.offset_);
                }
                return Conv.byteArrayToDouble(byArray, this.offset_);
            }
            case '6': {
                if (this.length_ == 8) {
                    String string = Conv.decfloat16ByteArrayToString(byArray, this.offset_);
                    return new BigDecimal(string).doubleValue();
                }
                String string = Conv.decfloat34ByteArrayToString(byArray, this.offset_);
                return new BigDecimal(string).doubleValue();
            }
        }
        return Double.parseDouble(this.getString(byArray));
    }

    public String getString(byte[] byArray) throws IOException {
        String string;
        boolean bl = this.cache_ != null;
        String string2 = string = bl ? this.lookup(byArray) : null;
        if (string == null) {
            switch (this.type_) {
                case '1': 
                case '3': {
                    throw new IOException("LOB data not allowed");
                }
                case '4': {
                    throw new IOException("DATALINK data not allowed");
                }
                case 'A': 
                case 'E': 
                case 'G': 
                case 'J': 
                case 'O': {
                    boolean bl2 = this.isVariableLength();
                    int n = bl2 ? Conv.byteArrayToShort(byArray, this.offset_) * (this.type_ == 'G' ? 2 : 1) : this.length_;
                    int n2 = bl2 ? this.offset_ + 2 : this.offset_;
                    string = Conv.ebcdicByteArrayToString(byArray, n2, n, this.buffer_, this.ccsid_);
                    break;
                }
                case 'B': {
                    if (this.numDigits_ < 5) {
                        string = String.valueOf(Conv.byteArrayToShort(byArray, this.offset_));
                        break;
                    }
                    if (this.numDigits_ < 10) {
                        string = String.valueOf(Conv.byteArrayToInt(byArray, this.offset_));
                        break;
                    }
                    string = String.valueOf(Conv.byteArrayToLong(byArray, this.offset_));
                    break;
                }
                case 'F': {
                    if (this.length_ == 4) {
                        string = String.valueOf(Conv.byteArrayToFloat(byArray, this.offset_));
                        break;
                    }
                    string = String.valueOf(Conv.byteArrayToDouble(byArray, this.offset_));
                    break;
                }
                case '6': {
                    if (this.length_ == 8) {
                        string = Conv.decfloat16ByteArrayToString(byArray, this.offset_);
                        break;
                    }
                    string = Conv.decfloat34ByteArrayToString(byArray, this.offset_);
                    break;
                }
                case '5': 
                case 'H': {
                    boolean bl3 = this.isVariableLength();
                    int n = bl3 ? (int)Conv.byteArrayToShort(byArray, this.offset_) : this.length_;
                    int n3 = bl3 ? this.offset_ + 2 : this.offset_;
                    string = Conv.bytesToHexString(byArray, n3, n, this.buffer_);
                    break;
                }
                case 'L': {
                    string = Conv.ebcdicByteArrayToString(byArray, this.offset_, this.length_, this.buffer_);
                    break;
                }
                case 'P': {
                    string = Conv.packedDecimalToString(byArray, this.offset_, this.numDigits_, this.decimalPositions_, this.buffer_);
                    break;
                }
                case 'S': {
                    string = Conv.zonedDecimalToString(byArray, this.offset_, this.numDigits_, this.decimalPositions_, this.buffer_);
                    break;
                }
                case 'T': {
                    string = Conv.ebcdicByteArrayToString(byArray, this.offset_, this.length_, this.buffer_);
                    break;
                }
                case 'Z': {
                    string = Conv.ebcdicByteArrayToString(byArray, this.offset_, this.length_, this.buffer_);
                    break;
                }
                default: {
                    throw new IOException("Unhandled field type: '" + this.type_ + "'");
                }
            }
            if (bl) {
                this.cache(byArray, string);
            }
        }
        return string;
    }

    public boolean getDate(byte[] byArray, Calendar calendar) throws IOException {
        switch (this.type_) {
            case 'L': {
                if (this.dateTimeFormat_ == null || !this.dateTimeFormat_.equals("*ISO")) break;
                String string = this.getString(byArray);
                int n = Integer.parseInt(string.substring(0, 4));
                int n2 = Integer.parseInt(string.substring(5, 7));
                int n3 = Integer.parseInt(string.substring(8, 10));
                calendar.set(1, n);
                calendar.set(2, n2 - 1);
                calendar.set(5, n3);
                return true;
            }
            case 'T': {
                if (this.dateTimeFormat_ == null || !this.dateTimeFormat_.equals("*ISO")) break;
                String string = this.getString(byArray);
                int n = Integer.parseInt(string.substring(0, 2));
                int n4 = Integer.parseInt(string.substring(3, 5));
                int n5 = Integer.parseInt(string.substring(6, 8));
                calendar.set(11, n);
                calendar.set(12, n4);
                calendar.set(13, n5);
                return true;
            }
            case 'Z': {
                String string = this.getString(byArray);
                int n = Integer.parseInt(string.substring(0, 4));
                int n6 = Integer.parseInt(string.substring(5, 7));
                int n7 = Integer.parseInt(string.substring(8, 10));
                int n8 = Integer.parseInt(string.substring(11, 13));
                int n9 = Integer.parseInt(string.substring(14, 16));
                int n10 = Integer.parseInt(string.substring(17, 19));
                int n11 = Integer.parseInt(string.substring(20, 23));
                calendar.set(1, n);
                calendar.set(2, n6 - 1);
                calendar.set(5, n7);
                calendar.set(11, n8);
                calendar.set(12, n9);
                calendar.set(13, n10);
                calendar.set(14, n11);
                return true;
            }
        }
        return false;
    }

    public void setDate(Calendar calendar, byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'L': {
                if (this.dateTimeFormat_ != null && this.dateTimeFormat_.equals("*ISO")) {
                    int n = calendar.get(1);
                    int n2 = calendar.get(2) + 1;
                    int n3 = calendar.get(5);
                    String string = n + "-" + this.get2(n2) + "-" + this.get2(n3);
                    Conv.stringToEBCDICByteArray37(string, byArray, this.offset_);
                    break;
                }
                throw new IOException("Unhandled date/time format: '" + this.dateTimeFormat_ + "'");
            }
            case 'T': {
                if (this.dateTimeFormat_ != null && this.dateTimeFormat_.equals("*ISO")) {
                    int n = calendar.get(11);
                    int n4 = calendar.get(12);
                    int n5 = calendar.get(13);
                    String string = this.get2(n) + "." + this.get2(n4) + "." + this.get2(n5);
                    Conv.stringToEBCDICByteArray37(string, byArray, this.offset_);
                    break;
                }
                throw new IOException("Unhandled date/time format: '" + this.dateTimeFormat_ + "'");
            }
            case 'Z': {
                int n = calendar.get(1);
                int n6 = calendar.get(2) + 1;
                int n7 = calendar.get(5);
                int n8 = calendar.get(11);
                int n9 = calendar.get(12);
                int n10 = calendar.get(13);
                int n11 = calendar.get(14);
                String string = n + "-" + this.get2(n6) + "-" + this.get2(n7) + "." + this.get2(n8) + "." + this.get2(n9) + "." + this.get2(n10) + ".";
                if (n11 < 100) {
                    string = string + "0";
                }
                if (n11 < 10) {
                    string = string + "0";
                }
                string = string + n11;
                string = string + "000";
                Conv.stringToEBCDICByteArray37(string, byArray, this.offset_);
                break;
            }
            default: {
                throw new IOException("Unhandled field type: '" + this.type_ + "'");
            }
        }
    }

    private String get2(int n) {
        this.buf2[0] = (char)(n > 10 ? n / 10 + 48 : 48);
        this.buf2[1] = (char)(n % 10 + 48);
        return new String(this.buf2);
    }

    public void setString(String string, byte[] byArray) throws IOException {
        boolean bl = this.isVariableLength();
        int n = bl ? this.offset_ + 2 : this.offset_;
        switch (this.type_) {
            case '1': 
            case '3': {
                throw new IOException("LOB data not allowed");
            }
            case '4': {
                throw new IOException("DATALINK data not allowed");
            }
            case 'A': 
            case 'E': 
            case 'G': 
            case 'J': 
            case 'O': {
                if (bl) {
                    int n2 = Conv.stringToEBCDICByteArray(string, byArray, n, this.ccsid_);
                    if (this.type_ == 'G') {
                        n2 >>= 1;
                    }
                    Conv.shortToByteArray(n2, byArray, this.offset_);
                    break;
                }
                int n3 = this.type_ == 'G' ? this.length_ * 2 : this.length_;
                Conv.stringToBlankPadEBCDICByteArray(string, byArray, n, n3, this.ccsid_);
                break;
            }
            case 'B': {
                if (this.numDigits_ < 5) {
                    short s = Short.parseShort(string);
                    Conv.shortToByteArray(s, byArray, this.offset_);
                    break;
                }
                if (this.numDigits_ < 10) {
                    int n4 = Integer.parseInt(string);
                    Conv.intToByteArray(n4, byArray, this.offset_);
                    break;
                }
                long l = Long.parseLong(string);
                Conv.longToByteArray(l, byArray, this.offset_);
                break;
            }
            case 'F': {
                if (this.length_ == 4) {
                    float f = Float.parseFloat(string);
                    Conv.floatToByteArray(f, byArray, this.offset_);
                    break;
                }
                double d = Double.parseDouble(string);
                Conv.doubleToByteArray(d, byArray, this.offset_);
                break;
            }
            case '5': 
            case 'H': {
                int n5 = Conv.hexStringToBytes(string, byArray, n);
                if (!bl) break;
                Conv.shortToByteArray(n5, byArray, this.offset_);
                break;
            }
            case 'L': 
            case 'T': 
            case 'Z': {
                Conv.stringToEBCDICByteArray37(string, byArray, this.offset_);
                break;
            }
            case 'P': {
                Conv.stringToPackedDecimal(string, this.numDigits_, byArray, this.offset_);
                break;
            }
            case 'S': {
                Conv.stringToZonedDecimal(string, this.numDigits_, byArray, this.offset_);
                break;
            }
            default: {
                throw new IOException("Unhandled field type: '" + this.type_ + "'");
            }
        }
    }

    public void setDouble(double d, byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'A': 
            case 'E': 
            case 'G': 
            case 'J': 
            case 'O': {
                String string = String.valueOf(d);
                if (this.isVariableLength()) {
                    int n = Conv.stringToEBCDICByteArray(string, byArray, this.offset_ + 2, this.ccsid_);
                    if (this.type_ == 'G') {
                        n >>= 1;
                    }
                    Conv.shortToByteArray(n, byArray, this.offset_);
                    break;
                }
                int n = this.type_ == 'G' ? this.length_ * 2 : this.length_;
                Conv.stringToBlankPadEBCDICByteArray(string, byArray, this.offset_, n, this.ccsid_);
                break;
            }
            case 'B': {
                if (this.numDigits_ < 5) {
                    Conv.shortToByteArray((short)d, byArray, this.offset_);
                    break;
                }
                if (this.numDigits_ < 10) {
                    Conv.intToByteArray((int)d, byArray, this.offset_);
                    break;
                }
                Conv.longToByteArray((long)d, byArray, this.offset_);
                break;
            }
            case 'F': {
                if (this.length_ == 4) {
                    Conv.floatToByteArray((float)d, byArray, this.offset_);
                    break;
                }
                Conv.doubleToByteArray(d, byArray, this.offset_);
                break;
            }
            default: {
                throw new IOException("Unhandled field type: '" + this.type_ + "'");
            }
        }
    }

    public void setFloat(float f, byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'A': 
            case 'E': 
            case 'G': 
            case 'J': 
            case 'O': {
                String string = String.valueOf(f);
                if (this.isVariableLength()) {
                    int n = Conv.stringToEBCDICByteArray(string, byArray, this.offset_ + 2, this.ccsid_);
                    if (this.type_ == 'G') {
                        n >>= 1;
                    }
                    Conv.shortToByteArray(n, byArray, this.offset_);
                    break;
                }
                int n = this.type_ == 'G' ? this.length_ * 2 : this.length_;
                Conv.stringToBlankPadEBCDICByteArray(string, byArray, this.offset_, n, this.ccsid_);
                break;
            }
            case 'B': {
                if (this.numDigits_ < 5) {
                    Conv.shortToByteArray((short)f, byArray, this.offset_);
                    break;
                }
                if (this.numDigits_ < 10) {
                    Conv.intToByteArray((int)f, byArray, this.offset_);
                    break;
                }
                Conv.longToByteArray((long)f, byArray, this.offset_);
                break;
            }
            case 'F': {
                if (this.length_ == 4) {
                    Conv.floatToByteArray(f, byArray, this.offset_);
                    break;
                }
                Conv.doubleToByteArray(f, byArray, this.offset_);
                break;
            }
            default: {
                throw new IOException("Unhandled field type: '" + this.type_ + "'");
            }
        }
    }

    public void setByte(byte by, byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'A': 
            case 'E': 
            case 'G': 
            case 'J': 
            case 'O': {
                String string = String.valueOf(by);
                if (this.isVariableLength()) {
                    int n = Conv.stringToEBCDICByteArray(string, byArray, this.offset_ + 2, this.ccsid_);
                    if (this.type_ == 'G') {
                        n >>= 1;
                    }
                    Conv.shortToByteArray(n, byArray, this.offset_);
                    break;
                }
                int n = this.type_ == 'G' ? this.length_ * 2 : this.length_;
                Conv.stringToBlankPadEBCDICByteArray(string, byArray, this.offset_, n, this.ccsid_);
                break;
            }
            case 'B': {
                if (this.numDigits_ < 5) {
                    Conv.shortToByteArray(by, byArray, this.offset_);
                    break;
                }
                if (this.numDigits_ < 10) {
                    Conv.intToByteArray(by, byArray, this.offset_);
                    break;
                }
                Conv.longToByteArray(by, byArray, this.offset_);
                break;
            }
            case 'F': {
                if (this.length_ == 4) {
                    Conv.floatToByteArray(by, byArray, this.offset_);
                    break;
                }
                Conv.doubleToByteArray(by, byArray, this.offset_);
                break;
            }
            default: {
                throw new IOException("Unhandled field type: '" + this.type_ + "'");
            }
        }
    }

    public void setShort(short s, byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'A': 
            case 'E': 
            case 'G': 
            case 'J': 
            case 'O': {
                String string = String.valueOf(s);
                if (this.isVariableLength()) {
                    int n = Conv.stringToEBCDICByteArray(string, byArray, this.offset_ + 2, this.ccsid_);
                    if (this.type_ == 'G') {
                        n >>= 1;
                    }
                    Conv.shortToByteArray(n, byArray, this.offset_);
                    break;
                }
                int n = this.type_ == 'G' ? this.length_ * 2 : this.length_;
                Conv.stringToBlankPadEBCDICByteArray(string, byArray, this.offset_, n, this.ccsid_);
                break;
            }
            case 'B': {
                if (this.numDigits_ < 5) {
                    Conv.shortToByteArray(s, byArray, this.offset_);
                    break;
                }
                if (this.numDigits_ < 10) {
                    Conv.intToByteArray(s, byArray, this.offset_);
                    break;
                }
                Conv.longToByteArray(s, byArray, this.offset_);
                break;
            }
            case 'F': {
                if (this.length_ == 4) {
                    Conv.floatToByteArray(s, byArray, this.offset_);
                    break;
                }
                Conv.doubleToByteArray(s, byArray, this.offset_);
                break;
            }
            default: {
                throw new IOException("Unhandled field type: '" + this.type_ + "'");
            }
        }
    }

    public void setInt(int n, byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'A': 
            case 'E': 
            case 'G': 
            case 'J': 
            case 'O': {
                String string = String.valueOf(n);
                if (this.isVariableLength()) {
                    int n2 = this.type_ == 'G' ? this.length_ * 2 : this.length_;
                    int n3 = Conv.stringToEBCDICByteArray(string, byArray, this.offset_ + 2, this.ccsid_);
                    if (this.type_ == 'G') {
                        n3 >>= 1;
                    }
                    Conv.shortToByteArray(n3, byArray, this.offset_);
                    break;
                }
                int n4 = this.type_ == 'G' ? this.length_ * 2 : this.length_;
                Conv.stringToBlankPadEBCDICByteArray(string, byArray, this.offset_, n4, this.ccsid_);
                break;
            }
            case 'B': {
                if (this.numDigits_ < 5) {
                    Conv.shortToByteArray((short)n, byArray, this.offset_);
                    break;
                }
                if (this.numDigits_ < 10) {
                    Conv.intToByteArray(n, byArray, this.offset_);
                    break;
                }
                Conv.longToByteArray(n, byArray, this.offset_);
                break;
            }
            case 'F': {
                if (this.length_ == 4) {
                    Conv.floatToByteArray(n, byArray, this.offset_);
                    break;
                }
                Conv.doubleToByteArray(n, byArray, this.offset_);
                break;
            }
            default: {
                throw new IOException("Unhandled field type: '" + this.type_ + "'");
            }
        }
    }

    public void setLong(long l, byte[] byArray) throws IOException {
        switch (this.type_) {
            case 'A': 
            case 'E': 
            case 'G': 
            case 'J': 
            case 'O': {
                String string = String.valueOf(l);
                if (this.isVariableLength()) {
                    int n = Conv.stringToEBCDICByteArray(string, byArray, this.offset_ + 2, this.ccsid_);
                    if (this.type_ == 'G') {
                        n >>= 1;
                    }
                    Conv.shortToByteArray(n, byArray, this.offset_);
                    break;
                }
                int n = this.type_ == 'G' ? this.length_ * 2 : this.length_;
                Conv.stringToBlankPadEBCDICByteArray(string, byArray, this.offset_, n, this.ccsid_);
                break;
            }
            case 'B': {
                if (this.numDigits_ < 5) {
                    Conv.shortToByteArray((short)l, byArray, this.offset_);
                    break;
                }
                if (this.numDigits_ < 10) {
                    Conv.intToByteArray((int)l, byArray, this.offset_);
                    break;
                }
                Conv.longToByteArray(l, byArray, this.offset_);
                break;
            }
            case 'F': {
                if (this.length_ == 4) {
                    Conv.floatToByteArray(l, byArray, this.offset_);
                    break;
                }
                Conv.doubleToByteArray(l, byArray, this.offset_);
                break;
            }
            default: {
                throw new IOException("Unhandled field type: '" + this.type_ + "'");
            }
        }
    }
}

