/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.impl.queues;

import com.solacesystems.jcsmp.impl.flow.FlowHandle;
import com.solacesystems.jcsmp.impl.queues.AppAckRangeCache;
import com.solacesystems.jcsmp.protocol.smf.AssuredCtrlHeaderBean;
import com.solacesystems.jcsmp.protocol.smf.impl.TlvParameterFactoryAssuredCtrl;
import java.util.concurrent.locks.ReentrantLock;

public abstract class AbstractUnackedMessageList {
    protected FlowHandle flowHandle;
    protected ReentrantLock rLock;

    public abstract boolean hasUnsentAcks();

    public abstract void sendAcks(String var1, boolean var2);

    public abstract void sendCloseAcks(String var1, boolean var2);

    public abstract EAppAckResult applicationAck(long var1, boolean var3);

    public abstract EAddResult add(long var1);

    public abstract int getWindowSize();

    public abstract UnackedMessageListInfo getCurrentUnackedMessageListInfo();

    protected void tpAddApplicationAck(AssuredCtrlHeaderBean aBean, long first, long last) {
        TlvParameterFactoryAssuredCtrl.instance().addApplicationAck(aBean, first, last);
    }

    public void tpAddApplicationAcks(AssuredCtrlHeaderBean aBean, AppAckRangeCache cache) {
        int offset = cache.getTmpOffset();
        long[] tmpranges = cache.getTmpRanges();
        int i = 0;
        while (i < offset) {
            long a = tmpranges[i++];
            long b = tmpranges[i++];
            this.tpAddApplicationAck(aBean, a, b);
        }
    }

    public AbstractUnackedMessageList(FlowHandle flow) {
        this.flowHandle = flow;
        this.rLock = new ReentrantLock();
    }

    public abstract void clear();

    public abstract boolean isKnownAppAcked(long var1);

    public void setAckThreshold(int threshold) {
    }

    public static final class MessageAckInfo {
        public long msgId;
        public boolean appAcked;
        public boolean ackSent;

        public MessageAckInfo(long msgId) {
            this.msgId = msgId;
            this.appAcked = false;
            this.ackSent = false;
        }

        public boolean isAppAcked() {
            return this.appAcked;
        }

        public void setAppAcked(boolean acked) {
            this.appAcked = acked;
        }

        public boolean isAckSent() {
            return this.ackSent;
        }

        public void setAckSent(boolean ackSent) {
            this.ackSent = ackSent;
        }

        public String toString() {
            return "id=" + this.msgId + " applAcked=" + this.appAcked;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof MessageAckInfo)) {
                return false;
            }
            MessageAckInfo info = (MessageAckInfo)o;
            return info.msgId == this.msgId && info.appAcked == this.appAcked && info.ackSent == this.ackSent;
        }

        public int hashCode() {
            return 4 * Long.valueOf(this.msgId).hashCode() + 2 * Boolean.valueOf(this.appAcked).hashCode() + Boolean.valueOf(this.ackSent).hashCode();
        }
    }

    public static enum EAppAckResult {
        OK,
        NOT_FOUND,
        DUPLICATE_ACK;

    }

    public static enum EAddResult {
        OK,
        DUPLICATE;

    }

    public static final class UnackedMessageListInfo {
        private long lastInOrderTpMsgId;
        private int windowSize;

        public long getLastInOrderTpMsgId() {
            return this.lastInOrderTpMsgId;
        }

        public void setLastInOrderTpMsgId(long msgId) {
            this.lastInOrderTpMsgId = msgId;
        }

        public int getWindowSize() {
            return this.windowSize;
        }

        public void setWindowSize(int winSize) {
            this.windowSize = winSize;
        }
    }
}

