/*
 * Decompiled with CFR 0.152.
 */
package com.solacesystems.jcsmp.protocol;

import com.solacesystems.jcsmp.impl.WireMessageEncoder;
import com.solacesystems.jcsmp.protocol.HeaderDescriptionBean;
import com.solacesystems.jcsmp.protocol.smf.SMFHeaderBean;

public class WireMessage {
    private SMFHeaderBean smfHeader;
    private HeaderDescriptionBean headerBean = null;
    private byte[] payload;
    private boolean sentFlag;
    private long rxTimestamp;
    private String friendlyName;
    public Object userDebugInfo;
    public Long serialNumber;
    public WireMessageEncoder encoder;
    private boolean sessionTag;

    public WireMessage() {
        this.reset();
    }

    public void reset() {
        this.headerBean = null;
        this.payload = new byte[0];
        this.sentFlag = false;
        this.smfHeader = null;
        this.rxTimestamp = 0L;
        this.friendlyName = "";
        this.userDebugInfo = null;
        this.serialNumber = null;
        this.sessionTag = false;
    }

    public HeaderDescriptionBean getHeaderBean() {
        return this.headerBean;
    }

    public WireMessage addHeaderBean(HeaderDescriptionBean h) {
        assert (!(h instanceof SMFHeaderBean));
        assert (this.headerBean == null);
        this.headerBean = h;
        return this;
    }

    public SMFHeaderBean getSmfHeader() {
        return this.smfHeader;
    }

    public WireMessage setSmfHeader(SMFHeaderBean smfHeader) {
        this.smfHeader = smfHeader;
        return this;
    }

    public int getMsgLen() {
        return this.smfHeader.getMsgTotalLenWithHeader();
    }

    public byte[] getPayload() {
        return this.payload;
    }

    public WireMessage setPayload(byte[] payload) {
        this.payload = payload;
        return this;
    }

    public boolean isSessionTag() {
        return this.sessionTag;
    }

    public void setSessionTag(boolean v) {
        this.sessionTag = v;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("Prtcl=" + this.getSmfHeader().getProtocol() + "; SMFHeader=[" + this.getSmfHeader() + "]; HeaderBean=[" + this.headerBean + "]; Payload=" + this.payload.length + "B");
        return buf.toString();
    }

    public boolean isSentFlag() {
        return this.sentFlag;
    }

    public void setSentFlag(boolean sentFlag) {
        this.sentFlag = sentFlag;
    }

    public boolean isUnknownProtocol() {
        SMFHeaderBean hdr = this.getSmfHeader();
        if (hdr != null) {
            return hdr.isUnknownProtocol();
        }
        return false;
    }

    public long getRxTimestamp() {
        return this.rxTimestamp;
    }

    public void setRxTimestamp(long rxTimestamp) {
        this.rxTimestamp = rxTimestamp;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }
}

