/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.security;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.util.Random;
import javax.wbem.cim.CIMException;

public class SecurityUtil {
    private static final int RANDOM_KEYSIZE = 20;
    public static final String ADMIN = "root";
    public static SecureRandom secrand = new SecureRandom(SecurityUtil.getSeed());
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static void incByteArray(byte[] bArray) {
        if (bArray == null) {
            return;
        }
        for (int i = 0; i < bArray.length; ++i) {
            byte temp = bArray[i];
            bArray[i] = (byte)(temp + 1);
            if (bArray[i] != 0) break;
        }
    }

    private static synchronized byte[] getSeed() {
        byte[] kb1 = new byte[20];
        byte[] kb2 = new byte[20];
        byte[] seed = new byte[20];
        long time = System.currentTimeMillis();
        Random seeder = new Random(time);
        seeder.nextBytes(kb1);
        seeder.nextBytes(kb2);
        time = System.currentTimeMillis();
        long mask = 1L;
        long test = 0L;
        for (int i = 0; i < 20; ++i) {
            test = time & mask;
            seed[i] = test > 0L ? kb1[i] : kb2[i];
            mask <<= 1;
        }
        return seed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] hashData(byte[] src, byte[] hash) {
        int i;
        if (hash == null || src == null) {
            throw new IllegalArgumentException();
        }
        if (hash.length < 4) {
            return null;
        }
        byte[] randomPad = new byte[hash.length];
        SecureRandom secureRandom = secrand;
        synchronized (secureRandom) {
            secrand.nextBytes(randomPad);
        }
        int numRep = src.length / hash.length + 1;
        byte[] dest = new byte[(numRep + 1) * hash.length];
        for (i = 0; i < 4; ++i) {
            dest[i] = (byte)(hash[i] ^ (src.length & 255 << 8 * i) >> 8 * i);
        }
        while (i < hash.length) {
            dest[i] = randomPad[i];
            ++i;
        }
        SecureRandom secureRandom2 = secrand;
        synchronized (secureRandom2) {
            secrand.nextBytes(randomPad);
        }
        int k = 0;
        for (i = 0; i < numRep; ++i) {
            for (int j = 0; j < hash.length && k < src.length; ++k, ++j) {
                dest[k + hash.length] = (byte)(hash[j] ^ src[k]);
            }
        }
        k += hash.length;
        i = 0;
        while (k < dest.length) {
            dest[k] = randomPad[i];
            ++i;
            ++k;
        }
        return dest;
    }

    public static byte[] extractHashedData(byte[] src, byte[] hash) {
        int i;
        if (src == null || hash == null) {
            throw new IllegalArgumentException();
        }
        int size = 0;
        for (i = 0; i < 4; ++i) {
            int tempByte = src[i] ^ hash[i];
            size += tempByte << 8 * i;
        }
        if (size > src.length - hash.length || size < src.length - 2 * hash.length) {
            return null;
        }
        if (size < 0) {
            return null;
        }
        byte[] dest = new byte[size];
        i = hash.length;
        int fullsize = size + i;
        while (i < fullsize) {
            for (int j = 0; j < hash.length && i < fullsize; ++i, ++j) {
                dest[i - hash.length] = (byte)(src[i] ^ hash[j]);
            }
        }
        return dest;
    }

    public static byte[] generateSerialized(Object[] objs) throws CIMException {
        byte[] bytes;
        ObjectOutputStream oos;
        ByteArrayOutputStream bas;
        try {
            bas = new ByteArrayOutputStream(2048);
            oos = new ObjectOutputStream(bas);
        }
        catch (IOException ex) {
            throw new CIMException("Cannot initialize output stream");
        }
        for (int i = 0; i < objs.length; ++i) {
            try {
                oos.writeObject(objs[i]);
                continue;
            }
            catch (Exception ex) {
                throw new CIMException("Cannot write to output stream");
            }
        }
        try {
            oos.flush();
            bytes = bas.toByteArray();
        }
        catch (Exception ex) {
            throw new CIMException("Cannot write to byte array");
        }
        try {
            oos.close();
            bas.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
        return bytes;
    }

    public static synchronized byte[] signDigest(byte[] digest, PrivateKey privkey, Signature signer) throws CIMException {
        byte[] result = null;
        try {
            signer.initSign(privkey);
            signer.update(digest);
            result = signer.sign();
        }
        catch (Exception x) {
            throw new CIMException("Cannot sign");
        }
        return result;
    }

    public static synchronized boolean verifyDigest(byte[] digest, Signature signer, byte[] signature, PublicKey publicKey) throws CIMException {
        boolean result = false;
        try {
            signer.initVerify(publicKey);
            signer.update(digest);
            result = signer.verify(signature);
        }
        catch (Exception x) {
            throw new CIMException("Cannot verify");
        }
        return result;
    }

    public static String toHex(byte[] data) {
        if (data == null) {
            return null;
        }
        if (data.length == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer(data.length * 2);
        for (int i = 0; i < data.length; ++i) {
            sb.append(hex[data[i] >> 4 & 0xF]);
            sb.append(hex[data[i] & 0xF]);
        }
        return sb.toString();
    }

    public static byte[] fromHex(String str) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        byte[] ba = new byte[len / 2];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            int k;
            ba[j] = 0;
            boolean ok = false;
            char c = str.charAt(i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(k << 4 & 0xF0);
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ok = false;
            c = str.charAt(++i);
            for (k = 0; k < hex.length; ++k) {
                if (c != hex[k]) continue;
                ba[j] = (byte)(ba[j] | (byte)(k & 0xF));
                ok = true;
                break;
            }
            if (!ok) {
                return null;
            }
            ++j;
        }
        return ba;
    }
}

