/*
 * Decompiled with CFR 0.152.
 */
package com.eg.agent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaVersion {
    JAVA_5{

        public boolean isJava9Higher() {
            return false;
        }
    }
    ,
    JAVA_6{

        public boolean isJava9Higher() {
            return false;
        }
    }
    ,
    JAVA_7{

        public boolean isJava9Higher() {
            return false;
        }
    }
    ,
    JAVA_8{

        public boolean isJava9Higher() {
            return false;
        }
    }
    ,
    JAVA_9{

        public boolean isJava9Higher() {
            return true;
        }
    }
    ,
    JAVA_10{

        public boolean isJava9Higher() {
            return true;
        }
    }
    ,
    JAVA_11{

        public boolean isJava9Higher() {
            return true;
        }
    }
    ,
    BELOW_5{

        public boolean isJava9Higher() {
            return false;
        }
    }
    ,
    ABOVE_11{

        public boolean isJava9Higher() {
            return true;
        }
    };


    public static JavaVersion getJavaVersion() {
        String string = System.getProperty("java.version");
        return JavaVersion.getJavaVersion(string);
    }

    public static boolean isJmapSupported(String string) {
        if (string.startsWith("9")) {
            return true;
        }
        if (string.startsWith("10")) {
            return true;
        }
        if (string.startsWith("11")) {
            return true;
        }
        if (string.startsWith("12")) {
            return true;
        }
        if (string.startsWith("13")) {
            return true;
        }
        if (string.startsWith("14")) {
            return true;
        }
        if (string.length() >= 3) {
            string = string.substring(0, 3);
        }
        Float f2 = Float.valueOf(string);
        return f2.floatValue() >= 1.6f;
    }

    public static JavaVersion getJavaVersion(String string) {
        if (string.startsWith("9")) {
            return JAVA_9;
        }
        if (string.startsWith("10")) {
            return JAVA_10;
        }
        if (string.startsWith("11")) {
            return JAVA_11;
        }
        if (string.length() >= 3) {
            string = string.substring(0, 3);
        }
        Float f2 = Float.valueOf(string);
        if (f2.floatValue() <= 1.4f) {
            return BELOW_5;
        }
        if (f2.floatValue() <= 1.5f) {
            return JAVA_5;
        }
        if (f2.floatValue() <= 1.6f) {
            return JAVA_6;
        }
        if (f2.floatValue() <= 1.7f) {
            return JAVA_7;
        }
        if (f2.floatValue() <= 1.8f) {
            return JAVA_8;
        }
        return ABOVE_11;
    }

    public abstract boolean isJava9Higher();
}

