/*
 * Decompiled with CFR 0.152.
 */
import com.egurkha.util.EgUtilities;
import com.unboundid.ldap.sdk.BindRequest;
import com.unboundid.ldap.sdk.BindResult;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.GSSAPIBindRequest;
import com.unboundid.ldap.sdk.GSSAPIBindRequestProperties;
import com.unboundid.ldap.sdk.GSSAPIChannelBindingType;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.util.ssl.SSLUtil;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

public class ADServerTest
extends GenericTest {
    private int adportNo = 389;
    private int connectTimeOut = 5000;
    private boolean isSSLEnabled = false;
    private boolean isUserConfigured = false;
    private boolean isLDAPConnect = true;
    private String userName = "none";
    private String password = "none";
    private String domainName = "none";
    private String kdcServer = "none";

    public ADServerTest(String[] stringArray) {
        super(stringArray);
        this.setMeasureCount(2);
        this.userName = this.getValueForParam("user");
        this.password = this.getValueForParam("password");
        this.domainName = this.getValueForParam("domain");
        this.kdcServer = this.getValueForParam("KDC_ip_address");
        String string = this.getValueForParam("ConnectTimeout");
        String string2 = this.getValueForParam("ssl");
        String string3 = this.getValueForParam("Connection_type");
        try {
            if (string != null && string.length() > 0) {
                this.connectTimeOut = Integer.parseInt(string);
                this.connectTimeOut *= 1000;
            } else {
                this.connectTimeOut = 5000;
            }
        }
        catch (Exception exception) {
            this.connectTimeOut = 5000;
        }
        try {
            this.adportNo = Integer.parseInt(this.portNo);
        }
        catch (Exception exception) {
            this.adportNo = 389;
        }
        if (string2 != null && (string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("yes"))) {
            this.adportNo = 636;
            this.isSSLEnabled = true;
        } else {
            this.isSSLEnabled = false;
        }
        if (string3 != null) {
            this.isLDAPConnect = string3.equalsIgnoreCase("ldap");
        }
        this.isUserConfigured = !this.domainName.equalsIgnoreCase("none") && !this.userName.equalsIgnoreCase("none") && !this.password.equalsIgnoreCase("none");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeMeasures(Hashtable hashtable) {
        Object object;
        double d = 0.0;
        double d2 = -5.0;
        LDAPConnection lDAPConnection = null;
        long l = 0L;
        long l2 = 0L;
        if (this.isLDAPConnect) {
            if (this.isSSLEnabled) {
                try {
                    object = new SSLUtil((TrustManager)new TrustAllTrustManager());
                    SSLSocketFactory sSLSocketFactory = object.createSSLSocketFactory();
                    l = System.currentTimeMillis();
                    lDAPConnection = new LDAPConnection((SocketFactory)sSLSocketFactory);
                    if (this.isUserConfigured) {
                        lDAPConnection.connect(this.targetHost, this.adportNo, this.connectTimeOut);
                        lDAPConnection.bind(this.userName + "@" + this.domainName, this.password);
                    } else {
                        lDAPConnection.connect(this.targetHost, this.adportNo, this.connectTimeOut);
                    }
                    l2 = System.currentTimeMillis();
                    d2 = (double)(l2 - l) / 1000.0;
                    d = 100.0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    d = 0.0;
                    d2 = -5.0;
                }
                finally {
                    if (lDAPConnection != null) {
                        lDAPConnection.close();
                    }
                }
            } else {
                try {
                    l = System.currentTimeMillis();
                    lDAPConnection = new LDAPConnection();
                    if (this.isUserConfigured) {
                        lDAPConnection.connect(this.targetHost, this.adportNo, this.connectTimeOut);
                        lDAPConnection.bind(this.userName + "@" + this.domainName, this.password);
                    } else {
                        lDAPConnection.connect(this.targetHost, this.adportNo, this.connectTimeOut);
                    }
                    object = lDAPConnection.getRootDSE();
                    l2 = System.currentTimeMillis();
                    d2 = (double)(l2 - l) / 1000.0;
                    d = 100.0;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    d = 0.0;
                    d2 = -5.0;
                }
                finally {
                    if (lDAPConnection != null) {
                        lDAPConnection.close();
                    }
                }
            }
        } else {
            try {
                SSLUtil sSLUtil;
                object = InetAddress.getByName(this.targetHost).getCanonicalHostName();
                if (this.isSSLEnabled) {
                    sSLUtil = new SSLUtil((TrustManager)new TrustAllTrustManager());
                    lDAPConnection = new LDAPConnection((SocketFactory)sSLUtil.createSSLSocketFactory(), (String)object, this.adportNo);
                } else {
                    lDAPConnection = new LDAPConnection((String)object, this.adportNo);
                }
                l = System.currentTimeMillis();
                sSLUtil = new GSSAPIBindRequestProperties(this.userName, this.password);
                String string = "";
                string = this.kdcServer != null && this.kdcServer.trim().equalsIgnoreCase("none") ? this.getKDCAddressWithPort() : (this.kdcServer.indexOf(":") == -1 ? this.kdcServer + ":88" : this.kdcServer);
                System.out.println(string);
                sSLUtil.setKDCAddress(string);
                sSLUtil.setRealm(this.domainName.toUpperCase());
                if (this.isSSLEnabled) {
                    sSLUtil.setChannelBindingType(GSSAPIChannelBindingType.TLS_SERVER_END_POINT);
                }
                GSSAPIBindRequest gSSAPIBindRequest = new GSSAPIBindRequest((GSSAPIBindRequestProperties)sSLUtil, new Control[0]);
                BindResult bindResult = lDAPConnection.bind((BindRequest)gSSAPIBindRequest);
                l2 = System.currentTimeMillis();
                d2 = (double)(l2 - l) / 1000.0;
                d = 100.0;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                d = 0.0;
                d2 = -5.0;
            }
            finally {
                if (lDAPConnection != null) {
                    lDAPConnection.close();
                }
            }
        }
        if (d <= 0.0) {
            d2 = -5.0;
        }
        if (this.isPassive) {
            if (d <= 0.0) {
                d = -5.0;
            }
            if (d2 <= 0.0) {
                d2 = -5.0;
            }
        }
        object = new ArrayList();
        ((ArrayList)object).add(new Double(d));
        ((ArrayList)object).add(new Double(d2));
        System.out.println("[ADServerTest] measureList " + object);
        this.addNewMeasure((ArrayList)object);
    }

    private String getKDCAddressWithPort() {
        String string = "";
        String string2 = "nslookup -type=srv _kerberos._tcp." + this.domainName;
        EgUtilities egUtilities = EgUtilities.createInstance();
        ArrayList arrayList = egUtilities.getExecOutputLines(string2);
        if (arrayList == null || arrayList.size() < 2) {
            return string;
        }
        if ((arrayList = (ArrayList)arrayList.get(0)) == null || arrayList.size() == 0) {
            return string;
        }
        String string3 = "";
        String string4 = "";
        String string5 = "";
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            String string6;
            String string7 = (String)arrayList.get(i);
            if (string7 == null || string7.trim().length() == 0) continue;
            if ((string7 = string7.trim()).startsWith("Server:")) {
                string3 = string7.substring(string7.indexOf(":") + 1).trim();
                continue;
            }
            if (string7.startsWith("Address:")) {
                string4 = string7.substring(string7.indexOf(":") + 1).trim();
                continue;
            }
            if (string7.startsWith("port") && string7.indexOf("=") > 0) {
                string5 = string7.substring(string7.indexOf("=") + 1).trim();
                continue;
            }
            if (string7.startsWith("svr hostname") && string7.indexOf("=") > 0 && (string6 = string7.substring(string7.indexOf("=") + 1).trim()).equalsIgnoreCase(string3)) break;
        }
        if (string4.trim().length() > 0 && string5.trim().length() > 0) {
            string = string4 + ":" + string5;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        ADServerTest aDServerTest = new ADServerTest(stringArray);
        aDServerTest.computeMeasures(new Hashtable());
    }
}

